/*
 * Decompiled with CFR 0.152.
 */
package jde.parser.visitor;

import java.util.Enumeration;
import java.util.Vector;
import jde.parser.syntaxtree.AdditiveExpression;
import jde.parser.syntaxtree.AllocationExpression;
import jde.parser.syntaxtree.AndExpression;
import jde.parser.syntaxtree.ArgumentList;
import jde.parser.syntaxtree.Arguments;
import jde.parser.syntaxtree.ArrayDimsAndInits;
import jde.parser.syntaxtree.ArrayInitializer;
import jde.parser.syntaxtree.AssignmentOperator;
import jde.parser.syntaxtree.Block;
import jde.parser.syntaxtree.BlockStatement;
import jde.parser.syntaxtree.BooleanLiteral;
import jde.parser.syntaxtree.BreakStatement;
import jde.parser.syntaxtree.CastExpression;
import jde.parser.syntaxtree.CastLookahead;
import jde.parser.syntaxtree.ClassBody;
import jde.parser.syntaxtree.ClassBodyDeclaration;
import jde.parser.syntaxtree.ClassDeclaration;
import jde.parser.syntaxtree.CompilationUnit;
import jde.parser.syntaxtree.ConditionalAndExpression;
import jde.parser.syntaxtree.ConditionalExpression;
import jde.parser.syntaxtree.ConditionalOrExpression;
import jde.parser.syntaxtree.ConstructorDeclaration;
import jde.parser.syntaxtree.ContinueStatement;
import jde.parser.syntaxtree.DoStatement;
import jde.parser.syntaxtree.EmptyStatement;
import jde.parser.syntaxtree.EqualityExpression;
import jde.parser.syntaxtree.ExclusiveOrExpression;
import jde.parser.syntaxtree.ExplicitConstructorInvocation;
import jde.parser.syntaxtree.Expression;
import jde.parser.syntaxtree.FieldDeclaration;
import jde.parser.syntaxtree.ForInit;
import jde.parser.syntaxtree.ForStatement;
import jde.parser.syntaxtree.ForUpdate;
import jde.parser.syntaxtree.FormalParameter;
import jde.parser.syntaxtree.FormalParameters;
import jde.parser.syntaxtree.IfStatement;
import jde.parser.syntaxtree.ImportDeclaration;
import jde.parser.syntaxtree.InclusiveOrExpression;
import jde.parser.syntaxtree.Initializer;
import jde.parser.syntaxtree.InstanceOfExpression;
import jde.parser.syntaxtree.InterfaceDeclaration;
import jde.parser.syntaxtree.InterfaceMemberDeclaration;
import jde.parser.syntaxtree.LabeledStatement;
import jde.parser.syntaxtree.Literal;
import jde.parser.syntaxtree.LocalVariableDeclaration;
import jde.parser.syntaxtree.MethodDeclaration;
import jde.parser.syntaxtree.MethodDeclarationLookahead;
import jde.parser.syntaxtree.MethodDeclarator;
import jde.parser.syntaxtree.MultiplicativeExpression;
import jde.parser.syntaxtree.Name;
import jde.parser.syntaxtree.NameList;
import jde.parser.syntaxtree.NestedClassDeclaration;
import jde.parser.syntaxtree.NestedInterfaceDeclaration;
import jde.parser.syntaxtree.Node;
import jde.parser.syntaxtree.NodeListInterface;
import jde.parser.syntaxtree.NodeToken;
import jde.parser.syntaxtree.NullLiteral;
import jde.parser.syntaxtree.PackageDeclaration;
import jde.parser.syntaxtree.PostfixExpression;
import jde.parser.syntaxtree.PreDecrementExpression;
import jde.parser.syntaxtree.PreIncrementExpression;
import jde.parser.syntaxtree.PrimaryExpression;
import jde.parser.syntaxtree.PrimaryPrefix;
import jde.parser.syntaxtree.PrimarySuffix;
import jde.parser.syntaxtree.PrimitiveType;
import jde.parser.syntaxtree.RelationalExpression;
import jde.parser.syntaxtree.ResultType;
import jde.parser.syntaxtree.ReturnStatement;
import jde.parser.syntaxtree.ShiftExpression;
import jde.parser.syntaxtree.Statement;
import jde.parser.syntaxtree.StatementExpression;
import jde.parser.syntaxtree.StatementExpressionList;
import jde.parser.syntaxtree.SwitchLabel;
import jde.parser.syntaxtree.SwitchStatement;
import jde.parser.syntaxtree.SynchronizedStatement;
import jde.parser.syntaxtree.ThrowStatement;
import jde.parser.syntaxtree.TryStatement;
import jde.parser.syntaxtree.Type;
import jde.parser.syntaxtree.TypeDeclaration;
import jde.parser.syntaxtree.UnaryExpression;
import jde.parser.syntaxtree.UnaryExpressionNotPlusMinus;
import jde.parser.syntaxtree.UnmodifiedClassDeclaration;
import jde.parser.syntaxtree.UnmodifiedInterfaceDeclaration;
import jde.parser.syntaxtree.VariableDeclarator;
import jde.parser.syntaxtree.VariableDeclaratorId;
import jde.parser.syntaxtree.VariableInitializer;
import jde.parser.syntaxtree.WhileStatement;
import jde.parser.visitor.DepthFirstVisitor;
import jde.parser.visitor.FormatCommand;
import jde.parser.visitor.TreeFormatterException;

public class TreeFormatter
extends DepthFirstVisitor {
    private Vector cmdQueue = new Vector();
    private boolean lineWrap;
    private int wrapWidth;
    private int indentAmt;
    private int curLine = 1;
    private int curColumn = 1;
    private int curIndent = 0;

    protected void processList(NodeListInterface n) {
        this.processList(n, null);
    }

    protected void processList(NodeListInterface n, FormatCommand cmd) {
        Enumeration e = n.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).accept(this);
            if (cmd == null || !e.hasMoreElements()) continue;
            this.cmdQueue.addElement(cmd);
        }
    }

    protected FormatCommand force() {
        return this.force(1);
    }

    protected FormatCommand force(int i) {
        return new FormatCommand(0, i);
    }

    protected FormatCommand indent() {
        return this.indent(1);
    }

    protected FormatCommand indent(int i) {
        return new FormatCommand(1, i);
    }

    protected FormatCommand outdent() {
        return this.outdent(1);
    }

    protected FormatCommand outdent(int i) {
        return new FormatCommand(2, i);
    }

    protected FormatCommand space() {
        return this.space(1);
    }

    protected FormatCommand space(int i) {
        return new FormatCommand(3, i);
    }

    protected void add(FormatCommand cmd) {
        this.cmdQueue.addElement(cmd);
    }

    public void visit(NodeToken n) {
        Enumeration e = this.cmdQueue.elements();
        block6: while (e.hasMoreElements()) {
            FormatCommand cmd = (FormatCommand)e.nextElement();
            switch (cmd.getCommand()) {
                case 0: {
                    this.curLine += cmd.getNumCommands();
                    this.curColumn = this.curIndent + 1;
                    break;
                }
                case 1: {
                    this.curIndent += this.indentAmt * cmd.getNumCommands();
                    break;
                }
                case 2: {
                    if (this.curIndent < this.indentAmt) continue block6;
                    this.curIndent -= this.indentAmt * cmd.getNumCommands();
                    break;
                }
                case 3: {
                    this.curColumn += cmd.getNumCommands();
                    break;
                }
                default: {
                    throw new TreeFormatterException("Invalid value in command queue.");
                }
            }
        }
        this.cmdQueue.removeAllElements();
        if (n.numSpecials() > 0) {
            e = n.specialTokens.elements();
            while (e.hasMoreElements()) {
                NodeToken special = (NodeToken)e.nextElement();
                this.placeToken(special, this.curLine, this.curColumn);
                this.curLine = special.endLine + 1;
            }
        }
        this.placeToken(n, this.curLine, this.curColumn);
        this.curLine = n.endLine;
        this.curColumn = n.endColumn;
    }

    private final void placeToken(NodeToken n, int line, int column) {
        int length = n.tokenImage.length();
        if (!this.lineWrap || n.tokenImage.indexOf(10) != -1 || column + length <= this.wrapWidth) {
            n.beginColumn = column;
        } else {
            ++line;
            n.beginColumn = column = this.curIndent + this.indentAmt + 1;
        }
        n.beginLine = line;
        int i = 0;
        while (i < length) {
            if (n.tokenImage.charAt(i) == '\n' && i < length - 1) {
                ++line;
                column = 1;
            } else {
                ++column;
            }
            ++i;
        }
        n.endLine = line;
        n.endColumn = column;
    }

    public void visit(CompilationUnit n) {
        if (n.f0.present()) {
            n.f0.accept(this);
        }
        if (n.f1.present()) {
            this.processList(n.f1);
        }
        if (n.f2.present()) {
            this.processList(n.f2);
        }
        n.f3.accept(this);
    }

    public void visit(PackageDeclaration n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
    }

    public void visit(ImportDeclaration n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            n.f2.accept(this);
        }
        n.f3.accept(this);
    }

    public void visit(TypeDeclaration n) {
        n.f0.accept(this);
    }

    public void visit(ClassDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
    }

    public void visit(UnmodifiedClassDeclaration n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            n.f2.accept(this);
        }
        if (n.f3.present()) {
            n.f3.accept(this);
        }
        n.f4.accept(this);
    }

    public void visit(ClassBody n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
        n.f2.accept(this);
    }

    public void visit(NestedClassDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
    }

    public void visit(ClassBodyDeclaration n) {
        n.f0.accept(this);
    }

    public void visit(MethodDeclarationLookahead n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
    }

    public void visit(InterfaceDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
    }

    public void visit(NestedInterfaceDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
    }

    public void visit(UnmodifiedInterfaceDeclaration n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            n.f2.accept(this);
        }
        n.f3.accept(this);
        if (n.f4.present()) {
            this.processList(n.f4);
        }
        n.f5.accept(this);
    }

    public void visit(InterfaceMemberDeclaration n) {
        n.f0.accept(this);
    }

    public void visit(FieldDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
        n.f2.accept(this);
        if (n.f3.present()) {
            this.processList(n.f3);
        }
        n.f4.accept(this);
    }

    public void visit(VariableDeclarator n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
    }

    public void visit(VariableDeclaratorId n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(VariableInitializer n) {
        n.f0.accept(this);
    }

    public void visit(ArrayInitializer n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        if (n.f2.present()) {
            n.f2.accept(this);
        }
        n.f3.accept(this);
    }

    public void visit(MethodDeclaration n) {
        if (n.f0.present()) {
            this.processList(n.f0);
        }
        n.f1.accept(this);
        n.f2.accept(this);
        if (n.f3.present()) {
            n.f3.accept(this);
        }
        n.f4.accept(this);
    }

    public void visit(MethodDeclarator n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            this.processList(n.f2);
        }
    }

    public void visit(FormalParameters n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        n.f2.accept(this);
    }

    public void visit(FormalParameter n) {
        if (n.f0.present()) {
            n.f0.accept(this);
        }
        n.f1.accept(this);
        n.f2.accept(this);
    }

    public void visit(ConstructorDeclaration n) {
        if (n.f0.present()) {
            n.f0.accept(this);
        }
        n.f1.accept(this);
        n.f2.accept(this);
        if (n.f3.present()) {
            n.f3.accept(this);
        }
        n.f4.accept(this);
        if (n.f5.present()) {
            n.f5.accept(this);
        }
        if (n.f6.present()) {
            this.processList(n.f6);
        }
        n.f7.accept(this);
    }

    public void visit(ExplicitConstructorInvocation n) {
        n.f0.accept(this);
    }

    public void visit(Initializer n) {
        if (n.f0.present()) {
            n.f0.accept(this);
        }
        n.f1.accept(this);
    }

    public void visit(Type n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(PrimitiveType n) {
        n.f0.accept(this);
    }

    public void visit(ResultType n) {
        n.f0.accept(this);
    }

    public void visit(Name n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(NameList n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(Expression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
    }

    public void visit(AssignmentOperator n) {
        n.f0.accept(this);
    }

    public void visit(ConditionalExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
    }

    public void visit(ConditionalOrExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(ConditionalAndExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(InclusiveOrExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(ExclusiveOrExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(AndExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(EqualityExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(InstanceOfExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
    }

    public void visit(RelationalExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(ShiftExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(AdditiveExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(MultiplicativeExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(UnaryExpression n) {
        n.f0.accept(this);
    }

    public void visit(PreIncrementExpression n) {
        n.f0.accept(this);
        n.f1.accept(this);
    }

    public void visit(PreDecrementExpression n) {
        n.f0.accept(this);
        n.f1.accept(this);
    }

    public void visit(UnaryExpressionNotPlusMinus n) {
        n.f0.accept(this);
    }

    public void visit(CastLookahead n) {
        n.f0.accept(this);
    }

    public void visit(PostfixExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
    }

    public void visit(CastExpression n) {
        n.f0.accept(this);
    }

    public void visit(PrimaryExpression n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(PrimaryPrefix n) {
        n.f0.accept(this);
    }

    public void visit(PrimarySuffix n) {
        n.f0.accept(this);
    }

    public void visit(Literal n) {
        n.f0.accept(this);
    }

    public void visit(BooleanLiteral n) {
        n.f0.accept(this);
    }

    public void visit(NullLiteral n) {
        n.f0.accept(this);
    }

    public void visit(Arguments n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        n.f2.accept(this);
    }

    public void visit(ArgumentList n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(AllocationExpression n) {
        n.f0.accept(this);
    }

    public void visit(ArrayDimsAndInits n) {
        n.f0.accept(this);
    }

    public void visit(Statement n) {
        n.f0.accept(this);
    }

    public void visit(LabeledStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
    }

    public void visit(Block n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
        n.f2.accept(this);
    }

    public void visit(BlockStatement n) {
        n.f0.accept(this);
    }

    public void visit(LocalVariableDeclaration n) {
        if (n.f0.present()) {
            n.f0.accept(this);
        }
        n.f1.accept(this);
        n.f2.accept(this);
        if (n.f3.present()) {
            this.processList(n.f3);
        }
    }

    public void visit(EmptyStatement n) {
        n.f0.accept(this);
    }

    public void visit(StatementExpression n) {
        n.f0.accept(this);
    }

    public void visit(SwitchStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
        n.f4.accept(this);
        if (n.f5.present()) {
            this.processList(n.f5);
        }
        n.f6.accept(this);
    }

    public void visit(SwitchLabel n) {
        n.f0.accept(this);
    }

    public void visit(IfStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
        n.f4.accept(this);
        if (n.f5.present()) {
            n.f5.accept(this);
        }
    }

    public void visit(WhileStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
        n.f4.accept(this);
    }

    public void visit(DoStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
        n.f4.accept(this);
        n.f5.accept(this);
        n.f6.accept(this);
    }

    public void visit(ForStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            n.f2.accept(this);
        }
        n.f3.accept(this);
        if (n.f4.present()) {
            n.f4.accept(this);
        }
        n.f5.accept(this);
        if (n.f6.present()) {
            n.f6.accept(this);
        }
        n.f7.accept(this);
        n.f8.accept(this);
    }

    public void visit(ForInit n) {
        n.f0.accept(this);
    }

    public void visit(StatementExpressionList n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.processList(n.f1);
        }
    }

    public void visit(ForUpdate n) {
        n.f0.accept(this);
    }

    public void visit(BreakStatement n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        n.f2.accept(this);
    }

    public void visit(ContinueStatement n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        n.f2.accept(this);
    }

    public void visit(ReturnStatement n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            n.f1.accept(this);
        }
        n.f2.accept(this);
    }

    public void visit(ThrowStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
    }

    public void visit(SynchronizedStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        n.f2.accept(this);
        n.f3.accept(this);
        n.f4.accept(this);
    }

    public void visit(TryStatement n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            this.processList(n.f2);
        }
        if (n.f3.present()) {
            n.f3.accept(this);
        }
    }

    public TreeFormatter() {
        this(3, 0);
    }

    public TreeFormatter(int indentAmt, int wrapWidth) {
        this.indentAmt = indentAmt;
        this.wrapWidth = wrapWidth;
        this.lineWrap = wrapWidth > 0;
    }
}

