/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package org.openxml.x3p;


/**
 * Interface that defines a publisher target. Publisher targets are
 * objects that provide a suitable publisher with enough information
 * that it can publish a document or node to that target. Output
 * streams, readers and files are supported by a different mechanism.
 * <P>
 * A publisher is usually associated with one or more publisher targets.
 * The target object is created and passed to {@link
 * PublisherFactory#createPublisher(PublisherTarget)} which returns a
 * suitable publisher. This decoupling enables the publisher and
 * application to be developed independently, as well as for targets
 * to be provided from an external source.
 * 
 * 
 * @version $Revision: 1.2 $ $Date: 1999/04/12 06:12:44 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public interface PublisherTarget
{
}
