/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.xpath.XBoolean;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.StylesheetSpec;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLTEngineImpl
implements XSLTProcessor {
    private TransformerFactory m_tfactory;
    private TransformerImpl m_transformerImpl;
    private DOM2Helper m_liaison;
    private String m_outputFileName;
    private DocumentHandler m_documentHandler = null;
    private ProblemListenerDefault m_problemListener;
    private Hashtable m_stylesheetParams;
    StylesheetRoot m_stylesheetRoot = null;
    Vector m_evalList = null;
    boolean m_needToEval = false;
    private boolean m_traceTemplateChildren = false;
    private boolean m_traceTemplates = false;
    boolean m_traceSelects = false;
    PrintWriter m_diagnosticsPrintWriter = null;
    Hashtable m_durationsTable = new Hashtable();
    private static XSLMessages m_XSLMessages = new XSLMessages();

    protected XSLTEngineImpl() throws SAXException {
        this.m_tfactory = TransformerFactory.newInstance();
        this.m_problemListener = new ProblemListenerDefault();
    }

    public XSLTEngineImpl(String string) throws SAXException {
        this.m_tfactory = TransformerFactory.newInstance();
        this.m_problemListener = new ProblemListenerDefault();
        try {
            this.m_liaison = (DOM2Helper)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("XML Liaison class " + string + " specified but not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("XML Liaison class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("XML Liaison class " + string + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("XML Liaison class " + string + " does not implement DOM2Helper", classCastException);
        }
    }

    public XSLTEngineImpl(XMLParserLiaison xMLParserLiaison) throws SAXException {
        this.m_tfactory = TransformerFactory.newInstance();
        this.m_problemListener = new ProblemListenerDefault();
        this.m_liaison = xMLParserLiaison;
    }

    XSLTEngineImpl(XMLParserLiaison xMLParserLiaison, XPathFactory xPathFactory) throws SAXException {
        this.m_tfactory = TransformerFactory.newInstance();
        this.m_problemListener = new ProblemListenerDefault();
        this.m_liaison = xMLParserLiaison;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getTraceManager().addTraceListener(traceListener);
        }
    }

    void addTraceListenersToStylesheet() throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_documentHandler != null) {
            this.m_documentHandler.characters(cArray, n, n2);
        } else if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getInputContentHandler().characters(cArray, n, n2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().comment(cArray, n, n2);
        }
    }

    public XMLParserLiaison createLiaison() throws SAXException {
        return new XMLParserLiaisonDefault();
    }

    public StylesheetRoot createStylesheetRoot(String string) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        try {
            if (string == null) {
                return new StylesheetRoot(this, string);
            }
            Source source = new XSLTInputSource(string).getSourceObject();
            Templates templates = this.m_tfactory.newTemplates(source);
            StylesheetRoot stylesheetRoot = new StylesheetRoot((org.apache.xalan.templates.StylesheetRoot)templates);
            return stylesheetRoot;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    StylesheetRoot createStylesheetRoot(String string, XSLTInputSource xSLTInputSource) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        try {
            Source source = xSLTInputSource.getSourceObject();
            Templates templates = this.m_tfactory.newTemplates(source);
            StylesheetRoot stylesheetRoot = new StylesheetRoot((org.apache.xalan.templates.StylesheetRoot)templates);
            return stylesheetRoot;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    public XBoolean createXBoolean(boolean bl) {
        return new XBoolean(bl);
    }

    public XNodeSet createXNodeSet(Node node) {
        return new XNodeSet(node);
    }

    public XNodeSet createXNodeSet(NodeList nodeList) {
        return new XNodeSet(nodeList);
    }

    public XNull createXNull() {
        return new XNull();
    }

    public XNumber createXNumber(double d) {
        return new XNumber(d);
    }

    public org.apache.xalan.xpath.XObject createXObject(Object object) {
        return new org.apache.xalan.xpath.XObject(object);
    }

    public XString createXString(String string) {
        return new XString(string);
    }

    protected void diag(String string) {
        if (this.m_diagnosticsPrintWriter != null) {
            this.m_diagnosticsPrintWriter.println(string);
        }
    }

    protected void displayDuration(String string, Object object) {
        long l = 0L;
        if (object != null) {
            long l2 = (Long)this.m_durationsTable.get(object);
            long l3 = System.currentTimeMillis();
            l = l3 - l2;
            if (this.m_diagnosticsPrintWriter != null) {
                this.m_diagnosticsPrintWriter.println(String.valueOf(string) + " took " + l + " milliseconds");
            }
            this.m_durationsTable.remove(object);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_documentHandler != null) {
            this.m_documentHandler.endDocument();
        } else if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getInputContentHandler().endDocument();
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.m_documentHandler == null) {
            this.m_documentHandler = new ParserAdapter((Parser)new SAXParser());
            if (this.m_transformerImpl != null) {
                ((ParserAdapter)this.m_documentHandler).setContentHandler(this.m_transformerImpl.getInputContentHandler());
            }
        }
        this.m_documentHandler.endElement(string);
    }

    public void endEntity(String string) throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().endEntity(string);
        }
    }

    public void error(int n) throws SAXException {
        this.error(null, null, n, null);
    }

    public void error(int n, Exception exception) throws SAXException {
        this.error(n, null, exception);
    }

    public void error(int n, Object[] objectArray) throws SAXException {
        this.error(null, null, n, objectArray);
    }

    public void error(int n, Object[] objectArray, Exception exception) throws SAXException {
        TransformerException transformerException;
        String string = XSLMessages.createMessage((int)n, (Object[])objectArray);
        SAXSourceLocator sAXSourceLocator = null;
        try {
            sAXSourceLocator = ((StylesheetHandler)((TransformerFactoryImpl)this.m_tfactory).newTemplatesHandler()).getLocator();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        DefaultErrorHandler defaultErrorHandler = this.m_problemListener == null ? (DefaultErrorHandler)this.m_tfactory.getErrorListener() : (DefaultErrorHandler)this.m_problemListener.getErrorHandler();
        TransformerException transformerException2 = transformerException = exception == null ? new TransformerException(string, (SourceLocator)sAXSourceLocator) : new TransformerException(string, (SourceLocator)sAXSourceLocator, exception);
        if (defaultErrorHandler != null) {
            try {
                defaultErrorHandler.fatalError(transformerException);
            }
            catch (TransformerException transformerException3) {
                throw new SAXException(transformerException3);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }

    public void error(String string) throws SAXException {
        TransformerException transformerException;
        Throwable throwable = null;
        SAXSourceLocator sAXSourceLocator = null;
        try {
            sAXSourceLocator = ((StylesheetHandler)((TransformerFactoryImpl)this.m_tfactory).newTemplatesHandler()).getLocator();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        DefaultErrorHandler defaultErrorHandler = this.m_problemListener == null ? (DefaultErrorHandler)this.m_tfactory.getErrorListener() : (DefaultErrorHandler)this.m_problemListener.getErrorHandler();
        TransformerException transformerException2 = transformerException = throwable == null ? new TransformerException(string, (SourceLocator)sAXSourceLocator) : new TransformerException(string, (SourceLocator)sAXSourceLocator, throwable);
        if (defaultErrorHandler != null) {
            try {
                defaultErrorHandler.fatalError(transformerException);
            }
            catch (TransformerException transformerException3) {
                throw new SAXException(transformerException3);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }

    public void error(Node node, Node node2, int n) throws SAXException {
        this.error(node, node2, n, null);
    }

    public void error(Node node, Node node2, int n, Object[] objectArray) throws SAXException {
        TransformerException transformerException;
        Throwable throwable = null;
        String string = XSLMessages.createMessage((int)n, (Object[])objectArray);
        SAXSourceLocator sAXSourceLocator = null;
        try {
            sAXSourceLocator = ((StylesheetHandler)((TransformerFactoryImpl)this.m_tfactory).newTemplatesHandler()).getLocator();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        DefaultErrorHandler defaultErrorHandler = this.m_problemListener == null ? (DefaultErrorHandler)this.m_tfactory.getErrorListener() : (DefaultErrorHandler)this.m_problemListener.getErrorHandler();
        TransformerException transformerException2 = transformerException = throwable == null ? new TransformerException(string, (SourceLocator)sAXSourceLocator) : new TransformerException(string, (SourceLocator)sAXSourceLocator, throwable);
        if (defaultErrorHandler != null) {
            try {
                defaultErrorHandler.fatalError(transformerException);
            }
            catch (TransformerException transformerException3) {
                throw new SAXException(transformerException3);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }

    public StylesheetSpec getAssociatedStylesheet(XSLTInputSource xSLTInputSource, String string, String string2) throws SAXException {
        try {
            Source source = this.m_tfactory.getAssociatedStylesheet(xSLTInputSource.getSourceObject(), string, null, string2);
            return (StylesheetSpec)source;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    public Vector getAssociatedStylesheets(XSLTInputSource xSLTInputSource, String string, String string2) throws SAXException {
        try {
            Source source = this.m_tfactory.getAssociatedStylesheet(xSLTInputSource.getSourceObject(), string, null, string2);
            Vector<StylesheetSpec> vector = new Vector<StylesheetSpec>();
            vector.addElement((StylesheetSpec)source);
            return vector;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.m_documentHandler;
    }

    public DocumentHandler getFormatterListener() {
        return this.m_documentHandler;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public ProblemListener getProblemListener() {
        if (this.m_problemListener.getProblemListener() != null) {
            return this.m_problemListener.getProblemListener();
        }
        return this.m_problemListener;
    }

    public Node getSourceTreeFromInput(XSLTInputSource xSLTInputSource) throws SAXException {
        Node node;
        block9: {
            node = null;
            String string = xSLTInputSource == null || xSLTInputSource.getSystemId() == null ? "Input XML" : xSLTInputSource.getSystemId();
            Source source = xSLTInputSource.getSourceObject();
            if (source instanceof DOMSource) {
                node = ((DOMSource)source).getNode();
            } else {
                try {
                    this.diag("========= Parsing " + string + " ==========");
                    this.pushTime(string);
                    if (this.m_liaison != null) {
                        this.m_liaison.parse(SAXSource.sourceToInputSource(source));
                        if (this.m_diagnosticsPrintWriter != null) {
                            this.displayDuration("Parse of " + string, string);
                        }
                        node = this.m_liaison.getDocument();
                        break block9;
                    }
                    XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                    try {
                        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    }
                    catch (SAXException sAXException) {}
                    SourceTreeHandler sourceTreeHandler = new SourceTreeHandler();
                    xMLReader.setContentHandler((ContentHandler)sourceTreeHandler);
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sourceTreeHandler);
                    xMLReader.parse(SAXSource.sourceToInputSource(source));
                    node = sourceTreeHandler.getRoot();
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof SAXException && ((SAXException)exception).getException() != null) {
                        exception2 = ((SAXException)exception).getException();
                    }
                    node = null;
                    this.error(50, new Object[]{string}, exception2);
                }
            }
        }
        return node;
    }

    public StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    Stylesheet getStylesheetFromPIURL(String string, Node node, String string2, boolean bl) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        Stylesheet stylesheet = null;
        String[] stringArray = new String[]{null};
        string = string.trim();
        int n = string.indexOf(35);
        String string3 = null;
        if (n == 0) {
            Object object;
            Object object2;
            Object object3;
            this.diag("Locating stylesheet from fragment identifier...");
            string3 = string.substring(1);
            XPathParser xPathParser = new XPathParser((ErrorListener)((Object)this.m_problemListener.getErrorHandler()), null);
            XPathContext xPathContext = new XPathContext();
            PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node);
            NodeIterator nodeIterator = null;
            try {
                object3 = new XPath(string3, null, (PrefixResolver)prefixResolverDefault, 1);
                object2 = new Compiler();
                xPathParser.initXPath(object2, "id(" + string3 + ")", (PrefixResolver)prefixResolverDefault);
                object = object3.execute(xPathContext, node, (PrefixResolver)prefixResolverDefault);
                nodeIterator = object.nodeset();
                if (nodeIterator.nextNode() == null) {
                    object3 = new XPath(string3, null, (PrefixResolver)prefixResolverDefault, 1);
                    xPathParser.initXPath(object2, "//*[@id='" + string3 + "']", (PrefixResolver)prefixResolverDefault);
                    object = object3.execute(xPathContext, node, (PrefixResolver)prefixResolverDefault);
                    nodeIterator = object.nodeset();
                    if (nodeIterator.nextNode() == null) {
                        object3 = new XPath(string3, null, (PrefixResolver)prefixResolverDefault, 1);
                        xPathParser.initXPath(object2, "//*[@name='" + string3 + "']", (PrefixResolver)prefixResolverDefault);
                        object = object3.execute(xPathContext, node, (PrefixResolver)prefixResolverDefault);
                        nodeIterator = object.nodeset();
                        if (nodeIterator.nextNode() == null) {
                            object3 = new XPath(string3, null, (PrefixResolver)prefixResolverDefault, 1);
                            xPathParser.initXPath(object2, string3, (PrefixResolver)prefixResolverDefault);
                            object = object3.execute(xPathContext, node, (PrefixResolver)prefixResolverDefault);
                            nodeIterator = object.nodeset();
                        }
                    }
                }
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
            if (nodeIterator.nextNode() == null) {
                this.error(51, new Object[]{string3});
            }
            if ((object3 = nodeIterator.previousNode()).getNodeType() == 1) {
                this.pushTime(object3);
                if (bl) {
                    this.m_stylesheetRoot = this.createStylesheetRoot(stringArray[0]);
                    stylesheet = this.m_stylesheetRoot.getObject();
                } else {
                    try {
                        object2 = new XSLTInputSource(string3).getSourceObject();
                        object = this.m_tfactory.newTemplates((Source)object2);
                        stylesheet = (org.apache.xalan.templates.StylesheetRoot)object;
                    }
                    catch (TransformerConfigurationException transformerConfigurationException) {
                        throw new SAXException(transformerConfigurationException);
                    }
                }
                this.addTraceListenersToStylesheet();
                try {
                    object2 = new StylesheetHandler((TransformerFactoryImpl)this.m_tfactory);
                    object2.pushStylesheet(stylesheet);
                    object = new TreeWalker((ContentHandler)object2, (DOMHelper)new DOM2Helper());
                    object.traverse((Node)object3);
                    this.displayDuration("Setup of " + string, object3);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException(transformerConfigurationException);
                }
            }
            Object var9_23 = null;
            this.error(52, new Object[]{string3});
        } else {
            Object object;
            this.diag(XSLMessages.createMessage((int)13, (Object[])new Object[]{string}));
            this.pushTime(string);
            if (bl) {
                this.m_stylesheetRoot = this.createStylesheetRoot(string);
                stylesheet = this.m_stylesheetRoot.getObject();
            } else {
                stylesheet = new Stylesheet((Stylesheet)this.m_stylesheetRoot.getObject());
            }
            this.addTraceListenersToStylesheet();
            try {
                object = new StylesheetHandler((TransformerFactoryImpl)this.m_tfactory);
                object.pushStylesheet(stylesheet);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new SAXException(transformerConfigurationException);
            }
            object = XSLTEngineImpl.getURLFromString(string, string2);
            XSLTInputSource xSLTInputSource = new XSLTInputSource(((URL)object).toString());
            if (this.m_liaison != null) {
                try {
                    this.m_liaison.parse(SAXSource.sourceToInputSource(xSLTInputSource.getSourceObject()));
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            }
            this.displayDuration("Parsing and init of " + string, string);
        }
        return stylesheet;
    }

    public TransformerImpl getTransformer() {
        return this.m_transformerImpl;
    }

    public TransformerFactoryImpl getTransformerFactory() {
        return (TransformerFactoryImpl)this.m_tfactory;
    }

    public static URL getURLFromString(String string, String string2) throws SAXException {
        URL uRL;
        block48: {
            String string3 = string;
            String string4 = string2;
            uRL = null;
            int n = 0;
            try {
                String string5;
                Object object;
                Object object2;
                if (string2 != null) {
                    if (string2.toLowerCase().startsWith("file:/")) {
                        n = 1;
                    } else if (string2.toLowerCase().startsWith("file:")) {
                        n = 2;
                    }
                }
                int n2 = string.indexOf(58);
                int n3 = string.indexOf(47);
                boolean bl = n2 != -1 && n3 != -1 && n2 < n3;
                if (bl || string2 == null || string2.length() == 0) {
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (string.charAt(0) != '.' && n <= 0) {
                    try {
                        object2 = new URL(string2);
                        uRL = new URL((URL)object2, string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                if (uRL == null) {
                    if (string.toLowerCase().startsWith("file:/")) {
                        string = string.substring(6);
                    } else if (string.toLowerCase().startsWith("file:")) {
                        string = string.substring(5);
                    }
                }
                if (uRL == null && (string2 == null || n > 0)) {
                    if (n == 1) {
                        if (string2 != null) {
                            string2 = string2.substring(6);
                        }
                        n = 1;
                    } else if (n == 2) {
                        if (string2 != null) {
                            string2 = string2.substring(5);
                        }
                        n = 2;
                    }
                    object2 = new File(string);
                    if (!((File)object2).isAbsolute() && string2 != null) {
                        boolean bl2;
                        String string6;
                        object = new StringTokenizer(string2, "\\/");
                        string5 = null;
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string6 = ((StringTokenizer)object).nextToken();
                            if (string5 == null) {
                                if (string2.charAt(0) == '\\' || string2.charAt(0) == '/') {
                                    string5 = String.valueOf(File.separator) + string6;
                                    continue;
                                }
                                string5 = string6;
                                continue;
                            }
                            string5 = String.valueOf(string5) + File.separator + string6;
                        }
                        object2 = new File(string5);
                        string6 = ((File)object2).isDirectory() ? ((File)object2).getAbsolutePath() : ((File)object2).getParent();
                        object2 = new File(string);
                        boolean bl3 = bl2 = ((File)object2).isAbsolute() || string.charAt(0) == '\\' || string.charAt(0) == '/';
                        if (!bl2) {
                            string = string6.charAt(string6.length() - 1) != File.separator.charAt(0) && string.charAt(0) != File.separator.charAt(0) ? String.valueOf(string6) + File.separator + string : String.valueOf(string6) + string;
                            object = new StringTokenizer(string, "\\/");
                            String string7 = null;
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                String string8 = ((StringTokenizer)object).nextToken();
                                if (string7 == null) {
                                    if (string.charAt(0) == '\\' || string.charAt(0) == '/') {
                                        string7 = String.valueOf(File.separator) + string8;
                                        continue;
                                    }
                                    string7 = string8;
                                    continue;
                                }
                                string7 = String.valueOf(string7) + File.separator + string8;
                            }
                            if (string7 != null) {
                                string = string7;
                            }
                        }
                        if (n == 1) {
                            string = string.charAt(0) == '/' ? "file://" + string : "file:/" + string;
                        } else if (n == 2) {
                            string = "file:" + string;
                        }
                        try {
                            uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
                if (uRL != null) break block48;
                if (string4 != null && string4.length() > 0) {
                    try {
                        object2 = new URL(string4);
                        uRL = new URL((URL)object2, string3);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                if (uRL != null) break block48;
                try {
                    if (string4 != null) {
                        object = new File(string4);
                        if (((File)object).isDirectory()) {
                            object2 = new File((File)object, string).getAbsolutePath();
                        } else {
                            string5 = ((File)object).getParent();
                            object2 = new File(string5, string).getAbsolutePath();
                        }
                    } else {
                        object2 = new File(string).getAbsolutePath();
                    }
                    object = ((String)object2).charAt(0) == '\\' || ((String)object2).charAt(0) == '/' ? "file://" + (String)object2 : "file:" + (String)object2;
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new SAXException("Cannot create url for: " + string, malformedURLException);
                }
            }
            catch (SecurityException securityException) {
                try {
                    uRL = new URL("http://xml.apache.org/xslt/" + Math.random());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return uRL;
    }

    public XMLParserLiaison getXMLProcessorLiaison() {
        return (XMLParserLiaison)this.m_liaison;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_documentHandler != null) {
            this.m_documentHandler.ignorableWhitespace(cArray, n, n2);
        } else if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getInputContentHandler().ignorableWhitespace(cArray, n, n2);
        }
    }

    public void message(String string) throws SAXException {
        this.message(null, null, string);
    }

    public void message(Node node, Node node2, String string) throws SAXException {
        this.m_problemListener.message(string);
    }

    long popDuration(Object object) {
        long l = 0L;
        if (object != null) {
            long l2 = (Long)this.m_durationsTable.get(object);
            long l3 = System.currentTimeMillis();
            l = l3 - l2;
            this.m_durationsTable.remove(object);
        }
        return l;
    }

    public void process(XSLTInputSource xSLTInputSource, XSLTInputSource xSLTInputSource2, XSLTResultTarget xSLTResultTarget) throws SAXException {
        block37: {
            try {
                XObject xObject;
                Object object;
                Object object2;
                Object object3;
                Boolean bl = new Boolean(true);
                this.pushTime(bl);
                Node node = null;
                Templates templates = null;
                if (this.m_needToEval) {
                    Source source;
                    object3 = null;
                    if (xSLTInputSource2 != null && (source = xSLTInputSource2.getSourceObject()) instanceof DOMSource) {
                        object3 = ((DOMSource)source).getNode();
                    }
                    if (object3 == null) {
                        object3 = new DOM2Helper().createDocument();
                    }
                    int n = 0;
                    while (n < this.m_evalList.size()) {
                        object2 = (String)this.m_evalList.elementAt(n);
                        object = (String)this.m_stylesheetParams.get(object2);
                        try {
                            xObject = XPathAPI.eval((Node)object3, (String)object);
                            this.m_stylesheetParams.put(object2, xObject);
                        }
                        catch (TransformerException transformerException) {
                            throw new SAXException(transformerException);
                        }
                        ++n;
                    }
                    this.m_needToEval = false;
                    this.m_evalList = null;
                }
                node = this.getSourceTreeFromInput(xSLTInputSource);
                if (xSLTInputSource2 != null) {
                    try {
                        templates = this.m_tfactory.newTemplates(xSLTInputSource2.getSourceObject());
                    }
                    catch (TransformerConfigurationException transformerConfigurationException) {
                        throw new SAXException(transformerConfigurationException);
                    }
                } else if (xSLTInputSource != null) {
                    if (node != null) {
                        Object object4;
                        object3 = null;
                        Stack<Object> stack = new Stack<Object>();
                        object2 = node.getFirstChild();
                        while (object2 != null) {
                            if (object2.getNodeType() == 7 && ((object = (ProcessingInstruction)object2).getNodeName().equals("xml-stylesheet") || object.getNodeName().equals("xml:stylesheet"))) {
                                boolean bl2 = true;
                                object4 = new StringTokenizer(object.getNodeValue(), " \t=");
                                while (((StringTokenizer)object4).hasMoreTokens()) {
                                    if (!((StringTokenizer)object4).nextToken().equals("type")) continue;
                                    String string = ((StringTokenizer)object4).nextToken();
                                    if ((string = string.substring(1, string.length() - 1)).equals("text/xsl") || string.equals("text/xml") || string.equals("application/xml+xslt")) continue;
                                    bl2 = false;
                                }
                                if (bl2) {
                                    object4 = new StringTokenizer(object.getNodeValue(), " \t=");
                                    while (((StringTokenizer)object4).hasMoreTokens()) {
                                        if (!((StringTokenizer)object4).nextToken().equals("href")) continue;
                                        object3 = ((StringTokenizer)object4).nextToken();
                                        object3 = ((String)object3).substring(1, ((String)object3).length() - 1);
                                        stack.push(object3);
                                    }
                                }
                            }
                            object2 = object2.getNextSibling();
                        }
                        boolean bl3 = true;
                        xObject = null;
                        while (!stack.isEmpty()) {
                            object4 = this.getStylesheetFromPIURL((String)stack.pop(), node, xSLTInputSource != null ? xSLTInputSource.getSystemId() : null, bl3);
                            if (!bl3) {
                                xObject.setImport((StylesheetComposed)object4);
                            }
                            xObject = object4;
                            bl3 = false;
                        }
                    }
                } else {
                    this.error(48);
                }
                if (templates == null) {
                    if (this.m_stylesheetRoot != null) {
                        templates = this.m_stylesheetRoot.getObject();
                    } else {
                        this.error(49);
                        return;
                    }
                }
                if (templates == null) break block37;
                try {
                    this.m_transformerImpl = (TransformerImpl)templates.newTransformer();
                    if (this.m_problemListener != null) {
                        this.m_transformerImpl.setErrorListener((ErrorListener)((Object)this.m_problemListener));
                    }
                    if (this.m_liaison != null) {
                        this.m_transformerImpl.getXPathContext().setDOMHelper((DOMHelper)this.m_liaison);
                    }
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException(transformerConfigurationException);
                }
                if (this.m_stylesheetParams != null) {
                    object3 = this.m_stylesheetParams.keys();
                    while (object3.hasMoreElements()) {
                        String string = (String)object3.nextElement();
                        object2 = this.m_stylesheetParams.get(string);
                        this.m_transformerImpl.setParameter(string, null, object2);
                    }
                }
                try {
                    this.m_transformerImpl.transform((Source)new DOMSource(node), xSLTResultTarget.getResultObject());
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
                if (this.m_diagnosticsPrintWriter != null) {
                    this.displayDuration("Total time", bl);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.error(0, new Object[]{malformedURLException.getMessage()}, malformedURLException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(0, new Object[]{fileNotFoundException.getMessage()}, fileNotFoundException);
            }
            catch (IOException iOException) {
                this.error(0, new Object[]{iOException.getMessage()}, iOException);
            }
            catch (SAXException sAXException) {
                this.error(79, sAXException);
            }
        }
    }

    public StylesheetRoot processStylesheet(String string) throws SAXException {
        try {
            XSLTInputSource xSLTInputSource = new XSLTInputSource(XSLTEngineImpl.getURLFromString(string, null).toString());
            return this.processStylesheet(xSLTInputSource);
        }
        catch (SAXException sAXException) {
            this.error(78, sAXException);
            return null;
        }
    }

    public StylesheetRoot processStylesheet(XSLTInputSource xSLTInputSource) throws SAXException {
        try {
            if (((TransformerFactoryImpl)this.m_tfactory).newTemplatesHandler().getTemplates() != null) {
                this.reset();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
        String string = xSLTInputSource == null || xSLTInputSource.getSystemId() == null ? "Input XSL" : xSLTInputSource.getSystemId();
        this.m_stylesheetRoot = null;
        try {
            StylesheetHandler stylesheetHandler = new StylesheetHandler((TransformerFactoryImpl)this.m_tfactory);
            Source source = xSLTInputSource.getSourceObject();
            if (source instanceof DOMSource) {
                if (((DOMSource)source).getNode() instanceof StylesheetRoot) {
                    this.m_stylesheetRoot = (StylesheetRoot)((Object)((DOMSource)source).getNode());
                } else {
                    stylesheetHandler.setSystemId(xSLTInputSource.getSystemId());
                    TreeWalker treeWalker = new TreeWalker((ContentHandler)stylesheetHandler, (DOMHelper)new DOM2Helper());
                    treeWalker.traverse(((DOMSource)source).getNode());
                    this.m_stylesheetRoot = new StylesheetRoot(stylesheetHandler.getStylesheetRoot());
                }
            } else {
                this.m_stylesheetRoot = this.createStylesheetRoot(xSLTInputSource.getSystemId(), xSLTInputSource);
                this.addTraceListenersToStylesheet();
                stylesheetHandler.pushStylesheet((Stylesheet)this.m_stylesheetRoot.getObject());
                this.diag("========= Parsing " + string + " ==========");
                this.pushTime(string);
                if (this.m_liaison != null) {
                    this.m_liaison.parse(SAXSource.sourceToInputSource(source));
                }
                if (this.m_diagnosticsPrintWriter != null) {
                    this.displayDuration("Parse of " + string, string);
                }
            }
        }
        catch (Exception exception) {
            this.error(50, new Object[]{string}, exception);
        }
        return this.m_stylesheetRoot;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_documentHandler != null) {
            this.m_documentHandler.processingInstruction(string, string2);
        } else if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getInputContentHandler().processingInstruction(string, string2);
        }
    }

    void pushTime(Object object) {
        if (object != null) {
            this.m_durationsTable.put(object, new Long(System.currentTimeMillis()));
        }
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getTraceManager().removeTraceListener(traceListener);
        }
    }

    public void reset() {
        if (this.m_transformerImpl != null) {
            this.m_transformerImpl.reset();
        }
        this.m_stylesheetParams = null;
    }

    public void setDiagnosticsOutput(OutputStream outputStream) {
        this.setDiagnosticsOutput(new PrintWriter(outputStream));
    }

    public void setDiagnosticsOutput(PrintWriter printWriter) {
        this.m_diagnosticsPrintWriter = printWriter;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        if (documentHandler instanceof ParserAdapter) {
            this.m_transformerImpl.setContentHandler(((ParserAdapter)documentHandler).getContentHandler());
        } else if (documentHandler instanceof XSLTEngineImpl) {
            this.m_transformerImpl.setContentHandler(((XSLTEngineImpl)documentHandler).getTransformer().getContentHandler());
        } else if (documentHandler instanceof XMLSerializer) {
            try {
                this.m_transformerImpl.setContentHandler(((XMLSerializer)documentHandler).asContentHandler());
            }
            catch (IOException iOException) {}
        }
        this.m_documentHandler = documentHandler;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setFormatterListener(DocumentHandler documentHandler) {
        this.m_documentHandler = documentHandler;
    }

    public void setOutputFileName(String string) {
        this.m_outputFileName = string;
    }

    public void setOutputStream(OutputStream outputStream) {
        SourceTreeHandler sourceTreeHandler = new SourceTreeHandler(this.m_transformerImpl);
        sourceTreeHandler.setResult((Result)new StreamResult(outputStream));
    }

    public void setParameter(String string, Object object) {
        if (this.m_stylesheetParams == null) {
            this.m_stylesheetParams = new Hashtable();
        }
        this.m_stylesheetParams.put(string, object);
    }

    public void setProblemListener(ProblemListener problemListener) {
        this.m_problemListener = problemListener instanceof ProblemListenerDefault ? (ProblemListenerDefault)problemListener : new ProblemListenerDefault(problemListener);
        if (this.m_transformerImpl != null) {
            this.m_transformerImpl.setErrorListener((ErrorListener)((Object)this.m_problemListener));
        }
        this.m_tfactory.setErrorListener((ErrorListener)((Object)this.m_problemListener));
    }

    public void setQuietConflictWarnings(boolean bl) {
        if (this.m_transformerImpl != null) {
            this.m_transformerImpl.setQuietConflictWarnings(bl);
        }
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
        org.apache.xalan.templates.StylesheetRoot stylesheetRoot2 = stylesheetRoot.getObject();
        if (this.m_transformerImpl == null) {
            this.m_transformerImpl = (TransformerImpl)stylesheetRoot2.newTransformer();
        }
        this.m_transformerImpl.setStylesheet(stylesheetRoot2);
        if (this.m_problemListener != null) {
            this.m_transformerImpl.setErrorListener((ErrorListener)((Object)this.m_problemListener));
        }
    }

    public void setStylesheetParam(String string, String string2) {
        if (this.m_evalList == null) {
            this.m_evalList = new Vector();
        }
        if (!this.m_evalList.contains(string)) {
            this.m_evalList.addElement(string);
        }
        this.setParameter(string, string2);
        this.m_needToEval = true;
    }

    public void setStylesheetParam(String string, org.apache.xalan.xpath.XObject xObject) {
        this.setParameter(string, (Object)xObject);
    }

    public void setTraceSelect(boolean bl) {
        this.m_traceSelects = bl;
    }

    public void setTraceTemplateChildren(boolean bl) {
        this.m_traceTemplateChildren = bl;
    }

    public void setTraceTemplates(boolean bl) {
        this.m_traceTemplates = bl;
    }

    public void startCDATA() throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().startCDATA();
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().startDTD(string, string2, string3);
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_documentHandler != null) {
            this.m_documentHandler.startDocument();
        } else if (this.m_transformerImpl != null) {
            this.m_transformerImpl.getInputContentHandler().startDocument();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.m_documentHandler == null) {
            this.m_documentHandler = new ParserAdapter((Parser)new SAXParser());
            if (this.m_transformerImpl != null) {
                ((ParserAdapter)this.m_documentHandler).setContentHandler(this.m_transformerImpl.getInputContentHandler());
            }
        }
        this.m_documentHandler.startElement(string, attributeList);
    }

    public void startEntity(String string) throws SAXException {
        if (this.m_transformerImpl != null && this.m_transformerImpl.getInputLexicalHandler() != null) {
            this.m_transformerImpl.getInputLexicalHandler().startEntity(string);
        }
    }

    public void warn(int n) throws SAXException {
        this.warn(null, null, n, null);
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        this.warn(null, null, n, objectArray);
    }

    public void warn(Node node, Node node2, int n) throws SAXException {
        this.warn(node, node2, n, null);
    }

    public void warn(Node node, Node node2, int n, Object[] objectArray) throws SAXException {
        TransformerException transformerException;
        Throwable throwable = null;
        String string = XSLMessages.createWarning((int)n, (Object[])objectArray);
        SAXSourceLocator sAXSourceLocator = null;
        try {
            sAXSourceLocator = ((StylesheetHandler)((TransformerFactoryImpl)this.m_tfactory).newTemplatesHandler()).getLocator();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        DefaultErrorHandler defaultErrorHandler = this.m_problemListener == null ? (DefaultErrorHandler)this.m_tfactory.getErrorListener() : (DefaultErrorHandler)this.m_problemListener.getErrorHandler();
        TransformerException transformerException2 = transformerException = throwable == null ? new TransformerException(string, (SourceLocator)sAXSourceLocator) : new TransformerException(string, (SourceLocator)sAXSourceLocator, throwable);
        if (defaultErrorHandler != null) {
            try {
                defaultErrorHandler.warning(transformerException);
            }
            catch (TransformerException transformerException3) {
                throw new SAXException(transformerException3);
            }
        } else {
            throw new SAXException(transformerException);
        }
    }
}

