# Copyright (C) 27 June 2002  Author FoxMaSk <odemah@phpfr.org>
use Irssi;
use strict;
use vars qw($VERSION %IRSSI);
                                            
$VERSION = "0.0.7"; 
%IRSSI = (
    authors => 'FoxMaSk',
    contact => 'odemah\@phpfr.org ',
    name => 'hello',
    description => 'answer hello to anybody who says hello to you (in a more complete way :-)',
    license => 'GNU GPL',
    url => 'http://team.gcu-squad.org/~odemah/',
    changed => 'Tue Sep 10 10:00:00 CET 2002',
);

#INSTALL : 
# script load hello.pl
# set hello_msg hi|hello|morning (for example)
# that's all :)
#
# set your custom hello_msg answer/detection as simple as possible or the regexp will be false ; 
# i mean $1 and $3 will not receive the hello msg like script hopes :-)


#CHANGES :
# 10/09/2002 hello_say() recognizes more ways to answer to hello. 
#  NOW :
#    if ( $msg =~ /^($hello_msg):? (.*)?$server->{nick}/i ) { .... }
#    elsif ( $msg =~ /^(.*)?$server->{nick}:? (.*)?($hello_msg)/i) { .... }
#  BEFORE :
#    if ( $msg =~ /^($hello_msg):? $server->{nick}$/i or $msg =~ /^$server->{nick}:? ($hello_msg)/i) { .... }
# 09/07/2002 use a hash to store the nick , channel and server to be sure to answer hello once.
# 07/07/2002 Fixing an infinite loooooop of hello answer to anyone else that use the script too :)
#            store the nick , channel and server to be sure to answer hello once.
# 28/06/2002 Adding : Irssi::setting_add_str and Irssi::setting_get_str
#
# 09/01/2003 Change of the $hello_msg which reacted wird :)

#TODO
#sub hello_quit {
#    my ($server,$nick,$addr,$reason) = @_;
#   Irssi::print grep { $_->nick_find($nick) } $server->channels;
#   Irssi::print map $_->{name}, grep $_->nick_find($nick), $server->channels;
#}

#If someone change his nick and has already told me hello
#change the nick in hash too. 
#sub hello_nick {
#    my ($server,$newnick, $oldnick, $addr) = @_;
#
#    #i have to find the channel name !
#    my $channel="";
#
#    if ( exists ( $hellonicks{"$server->{tag}/$channel/$oldnick"} ) ) {
#        delete( $hellonicks{"$server->{tag}/$channel/$oldnick"} );
#        $hellonicks{"$server->{tag}/$channel/$newnick"}="hello";
#    }
#}


my %hellonicks = ();

#main sub : for public message
sub hello_say {
    my ($server, $msg, $nick, $address, $channel) = @_;
    my $hello_msg = Irssi::settings_get_str("hello_msg");
    
    # PART 1 : HELLO BEGINS THE LINE
    #$hello_msg + something (optionnally) + your nick + something (optionnally)
    #example : hello foxmask
    #example : hello foxmask friend1
    #example : hello friend1 foxmask friend2
    if ( $msg =~ /^($hello_msg):? (.*)?$server->{nick}/i ) { 
        if (! exists($hellonicks{"$server->{tag}/$channel/$nick"} ) ) {
            $hellonicks{"$server->{tag}/$channel/$nick"} = "hello";
            $server->command("msg $channel $nick: $1");
        }
    }
    
    # PART 2 : HELLO ENDS THE LINE
    #something (optionnally) + your nick + something (optionnaly) + $hello_msg
    #example : foxmask hello
    #example : friend1 foxmask hello
    #example : friend1 foxmask friend2 hello
    elsif ( $msg =~ /^(.*)?$server->{nick}:? (.*)?($hello_msg)/i) {
        if (! exists($hellonicks{"$server->{tag}/$channel/$nick"} ) ) {
            $hellonicks{"$server->{tag}/$channel/$nick"} = "hello";
            $server->command("msg $channel $nick: $3");
        }
    }
}

#when i say hello to someone i save his nick 
#to avoid to answer him if he answers me :)
sub hello_own {
    my ($server, $msg, $channel) = @_;
    my $hello_msg = Irssi::settings_get_str("hello_msg");
    my $nick = ""; my $find = "";
    if ( $msg =~ /^($hello_msg) (\w+)/i ) {
        $nick = $2;
    } elsif ( $msg =~ /^(\w+):? ($hello_msg)$/i) {
        $nick = $1;
    }
    if ($nick ne '') {
        if (! exists($hellonicks{"$server->{tag}/$channel/$nick"} ) ) {
            $hellonicks{"$server->{tag}/$channel/$nick"}="hello";
        }
    }
}

#remove the nick that quits if [he|i] says? hello to [me|him] 
sub hello_join {
    my ($server,$channel, $nick,$addr) = @_;

    if ( exists($hellonicks{"$server->{tag}/$channel/$nick"} ) ) {
        delete($hellonicks{"$server->{tag}/$channel/$nick"} );
    }
}    

#remove the nick that parts the current channel if [he|i] says? hello to [me|him]
sub hello_part {
    my ($server,$channel, $nick,$addr,$reason) = @_;
    if ( exists($hellonicks{"$server->{tag}/$channel/$nick"} ) ) {
        delete($hellonicks{"$server->{tag}/$channel/$nick"} );
    }
}

sub hello_show {
    #who said hello to me :)
    my $key="";
    Irssi::print ",----[ Hello made by ...]";
    foreach $key (keys %hellonicks) {
        Irssi::print "|   $hellonicks{$key} from/to $key";
    }
    Irssi::print "`----[ Hello $VERSION ] ";
}

sub hello_help {
    Irssi::print ",----[ Hello Help  ...]";
    Irssi::print "|  To setup your custom hello_msg answer/detector just enter, for example :";
    Irssi::print "|  set hello_msg hi|hello|morning";
    Irssi::print "|  that's all :)";
    Irssi::print "|  hello_show : displays the list of people who said hello to you or to who you said hello";
    Irssi::print "|  hello_help : this message";
    Irssi::print "`----[ Hello $VERSION ] ";
}

Irssi::settings_add_str($IRSSI{'name'},"hello_msg","yop?|coucou|bonsoir|bonjour|hel?lo|ehlo|sa?lu?t|pouette|plop|kikoo?u?|h?ola|tchuss");

Irssi::signal_add_last('message own_public' , 'hello_own'  );
Irssi::signal_add_last("message part"       , "hello_part" );
Irssi::signal_add_last("message join"       , "hello_join" );
Irssi::signal_add_last("message public"     , "hello_say"   );
# Irssi::signal_add_last("message nick"       , "hello_nick"  );
# Irssi::signal_add_last("message quit"       , "hello_quit"  );

Irssi::command_bind   ("hello_show"         , "hello_show" );
Irssi::command_bind   ("hello_help"         , "hello_help" );

Irssi::print          ("Hello $VERSION loaded!");
