/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private File listing;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private String chmod = null;
    private String umask = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing", "making directory", "chmod"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed", "created directory", "mode changed"};

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void setChmod(String theMode) {
        this.chmod = theMode;
    }

    public void setUmask(String theUmask) {
        this.umask = theUmask;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(String action) throws BuildException {
        this.log("DEPRECATED - The setAction(String) method has been deprecated. Use setAction(FTP.Action) instead.");
        Action a = new Action();
        a.setValue(action);
        this.action = a.getAction();
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setListing(File listing) throws BuildException {
        this.listing = listing;
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, ((ProjectComponent)this).project);
            ds.scan();
        }
        String[] dsfiles = ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            if (this.action == 3) {
                File pd = this.fileUtils.getParentFile(this.listing);
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.listing));
            }
            int i = 0;
            while (i < dsfiles.length) {
                switch (this.action) {
                    case 0: {
                        this.sendFile(ftp, dir, dsfiles[i]);
                        break;
                    }
                    case 1: {
                        this.getFile(ftp, dir, dsfiles[i]);
                        break;
                    }
                    case 2: {
                        this.delFile(ftp, dsfiles[i]);
                        break;
                    }
                    case 3: {
                        this.listFile(ftp, bw, dsfiles[i]);
                        break;
                    }
                    case 5: {
                        this.doSiteCommand(ftp, "chmod " + this.chmod + " " + dsfiles[i]);
                        ++this.transferred;
                        break;
                    }
                    default: {
                        throw new BuildException("unknown ftp action " + this.action);
                    }
                }
                ++i;
            }
            Object var9_9 = null;
            if (bw == null) return dsfiles.length;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bw == null) throw throwable;
            bw.close();
            throw throwable;
        }
        bw.close();
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.transferFiles(ftp, fs);
            }
            ++i;
        }
        this.log(this.transferred + " files " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " files were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    /*
     * WARNING - void declaration
     */
    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        String dirname;
        Vector<File> parents = new Vector<File>();
        File dir = new File(filename);
        while ((dirname = dir.getParent()) != null) {
            void var5_5;
            dir = new File((String)var5_5);
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        while (i >= 0) {
            dir = (File)parents.elementAt(i);
            if (!this.dirCache.contains(dir)) {
                this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                if (!ftp.makeDirectory(this.resolveFile(dir.getPath()))) {
                    this.handleMkDirFailure(ftp);
                }
                this.dirCache.addElement(dir);
            }
            --i;
        }
    }

    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.action == 0) {
                this.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        if (this.action == 0) {
            return remoteTimestamp > localTimestamp;
        }
        return localTimestamp > remoteTimestamp;
    }

    protected void doSiteCommand(FTPClient ftp, String TheCMD) throws IOException, BuildException {
        String[] MyReply = null;
        this.log("Doing Site Command: " + TheCMD, 3);
        boolean rc = ftp.sendSiteCommand(TheCMD);
        if (!rc) {
            this.log("Failed to issue Site Command: " + TheCMD, 1);
        } else {
            MyReply = ftp.getReplyStrings();
            int x = 0;
            while (x < MyReply.length) {
                if (MyReply[x].indexOf("200") == -1) {
                    this.log(MyReply[x], 1);
                }
                ++x;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            instream = null;
            try {
                file = this.project.resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (instream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + file.getAbsolutePath());
                }
                instream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(ftp, filename);
                ftp.storeFile(this.resolveFile(filename), instream);
                success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
                if (!success) {
                    s = "could not put file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                if (this.chmod != null) {
                    this.doSiteCommand(ftp, "chmod " + this.chmod + " " + filename);
                }
                this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("File " + filename + " deleted from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            outstream = null;
            try {
                file = this.project.resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (outstream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + filename + " to " + file.getAbsolutePath());
                }
                if (!(pdir = this.fileUtils.getParentFile(file)).exists()) {
                    pdir.mkdirs();
                }
                outstream = new BufferedOutputStream(new FileOutputStream(file));
                ftp.retrieveFile(this.resolveFile(filename), outstream);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    s = "could not get file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("listing " + filename);
        }
        FTPFile ftpfile = ftp.listFiles(this.resolveFile(filename))[0];
        bw.write(ftpfile.toString());
        bw.newLine();
        ++this.transferred;
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        if (this.verbose) {
            this.log("creating directory: " + dir);
        }
        if (!ftp.makeDirectory(dir)) {
            this.handleMkDirFailure(ftp);
            if (this.verbose) {
                this.log("directory already exists");
            }
        } else if (this.verbose) {
            this.log("directory created OK");
        }
    }

    private void handleMkDirFailure(FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: " + ftp.getReplyString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.checkConfiguration();
        FTPClient ftp = null;
        try {
            try {
                this.log("Opening FTP connection to " + this.server, 3);
                ftp = new FTPClient();
                ftp.connect(this.server, this.port);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("FTP connection failed: " + ftp.getReplyString());
                }
                this.log("connected", 3);
                this.log("logging in to FTP server", 3);
                if (!ftp.login(this.userid, this.password)) {
                    throw new BuildException("Could not login to FTP server");
                }
                this.log("login succeeded", 3);
                if (this.binary) {
                    ftp.setFileType(2);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                    }
                }
                if (this.passive) {
                    this.log("entering passive mode", 3);
                    ftp.enterLocalPassiveMode();
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not enter into passive mode: " + ftp.getReplyString());
                    }
                }
                if (this.umask != null) {
                    this.doSiteCommand(ftp, "umask " + this.umask);
                }
                if (this.action == 4) {
                    this.makeRemoteDir(ftp, this.remotedir);
                } else {
                    if (this.remotedir != null) {
                        this.log("changing the remote directory", 3);
                        ftp.changeWorkingDirectory(this.remotedir);
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                        }
                    }
                    this.log(ACTION_STRS[this.action] + " files");
                    this.transferFiles(ftp);
                }
            }
            catch (IOException ex) {
                throw new BuildException("error during FTP transfer: " + ex);
            }
            Object var4_2 = null;
            if (ftp == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (ftp == null) throw throwable;
            if (!ftp.isConnected()) throw throwable;
            try {
                this.log("disconnecting", 3);
                ftp.logout();
                ftp.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        if (!ftp.isConnected()) return;
        try {}
        catch (IOException ex) {}
        this.log("disconnecting", 3);
        ftp.logout();
        ftp.disconnect();
        return;
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] validActions = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod"};

        public String[] getValues() {
            return validActions;
        }

        public int getAction() {
            String actionL = this.getValue().toLowerCase(Locale.US);
            if (actionL.equals("send") || actionL.equals("put")) {
                return 0;
            }
            if (actionL.equals("recv") || actionL.equals("get")) {
                return 1;
            }
            if (actionL.equals("del") || actionL.equals("delete")) {
                return 2;
            }
            if (actionL.equals("list")) {
                return 3;
            }
            if (actionL.equals("chmod")) {
                return 5;
            }
            if (actionL.equals("mkdir")) {
                return 4;
            }
            return 0;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.scandir(".", "", true);
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                FTPFile[] newfiles = this.ftp.listFiles();
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                int i = 0;
                while (i < newfiles.length) {
                    FTPFile file = newfiles[i];
                    if (!file.getName().equals(".") && !file.getName().equals("..")) {
                        String name;
                        if (file.isDirectory()) {
                            name = vpath + file.getName();
                            if (this.isIncluded(name)) {
                                if (!this.isExcluded(name)) {
                                    this.dirsIncluded.addElement(name);
                                    if (fast) {
                                        this.scandir(file.getName(), name + File.separator, fast);
                                    }
                                } else {
                                    this.dirsExcluded.addElement(name);
                                    if (fast && this.couldHoldIncluded(name)) {
                                        this.scandir(file.getName(), name + File.separator, fast);
                                    }
                                }
                            } else {
                                this.dirsNotIncluded.addElement(name);
                                if (fast && this.couldHoldIncluded(name)) {
                                    this.scandir(file.getName(), name + File.separator, fast);
                                }
                            }
                            if (!fast) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        } else if (file.isFile()) {
                            name = vpath + file.getName();
                            if (this.isIncluded(name)) {
                                if (!this.isExcluded(name)) {
                                    this.filesIncluded.addElement(name);
                                } else {
                                    this.filesExcluded.addElement(name);
                                }
                            } else {
                                this.filesNotIncluded.addElement(name);
                            }
                        }
                    }
                    ++i;
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }
    }
}

