(*  Copyright (c) 2001 Anthony L Shipman *)

(*  This demonstrates some termio operations. *)

structure Main=
struct
    structure TTY = Posix.TTY

    fun toErr msg = TextIO.output(TextIO.stdErr, msg)
    exception Error of string


    fun setErase ch =
    let
	val fd   = Posix.FileSys.wordToFD 0w0
	val attr = TTY.getattr fd
	val new_attr = TTY.termios {
		iflag  = TTY.getiflag attr,
		oflag  = TTY.getoflag attr,
		cflag  = TTY.getcflag attr,
		lflag  = TTY.getlflag attr,
		cc     = TTY.V.update
			    (TTY.getcc attr, [(TTY.V.erase, ch)]),
		ispeed = TTY.getispeed attr,
		ospeed = TTY.getospeed attr
		}
    in
	TTY.setattr(fd, TTY.TC.sanow, new_attr)
    end


    fun parseControl s =
    let
	fun bad() = raise Error
		"Invalid control character\n"
    in
	case explode s of
	  [#"^", c] => Char.chr(Word.toInt(
	  	Word.andb(Word.fromInt(Char.ord c), 0wx1f)))

	| [c] => if Char.isCntrl c then c else bad()

	| _ => bad()
    end


    fun main(arg0, argv) =
    let
    in
	case argv of
	  ("erase"::ch::_) => setErase (parseControl ch)

	| _ => raise Error "Usage: ttyx [erase ch]\n";

        OS.Process.success
    end
    handle
      IO.Io {name, function, cause} =>
	(
	    toErr(concat["IO Error: ", name,
	                 ", ", exnMessage cause, "\n"]);
	    OS.Process.failure
	)

    | Error msg => (toErr msg; OS.Process.failure)

    | x => (toErr(concat["Uncaught exception: ", exnMessage x,"\n"]);
    	    OS.Process.failure)


    val _ = SMLofNJ.exportFn("ttyx", main)
end
