(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    fun count strm file =
    let
	fun read (nchars, nwords, nlines) =
	(
	    (* This ensures the line ends with a \n
	       unless we are at eof.
	    *)
	    case TextIO.inputLine strm of
	      "" => (nchars, nwords, nlines)

	    | line =>
		let
		    val words = String.tokens Char.isSpace line
		in
		    read (nchars + size line,
		          nwords + length words,
			  nlines + 1)
		end
	)

	val (nchars, nwords, nlines) = read (0, 0, 0)
    in
	print(concat[Int.toString nlines, " ",
		     Int.toString nwords, " ",
		     Int.toString nchars, " ",
		     file, "\n"])
    end


    fun main(arg0, argv) =
    let
    in
	case argv of
	  [] => count TextIO.stdIn ""

	| (file::_) =>
	    let
		val strm = TextIO.openIn file
	    in
		(count strm file) handle x =>
		    (TextIO.closeIn strm; raise x);
		TextIO.closeIn strm
	    end;

        OS.Process.success
    end
    handle
      IO.Io {name, function, cause} =>
	(
	    toErr(concat["IO Error: ", name,
	                 ", ", exnMessage cause, "\n"]);
	    OS.Process.failure
	)

    | x => (toErr(concat["Uncaught exception: ", exnMessage x,"\n"]);
    	    OS.Process.failure)


    val _ = SMLofNJ.exportFn("wcx", main)
end
