
structure Main =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    datatype Msg = Msg of unit CML.event

    val req_chan: Msg CML.chan  = CML.channel()
    val rpl_chan: unit CML.chan = CML.channel()


    fun server t =
    let
	fun loop() =
	(
	    case CML.recv req_chan of
	      Msg nack =>
	    (
		delay t; 

		CML.select [
		    CML.sendEvt(rpl_chan, ()), 
		    CML.wrap(nack, fn () => print "Got a nack\n")
		    ];

		loop()
	    )
	)
    in
	CML.spawn loop
    end



    and reqEvt () =
    let
	fun sender nack_evt =
	(
	    CML.send(req_chan, Msg nack_evt);
	    CML.recvEvt rpl_chan
	)
    in
	CML.withNack sender
    end



    and client t =
    let
	fun body() =
	(
	    CML.select[
		CML.wrap(reqEvt(),   fn () => print "got the reply\n"),
		CML.wrap(time_out t, fn () => print "client timed out\n") 
		];

	    print "done client\n"
	)
	handle
	  x => print(concat["exception: '", exnMessage x, "' in client\n"])
    in
	ignore(CML.spawn body)
    end


    and time_out t = CML.timeOutEvt(Time.fromSeconds(Int.toLarge t))
    and delay t    = CML.sync(time_out t)


    fun run() =
    (
	print "Test\n";
	server 3;   (* send reply after client times out *)
	client 2
    )


    fun main(arg0, argv) =
    let
    in
	RunCML.doit(run, NONE);
        OS.Process.success
    end
    handle
      x => (print(concat["exception: ", exnMessage x, " in main\n"]);
      	    OS.Process.failure)

    val _ = SMLofNJ.exportFn("nackbug", main)
end




