(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    fun main(arg0, argv) =
    let
	fun bad() = raise Fail "bye"
    in
	bad();
        OS.Process.success
    end
    handle x => (
	toErr(concat["Uncaught exception: ",
	             exnMessage x, " from\n"]);

	app (fn s => (print "\t"; print s; print "\n"))
		(SMLofNJ.exnHistory x);

	OS.Process.failure
	)

    val _ = SMLofNJ.exportFn("exnhist", main)
end



