(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct
    structure O = Unsafe.Object
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    (*	Estimate the size of v in 32-bit words.
	Boxed objects have an extra descriptor word
	which also contains the length for vectors
	and arrays.
    *)
    fun sizeof v =
    let
	fun obj_size obj =
	(
	    case O.rep obj of
	      O.Unboxed	=> 1	(* inline 31 bits *)
	    | O.Real	=> 1+2

	    | O.Pair      => tup_size obj
	    | O.Record    => tup_size obj
	    | O.RealArray => tup_size obj

	    | O.PolyArray => arr_size obj

	    (* includes Word8Vector.vector
	       and CharVector.vector
	    *)
	    | O.ByteVector => 1 +
		((size(O.toString obj)+3) div 4)

	    (* includes Word8Array.array
	       and CharArray.array
	    *)
	    | O.ByteArray =>  1 +
		((Array.length(O.toArray obj)+3) div 4)

	    | _ => 2	(* punt for other objects *)
	)

	(*  Count the record plus the size of
	    pointed-to objects in the heap.
	*)
	and tup_size obj =
	let
	    fun sz obj =
		if O.boxed obj
		then
		    1 + (obj_size obj)
		else
		    1
	in
	    Vector.foldl
		(fn (obj, s) => s + (sz obj))
		1
		(O.toTuple obj)
	end

	and arr_size obj =
	let
	    fun sz obj =
		if O.boxed obj
		then
		    1 + (obj_size obj)
		else
		    1
	in
	    Array.foldl
		(fn (obj, s) => s + (sz obj))
		1
		(O.toArray obj)
	end
    in
	obj_size(O.toObject v)
    end



    fun main(arg0, argv) =
    let
	fun show name v = print(concat[
		"Size of ", name,
		" = ", Int.toString(sizeof v),
		" 32-bit words\n"])
    in
	show "integer"	3;
	show "real"	3.3;
	show "string"	"abc";

	show "pair"	("abc", 42);
	show "record"	{a = 1, b = 4.5, c = "fred"};

        OS.Process.success
    end
    handle x => (
	toErr(concat["Uncaught exception: ",
	             exnMessage x, "\n"]);
	OS.Process.failure)


    val _ = SMLofNJ.exportFn("sizeof", main)
end

