(*  Copyright (c) 2001 Anthony L Shipman *)


structure Common =
struct

(*-------------------------------------------------*)
(*  A hash table with string keys. *)

    structure STRT_key =
    struct
	type hash_key = string
	val hashVal = HashString.hashString
	fun sameKey (s1, s2) = (s1 = s2)
    end

    structure STRT = HashTableFn(STRT_key)

    exception NotFound

(*-------------------------------------------------*)

end


structure Table:
    sig
	val set:    string * string -> unit
	val get:    string -> string option
    end =
struct
    open Common

    type Table = string STRT.hash_table

    val susp = SMLofNJ.Susp.delay(fn () =>
    		STRT.mkTable(101, NotFound): Table)

    fun table() = SMLofNJ.Susp.force susp

    fun set (k, v) = STRT.insert (table()) (k, v)
    fun get k      = STRT.find (table()) k
end


structure Main =
struct

    fun main(arg0, argv) =
    let
    in
	Table.set("fox", "brown");
	print(concat["The fox is ", valOf(Table.get "fox"), "\n"]);

        OS.Process.success
    end

    val _ = SMLofNJ.exportFn("susp", main)
end



