(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main =
struct

    fun serve port =
    let
	fun run listener =
	let
	    fun accept() =
	    let
		val (conn, conn_addr) = Socket.accept listener
	    in
		respond conn;
		accept()
	    end

	    and respond conn =
	    let
		val msg = "hello world from tcpserver\n"
		val buf = {buf = Byte.stringToBytes msg,
			   i = 0, sz = NONE}
	    in
		ignore(Socket.sendVec(conn, buf));
		Socket.close conn
	    end
	    handle x => (Socket.close conn; raise x)

	in
	    Socket.Ctl.setREUSEADDR(listener, true);
	    Socket.bind(listener, INetSock.any port);
	    Socket.listen(listener, 9);
	    accept()
	end
	handle x => (Socket.close listener; raise x)
    in
	run (INetSock.TCP.socket())
    end
    handle OS.SysErr (msg, _) => raise Fail (msg ^ "\n")


    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    fun main(arg0, argv) =
    let
    in
	case argv of
	  [port] => 
	    (case Int.fromString port of
	      NONE => raise Fail "Invalid port number\n"

	    | SOME p => serve p)

	| _ => raise Fail "Usage: tcpserver port\n";

        OS.Process.success
    end
    handle
      Fail msg => (toErr msg; OS.Process.failure)

    | x =>
    (
	toErr(concat["Uncaught exception: ",
		     exnMessage x, " from\n"]);
	app (fn s => (print "\t"; print s; print "\n"))
	    (SMLofNJ.exnHistory x);
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("tcpserver", main)
end



