(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main =
struct
    fun alarm_handler(signal, n, cont) =
    let
    in
	print(concat["tick at ", Time.toString(Time.now()), "\n"]);
	cont
    end

    fun main(arg0, argv) =
    let
	fun loop() = (Signals.pause(); loop())
    in
	Signals.setHandler(
	    Signals.sigALRM,
	    Signals.HANDLER alarm_handler);

	SMLofNJ.IntervalTimer.setIntTimer
	    (SOME(Time.fromSeconds 1));

	loop();

        OS.Process.success
    end

    val _ = SMLofNJ.exportFn("ticker", main)
end


