(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: common.sml,v 1.12 2001/09/06 20:08:16 felix Exp $ *)

(*  Useful common declarations. *)


structure Common =
struct 

(*-------------------------------------------------------------------*)

    exception FatalX
    exception InternalError of string

    fun toErr s = (TextIO.output(TextIO.stdErr, s);
    		   TextIO.flushOut(TextIO.stdErr))

    (*	These shutdown the server with the given status code. *)
    fun success() = RunCML.shutdown OS.Process.success
    fun fail()    = (toErr "Aborting\n"; RunCML.shutdown OS.Process.failure)

(*-------------------------------------------------------------------*)

    datatype SrcPos = SrcPos of {
    	file:	string,
	line:	int,			(* first line is line 1 *)
	col:	int			(* left-most column is col 1 *)
	}

    fun formatPos (SrcPos {file, line, col}) =
    (
	concat[file, "@", Int.toString line, ".", Int.toString col]
    )


(*-------------------------------------------------------------------*)

    (* Construct a general purpose map with strings as keys. *)

    structure STRT_key =
    struct
	type hash_key = string
	val hashVal = HashString.hashString
	fun sameKey (s1, s2) = (s1 = s2)
    end

    exception NotFound

    structure STRT = HashTableFn(STRT_key)

(*-------------------------------------------------------------------*)

    fun isVal   c1 c2 = (c1 = c2)
    fun isntVal c1 c2 = (c1 <> c2)

    fun upperCase str = String.map Char.toUpper str

(*-------------------------------------------------------------------*)

end
