(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: t_main.sml,v 1.2 2001/06/11 12:26:58 felix Exp $ *)

structure TestMain: sig end =
struct

    fun toErr s = TextIO.output(TextIO.stdErr, s)


    fun main(arg0, argv) =
    let
	fun run() =
	(
	    t_Utils.run();
	    t_Headers.run();

	    Log.flush();

	    if TestUtils.numFailures() = 0
	    then
		(print "All tests passed\n"; Common.success())
	    else
		(print "Tests failed\n"; Common.fail())
	)
	handle x =>
	(
	    toErr(concat["Uncaught exception ", exnName x, ": ",exnMessage x, "\n"]);
	    app (fn s => (print "\t"; print s; print "\n"))
		 (SMLofNJ.exnHistory x);
	    Common.fail()
	)


    in
	RunCML.doit(run, NONE)
    end

    val _ = SMLofNJ.exportFn("t_main", main)

end
