(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: node_handler_sig.sml,v 1.5 2001/08/15 19:03:16 felix Exp $ *)

(*  All node handlers are specialised with one of these structures.

@#34567890123456789012345678901234567890123456789012345678901234567890
*)

signature NODE_HANDLER =
sig

    (*	A value of this type is passed to the create function for the
	handler.
    *)
    type CreateArg

    (*	Create the thread for the handler. Optionally a new
	node configuration can be returned to update the original
	configuration.	All security-related initialisation must be
	done in here so that the master node will be blocked until
	it is ready.

	The caller should be prepared to handle exceptions from here if
	the creation fails.
    *)
    val init:	CreateArg -> Node.HndMbox * (Config.SwerveConfig option)


    (*	This tests if the handler will take the last segment
	of the URL path. For example a directory node wants
	the last segment as a file name.
    *)
    val	canTakeLast:	Config.NodeConfig -> bool


    (*	This tests if the handler will take all of the
	rest of the URL path if there are no child nodes.
    *)
    val	canTakeRest:	Config.NodeConfig -> bool

end

