/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import IceGridGUI.CellRenderer;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.Root;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.SimpleInternalFrame;
import IceGridGUI.Tab;
import IceGridGUI.TreeNodeBase;
import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreePath;

public class LiveDeploymentPane
extends JSplitPane
implements Tab {
    private Root _root;
    private SimpleInternalFrame _leftPane;
    private SimpleInternalFrame _propertiesFrame;
    private LinkedList _previousNodes = new LinkedList();
    private LinkedList _nextNodes = new LinkedList();
    private TreeNode _currentNode;
    private boolean _selectionListenerEnabled = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void updateUI() {
        super.updateUI();
        this.setEmptyDividerBorder();
    }

    public void selected() {
        Coordinator c = this._root.getCoordinator();
        c.getCloseApplicationAction().setEnabled(false);
        c.getSaveAction().setEnabled(false);
        c.getSaveToRegistryAction().setEnabled(false);
        c.getSaveToFileAction().setEnabled(false);
        c.getDiscardUpdatesAction().setEnabled(false);
        c.getBackAction().setEnabled(this._previousNodes.size() > 0);
        c.getForwardAction().setEnabled(this._nextNodes.size() > 0);
        c.showActions(this._currentNode);
    }

    public void refresh() {
        if (this._currentNode != null) {
            this._currentNode.getEditor();
            if (this._root.getCoordinator().getCurrentTab() == this) {
                this._root.getCoordinator().showActions(this._currentNode);
            }
        }
    }

    public void showNode(TreeNodeBase node) {
        TreeNode newNode = (TreeNode)node;
        if (newNode != this._currentNode) {
            if (newNode == null) {
                this._currentNode = null;
                this.showCurrentNode();
            } else {
                if (this._currentNode != null && this._root.hasNode(this._currentNode)) {
                    this._previousNodes.add(this._currentNode);
                    while (this._previousNodes.size() >= 20) {
                        this._previousNodes.removeFirst();
                    }
                    this._root.getCoordinator().getBackAction().setEnabled(true);
                }
                this._nextNodes.clear();
                this._root.getCoordinator().getForwardAction().setEnabled(false);
                this._currentNode = newNode;
                this.showCurrentNode();
            }
        } else {
            this.refresh();
        }
    }

    public void back() {
        TreeNode previousNode = null;
        do {
            previousNode = (TreeNode)this._previousNodes.removeLast();
        } while (this._previousNodes.size() > 0 && (previousNode == this._currentNode || !this._root.hasNode(previousNode)));
        if (this._previousNodes.size() == 0) {
            this._root.getCoordinator().getBackAction().setEnabled(false);
        }
        if (previousNode != this._currentNode) {
            if (this._currentNode != null) {
                this._nextNodes.addFirst(this._currentNode);
                this._root.getCoordinator().getForwardAction().setEnabled(true);
            }
            this._currentNode = previousNode;
            this._selectionListenerEnabled = false;
            this._root.setSelectedNode(this._currentNode);
            this._selectionListenerEnabled = true;
            this.showCurrentNode();
        }
    }

    public void forward() {
        TreeNode nextNode = null;
        do {
            nextNode = (TreeNode)this._nextNodes.removeFirst();
        } while (this._nextNodes.size() > 0 && (nextNode == this._currentNode || !this._root.hasNode(nextNode)));
        if (this._nextNodes.size() == 0) {
            this._root.getCoordinator().getForwardAction().setEnabled(false);
        }
        if (nextNode != this._currentNode) {
            if (this._currentNode != null) {
                this._previousNodes.add(this._currentNode);
                this._root.getCoordinator().getBackAction().setEnabled(true);
            }
            this._currentNode = nextNode;
            this._selectionListenerEnabled = false;
            this._root.setSelectedNode(this._currentNode);
            this._selectionListenerEnabled = true;
            this.showCurrentNode();
        }
    }

    public void save() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void saveToRegistry() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void saveToFile() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void discardUpdates() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean close() {
        return false;
    }

    LiveDeploymentPane(Root root) {
        super(1, true);
        this._root = root;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        CellRenderer renderer = new CellRenderer();
        PopupListener popupListener = new PopupListener();
        JTree tree = this._root.getTree();
        tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        tree.setCellRenderer(renderer);
        ToolTipManager.sharedInstance().registerComponent(tree);
        tree.addMouseListener(popupListener);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new SelectionListener());
        tree.setRootVisible(false);
        JScrollPane leftScroll = new JScrollPane(tree, 20, 30);
        leftScroll.setBorder(Borders.EMPTY_BORDER);
        this._leftPane = new SimpleInternalFrame("Runtime Components");
        this._leftPane.setContent(leftScroll);
        this._leftPane.setPreferredSize(new Dimension(280, 350));
        this._propertiesFrame = new SimpleInternalFrame("Properties");
        this.setLeftComponent(this._leftPane);
        this.setRightComponent(this._propertiesFrame);
    }

    private void showCurrentNode() {
        this._root.getCoordinator().showActions(this._currentNode);
        if (this._currentNode == null) {
            Component oldContent = this._propertiesFrame.getContent();
            if (oldContent != null) {
                this._propertiesFrame.remove(oldContent);
            }
            this._propertiesFrame.setTitle("Properties");
            this._propertiesFrame.setToolBar(null);
        } else {
            Editor editor = this._currentNode.getEditor();
            JComponent currentProperties = editor.getProperties();
            this._propertiesFrame.setContent(currentProperties);
            this._propertiesFrame.setTitle(currentProperties.getName());
            this._propertiesFrame.setToolBar(editor.getToolBar());
        }
        this._propertiesFrame.validate();
        this._propertiesFrame.repaint();
    }

    private void setEmptyDividerBorder() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    static {
        $assertionsDisabled = !LiveDeploymentPane.class.desiredAssertionStatus();
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreeNode node;
            JPopupMenu popup;
            JTree tree;
            TreePath path;
            if (e.isPopupTrigger() && (path = (tree = (JTree)e.getComponent()).getPathForLocation(e.getX(), e.getY())) != null && (popup = (node = (TreeNode)path.getLastPathComponent()).getPopupMenu()) != null) {
                popup.show(tree, e.getX(), e.getY());
            }
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (LiveDeploymentPane.this._selectionListenerEnabled) {
                TreePath path = null;
                if (e.isAddedPath()) {
                    path = e.getPath();
                }
                if (path == null) {
                    LiveDeploymentPane.this.showNode(null);
                } else {
                    LiveDeploymentPane.this.showNode((TreeNode)path.getLastPathComponent());
                }
            }
        }
    }
}

