/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.ListTextField;
import IceGridGUI.Application.PropertiesField;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class PropertySetEditor
extends Editor {
    private String _oldId;
    private final JTextField _id = new JTextField(20);
    private final JLabel _idLabel;
    private ListTextField _propertySets = new ListTextField(20);
    private PropertiesField _properties;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyUpdate(boolean refresh) {
        PropertySet nps = (PropertySet)this._target;
        Root root = nps.getRoot();
        root.disableSelectionListener();
        try {
            PropertySetDescriptor descriptor;
            PropertySetParent parent = (PropertySetParent)((Object)nps.getParent());
            if (nps.isEphemeral()) {
                this.writeDescriptor();
                descriptor = (PropertySetDescriptor)nps.getDescriptor();
                nps.destroy();
                try {
                    parent.tryAdd(this.getIdText(), descriptor);
                }
                catch (UpdateFailedException e) {
                    block18: {
                        try {
                            parent.insertPropertySet(nps, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block18;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                this._target = ((TreeNode)((Object)parent)).findChildWithDescriptor(descriptor);
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            } else if (!this.isSimpleUpdate()) {
                descriptor = (PropertySetDescriptor)nps.getDescriptor();
                try {
                    parent.tryRename(this._target.getId(), this._oldId, this.getIdText());
                }
                catch (UpdateFailedException e) {
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                this._target = ((TreeNode)((Object)parent)).findChildWithDescriptor(descriptor);
                this.writeDescriptor();
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            } else {
                this.writeDescriptor();
                root.updated();
                nps.getEditable().markModified();
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    Utils.Resolver getDetailResolver() {
        Root root = this._target.getRoot();
        if (root.getCoordinator().substitute()) {
            return this._target.getResolver();
        }
        return null;
    }

    PropertySetEditor() {
        this("ID");
        this._id.setToolTipText("The id of this Property Set");
        this._id.getDocument().addDocumentListener(this._updateListener);
    }

    protected PropertySetEditor(String label) {
        this._idLabel = new JLabel(label);
        this._propertySets.getDocument().addDocumentListener(this._updateListener);
        this._propertySets.setToolTipText("Property Set References");
        this._properties = new PropertiesField(this);
    }

    void writeDescriptor() {
        PropertySetDescriptor descriptor = (PropertySetDescriptor)this.getPropertySet().getDescriptor();
        descriptor.references = this._propertySets.getList().toArray(new String[0]);
        descriptor.properties = this._properties.getProperties();
    }

    boolean isSimpleUpdate() {
        return this.getIdText().equals(this._oldId);
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append(this._idLabel);
        builder.append((Component)this.getIdComponent(), 3);
        builder.nextLine();
        builder.append("Property Sets");
        builder.append((Component)this._propertySets, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        JScrollPane scrollPane = new JScrollPane(this._properties);
        CellConstraints cc = new CellConstraints();
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Named Property Set");
    }

    protected boolean validate() {
        return this.check(new String[]{this._idLabel.getText(), this.getIdText()});
    }

    void show(String unsubstitutedId, PropertySet nps) {
        this.detectUpdates(false);
        this._target = nps;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        PropertySetDescriptor descriptor = (PropertySetDescriptor)nps.getDescriptor();
        this.showId(unsubstitutedId, resolver);
        this._oldId = unsubstitutedId;
        this._propertySets.setList(Arrays.asList(descriptor.references), resolver);
        this._propertySets.setEditable(isEditable);
        this._properties.setProperties(descriptor.properties, null, null, this.getDetailResolver(), isEditable);
        this._applyButton.setEnabled(nps.isEphemeral());
        this._discardButton.setEnabled(nps.isEphemeral());
        this.detectUpdates(true);
        if (nps.isEphemeral()) {
            this.updated();
        }
    }

    protected JComponent getIdComponent() {
        return this._id;
    }

    protected String getIdText() {
        return this._id.getText().trim();
    }

    protected void showId(String unsubstitutedId, Utils.Resolver resolver) {
        this._id.setText(unsubstitutedId);
        this._id.setEditable(resolver == null);
    }

    private PropertySet getPropertySet() {
        return (PropertySet)this._target;
    }

    static {
        $assertionsDisabled = !PropertySetEditor.class.desiredAssertionStatus();
    }
}

