/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Current;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocalObjectHolder;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.ServantLocator;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceUtil.OutputBase;
import IceUtil.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class IncomingBase {
    protected Current _current;
    protected Object _servant;
    protected ServantLocator _locator;
    protected LocalObjectHolder _cookie;
    protected boolean _response;
    protected byte _compress;
    protected BasicStream _os;
    protected ConnectionI _connection;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected IncomingBase(Instance instance, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._response = response;
        this._compress = compress;
        this._os = new BasicStream(instance);
        this._connection = connection;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = this._connection;
        this._current.requestId = requestId;
        this._cookie = new LocalObjectHolder();
    }

    protected IncomingBase(IncomingBase in) {
        this._current = in._current;
        in._current = null;
        this._servant = in._servant;
        in._servant = null;
        this._locator = in._locator;
        in._locator = null;
        this._cookie = in._cookie;
        in._cookie = null;
        this._response = in._response;
        in._response = false;
        this._compress = in._compress;
        in._compress = 0;
        this._os = in._os;
        in._os = null;
        this._connection = in._connection;
        in._connection = null;
    }

    public void reset(Instance instance, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        if (this._cookie == null) {
            this._cookie = new LocalObjectHolder();
        }
        this._response = response;
        this._compress = compress;
        if (this._os == null) {
            this._os = new BasicStream(instance);
        }
        this._connection = connection;
    }

    public void reclaim() {
        this._servant = null;
        this._locator = null;
        if (this._cookie != null) {
            this._cookie.value = null;
        }
        if (this._os != null) {
            this._os.reset();
        }
    }

    protected final void __warning(Exception ex) {
        if (!$assertionsDisabled && this._os == null) {
            throw new AssertionError();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OutputBase out = new OutputBase(pw);
        out.setUseTab(false);
        out.print("dispatch exception:");
        out.print("\nidentity: " + this._os.instance().identityToString(this._current.id));
        out.print("\nfacet: " + StringUtil.escapeString(this._current.facet, ""));
        out.print("\noperation: " + this._current.operation);
        out.print("\n");
        ex.printStackTrace(pw);
        pw.flush();
        this._os.instance().initializationData().logger.warning(sw.toString());
    }

    protected final void __handleException(Exception exc) {
        try {
            throw exc;
        }
        catch (RequestFailedException ex) {
            if (ex.id == null) {
                ex.id = this._current.id;
            }
            if (ex.facet == null) {
                ex.facet = this._current.facet;
            }
            if (ex.operation == null || ex.operation.length() == 0) {
                ex.operation = this._current.operation;
            }
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                if (ex instanceof ObjectNotExistException) {
                    this._os.writeByte((byte)2);
                } else if (ex instanceof FacetNotExistException) {
                    this._os.writeByte((byte)3);
                } else if (ex instanceof OperationNotExistException) {
                    this._os.writeByte((byte)4);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                ex.id.__write(this._os);
                if (ex.facet == null || ex.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] facetPath2 = new String[]{ex.facet};
                    this._os.writeStringSeq(facetPath2);
                }
                this._os.writeString(ex.operation);
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (UnknownLocalException ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                this._os.writeString(ex.unknown);
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (UnknownUserException ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                this._os.writeString(ex.unknown);
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (UnknownException ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                this._os.writeString(ex.unknown);
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (LocalException ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (UserException ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                this._connection.sendResponse(this._os, this._compress);
            } else {
                this._connection.sendNoResponse();
            }
        }
        catch (Exception ex) {
            if (this._os.instance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
                this._connection.sendResponse(this._os, this._compress);
            }
            this._connection.sendNoResponse();
        }
    }

    static {
        $assertionsDisabled = !IncomingBase.class.desiredAssertionStatus();
    }
}

