/*! @azure/msal-browser v4.2.1 2025-02-11 */
"use strict";!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).msal={})}(this,(function(e){
/*! @azure/msal-common v15.1.1 2025-02-11 */
const t={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_RESPONSE_TYPE:"code",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",FRAGMENT_RESPONSE_MODE:"fragment",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",NOT_AVAILABLE:"Not Available",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],TOKEN_RESPONSE_TYPE:"token",ID_TOKEN_RESPONSE_TYPE:"id_token",SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},r=400,n=499,o=500,i=599,a=[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE],s=[...a,t.EMAIL_SCOPE],c="Content-Type",l="Content-Length",d="Retry-After",h="X-AnchorMailbox",u="WWW-Authenticate",g="Authentication-Info",p="x-ms-request-id",m="x-ms-httpver",f="active-account-filters",C="common",y="organizations",v="consumers",I="access_token",T="xms_cc",w={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},A={PLAIN:"plain",S256:"S256"},k={QUERY:"query",FRAGMENT:"fragment"},S={...k,FORM_POST:"form_post"},b="authorization_code",E="refresh_token",R="MSSTS",_="ADFS",P="Generic",M="-",N=".",O={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},q="appmetadata",U="1",L="authority-metadata",H=86400,x="config",B="cache",D="network",F="hardcoded_values",K={SCHEMA_VERSION:5,MAX_CUR_HEADER_BYTES:80,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},z={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},G=60,$=3600,Q="throttling",W="retry-after, h429",j="invalid_grant",V="client_mismatch",Y="username",J="password",X=200,Z=400,ee="1",te="3",re="4",ne="2",oe="4",ie="5",ae="0",se="1",ce="2",le="3",de="4",he={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},ue="unexpected_error",ge="post_request_failed";var pe=Object.freeze({__proto__:null,postRequestFailed:ge,unexpectedError:ue});
/*! @azure/msal-common v15.1.1 2025-02-11 */const me={[ue]:"Unexpected error in authentication.",[ge]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."},fe={unexpectedError:{code:ue,desc:me[ue]},postRequestFailed:{code:ge,desc:me[ge]}};class Ce extends Error{constructor(e,r,n){super(r?`${e}: ${r}`:e),Object.setPrototypeOf(this,Ce.prototype),this.errorCode=e||t.EMPTY_STRING,this.errorMessage=r||t.EMPTY_STRING,this.subError=n||t.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function ye(e,t){return new Ce(e,t?`${me[e]} ${t}`:me[e])}
/*! @azure/msal-common v15.1.1 2025-02-11 */const ve="client_info_decoding_error",Ie="client_info_empty_error",Te="token_parsing_error",we="null_or_empty_token",Ae="endpoints_resolution_error",ke="network_error",Se="openid_config_error",be="hash_not_deserialized",Ee="invalid_state",Re="state_mismatch",_e="state_not_found",Pe="nonce_mismatch",Me="auth_time_not_found",Ne="max_age_transpired",Oe="multiple_matching_tokens",qe="multiple_matching_accounts",Ue="multiple_matching_appMetadata",Le="request_cannot_be_made",He="cannot_remove_empty_scope",xe="cannot_append_scopeset",Be="empty_input_scopeset",De="device_code_polling_cancelled",Fe="device_code_expired",Ke="device_code_unknown_error",ze="no_account_in_silent_request",Ge="invalid_cache_record",$e="invalid_cache_environment",Qe="no_account_found",We="no_crypto_object",je="unexpected_credential_type",Ve="invalid_assertion",Ye="invalid_client_credential",Je="token_refresh_required",Xe="user_timeout_reached",Ze="token_claims_cnf_required_for_signedjwt",et="authorization_code_missing_from_server_response",tt="binding_key_not_removed",rt="end_session_endpoint_not_supported",nt="key_id_missing",ot="no_network_connectivity",it="user_canceled",at="missing_tenant_id_error",st="method_not_implemented",ct="nested_app_auth_bridge_disabled";var lt=Object.freeze({__proto__:null,authTimeNotFound:Me,authorizationCodeMissingFromServerResponse:et,bindingKeyNotRemoved:tt,cannotAppendScopeSet:xe,cannotRemoveEmptyScope:He,clientInfoDecodingError:ve,clientInfoEmptyError:Ie,deviceCodeExpired:Fe,deviceCodePollingCancelled:De,deviceCodeUnknownError:Ke,emptyInputScopeSet:Be,endSessionEndpointNotSupported:rt,endpointResolutionError:Ae,hashNotDeserialized:be,invalidAssertion:Ve,invalidCacheEnvironment:$e,invalidCacheRecord:Ge,invalidClientCredential:Ye,invalidState:Ee,keyIdMissing:nt,maxAgeTranspired:Ne,methodNotImplemented:st,missingTenantIdError:at,multipleMatchingAccounts:qe,multipleMatchingAppMetadata:Ue,multipleMatchingTokens:Oe,nestedAppAuthBridgeDisabled:ct,networkError:ke,noAccountFound:Qe,noAccountInSilentRequest:ze,noCryptoObject:We,noNetworkConnectivity:ot,nonceMismatch:Pe,nullOrEmptyToken:we,openIdConfigError:Se,requestCannotBeMade:Le,stateMismatch:Re,stateNotFound:_e,tokenClaimsCnfRequiredForSignedJwt:Ze,tokenParsingError:Te,tokenRefreshRequired:Je,unexpectedCredentialType:je,userCanceled:it,userTimeoutReached:Xe});
/*! @azure/msal-common v15.1.1 2025-02-11 */const dt={[ve]:"The client info could not be parsed/decoded correctly",[Ie]:"The client info was empty",[Te]:"Token cannot be parsed",[we]:"The token is null or empty",[Ae]:"Endpoints cannot be resolved",[ke]:"Network request failed",[Se]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[be]:"The hash parameters could not be deserialized",[Ee]:"State was not the expected format",[Re]:"State mismatch error",[_e]:"State not found",[Pe]:"Nonce mismatch error",[Me]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[Ne]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[Oe]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[qe]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[Ue]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[Le]:"Token request cannot be made without authorization code or refresh token.",[He]:"Cannot remove null or empty scope from ScopeSet",[xe]:"Cannot append ScopeSet",[Be]:"Empty input ScopeSet cannot be processed",[De]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[Fe]:"Device code is expired.",[Ke]:"Device code stopped polling for unknown reasons.",[ze]:"Please pass an account object, silent flow is not supported without account information",[Ge]:"Cache record object was null or undefined.",[$e]:"Invalid environment when attempting to create cache entry",[Qe]:"No account found in cache for given key.",[We]:"No crypto object detected.",[je]:"Unexpected credential type.",[Ve]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[Ye]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[Je]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[Xe]:"User defined timeout for device code polling reached",[Ze]:"Cannot generate a POP jwt if the token_claims are not populated",[et]:"Server response does not contain an authorization code to proceed",[tt]:"Could not remove the credential's binding key from storage.",[rt]:"The provided authority does not support logout",[nt]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[ot]:"No network connectivity. Check your internet connection.",[it]:"User cancelled the flow.",[at]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[st]:"This method has not been implemented",[ct]:"The nested app auth bridge is disabled"},ht={clientInfoDecodingError:{code:ve,desc:dt[ve]},clientInfoEmptyError:{code:Ie,desc:dt[Ie]},tokenParsingError:{code:Te,desc:dt[Te]},nullOrEmptyToken:{code:we,desc:dt[we]},endpointResolutionError:{code:Ae,desc:dt[Ae]},networkError:{code:ke,desc:dt[ke]},unableToGetOpenidConfigError:{code:Se,desc:dt[Se]},hashNotDeserialized:{code:be,desc:dt[be]},invalidStateError:{code:Ee,desc:dt[Ee]},stateMismatchError:{code:Re,desc:dt[Re]},stateNotFoundError:{code:_e,desc:dt[_e]},nonceMismatchError:{code:Pe,desc:dt[Pe]},authTimeNotFoundError:{code:Me,desc:dt[Me]},maxAgeTranspired:{code:Ne,desc:dt[Ne]},multipleMatchingTokens:{code:Oe,desc:dt[Oe]},multipleMatchingAccounts:{code:qe,desc:dt[qe]},multipleMatchingAppMetadata:{code:Ue,desc:dt[Ue]},tokenRequestCannotBeMade:{code:Le,desc:dt[Le]},removeEmptyScopeError:{code:He,desc:dt[He]},appendScopeSetError:{code:xe,desc:dt[xe]},emptyInputScopeSetError:{code:Be,desc:dt[Be]},DeviceCodePollingCancelled:{code:De,desc:dt[De]},DeviceCodeExpired:{code:Fe,desc:dt[Fe]},DeviceCodeUnknownError:{code:Ke,desc:dt[Ke]},NoAccountInSilentRequest:{code:ze,desc:dt[ze]},invalidCacheRecord:{code:Ge,desc:dt[Ge]},invalidCacheEnvironment:{code:$e,desc:dt[$e]},noAccountFound:{code:Qe,desc:dt[Qe]},noCryptoObj:{code:We,desc:dt[We]},unexpectedCredentialType:{code:je,desc:dt[je]},invalidAssertion:{code:Ve,desc:dt[Ve]},invalidClientCredential:{code:Ye,desc:dt[Ye]},tokenRefreshRequired:{code:Je,desc:dt[Je]},userTimeoutReached:{code:Xe,desc:dt[Xe]},tokenClaimsRequired:{code:Ze,desc:dt[Ze]},noAuthorizationCodeFromServer:{code:et,desc:dt[et]},bindingKeyNotRemovedError:{code:tt,desc:dt[tt]},logoutNotSupported:{code:rt,desc:dt[rt]},keyIdMissing:{code:nt,desc:dt[nt]},noNetworkConnectivity:{code:ot,desc:dt[ot]},userCanceledError:{code:it,desc:dt[it]},missingTenantIdError:{code:at,desc:dt[at]},nestedAppAuthBridgeDisabled:{code:ct,desc:dt[ct]}};class ut extends Ce{constructor(e,t){super(e,t?`${dt[e]}: ${t}`:dt[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,ut.prototype)}}function gt(e,t){return new ut(e,t)}
/*! @azure/msal-common v15.1.1 2025-02-11 */const pt={createNewGuid:()=>{throw gt(st)},base64Decode:()=>{throw gt(st)},base64Encode:()=>{throw gt(st)},base64UrlEncode:()=>{throw gt(st)},encodeKid:()=>{throw gt(st)},async getPublicKeyThumbprint(){throw gt(st)},async removeTokenBindingKey(){throw gt(st)},async clearKeystore(){throw gt(st)},async signJwt(){throw gt(st)},async hashString(){throw gt(st)}};
/*! @azure/msal-common v15.1.1 2025-02-11 */var mt;e.LogLevel=void 0,(mt=e.LogLevel||(e.LogLevel={}))[mt.Error=0]="Error",mt[mt.Warning=1]="Warning",mt[mt.Info=2]="Info",mt[mt.Verbose=3]="Verbose",mt[mt.Trace=4]="Trace";class ft{constructor(r,n,o){this.level=e.LogLevel.Info;const i=r||ft.createDefaultLoggerOptions();this.localCallback=i.loggerCallback||(()=>{}),this.piiLoggingEnabled=i.piiLoggingEnabled||!1,this.level="number"==typeof i.logLevel?i.logLevel:e.LogLevel.Info,this.correlationId=i.correlationId||t.EMPTY_STRING,this.packageName=n||t.EMPTY_STRING,this.packageVersion=o||t.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info}}clone(e,t,r){return new ft({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:r||this.correlationId},e,t)}logMessage(t,r){if(r.logLevel>this.level||!this.piiLoggingEnabled&&r.containsPii)return;const n=`${`[${(new Date).toUTCString()}] : [${r.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${e.LogLevel[r.logLevel]} - ${t}`;this.executeCallback(r.logLevel,n,r.containsPii||!1)}executeCallback(e,t,r){this.localCallback&&this.localCallback(e,t,r)}error(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!1,correlationId:n||t.EMPTY_STRING})}errorPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!0,correlationId:n||t.EMPTY_STRING})}warning(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!1,correlationId:n||t.EMPTY_STRING})}warningPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!0,correlationId:n||t.EMPTY_STRING})}info(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!1,correlationId:n||t.EMPTY_STRING})}infoPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!0,correlationId:n||t.EMPTY_STRING})}verbose(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!1,correlationId:n||t.EMPTY_STRING})}verbosePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!0,correlationId:n||t.EMPTY_STRING})}trace(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!1,correlationId:n||t.EMPTY_STRING})}tracePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!0,correlationId:n||t.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Ct="@azure/msal-common",yt="15.1.1",vt={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};
/*! @azure/msal-common v15.1.1 2025-02-11 */
function It(e,t){const r=function(e){if(!e)throw gt(we);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(e);if(!t||t.length<4)throw gt(Te);return t[2]}(e);try{const e=t(r);return JSON.parse(e)}catch(e){throw gt(Te)}}function Tt(e,t){if(0===t||Date.now()-3e5>e+t)throw gt(Ne)}
/*! @azure/msal-common v15.1.1 2025-02-11 */function wt(){return Math.round((new Date).getTime()/1e3)}function At(e,t){const r=Number(e)||0;return wt()+t>r}function kt(e){return Number(e)>wt()}
/*! @azure/msal-common v15.1.1 2025-02-11 */function St(e){return[Pt(e),Mt(e),Nt(e),Ot(e),qt(e)].join(M).toLowerCase()}function bt(e,t,r,n,o){return{credentialType:O.ID_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r,realm:o}}function Et(e,t,r,n,o,i,a,s,c,l,d,h,u,g,p){const m={homeAccountId:e,credentialType:O.ACCESS_TOKEN,secret:r,cachedAt:wt().toString(),expiresOn:a.toString(),extendedExpiresOn:s.toString(),environment:t,clientId:n,realm:o,target:i,tokenType:d||z.BEARER};if(h&&(m.userAssertionHash=h),l&&(m.refreshOn=l.toString()),g&&(m.requestedClaims=g,m.requestedClaimsHash=p),m.tokenType?.toLowerCase()!==z.BEARER.toLowerCase())switch(m.credentialType=O.ACCESS_TOKEN_WITH_AUTH_SCHEME,m.tokenType){case z.POP:const e=It(r,c);if(!e?.cnf?.kid)throw gt(Ze);m.keyId=e.cnf.kid;break;case z.SSH:m.keyId=u}return m}function Rt(e,t,r,n,o,i,a){const s={credentialType:O.REFRESH_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r};return i&&(s.userAssertionHash=i),o&&(s.familyId=o),a&&(s.expiresOn=a.toString()),s}function _t(e){return e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("credentialType")&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("secret")}function Pt(e){return[e.homeAccountId,e.environment].join(M).toLowerCase()}function Mt(e){const t=e.credentialType===O.REFRESH_TOKEN&&e.familyId||e.clientId;return[e.credentialType,t,e.realm||""].join(M).toLowerCase()}function Nt(e){return(e.target||"").toLowerCase()}function Ot(e){return(e.requestedClaimsHash||"").toLowerCase()}function qt(e){return e.tokenType&&e.tokenType.toLowerCase()!==z.BEARER.toLowerCase()?e.tokenType.toLowerCase():""}function Ut(){return wt()+H}function Lt(e,t,r){e.authorization_endpoint=t.authorization_endpoint,e.token_endpoint=t.token_endpoint,e.end_session_endpoint=t.end_session_endpoint,e.issuer=t.issuer,e.endpointsFromNetwork=r,e.jwks_uri=t.jwks_uri}function Ht(e,t,r){e.aliases=t.aliases,e.preferred_cache=t.preferred_cache,e.preferred_network=t.preferred_network,e.aliasesFromNetwork=r}function xt(e){return e.expiresAt<=wt()}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Bt="redirect_uri_empty",Dt="claims_request_parsing_error",Ft="authority_uri_insecure",Kt="url_parse_error",zt="empty_url_error",Gt="empty_input_scopes_error",$t="invalid_prompt_value",Qt="invalid_claims",Wt="token_request_empty",jt="logout_request_empty",Vt="invalid_code_challenge_method",Yt="pkce_params_missing",Jt="invalid_cloud_discovery_metadata",Xt="invalid_authority_metadata",Zt="untrusted_authority",er="missing_ssh_jwk",tr="missing_ssh_kid",rr="missing_nonce_authentication_header",nr="invalid_authentication_header",or="cannot_set_OIDCOptions",ir="cannot_allow_platform_broker",ar="authority_mismatch";var sr=Object.freeze({__proto__:null,authorityMismatch:ar,authorityUriInsecure:Ft,cannotAllowPlatformBroker:ir,cannotSetOIDCOptions:or,claimsRequestParsingError:Dt,emptyInputScopesError:Gt,invalidAuthenticationHeader:nr,invalidAuthorityMetadata:Xt,invalidClaims:Qt,invalidCloudDiscoveryMetadata:Jt,invalidCodeChallengeMethod:Vt,invalidPromptValue:$t,logoutRequestEmpty:jt,missingNonceAuthenticationHeader:rr,missingSshJwk:er,missingSshKid:tr,pkceParamsMissing:Yt,redirectUriEmpty:Bt,tokenRequestEmpty:Wt,untrustedAuthority:Zt,urlEmptyError:zt,urlParseError:Kt});
/*! @azure/msal-common v15.1.1 2025-02-11 */const cr={[Bt]:"A redirect URI is required for all calls, and none has been set.",[Dt]:"Could not parse the given claims request object.",[Ft]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[Kt]:"URL could not be parsed into appropriate segments.",[zt]:"URL was empty or null.",[Gt]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[$t]:"Please see here for valid configuration options: https://azuread.github.io/microsoft-authentication-library-for-js/ref/modules/_azure_msal_common.html#commonauthorizationurlrequest",[Qt]:"Given claims parameter must be a stringified JSON object.",[Wt]:"Token request was empty and not found in cache.",[jt]:"The logout request was null or undefined.",[Vt]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[Yt]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[Jt]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[Xt]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[Zt]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[er]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[tr]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[rr]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[nr]:"Invalid authentication header provided",[or]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[ir]:"Cannot set allowPlatformBroker parameter to true when not in AAD protocol mode.",[ar]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority."},lr={redirectUriNotSet:{code:Bt,desc:cr[Bt]},claimsRequestParsingError:{code:Dt,desc:cr[Dt]},authorityUriInsecure:{code:Ft,desc:cr[Ft]},urlParseError:{code:Kt,desc:cr[Kt]},urlEmptyError:{code:zt,desc:cr[zt]},emptyScopesError:{code:Gt,desc:cr[Gt]},invalidPrompt:{code:$t,desc:cr[$t]},invalidClaimsRequest:{code:Qt,desc:cr[Qt]},tokenRequestEmptyError:{code:Wt,desc:cr[Wt]},logoutRequestEmptyError:{code:jt,desc:cr[jt]},invalidCodeChallengeMethod:{code:Vt,desc:cr[Vt]},invalidCodeChallengeParams:{code:Yt,desc:cr[Yt]},invalidCloudDiscoveryMetadata:{code:Jt,desc:cr[Jt]},invalidAuthorityMetadata:{code:Xt,desc:cr[Xt]},untrustedAuthority:{code:Zt,desc:cr[Zt]},missingSshJwk:{code:er,desc:cr[er]},missingSshKid:{code:tr,desc:cr[tr]},missingNonceAuthenticationHeader:{code:rr,desc:cr[rr]},invalidAuthenticationHeader:{code:nr,desc:cr[nr]},cannotSetOIDCOptions:{code:or,desc:cr[or]},cannotAllowPlatformBroker:{code:ir,desc:cr[ir]},authorityMismatch:{code:ar,desc:cr[ar]}};class dr extends Ce{constructor(e){super(e,cr[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,dr.prototype)}}function hr(e){return new dr(e)}
/*! @azure/msal-common v15.1.1 2025-02-11 */class ur{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return 0===Object.keys(t).length}catch(e){}return!0}static startsWith(e,t){return 0===e.indexOf(t)}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},r=e.split("&"),n=e=>decodeURIComponent(e.replace(/\+/g," "));return r.forEach((e=>{if(e.trim()){const[r,o]=e.split(/=(.+)/g,2);r&&o&&(t[n(r)]=n(o))}})),t}static trimArrayEntries(e){return e.map((e=>e.trim()))}static removeEmptyStringsFromArray(e){return e.filter((e=>!!e))}static jsonParseHelper(e){try{return JSON.parse(e)}catch(e){return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class gr{constructor(e){const t=e?ur.trimArrayEntries([...e]):[],r=t?ur.removeEmptyStringsFromArray(t):[];if(!r||!r.length)throw hr(Gt);this.scopes=new Set,r.forEach((e=>this.scopes.add(e)))}static fromString(e){const r=(e||t.EMPTY_STRING).split(" ");return new gr(r)}static createSearchScopes(e){const r=new gr(e);return r.containsOnlyOIDCScopes()?r.removeScope(t.OFFLINE_ACCESS_SCOPE):r.removeOIDCScopes(),r}containsScope(e){const t=this.printScopesLowerCase().split(" "),r=new gr(t);return!!e&&r.scopes.has(e.toLowerCase())}containsScopeSet(e){return!(!e||e.scopes.size<=0)&&(this.scopes.size>=e.scopes.size&&e.asArray().every((e=>this.containsScope(e))))}containsOnlyOIDCScopes(){let e=0;return s.forEach((t=>{this.containsScope(t)&&(e+=1)})),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach((e=>this.appendScope(e)))}catch(e){throw gt(xe)}}removeScope(e){if(!e)throw gt(He);this.scopes.delete(e.trim())}removeOIDCScopes(){s.forEach((e=>{this.scopes.delete(e)}))}unionScopeSets(e){if(!e)throw gt(Be);const t=new Set;return e.scopes.forEach((e=>t.add(e.toLowerCase()))),this.scopes.forEach((e=>t.add(e.toLowerCase()))),t}intersectingScopeSets(e){if(!e)throw gt(Be);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),r=e.getScopeCount(),n=this.getScopeCount();return t.size<n+r}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach((t=>e.push(t))),e}printScopes(){if(this.scopes){return this.asArray().join(" ")}return t.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}
/*! @azure/msal-common v15.1.1 2025-02-11 */function pr(e,t){if(!e)throw gt(Ie);try{const r=t(e);return JSON.parse(r)}catch(e){throw gt(ve)}}function mr(e){if(!e)throw gt(ve);const r=e.split(N,2);return{uid:r[0],utid:r.length<2?t.EMPTY_STRING:r[1]}}
/*! @azure/msal-common v15.1.1 2025-02-11 */function fr(e,t){return!!e&&!!t&&e===t.split(".")[1]}function Cr(e,t,r,n){if(n){const{oid:t,sub:r,tid:o,name:i,tfp:a,acr:s}=n,c=o||a||s||"";return{tenantId:c,localAccountId:t||r||"",name:i,isHomeTenant:fr(c,e)}}return{tenantId:r,localAccountId:t,isHomeTenant:fr(r,e)}}function yr(e,t,r,n){let o=e;if(t){const{isHomeTenant:r,...n}=t;o={...e,...n}}if(r){const{isHomeTenant:t,...i}=Cr(e.homeAccountId,e.localAccountId,e.tenantId,r);return o={...o,...i,idTokenClaims:r,idToken:n},o}return o}
/*! @azure/msal-common v15.1.1 2025-02-11 */const vr=0,Ir=1,Tr=2,wr=3;
/*! @azure/msal-common v15.1.1 2025-02-11 */function Ar(e){if(e){return e.tid||e.tfp||e.acr||null}return null}
/*! @azure/msal-common v15.1.1 2025-02-11 */const kr={AAD:"AAD",OIDC:"OIDC"};
/*! @azure/msal-common v15.1.1 2025-02-11 */class Sr{generateAccountId(){return[this.homeAccountId,this.environment].join(M).toLowerCase()}generateAccountKey(){return Sr.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map((e=>[e.tenantId,e])))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(M).toLowerCase()}static createAccount(e,t,r){const n=new Sr;let o;t.authorityType===Ir?n.authorityType=_:t.protocolMode===kr.AAD?n.authorityType=R:n.authorityType=P,e.clientInfo&&r&&(o=pr(e.clientInfo,r)),n.clientInfo=e.clientInfo,n.homeAccountId=e.homeAccountId,n.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw gt($e);n.environment=i,n.realm=o?.utid||Ar(e.idTokenClaims)||"",n.localAccountId=o?.uid||e.idTokenClaims?.oid||e.idTokenClaims?.sub||"";const a=e.idTokenClaims?.preferred_username||e.idTokenClaims?.upn,s=e.idTokenClaims?.emails?e.idTokenClaims.emails[0]:null;if(n.username=a||s||"",n.name=e.idTokenClaims?.name||"",n.cloudGraphHostName=e.cloudGraphHostName,n.msGraphHost=e.msGraphHost,e.tenantProfiles)n.tenantProfiles=e.tenantProfiles;else{const t=Cr(e.homeAccountId,n.localAccountId,n.realm,e.idTokenClaims);n.tenantProfiles=[t]}return n}static createFromAccountInfo(e,t,r){const n=new Sr;return n.authorityType=e.authorityType||P,n.homeAccountId=e.homeAccountId,n.localAccountId=e.localAccountId,n.nativeAccountId=e.nativeAccountId,n.realm=e.tenantId,n.environment=e.environment,n.username=e.username,n.name=e.name,n.cloudGraphHostName=t,n.msGraphHost=r,n.tenantProfiles=Array.from(e.tenantProfiles?.values()||[]),n}static generateHomeAccountId(e,t,r,n,o){if(t!==Ir&&t!==Tr){if(e)try{const t=pr(e,n.base64Decode);if(t.uid&&t.utid)return`${t.uid}.${t.utid}`}catch(e){}r.warning("No client info in response")}return o?.sub||""}static isAccountEntity(e){return!!e&&(e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"))}static accountInfoIsEqual(e,t,r){if(!e||!t)return!1;let n=!0;if(r){const r=e.idTokenClaims||{},o=t.idTokenClaims||{};n=r.iat===o.iat&&r.nonce===o.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&n}}
/*! @azure/msal-common v15.1.1 2025-02-11 */function br(e){return e.startsWith("#/")?e.substring(2):e.startsWith("#")||e.startsWith("?")?e.substring(1):e}function Er(e){if(!e||e.indexOf("=")<0)return null;try{const t=br(e),r=Object.fromEntries(new URLSearchParams(t));if(r.code||r.error||r.error_description||r.state)return r}catch(e){throw gt(be)}return null}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Rr{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw hr(zt);e.includes("#")||(this._urlString=Rr.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return ur.endsWith(t,"?")?t=t.slice(0,-1):ur.endsWith(t,"?/")&&(t=t.slice(0,-2)),ur.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch(e){throw hr(Kt)}if(!e.HostNameAndPort||!e.PathSegments)throw hr(Kt);if(!e.Protocol||"https:"!==e.Protocol.toLowerCase())throw hr(Ft)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return Rr.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),r=t.PathSegments;return!e||0===r.length||r[0]!==C&&r[0]!==y||(r[0]=e),Rr.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw hr(Kt);const r={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let n=r.AbsolutePath.split("/");return n=n.filter((e=>e&&e.length>0)),r.PathSegments=n,r.QueryString&&r.QueryString.endsWith("/")&&(r.QueryString=r.QueryString.substring(0,r.QueryString.length-1)),r}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),r=e.match(t);if(!r)throw hr(Kt);return r[2]}static getAbsoluteUrl(e,r){if(e[0]===t.FORWARD_SLASH){const t=new Rr(r).getUrlComponents();return t.Protocol+"//"+t.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new Rr(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!Er(e)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const _r={"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},Pr={tenant_discovery_endpoint:"https://{canonicalAuthority}/v2.0/.well-known/openid-configuration",metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]},Mr=new Set;function Nr(e,t,r,n){if(n?.trace(`getAliasesFromMetadata called with source: ${r}`),e&&t){const o=Or(t,e);if(o)return n?.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${r}, returning aliases`),o.aliases;n?.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${r}`)}return null}function Or(e,t){for(let r=0;r<e.length;r++){const n=e[r];if(n.aliases.includes(t))return n}return null}
/*! @azure/msal-common v15.1.1 2025-02-11 */Pr.metadata.forEach((e=>{e.aliases.forEach((e=>{Mr.add(e)}))}));const qr="cache_quota_exceeded",Ur="cache_error_unknown",Lr={[qr]:"Exceeded cache storage capacity.",[Ur]:"Unexpected error occurred when using cache storage."};class Hr extends Error{constructor(e,t){const r=t||(Lr[e]?Lr[e]:Lr[Ur]);super(`${e}: ${r}`),Object.setPrototypeOf(this,Hr.prototype),this.name="CacheError",this.errorCode=e,this.errorMessage=r}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class xr{constructor(e,t,r,n){this.clientId=e,this.cryptoImpl=t,this.commonLogger=r.clone(Ct,yt),this.staticAuthorityOptions=n}getAllAccounts(e){return this.buildTenantProfiles(this.getAccountsFilteredBy(e||{}),e)}getAccountInfoFilteredBy(e){const t=this.getAllAccounts(e);if(t.length>1){return t.sort((e=>e.idTokenClaims?-1:1))[0]}return 1===t.length?t[0]:null}getBaseAccountInfo(e){const t=this.getAccountsFilteredBy(e);return t.length>0?t[0].getAccountInfo():null}buildTenantProfiles(e,t){return e.flatMap((e=>this.getTenantProfilesFromAccountEntity(e,t?.tenantId,t)))}getTenantedAccountInfoByFilter(e,t,r,n){let o,i=null;if(n&&!this.tenantProfileMatchesFilter(r,n))return null;const a=this.getIdToken(e,t,r.tenantId);return a&&(o=It(a.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(o,n))?null:(i=yr(e,r,o,a?.secret),i)}getTenantProfilesFromAccountEntity(e,t,r){const n=e.getAccountInfo();let o=n.tenantProfiles||new Map;const i=this.getTokenKeys();if(t){const e=o.get(t);if(!e)return[];o=new Map([[t,e]])}const a=[];return o.forEach((e=>{const t=this.getTenantedAccountInfoByFilter(n,i,e,r);t&&a.push(t)})),a}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId))&&((!t.name||e.name===t.name)&&(void 0===t.isHomeTenant||e.isHomeTenant===t.isHomeTenant))}idTokenClaimsMatchTenantProfileFilter(e,t){if(t){if(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId))return!1;if(t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint))return!1;if(t.username&&!this.matchUsername(e.preferred_username,t.username))return!1;if(t.name&&!this.matchName(e,t.name))return!1;if(t.sid&&!this.matchSid(e,t.sid))return!1}return!0}async saveCacheRecord(e,t,r){if(!e)throw gt(Ge);try{e.account&&await this.setAccount(e.account,t),e.idToken&&!1!==r?.idToken&&await this.setIdTokenCredential(e.idToken,t),e.accessToken&&!1!==r?.accessToken&&await this.saveAccessToken(e.accessToken,t),e.refreshToken&&!1!==r?.refreshToken&&await this.setRefreshTokenCredential(e.refreshToken,t),e.appMetadata&&this.setAppMetadata(e.appMetadata)}catch(e){throw this.commonLogger?.error("CacheManager.saveCacheRecord: failed"),e instanceof Error?(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e.message}`,t),"QuotaExceededError"===e.name||"NS_ERROR_DOM_QUOTA_REACHED"===e.name||e.message.includes("exceeded the quota")?(this.commonLogger?.error("CacheManager.saveCacheRecord: exceeded storage quota",t),new Hr(qr)):new Hr(e.name,e.message)):(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e}`,t),new Hr(Ur))}}async saveAccessToken(e,t){const r={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},n=this.getTokenKeys(),o=gr.fromString(e.target),i=[];n.accessToken.forEach((e=>{if(!this.accessTokenKeyMatchesFilter(e,r,!1))return;const t=this.getAccessTokenCredential(e);if(t&&this.credentialMatchesFilter(t,r)){gr.fromString(t.target).intersectingScopeSets(o)&&i.push(this.removeAccessToken(e))}})),await Promise.all(i),await this.setAccessTokenCredential(e,t)}getAccountsFilteredBy(e){const t=this.getAccountKeys(),r=[];return t.forEach((t=>{if(!this.isAccountKey(t,e.homeAccountId))return;const n=this.getAccount(t,this.commonLogger);if(!n)return;if(e.homeAccountId&&!this.matchHomeAccountId(n,e.homeAccountId))return;if(e.username&&!this.matchUsername(n.username,e.username))return;if(e.environment&&!this.matchEnvironment(n,e.environment))return;if(e.realm&&!this.matchRealm(n,e.realm))return;if(e.nativeAccountId&&!this.matchNativeAccountId(n,e.nativeAccountId))return;if(e.authorityType&&!this.matchAuthorityType(n,e.authorityType))return;const o={localAccountId:e?.localAccountId,name:e?.name},i=n.tenantProfiles?.filter((e=>this.tenantProfileMatchesFilter(e,o)));i&&0===i.length||r.push(n)})),r}isAccountKey(e,t,r){return!(e.split(M).length<3)&&(!(t&&!e.toLowerCase().includes(t.toLowerCase()))&&!(r&&!e.toLowerCase().includes(r.toLowerCase())))}isCredentialKey(e){if(e.split(M).length<6)return!1;const t=e.toLowerCase();if(-1===t.indexOf(O.ID_TOKEN.toLowerCase())&&-1===t.indexOf(O.ACCESS_TOKEN.toLowerCase())&&-1===t.indexOf(O.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())&&-1===t.indexOf(O.REFRESH_TOKEN.toLowerCase()))return!1;if(t.indexOf(O.REFRESH_TOKEN.toLowerCase())>-1){const e=`${O.REFRESH_TOKEN}${M}${this.clientId}${M}`,r=`${O.REFRESH_TOKEN}${M}${U}${M}`;if(-1===t.indexOf(e.toLowerCase())&&-1===t.indexOf(r.toLowerCase()))return!1}else if(-1===t.indexOf(this.clientId.toLowerCase()))return!1;return!0}credentialMatchesFilter(e,t){if(t.clientId&&!this.matchClientId(e,t.clientId))return!1;if(t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash))return!1;if("string"==typeof t.homeAccountId&&!this.matchHomeAccountId(e,t.homeAccountId))return!1;if(t.environment&&!this.matchEnvironment(e,t.environment))return!1;if(t.realm&&!this.matchRealm(e,t.realm))return!1;if(t.credentialType&&!this.matchCredentialType(e,t.credentialType))return!1;if(t.familyId&&!this.matchFamilyId(e,t.familyId))return!1;if(t.target&&!this.matchTarget(e,t.target))return!1;if((t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash)return!1;if(e.credentialType===O.ACCESS_TOKEN_WITH_AUTH_SCHEME){if(t.tokenType&&!this.matchTokenType(e,t.tokenType))return!1;if(t.tokenType===z.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId))return!1}return!0}getAppMetadataFilteredBy(e){const t=this.getKeys(),r={};return t.forEach((t=>{if(!this.isAppMetadata(t))return;const n=this.getAppMetadata(t);n&&(e.environment&&!this.matchEnvironment(n,e.environment)||e.clientId&&!this.matchClientId(n,e.clientId)||(r[t]=n))})),r}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let r=null;return t.forEach((t=>{if(!this.isAuthorityMetadata(t)||-1===t.indexOf(this.clientId))return;const n=this.getAuthorityMetadata(t);n&&-1!==n.aliases.indexOf(e)&&(r=n)})),r}async removeAllAccounts(){const e=this.getAccountKeys(),t=[];e.forEach((e=>{t.push(this.removeAccount(e))})),await Promise.all(t)}async removeAccount(e){const t=this.getAccount(e,this.commonLogger);t&&(await this.removeAccountContext(t),this.removeItem(e))}async removeAccountContext(e){const t=this.getTokenKeys(),r=e.generateAccountId(),n=[];t.idToken.forEach((e=>{0===e.indexOf(r)&&this.removeIdToken(e)})),t.accessToken.forEach((e=>{0===e.indexOf(r)&&n.push(this.removeAccessToken(e))})),t.refreshToken.forEach((e=>{0===e.indexOf(r)&&this.removeRefreshToken(e)})),await Promise.all(n)}async removeAccessToken(e){const t=this.getAccessTokenCredential(e);if(t){if(t.credentialType.toLowerCase()===O.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()&&t.tokenType===z.POP){const e=t.keyId;if(e)try{await this.cryptoImpl.removeTokenBindingKey(e)}catch(e){throw gt(tt)}}return this.removeItem(e)}}removeAppMetadata(){return this.getKeys().forEach((e=>{this.isAppMetadata(e)&&this.removeItem(e)})),!0}readAccountFromCache(e){const t=Sr.generateAccountCacheKey(e);return this.getAccount(t,this.commonLogger)}getIdToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:O.ID_TOKEN,clientId:this.clientId,realm:r},a=this.getIdTokensByFilter(i,t),s=a.size;if(s<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(s>1){let t=a;if(!r){const r=new Map;a.forEach(((t,n)=>{t.realm===e.tenantId&&r.set(n,t)}));const n=r.size;if(n<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),a.values().next().value;if(1===n)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),r.values().next().value;t=r}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),t.forEach(((e,t)=>{this.removeIdToken(t)})),n&&o&&n.addFields({multiMatchedID:a.size},o),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),a.values().next().value}getIdTokensByFilter(e,t){const r=t&&t.idToken||this.getTokenKeys().idToken,n=new Map;return r.forEach((t=>{if(!this.idTokenKeyMatchesFilter(t,{clientId:this.clientId,...e}))return;const r=this.getIdTokenCredential(t);r&&this.credentialMatchesFilter(r,e)&&n.set(t,r)})),n}idTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.clientId||-1!==r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase()))}removeIdToken(e){this.removeItem(e)}removeRefreshToken(e){this.removeItem(e)}getAccessToken(e,t,r,n,o,i){this.commonLogger.trace("CacheManager - getAccessToken called");const a=gr.createSearchScopes(t.scopes),s=t.authenticationScheme||z.BEARER,c=s&&s.toLowerCase()!==z.BEARER.toLowerCase()?O.ACCESS_TOKEN_WITH_AUTH_SCHEME:O.ACCESS_TOKEN,l={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:c,clientId:this.clientId,realm:n||e.tenantId,target:a,tokenType:s,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},d=r&&r.accessToken||this.getTokenKeys().accessToken,h=[];d.forEach((e=>{if(this.accessTokenKeyMatchesFilter(e,l,!0)){const t=this.getAccessTokenCredential(e);t&&this.credentialMatchesFilter(t,l)&&h.push(t)}}));const u=h.length;return u<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found"),null):u>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them"),h.forEach((e=>{this.removeAccessToken(St(e))})),o&&i&&o.addFields({multiMatchedAT:h.length},i),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token"),h[0])}accessTokenKeyMatchesFilter(e,t,r){const n=e.toLowerCase();if(t.clientId&&-1===n.indexOf(t.clientId.toLowerCase()))return!1;if(t.homeAccountId&&-1===n.indexOf(t.homeAccountId.toLowerCase()))return!1;if(t.realm&&-1===n.indexOf(t.realm.toLowerCase()))return!1;if(t.requestedClaimsHash&&-1===n.indexOf(t.requestedClaimsHash.toLowerCase()))return!1;if(t.target){const e=t.target.asArray();for(let t=0;t<e.length;t++){if(r&&!n.includes(e[t].toLowerCase()))return!1;if(!r&&n.includes(e[t].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e){const t=this.getTokenKeys(),r=[];return t.accessToken.forEach((t=>{if(!this.accessTokenKeyMatchesFilter(t,e,!0))return;const n=this.getAccessTokenCredential(t);n&&this.credentialMatchesFilter(n,e)&&r.push(n)})),r}getRefreshToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?U:void 0,a={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:O.REFRESH_TOKEN,clientId:this.clientId,familyId:i},s=r&&r.refreshToken||this.getTokenKeys().refreshToken,c=[];s.forEach((e=>{if(this.refreshTokenKeyMatchesFilter(e,a)){const t=this.getRefreshTokenCredential(e);t&&this.credentialMatchesFilter(t,a)&&c.push(t)}}));const l=c.length;return l<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(l>1&&n&&o&&n.addFields({multiMatchedRT:l},o),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),c[0])}refreshTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.familyId||-1!==r.indexOf(t.familyId.toLowerCase()))&&(!(!t.familyId&&t.clientId&&-1===r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase())))}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},r=this.getAppMetadataFilteredBy(t),n=Object.keys(r).map((e=>r[e])),o=n.length;if(o<1)return null;if(o>1)throw gt(Ue);return n[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!(!t||t.familyId!==U)}matchHomeAccountId(e,t){return!("string"!=typeof e.homeAccountId||t!==e.homeAccountId)}matchLocalAccountIdFromTokenClaims(e,t){return t===(e.oid||e.sub)}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){return!(t.toLowerCase()!==e.name?.toLowerCase())}matchUsername(e,t){return!(!e||"string"!=typeof e||t?.toLowerCase()!==e.toLowerCase())}matchUserAssertionHash(e,t){return!(!e.userAssertionHash||t!==e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const r=function(e,t){let r;const n=e.canonicalAuthority;if(n){const o=new Rr(n).getUrlComponents().HostNameAndPort;r=Nr(o,e.cloudDiscoveryMetadata?.metadata,x,t)||Nr(o,Pr.metadata,F,t)||e.knownAuthorities}return r||[]}(this.staticAuthorityOptions,this.commonLogger);if(r.includes(t)&&r.includes(e.environment))return!0}const r=this.getAuthorityMetadataByAlias(t);return!!(r&&r.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!(!e.clientId||t!==e.clientId)}matchFamilyId(e,t){return!(!e.familyId||t!==e.familyId)}matchRealm(e,t){return!(e.realm?.toLowerCase()!==t.toLowerCase())}matchNativeAccountId(e,t){return!(!e.nativeAccountId||t!==e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||(e.preferred_username===t||e.upn===t)}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!(!e.authorityType||t.toLowerCase()!==e.authorityType.toLowerCase())}matchTarget(e,t){if(e.credentialType!==O.ACCESS_TOKEN&&e.credentialType!==O.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target)return!1;return gr.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!(!e.tokenType||e.tokenType!==t)}matchKeyId(e,t){return!(!e.keyId||e.keyId!==t)}isAppMetadata(e){return-1!==e.indexOf(q)}isAuthorityMetadata(e){return-1!==e.indexOf(L)}generateAuthorityMetadataCacheKey(e){return`${L}-${this.clientId}-${e}`}static toObject(e,t){for(const r in t)e[r]=t[r];return e}}class Br extends xr{async setAccount(){throw gt(st)}getAccount(){throw gt(st)}async setIdTokenCredential(){throw gt(st)}getIdTokenCredential(){throw gt(st)}async setAccessTokenCredential(){throw gt(st)}getAccessTokenCredential(){throw gt(st)}async setRefreshTokenCredential(){throw gt(st)}getRefreshTokenCredential(){throw gt(st)}setAppMetadata(){throw gt(st)}getAppMetadata(){throw gt(st)}setServerTelemetry(){throw gt(st)}getServerTelemetry(){throw gt(st)}setAuthorityMetadata(){throw gt(st)}getAuthorityMetadata(){throw gt(st)}getAuthorityMetadataKeys(){throw gt(st)}setThrottlingCache(){throw gt(st)}getThrottlingCache(){throw gt(st)}removeItem(){throw gt(st)}getKeys(){throw gt(st)}getAccountKeys(){throw gt(st)}getTokenKeys(){throw gt(st)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Dr={tokenRenewalOffsetSeconds:300,preventCorsPreflight:!1},Fr={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info,correlationId:t.EMPTY_STRING},Kr={claimsBasedCachingEnabled:!1},zr={async sendGetRequestAsync(){throw gt(st)},async sendPostRequestAsync(){throw gt(st)}},Gr={sku:t.SKU,version:yt,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},$r={clientSecret:t.EMPTY_STRING,clientAssertion:void 0},Qr={azureCloudInstance:vt.None,tenant:`${t.DEFAULT_COMMON_TENANT}`},Wr={application:{appName:"",appVersion:""}};function jr(e){return e.authOptions.authority.options.protocolMode===kr.OIDC}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Vr="home_account_id",Yr="UPN",Jr="client_id",Xr="redirect_uri",Zr="response_type",en="token_type",tn="req_cnf",rn="return_spa_code",nn="x-client-xtra-sku",on="brk_client_id",an="brk_redirect_uri";
/*! @azure/msal-common v15.1.1 2025-02-11 */
/*! @azure/msal-common v15.1.1 2025-02-11 */
class sn{static validateRedirectUri(e){if(!e)throw hr(Bt)}static validatePrompt(e){const t=[];for(const e in w)t.push(w[e]);if(t.indexOf(e)<0)throw hr($t)}static validateClaims(e){try{JSON.parse(e)}catch(e){throw hr(Qt)}}static validateCodeChallengeParams(e,t){if(!e||!t)throw hr(Yt);this.validateCodeChallengeMethod(t)}static validateCodeChallengeMethod(e){if([A.PLAIN,A.S256].indexOf(e)<0)throw hr(Vt)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class cn{constructor(e,t){this.parameters=new Map,this.performanceClient=t,this.correlationId=e}addResponseTypeCode(){this.parameters.set(Zr,encodeURIComponent(t.CODE_RESPONSE_TYPE))}addResponseTypeForTokenAndIdToken(){this.parameters.set(Zr,encodeURIComponent(`${t.TOKEN_RESPONSE_TYPE} ${t.ID_TOKEN_RESPONSE_TYPE}`))}addResponseMode(e){this.parameters.set("response_mode",encodeURIComponent(e||S.QUERY))}addNativeBroker(){this.parameters.set("nativebroker",encodeURIComponent("1"))}addScopes(e,t=!0,r=a){!t||r.includes("openid")||e.includes("openid")||r.push("openid");const n=t?[...e||[],...r]:e||[],o=new gr(n);this.parameters.set("scope",encodeURIComponent(o.printScopes()))}addClientId(e){this.parameters.set(Jr,encodeURIComponent(e))}addRedirectUri(e){sn.validateRedirectUri(e),this.parameters.set(Xr,encodeURIComponent(e))}addPostLogoutRedirectUri(e){sn.validateRedirectUri(e),this.parameters.set("post_logout_redirect_uri",encodeURIComponent(e))}addIdTokenHint(e){this.parameters.set("id_token_hint",encodeURIComponent(e))}addDomainHint(e){this.parameters.set("domain_hint",encodeURIComponent(e))}addLoginHint(e){this.parameters.set("login_hint",encodeURIComponent(e))}addCcsUpn(e){this.parameters.set(h,encodeURIComponent(`UPN:${e}`))}addCcsOid(e){this.parameters.set(h,encodeURIComponent(`Oid:${e.uid}@${e.utid}`))}addSid(e){this.parameters.set("sid",encodeURIComponent(e))}addClaims(e,t){const r=this.addClientCapabilitiesToClaims(e,t);sn.validateClaims(r),this.parameters.set("claims",encodeURIComponent(r))}addCorrelationId(e){this.parameters.set("client-request-id",encodeURIComponent(e))}addLibraryInfo(e){this.parameters.set("x-client-SKU",e.sku),this.parameters.set("x-client-VER",e.version),e.os&&this.parameters.set("x-client-OS",e.os),e.cpu&&this.parameters.set("x-client-CPU",e.cpu)}addApplicationTelemetry(e){e?.appName&&this.parameters.set("x-app-name",e.appName),e?.appVersion&&this.parameters.set("x-app-ver",e.appVersion)}addPrompt(e){sn.validatePrompt(e),this.parameters.set("prompt",encodeURIComponent(e))}addState(e){e&&this.parameters.set("state",encodeURIComponent(e))}addNonce(e){this.parameters.set("nonce",encodeURIComponent(e))}addCodeChallengeParams(e,t){if(sn.validateCodeChallengeParams(e,t),!e||!t)throw hr(Yt);this.parameters.set("code_challenge",encodeURIComponent(e)),this.parameters.set("code_challenge_method",encodeURIComponent(t))}addAuthorizationCode(e){this.parameters.set("code",encodeURIComponent(e))}addDeviceCode(e){this.parameters.set("device_code",encodeURIComponent(e))}addRefreshToken(e){this.parameters.set("refresh_token",encodeURIComponent(e))}addCodeVerifier(e){this.parameters.set("code_verifier",encodeURIComponent(e))}addClientSecret(e){this.parameters.set("client_secret",encodeURIComponent(e))}addClientAssertion(e){e&&this.parameters.set("client_assertion",encodeURIComponent(e))}addClientAssertionType(e){e&&this.parameters.set("client_assertion_type",encodeURIComponent(e))}addOboAssertion(e){this.parameters.set("assertion",encodeURIComponent(e))}addRequestTokenUse(e){this.parameters.set("requested_token_use",encodeURIComponent(e))}addGrantType(e){this.parameters.set("grant_type",encodeURIComponent(e))}addClientInfo(){this.parameters.set("client_info","1")}addExtraQueryParameters(e){Object.entries(e).forEach((([e,t])=>{!this.parameters.has(e)&&t&&this.parameters.set(e,t)}))}addClientCapabilitiesToClaims(e,t){let r;if(e)try{r=JSON.parse(e)}catch(e){throw hr(Qt)}else r={};return t&&t.length>0&&(r.hasOwnProperty(I)||(r[I]={}),r[I][T]={values:t}),JSON.stringify(r)}addUsername(e){this.parameters.set(Y,encodeURIComponent(e))}addPassword(e){this.parameters.set(J,encodeURIComponent(e))}addPopToken(e){e&&(this.parameters.set(en,z.POP),this.parameters.set(tn,encodeURIComponent(e)))}addSshJwk(e){e&&(this.parameters.set(en,z.SSH),this.parameters.set(tn,encodeURIComponent(e)))}addServerTelemetry(e){this.parameters.set("x-client-current-telemetry",e.generateCurrentRequestHeaderValue()),this.parameters.set("x-client-last-telemetry",e.generateLastRequestHeaderValue())}addThrottling(){this.parameters.set("x-ms-lib-capability",W)}addLogoutHint(e){this.parameters.set("logout_hint",encodeURIComponent(e))}addBrokerParameters(e){const t={};t[on]=e.brokerClientId,t[an]=e.brokerRedirectUri,this.addExtraQueryParameters(t)}createQueryString(){const e=new Array;return this.parameters.forEach(((t,r)=>{e.push(`${r}=${t}`)})),function(e,t,r){if(!t)return;const n=e.get(Jr);n&&e.has(on)&&r?.addFields({embeddedClientId:n,embeddedRedirectUri:e.get(Xr)},t)}(this.parameters,this.correlationId,this.performanceClient),e.join("&")}}
/*! @azure/msal-common v15.1.1 2025-02-11 */
/*! @azure/msal-common v15.1.1 2025-02-11 */
const ln={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenPreRedirect:"acquireTokenPreRedirect",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",AwaitConcurrentIframe:"awaitConcurrentIframe",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",NetworkClientSendPostRequestAsync:"networkClientSendPostRequestAsync",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",InitializeCache:"initializeCache",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",StandardInteractionClientInitializeAuthorizationCodeRequest:"standardInteractionClientInitializeAuthorizationCodeRequest",GetAuthCodeUrl:"getAuthCodeUrl",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",AuthClientCreateQueryString:"authClientCreateQueryString",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",ImportExistingCache:"importExistingCache",SetUserData:"setUserData",LocalStorageUpdated:"localStorageUpdated",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues",GenerateHKDF:"generateHKDF",GenerateBaseKey:"generateBaseKey",Base64Decode:"base64Decode",UrlEncodeArr:"urlEncodeArr",Encrypt:"encrypt",Decrypt:"decrypt"},dn=new Map([[ln.AcquireTokenByCode,"ATByCode"],[ln.AcquireTokenByRefreshToken,"ATByRT"],[ln.AcquireTokenSilent,"ATS"],[ln.AcquireTokenSilentAsync,"ATSAsync"],[ln.AcquireTokenPopup,"ATPopup"],[ln.AcquireTokenRedirect,"ATRedirect"],[ln.CryptoOptsGetPublicKeyThumbprint,"CryptoGetPKThumb"],[ln.CryptoOptsSignJwt,"CryptoSignJwt"],[ln.SilentCacheClientAcquireToken,"SltCacheClientAT"],[ln.SilentIframeClientAcquireToken,"SltIframeClientAT"],[ln.SilentRefreshClientAcquireToken,"SltRClientAT"],[ln.SsoSilent,"SsoSlt"],[ln.StandardInteractionClientGetDiscoveredAuthority,"StdIntClientGetDiscAuth"],[ln.FetchAccountIdWithNativeBroker,"FetchAccIdWithNtvBroker"],[ln.NativeInteractionClientAcquireToken,"NtvIntClientAT"],[ln.BaseClientCreateTokenRequestHeaders,"BaseClientCreateTReqHead"],[ln.NetworkClientSendPostRequestAsync,"NetClientSendPost"],[ln.RefreshTokenClientExecutePostToTokenEndpoint,"RTClientExecPost"],[ln.AuthorizationCodeClientExecutePostToTokenEndpoint,"AuthCodeClientExecPost"],[ln.BrokerHandhshake,"BrokerHandshake"],[ln.AcquireTokenByRefreshTokenInBroker,"ATByRTInBroker"],[ln.AcquireTokenByBroker,"ATByBroker"],[ln.RefreshTokenClientExecuteTokenRequest,"RTClientExecTReq"],[ln.RefreshTokenClientAcquireToken,"RTClientAT"],[ln.RefreshTokenClientAcquireTokenWithCachedRefreshToken,"RTClientATWithCachedRT"],[ln.RefreshTokenClientAcquireTokenByRefreshToken,"RTClientATByRT"],[ln.RefreshTokenClientCreateTokenRequestBody,"RTClientCreateTReqBody"],[ln.AcquireTokenFromCache,"ATFromCache"],[ln.SilentFlowClientAcquireCachedToken,"SltFlowClientATCached"],[ln.SilentFlowClientGenerateResultFromCacheRecord,"SltFlowClientGenResFromCache"],[ln.AcquireTokenBySilentIframe,"ATBySltIframe"],[ln.InitializeBaseRequest,"InitBaseReq"],[ln.InitializeSilentRequest,"InitSltReq"],[ln.InitializeClientApplication,"InitClientApplication"],[ln.InitializeCache,"InitCache"],[ln.ImportExistingCache,"importCache"],[ln.SetUserData,"setUserData"],[ln.LocalStorageUpdated,"localStorageUpdated"],[ln.SilentIframeClientTokenHelper,"SIClientTHelper"],[ln.SilentHandlerInitiateAuthRequest,"SHandlerInitAuthReq"],[ln.SilentHandlerMonitorIframeForHash,"SltHandlerMonitorIframeForHash"],[ln.SilentHandlerLoadFrame,"SHandlerLoadFrame"],[ln.SilentHandlerLoadFrameSync,"SHandlerLoadFrameSync"],[ln.StandardInteractionClientCreateAuthCodeClient,"StdIntClientCreateAuthCodeClient"],[ln.StandardInteractionClientGetClientConfiguration,"StdIntClientGetClientConf"],[ln.StandardInteractionClientInitializeAuthorizationRequest,"StdIntClientInitAuthReq"],[ln.StandardInteractionClientInitializeAuthorizationCodeRequest,"StdIntClientInitAuthCodeReq"],[ln.GetAuthCodeUrl,"GetAuthCodeUrl"],[ln.HandleCodeResponseFromServer,"HandleCodeResFromServer"],[ln.HandleCodeResponse,"HandleCodeResp"],[ln.UpdateTokenEndpointAuthority,"UpdTEndpointAuth"],[ln.AuthClientAcquireToken,"AuthClientAT"],[ln.AuthClientExecuteTokenRequest,"AuthClientExecTReq"],[ln.AuthClientCreateTokenRequestBody,"AuthClientCreateTReqBody"],[ln.AuthClientCreateQueryString,"AuthClientCreateQueryStr"],[ln.PopTokenGenerateCnf,"PopTGenCnf"],[ln.PopTokenGenerateKid,"PopTGenKid"],[ln.HandleServerTokenResponse,"HandleServerTRes"],[ln.DeserializeResponse,"DeserializeRes"],[ln.AuthorityFactoryCreateDiscoveredInstance,"AuthFactCreateDiscInst"],[ln.AuthorityResolveEndpointsAsync,"AuthResolveEndpointsAsync"],[ln.AuthorityResolveEndpointsFromLocalSources,"AuthResolveEndpointsFromLocal"],[ln.AuthorityGetCloudDiscoveryMetadataFromNetwork,"AuthGetCDMetaFromNet"],[ln.AuthorityUpdateCloudDiscoveryMetadata,"AuthUpdCDMeta"],[ln.AuthorityGetEndpointMetadataFromNetwork,"AuthUpdCDMetaFromNet"],[ln.AuthorityUpdateEndpointMetadata,"AuthUpdEndpointMeta"],[ln.AuthorityUpdateMetadataWithRegionalInformation,"AuthUpdMetaWithRegInfo"],[ln.RegionDiscoveryDetectRegion,"RegDiscDetectReg"],[ln.RegionDiscoveryGetRegionFromIMDS,"RegDiscGetRegFromIMDS"],[ln.RegionDiscoveryGetCurrentVersion,"RegDiscGetCurrentVer"],[ln.AcquireTokenByCodeAsync,"ATByCodeAsync"],[ln.GetEndpointMetadataFromNetwork,"GetEndpointMetaFromNet"],[ln.GetCloudDiscoveryMetadataFromNetworkMeasurement,"GetCDMetaFromNet"],[ln.HandleRedirectPromiseMeasurement,"HandleRedirectPromise"],[ln.HandleNativeRedirectPromiseMeasurement,"HandleNtvRedirectPromise"],[ln.UpdateCloudDiscoveryMetadataMeasurement,"UpdateCDMeta"],[ln.UsernamePasswordClientAcquireToken,"UserPassClientAT"],[ln.NativeMessageHandlerHandshake,"NtvMsgHandlerHandshake"],[ln.NativeGenerateAuthResult,"NtvGenAuthRes"],[ln.RemoveHiddenIframe,"RemoveHiddenIframe"],[ln.ClearTokensAndKeysWithClaims,"ClearTAndKeysWithClaims"],[ln.CacheManagerGetRefreshToken,"CacheManagerGetRT"],[ln.GeneratePkceCodes,"GenPkceCodes"],[ln.GenerateCodeVerifier,"GenCodeVerifier"],[ln.GenerateCodeChallengeFromVerifier,"GenCodeChallengeFromVerifier"],[ln.Sha256Digest,"Sha256Digest"],[ln.GetRandomValues,"GetRandomValues"],[ln.GenerateHKDF,"genHKDF"],[ln.GenerateBaseKey,"genBaseKey"],[ln.Base64Decode,"b64Decode"],[ln.UrlEncodeArr,"urlEncArr"],[ln.Encrypt,"encrypt"],[ln.Decrypt,"decrypt"]]),hn=1,un=2,gn=new Set(["accessTokenSize","durationMs","idTokenSize","matsSilentStatus","matsHttpStatus","refreshTokenSize","queuedTimeMs","startTimeMs","status","multiMatchedAT","multiMatchedID","multiMatchedRT","unencryptedCacheCount","encryptedCacheExpiredCount"]),pn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}try{const n=e(...i);return a?.end({success:!0}),r.trace(`Returning result from ${t}`),n}catch(e){r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}},mn=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}return n?.setPreQueueTime(t,o),e(...i).then((e=>(r.trace(`Returning result from ${t}`),a?.end({success:!0}),e))).catch((e=>{r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}))};
/*! @azure/msal-common v15.1.1 2025-02-11 */
class fn{constructor(e,t,r,n){this.networkInterface=e,this.logger=t,this.performanceClient=r,this.correlationId=n}async detectRegion(e,r){this.performanceClient?.addQueueMeasurement(ln.RegionDiscoveryDetectRegion,this.correlationId);let n=e;if(n)r.region_source=te;else{const e=fn.IMDS_OPTIONS;try{const o=await mn(this.getRegionFromIMDS.bind(this),ln.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t.IMDS_VERSION,e);if(o.status===X&&(n=o.body,r.region_source=re),o.status===Z){const t=await mn(this.getCurrentVersion.bind(this),ln.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(e);if(!t)return r.region_source=ee,null;const o=await mn(this.getRegionFromIMDS.bind(this),ln.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t,e);o.status===X&&(n=o.body,r.region_source=re)}}catch(e){return r.region_source=ee,null}}return n||(r.region_source=ee),n||null}async getRegionFromIMDS(e,r){return this.performanceClient?.addQueueMeasurement(ln.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?api-version=${e}&format=text`,r,t.IMDS_TIMEOUT)}async getCurrentVersion(e){this.performanceClient?.addQueueMeasurement(ln.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const r=await this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?format=json`,e);return r.status===Z&&r.body&&r.body["newest-versions"]&&r.body["newest-versions"].length>0?r.body["newest-versions"][0]:null}catch(e){return null}}}fn.IMDS_OPTIONS={headers:{Metadata:"true"}};
/*! @azure/msal-common v15.1.1 2025-02-11 */
class Cn{constructor(e,t,r,n,o,i,a,s){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=r,this.authorityOptions=n,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=o,this.performanceClient=a,this.correlationId=i,this.managedIdentity=s||!1,this.regionDiscovery=new fn(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(t.CIAM_AUTH_URL))return wr;const r=e.PathSegments;if(r.length)switch(r[0].toLowerCase()){case t.ADFS:return Ir;case t.DSTS:return Tr}return vr}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new Rr(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw gt(Ae)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw gt(Ae)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw gt(Ae)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw gt(rt);return this.replacePath(this.metadata.end_session_endpoint)}throw gt(Ae)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw gt(Ae)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw gt(Ae)}canReplaceTenant(e){return 1===e.PathSegments.length&&!Cn.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===vr&&this.protocolMode===kr.AAD}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const r=new Rr(this.metadata.canonical_authority).getUrlComponents(),n=r.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach(((e,o)=>{let i=n[o];if(0===o&&this.canReplaceTenant(r)){const e=new Rr(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];i!==e&&(this.logger.verbose(`Replacing tenant domain name ${i} with id ${e}`),i=e)}e!==i&&(t=t.replace(`/${i}/`,`/${e}/`))})),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===Ir||this.protocolMode!==kr.AAD&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){this.performanceClient?.addQueueMeasurement(ln.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await mn(this.updateCloudDiscoveryMetadata.bind(this),ln.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const r=await mn(this.updateEndpointMetadata.bind(this),ln.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:r}),this.performanceClient?.addFields({cloudDiscoverySource:t,authorityEndpointSource:r},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:Ut(),jwks_uri:""}),e}updateCachedMetadata(e,t,r){t!==B&&r?.source!==B&&(e.expiresAt=Ut(),e.canonical_authority=this.canonicalAuthority);const n=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(n,e),this.metadata=e}async updateEndpointMetadata(e){this.performanceClient?.addQueueMeasurement(ln.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===F&&this.authorityOptions.azureRegionConfiguration?.azureRegion&&t.metadata){Lt(e,await mn(this.updateMetadataWithRegionalInformation.bind(this),ln.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata),!1),e.canonical_authority=this.canonicalAuthority}return t.source}let r=await mn(this.getEndpointMetadataFromNetwork.bind(this),ln.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return this.authorityOptions.azureRegionConfiguration?.azureRegion&&(r=await mn(this.updateMetadataWithRegionalInformation.bind(this),ln.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(r)),Lt(e,r,!0),D;throw gt(Se,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),Lt(e,t,!1),{source:x};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const t=this.getEndpointMetadataFromHardcodedValues();if(t)return Lt(e,t,!1),{source:F,metadata:t};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const r=xt(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!r?(this.logger.verbose("Found endpoint metadata in the cache."),{source:B}):(r&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new Rr(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch(e){throw hr(Xt)}return null}async getEndpointMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(ln.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const r=await this.networkInterface.sendGetRequestAsync(t,e),n=function(e){return e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("jwks_uri")}
/*! @azure/msal-common v15.1.1 2025-02-11 */(r.body);return n?r.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(e){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${e}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in _r?_r[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){this.performanceClient?.addQueueMeasurement(ln.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const r=this.authorityOptions.azureRegionConfiguration?.azureRegion;if(r){if(r!==t.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=ne,this.regionDiscoveryMetadata.region_used=r,Cn.replaceWithRegionalInformation(e,r);const n=await mn(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),ln.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)(this.authorityOptions.azureRegionConfiguration?.environmentRegion,this.regionDiscoveryMetadata);if(n)return this.regionDiscoveryMetadata.region_outcome=oe,this.regionDiscoveryMetadata.region_used=n,Cn.replaceWithRegionalInformation(e,n);this.regionDiscoveryMetadata.region_outcome=ie}return e}async updateCloudDiscoveryMetadata(e){this.performanceClient?.addQueueMeasurement(ln.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const r=await mn(this.getCloudDiscoveryMetadataFromNetwork.bind(this),ln.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return Ht(e,r,!0),D;throw hr(Zt)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||t.NOT_APPLICABLE}`);const r=this.getCloudDiscoveryMetadataFromConfig();if(r)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),Ht(e,r,!1),x;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const t=(n=this.hostnameAndPort,Or(Pr.metadata,n));if(t)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),Ht(e,t,!1),F;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}var n;const o=xt(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!o?(this.logger.verbose("Found cloud discovery metadata in the cache."),B):(o&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===wr)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=Or(JSON.parse(this.authorityOptions.cloudDiscoveryMetadata).metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),e)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),e;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch(e){throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),hr(Jt)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(ln.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${t.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,r={};let n=null;try{const o=await this.networkInterface.sendGetRequestAsync(e,r);let i,a;if(function(e){return e.hasOwnProperty("tenant_discovery_endpoint")&&e.hasOwnProperty("metadata")}
/*! @azure/msal-common v15.1.1 2025-02-11 */(o.body))i=o.body,a=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else{if(!function(e){return e.hasOwnProperty("error")&&e.hasOwnProperty("error_description")}(o.body))return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${o.status}`),i=o.body,i.error===t.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),a=[]}this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=Or(a,this.hostnameAndPort)}catch(e){if(e instanceof Ce)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.\nError: ${e.errorCode}\nError Description: ${e.errorMessage}`);else{const t=e;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.\nError: ${t.name}\nError Description: ${t.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=Cn.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter((e=>e&&Rr.getDomainFromUrl(e).toLowerCase()===this.hostnameAndPort)).length>0}static generateAuthority(e,r){let n;if(r&&r.azureCloudInstance!==vt.None){const e=r.tenant?r.tenant:t.DEFAULT_COMMON_TENANT;n=`${r.azureCloudInstance}/${e}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.managedIdentity)return t.DEFAULT_AUTHORITY_HOST;if(this.discoveryComplete())return this.metadata.preferred_cache;throw gt(Ae)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return Mr.has(e)}static isPublicCloudAuthority(e){return t.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,r,n){const o=new Rr(e);o.validateAsUri();const i=o.getUrlComponents();let a=`${r}.${i.HostNameAndPort}`;this.isPublicCloudAuthority(i.HostNameAndPort)&&(a=`${r}.${t.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const s=Rr.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:a}).urlString;return n?`${s}?${n}`:s}static replaceWithRegionalInformation(e,t){const r={...e};return r.authorization_endpoint=Cn.buildRegionalAuthorityString(r.authorization_endpoint,t),r.token_endpoint=Cn.buildRegionalAuthorityString(r.token_endpoint,t),r.end_session_endpoint&&(r.end_session_endpoint=Cn.buildRegionalAuthorityString(r.end_session_endpoint,t)),r}static transformCIAMAuthority(e){let r=e;const n=new Rr(e).getUrlComponents();if(0===n.PathSegments.length&&n.HostNameAndPort.endsWith(t.CIAM_AUTH_URL)){r=`${r}${n.HostNameAndPort.split(".")[0]}${t.AAD_TENANT_DOMAIN_SUFFIX}`}return r}}function yn(e){return e.endsWith(t.FORWARD_SLASH)?e:`${e}${t.FORWARD_SLASH}`}function vn(e){const t=e.cloudDiscoveryMetadata;let r;if(t)try{r=JSON.parse(t)}catch(e){throw hr(Jt)}return{canonicalAuthority:e.authority?yn(e.authority):void 0,knownAuthorities:e.knownAuthorities,cloudDiscoveryMetadata:r}}
/*! @azure/msal-common v15.1.1 2025-02-11 */async function In(e,t,r,n,o,i,a){a?.addQueueMeasurement(ln.AuthorityFactoryCreateDiscoveredInstance,i);const s=Cn.transformCIAMAuthority(yn(e)),c=new Cn(s,t,r,n,o,i,a);try{return await mn(c.resolveEndpointsAsync.bind(c),ln.AuthorityResolveEndpointsAsync,o,a,i)(),c}catch(e){throw gt(Ae)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */Cn.reservedTenantDomains=new Set(["{tenant}","{tenantid}",C,v,y]);class Tn extends Ce{constructor(e,t,r,n,o){super(e,t,r),this.name="ServerError",this.errorNo=n,this.status=o,Object.setPrototypeOf(this,Tn.prototype)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class wn{static generateThrottlingStorageKey(e){return`${Q}.${JSON.stringify(e)}`}static preProcess(e,r){const n=wn.generateThrottlingStorageKey(r),o=e.getThrottlingCache(n);if(o){if(o.throttleTime<Date.now())return void e.removeItem(n);throw new Tn(o.errorCodes?.join(" ")||t.EMPTY_STRING,o.errorMessage,o.subError)}}static postProcess(e,t,r){if(wn.checkResponseStatus(r)||wn.checkResponseForRetryAfter(r)){const n={throttleTime:wn.calculateThrottleTime(parseInt(r.headers[d])),error:r.body.error,errorCodes:r.body.error_codes,errorMessage:r.body.error_description,subError:r.body.suberror};e.setThrottlingCache(wn.generateThrottlingStorageKey(t),n)}}static checkResponseStatus(e){return 429===e.status||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return!!e.headers&&(e.headers.hasOwnProperty(d)&&(e.status<200||e.status>=300))}static calculateThrottleTime(e){const t=e<=0?0:e,r=Date.now()/1e3;return Math.floor(1e3*Math.min(r+(t||G),r+$))}static removeThrottle(e,t,r,n){const o={clientId:t,authority:r.authority,scopes:r.scopes,homeAccountIdentifier:n,claims:r.claims,authenticationScheme:r.authenticationScheme,resourceRequestMethod:r.resourceRequestMethod,resourceRequestUri:r.resourceRequestUri,shrClaims:r.shrClaims,sshKid:r.sshKid},i=this.generateThrottlingStorageKey(o);e.removeItem(i)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class An extends Ce{constructor(e,t,r){super(e.errorCode,e.errorMessage,e.subError),Object.setPrototypeOf(this,An.prototype),this.name="NetworkError",this.error=e,this.httpStatus=t,this.responseHeaders=r}}function kn(e,t,r){return new An(e,t,r)}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Sn{constructor(e,t){this.config=function({authOptions:e,systemOptions:t,loggerOptions:r,cacheOptions:n,storageInterface:o,networkInterface:i,cryptoInterface:a,clientCredentials:s,libraryInfo:c,telemetry:l,serverTelemetryManager:d,persistencePlugin:h,serializableCache:u}){const g={...Fr,...r};return{authOptions:(p=e,{clientCapabilities:[],azureCloudOptions:Qr,skipAuthorityMetadataCache:!1,instanceAware:!1,...p}),systemOptions:{...Dr,...t},loggerOptions:g,cacheOptions:{...Kr,...n},storageInterface:o||new Br(e.clientId,pt,new ft(g)),networkInterface:i||zr,cryptoInterface:a||pt,clientCredentials:s||$r,libraryInfo:{...Gr,...c},telemetry:{...Wr,...l},serverTelemetryManager:d||null,persistencePlugin:h||null,serializableCache:u||null};var p}(e),this.logger=new ft(this.config.loggerOptions,Ct,yt),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const r={};if(r[c]=t.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case Vr:try{const t=mr(e.credential);r[h]=`Oid:${t.uid}@${t.utid}`}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Yr:r[h]=`UPN: ${e.credential}`}return r}async executePostToTokenEndpoint(e,t,r,n,o,i){i&&this.performanceClient?.addQueueMeasurement(i,o);const a=await this.sendPostRequest(n,e,{body:t,headers:r},o);return this.config.serverTelemetryManager&&a.status<500&&429!==a.status&&this.config.serverTelemetryManager.clearTelemetryCache(),a}async sendPostRequest(e,t,r,n){let o;wn.preProcess(this.cacheManager,e);try{o=await mn(this.networkClient.sendPostRequestAsync.bind(this.networkClient),ln.NetworkClientSendPostRequestAsync,this.logger,this.performanceClient,n)(t,r);const e=o.headers||{};this.performanceClient?.addFields({refreshTokenSize:o.body.refresh_token?.length||0,httpVerToken:e[m]||"",requestId:e[p]||""},n)}catch(e){if(e instanceof An){const t=e.responseHeaders;throw t&&this.performanceClient?.addFields({httpVerToken:t[m]||"",requestId:t[p]||"",contentTypeHeader:t[c]||void 0,contentLengthHeader:t[l]||void 0,httpStatus:e.httpStatus},n),e.error}throw e instanceof Ce?e:gt(ke)}return wn.postProcess(this.cacheManager,e,o),o}async updateAuthority(e,t){this.performanceClient?.addQueueMeasurement(ln.UpdateTokenEndpointAuthority,t);const r=`https://${e}/${this.authority.tenant}/`,n=await In(r,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=n}createTokenQueryParameters(e){const t=new cn(e.correlationId,this.performanceClient);return e.embeddedClientId&&t.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenQueryParameters&&t.addExtraQueryParameters(e.tokenQueryParameters),t.addCorrelationId(e.correlationId),t.createQueryString()}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const bn="no_tokens_found",En="native_account_unavailable",Rn="refresh_token_expired",_n="interaction_required",Pn="consent_required",Mn="login_required",Nn="bad_token";var On=Object.freeze({__proto__:null,badToken:Nn,consentRequired:Pn,interactionRequired:_n,loginRequired:Mn,nativeAccountUnavailable:En,noTokensFound:bn,refreshTokenExpired:Rn});
/*! @azure/msal-common v15.1.1 2025-02-11 */const qn=[_n,Pn,Mn,Nn],Un=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],Ln={[bn]:"No refresh token found in the cache. Please sign-in.",[En]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[Rn]:"Refresh token has expired.",[Nn]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve."},Hn={noTokensFoundError:{code:bn,desc:Ln[bn]},native_account_unavailable:{code:En,desc:Ln[En]},bad_token:{code:Nn,desc:Ln[Nn]}};class xn extends Ce{constructor(e,r,n,o,i,a,s,c){super(e,r,n),Object.setPrototypeOf(this,xn.prototype),this.timestamp=o||t.EMPTY_STRING,this.traceId=i||t.EMPTY_STRING,this.correlationId=a||t.EMPTY_STRING,this.claims=s||t.EMPTY_STRING,this.name="InteractionRequiredAuthError",this.errorNo=c}}function Bn(e,t,r){const n=!!e&&qn.indexOf(e)>-1,o=!!r&&Un.indexOf(r)>-1,i=!!t&&qn.some((e=>t.indexOf(e)>-1));return n||i||o}function Dn(e){return new xn(e,Ln[e])}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Fn{static setRequestState(e,r,n){const o=Fn.generateLibraryState(e,n);return r?`${o}${t.RESOURCE_DELIM}${r}`:o}static generateLibraryState(e,t){if(!e)throw gt(We);const r={id:e.createNewGuid()};t&&(r.meta=t);const n=JSON.stringify(r);return e.base64Encode(n)}static parseRequestState(e,r){if(!e)throw gt(We);if(!r)throw gt(Ee);try{const n=r.split(t.RESOURCE_DELIM),o=n[0],i=n.length>1?n.slice(1).join(t.RESOURCE_DELIM):t.EMPTY_STRING,a=e.base64Decode(o),s=JSON.parse(a);return{userRequestState:i||t.EMPTY_STRING,libraryState:s}}catch(e){throw gt(Ee)}}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Kn="sw";class zn{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){this.performanceClient?.addQueueMeasurement(ln.PopTokenGenerateCnf,e.correlationId);const r=await mn(this.generateKid.bind(this),ln.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),n=this.cryptoUtils.base64UrlEncode(JSON.stringify(r));return{kid:r.kid,reqCnfString:n}}async generateKid(e){this.performanceClient?.addQueueMeasurement(ln.PopTokenGenerateKid,e.correlationId);return{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:Kn}}async signPopToken(e,t,r){return this.signPayload(e,t,r)}async signPayload(e,t,r,n){const{resourceRequestMethod:o,resourceRequestUri:i,shrClaims:a,shrNonce:s,shrOptions:c}=r,l=i?new Rr(i):void 0,d=l?.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:wt(),m:o?.toUpperCase(),u:d?.HostNameAndPort,nonce:s||this.cryptoUtils.createNewGuid(),p:d?.AbsolutePath,q:d?.QueryString?[[],d.QueryString]:void 0,client_claims:a||void 0,...n},t,c,r.correlationId)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Gn{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class $n{constructor(e,t,r,n,o,i,a){this.clientId=e,this.cacheStorage=t,this.cryptoObj=r,this.logger=n,this.serializableCache=o,this.persistencePlugin=i,this.performanceClient=a}validateServerAuthorizationCodeResponse(e,t){if(!e.state||!t)throw e.state?gt(_e,"Cached State"):gt(_e,"Server State");let r,n;try{r=decodeURIComponent(e.state)}catch(t){throw gt(Ee,e.state)}try{n=decodeURIComponent(t)}catch(t){throw gt(Ee,e.state)}if(r!==n)throw gt(Re);if(e.error||e.error_description||e.suberror){const t=function(e){const t="code=",r=e.error_uri?.lastIndexOf(t);return r&&r>=0?e.error_uri?.substring(r+5):void 0}(e);if(Bn(e.error,e.error_description,e.suberror))throw new xn(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"",t);throw new Tn(e.error||"",e.error_description,e.suberror,t)}}validateTokenResponse(e,a){if(e.error||e.error_description||e.suberror){const s=`Error(s): ${e.error_codes||t.NOT_AVAILABLE} - Timestamp: ${e.timestamp||t.NOT_AVAILABLE} - Description: ${e.error_description||t.NOT_AVAILABLE} - Correlation ID: ${e.correlation_id||t.NOT_AVAILABLE} - Trace ID: ${e.trace_id||t.NOT_AVAILABLE}`,c=e.error_codes?.length?e.error_codes[0]:void 0,l=new Tn(e.error,s,e.suberror,c,e.status);if(a&&e.status&&e.status>=o&&e.status<=i)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.\n${l}`);if(a&&e.status&&e.status>=r&&e.status<=n)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.\n${l}`);if(Bn(e.error,e.error_description,e.suberror))throw new xn(e.error,e.error_description,e.suberror,e.timestamp||t.EMPTY_STRING,e.trace_id||t.EMPTY_STRING,e.correlation_id||t.EMPTY_STRING,e.claims||t.EMPTY_STRING,c);throw l}}async handleServerTokenResponse(e,r,n,o,i,a,s,c,l){let d,h;if(this.performanceClient?.addQueueMeasurement(ln.HandleServerTokenResponse,e.correlation_id),e.id_token){if(d=It(e.id_token||t.EMPTY_STRING,this.cryptoObj.base64Decode),i&&i.nonce&&d.nonce!==i.nonce)throw gt(Pe);if(o.maxAge||0===o.maxAge){const e=d.auth_time;if(!e)throw gt(Me);Tt(e,o.maxAge)}}this.homeAccountIdentifier=Sr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,r.authorityType,this.logger,this.cryptoObj,d),i&&i.state&&(h=Fn.parseRequestState(this.cryptoObj,i.state)),e.key_id=e.key_id||o.sshKid||void 0;const u=this.generateCacheRecord(e,r,n,o,d,a,i);let g;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),g=new Gn(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(g)),s&&!c&&u.account){const e=u.account.generateAccountKey();if(!this.cacheStorage.getAccount(e))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await $n.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,d,h,void 0,l)}await this.cacheStorage.saveCacheRecord(u,o.correlationId,o.storeInCache)}finally{this.persistencePlugin&&this.serializableCache&&g&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(g))}return $n.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,d,h,e,l)}generateCacheRecord(e,t,r,n,o,i,a){const s=t.getPreferredCache();if(!s)throw gt($e);const c=Ar(o);let l,d;e.id_token&&o&&(l=bt(this.homeAccountIdentifier,s,e.id_token,this.clientId,c||""),d=Qn(this.cacheStorage,t,this.homeAccountIdentifier,this.cryptoObj.base64Decode,o,e.client_info,s,c,a,void 0,this.logger));let h=null;if(e.access_token){const o=e.scope?gr.fromString(e.scope):new gr(n.scopes||[]),a=("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0,l=("string"==typeof e.ext_expires_in?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,d=("string"==typeof e.refresh_in?parseInt(e.refresh_in,10):e.refresh_in)||void 0,u=r+a,g=u+l,p=d&&d>0?r+d:void 0;h=Et(this.homeAccountIdentifier,s,e.access_token,this.clientId,c||t.tenant||"",o.printScopes(),u,g,this.cryptoObj.base64Decode,p,e.token_type,i,e.key_id,n.claims,n.requestedClaimsHash)}let u=null;if(e.refresh_token){let t;if(e.refresh_token_expires_in){t=r+("string"==typeof e.refresh_token_expires_in?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in)}u=Rt(this.homeAccountIdentifier,s,e.refresh_token,this.clientId,e.foci,i,t)}let g=null;return e.foci&&(g={clientId:this.clientId,environment:s,familyId:e.foci}),{account:d,idToken:l,accessToken:h,refreshToken:u,appMetadata:g}}static async generateAuthenticationResult(e,r,n,o,i,a,s,c,l){let d,h,u=t.EMPTY_STRING,g=[],p=null,m=t.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType!==z.POP||i.popKid)u=n.accessToken.secret;else{const t=new zn(e),{secret:r,keyId:o}=n.accessToken;if(!o)throw gt(nt);u=await t.signPopToken(r,o,i)}g=gr.fromString(n.accessToken.target).asArray(),p=new Date(1e3*Number(n.accessToken.expiresOn)),d=new Date(1e3*Number(n.accessToken.extendedExpiresOn)),n.accessToken.refreshOn&&(h=new Date(1e3*Number(n.accessToken.refreshOn)))}n.appMetadata&&(m=n.appMetadata.familyId===U?U:"");const f=a?.oid||a?.sub||"",C=a?.tid||"";c?.spa_accountid&&n.account&&(n.account.nativeAccountId=c?.spa_accountid);const y=n.account?yr(n.account.getAccountInfo(),void 0,a,n.idToken?.secret):null;return{authority:r.canonicalAuthority,uniqueId:f,tenantId:C,scopes:g,account:y,idToken:n?.idToken?.secret||"",idTokenClaims:a||{},accessToken:u,fromCache:o,expiresOn:p,extExpiresOn:d,refreshOn:h,correlationId:i.correlationId,requestId:l||t.EMPTY_STRING,familyId:m,tokenType:n.accessToken?.tokenType||t.EMPTY_STRING,state:s?s.userRequestState:t.EMPTY_STRING,cloudGraphHostName:n.account?.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:n.account?.msGraphHost||t.EMPTY_STRING,code:c?.spa_code,fromNativeBroker:!1}}}function Qn(e,t,r,n,o,i,a,s,c,l,d){d?.verbose("setCachedAccount called");const h=e.getAccountKeys().find((e=>e.startsWith(r)));let u=null;h&&(u=e.getAccount(h));const g=u||Sr.createAccount({homeAccountId:r,idTokenClaims:o,clientInfo:i,environment:a,cloudGraphHostName:c?.cloud_graph_host_name,msGraphHost:c?.msgraph_host,nativeAccountId:l},t,n),p=g.tenantProfiles||[],m=s||g.realm;if(m&&!p.find((e=>e.tenantId===m))){const e=Cr(r,g.localAccountId,m,o);p.push(e)}return g.tenantProfiles=p,g}
/*! @azure/msal-common v15.1.1 2025-02-11 */async function Wn(e,t,r){if("string"==typeof e)return e;return e({clientId:t,tokenEndpoint:r})}
/*! @azure/msal-common v15.1.1 2025-02-11 */class jn extends Sn{constructor(e,t){super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=this.config.authOptions.authority.options.OIDCOptions?.defaultScopes}async getAuthCodeUrl(e){this.performanceClient?.addQueueMeasurement(ln.GetAuthCodeUrl,e.correlationId);const t=await mn(this.createAuthCodeUrlQueryString.bind(this),ln.AuthClientCreateQueryString,this.logger,this.performanceClient,e.correlationId)(e);return Rr.appendQueryString(this.authority.authorizationEndpoint,t)}async acquireToken(e,t){if(this.performanceClient?.addQueueMeasurement(ln.AuthClientAcquireToken,e.correlationId),!e.code)throw gt(Le);const r=wt(),n=await mn(this.executeTokenRequest.bind(this),ln.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),o=n.headers?.[p],i=new $n(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(n.body),mn(i.handleServerTokenResponse.bind(i),ln.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,r,e,t,void 0,void 0,void 0,o)}handleFragmentResponse(e,t){if(new $n(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,null,null).validateServerAuthorizationCodeResponse(e,t),!e.code)throw gt(et);return e}getLogoutUri(e){if(!e)throw hr(jt);const t=this.createLogoutUrlQueryString(e);return Rr.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(ln.AuthClientExecuteTokenRequest,t.correlationId);const r=this.createTokenQueryParameters(t),n=Rr.appendQueryString(e.tokenEndpoint,r),o=await mn(this.createTokenRequestBody.bind(this),ln.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const e=pr(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${e.uid}${N}${e.utid}`,type:Vr}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}const a=this.createTokenRequestHeaders(i||t.ccsCredential),s={clientId:t.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:e.canonicalAuthority,scopes:t.scopes,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid};return mn(this.executePostToTokenEndpoint.bind(this),ln.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(n,o,a,s,t.correlationId,ln.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(ln.AuthClientCreateTokenRequestBody,e.correlationId);const t=new cn(e.correlationId,this.performanceClient);if(t.addClientId(e.embeddedClientId||e.tokenBodyParameters?.[Jr]||this.config.authOptions.clientId),this.includeRedirectUri?t.addRedirectUri(e.redirectUri):sn.validateRedirectUri(e.redirectUri),t.addScopes(e.scopes,!0,this.oidcDefaultScopes),t.addAuthorizationCode(e.code),t.addLibraryInfo(this.config.libraryInfo),t.addApplicationTelemetry(this.config.telemetry.application),t.addThrottling(),this.serverTelemetryManager&&!jr(this.config)&&t.addServerTelemetry(this.serverTelemetryManager),e.codeVerifier&&t.addCodeVerifier(e.codeVerifier),this.config.clientCredentials.clientSecret&&t.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const r=this.config.clientCredentials.clientAssertion;t.addClientAssertion(await Wn(r.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),t.addClientAssertionType(r.assertionType)}if(t.addGrantType(b),t.addClientInfo(),e.authenticationScheme===z.POP){const r=new zn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await mn(r.generateCnf.bind(r),ln.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}t.addPopToken(n)}else if(e.authenticationScheme===z.SSH){if(!e.sshJwk)throw hr(er);t.addSshJwk(e.sshJwk)}let r;if((!ur.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.clientInfo)try{const t=pr(e.clientInfo,this.cryptoUtils.base64Decode);r={credential:`${t.uid}${N}${t.utid}`,type:Vr}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}else r=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&r)switch(r.type){case Vr:try{const e=mr(r.credential);t.addCcsOid(e)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Yr:t.addCcsUpn(r.credential)}return e.embeddedClientId&&t.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenBodyParameters&&t.addExtraQueryParameters(e.tokenBodyParameters),!e.enableSpaAuthorizationCode||e.tokenBodyParameters&&e.tokenBodyParameters[rn]||t.addExtraQueryParameters({[rn]:"1"}),t.createQueryString()}async createAuthCodeUrlQueryString(e){const t=e.correlationId||this.config.cryptoInterface.createNewGuid();this.performanceClient?.addQueueMeasurement(ln.AuthClientCreateQueryString,t);const r=new cn(t,this.performanceClient);r.addClientId(e.embeddedClientId||e.extraQueryParameters?.[Jr]||this.config.authOptions.clientId);const n=[...e.scopes||[],...e.extraScopesToConsent||[]];if(r.addScopes(n,!0,this.oidcDefaultScopes),r.addRedirectUri(e.redirectUri),r.addCorrelationId(t),r.addResponseMode(e.responseMode),r.addResponseTypeCode(),r.addLibraryInfo(this.config.libraryInfo),jr(this.config)||r.addApplicationTelemetry(this.config.telemetry.application),r.addClientInfo(),e.codeChallenge&&e.codeChallengeMethod&&r.addCodeChallengeParams(e.codeChallenge,e.codeChallengeMethod),e.prompt&&r.addPrompt(e.prompt),e.domainHint&&(r.addDomainHint(e.domainHint),this.performanceClient?.addFields({domainHintFromRequest:!0},t)),this.performanceClient?.addFields({prompt:e.prompt},t),e.prompt!==w.SELECT_ACCOUNT)if(e.sid&&e.prompt===w.NONE)this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),r.addSid(e.sid),this.performanceClient?.addFields({sidFromRequest:!0},t);else if(e.account){const n=this.extractAccountSid(e.account);let o=this.extractLoginHint(e.account);if(o&&e.domainHint&&(this.logger.warning('AuthorizationCodeClient.createAuthCodeUrlQueryString: "domainHint" param is set, skipping opaque "login_hint" claim. Please consider not passing domainHint'),o=null),o){this.logger.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),r.addLoginHint(o),this.performanceClient?.addFields({loginHintFromClaim:!0},t);try{const t=mr(e.account.homeAccountId);r.addCcsOid(t)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(n&&e.prompt===w.NONE){this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),r.addSid(n),this.performanceClient?.addFields({sidFromClaim:!0},t);try{const t=mr(e.account.homeAccountId);r.addCcsOid(t)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e.loginHint)this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),r.addLoginHint(e.loginHint),r.addCcsUpn(e.loginHint),this.performanceClient?.addFields({loginHintFromRequest:!0},t);else if(e.account.username){this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),r.addLoginHint(e.account.username),this.performanceClient?.addFields({loginHintFromUpn:!0},t);try{const t=mr(e.account.homeAccountId);r.addCcsOid(t)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else e.loginHint&&(this.logger.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),r.addLoginHint(e.loginHint),r.addCcsUpn(e.loginHint),this.performanceClient?.addFields({loginHintFromRequest:!0},t));else this.logger.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");if(e.nonce&&r.addNonce(e.nonce),e.state&&r.addState(e.state),(e.claims||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&r.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.embeddedClientId&&r.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),this.addExtraQueryParams(e,r),e.platformBroker&&(r.addNativeBroker(),e.authenticationScheme===z.POP)){const t=new zn(this.cryptoUtils);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await mn(t.generateCnf.bind(t),ln.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}r.addPopToken(n)}return r.createQueryString()}createLogoutUrlQueryString(e){const t=new cn(e.correlationId,this.performanceClient);return e.postLogoutRedirectUri&&t.addPostLogoutRedirectUri(e.postLogoutRedirectUri),e.correlationId&&t.addCorrelationId(e.correlationId),e.idTokenHint&&t.addIdTokenHint(e.idTokenHint),e.state&&t.addState(e.state),e.logoutHint&&t.addLogoutHint(e.logoutHint),this.addExtraQueryParams(e,t),t.createQueryString()}addExtraQueryParams(e,t){!(e.extraQueryParameters&&e.extraQueryParameters.hasOwnProperty("instance_aware"))&&this.config.authOptions.instanceAware&&(e.extraQueryParameters=e.extraQueryParameters||{},e.extraQueryParameters.instance_aware="true"),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters)}extractAccountSid(e){return e.idTokenClaims?.sid||null}extractLoginHint(e){return e.idTokenClaims?.login_hint||null}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Vn extends Sn{constructor(e,t){super(e,t)}async acquireToken(e){this.performanceClient?.addQueueMeasurement(ln.RefreshTokenClientAcquireToken,e.correlationId);const t=wt(),r=await mn(this.executeTokenRequest.bind(this),ln.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),n=r.headers?.[p],o=new $n(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return o.validateTokenResponse(r.body),mn(o.handleServerTokenResponse.bind(o),ln.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(r.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,n)}async acquireTokenByRefreshToken(e){if(!e)throw hr(Wt);if(this.performanceClient?.addQueueMeasurement(ln.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw gt(ze);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await mn(this.acquireTokenWithCachedRefreshToken.bind(this),ln.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(t){const r=t instanceof xn&&t.errorCode===bn,n=t instanceof Tn&&t.errorCode===j&&t.subError===V;if(r||n)return mn(this.acquireTokenWithCachedRefreshToken.bind(this),ln.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw t}return mn(this.acquireTokenWithCachedRefreshToken.bind(this),ln.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){this.performanceClient?.addQueueMeasurement(ln.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const r=pn(this.cacheManager.getRefreshToken.bind(this.cacheManager),ln.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,void 0,this.performanceClient,e.correlationId);if(!r)throw Dn(bn);if(r.expiresOn&&At(r.expiresOn,e.refreshTokenExpirationOffsetSeconds||300))throw this.performanceClient?.addFields({rtExpiresOnMs:Number(r.expiresOn)},e.correlationId),Dn(Rn);const n={...e,refreshToken:r.secret,authenticationScheme:e.authenticationScheme||z.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:Vr}};try{return await mn(this.acquireToken.bind(this),ln.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(n)}catch(t){if(t instanceof xn&&(this.performanceClient?.addFields({rtExpiresOnMs:Number(r.expiresOn)},e.correlationId),t.subError===Nn)){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const e=St(r);this.cacheManager.removeRefreshToken(e)}throw t}}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(ln.RefreshTokenClientExecuteTokenRequest,e.correlationId);const r=this.createTokenQueryParameters(e),n=Rr.appendQueryString(t.tokenEndpoint,r),o=await mn(this.createTokenRequestBody.bind(this),ln.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),a={clientId:e.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:t.canonicalAuthority,scopes:e.scopes,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid};return mn(this.executePostToTokenEndpoint.bind(this),ln.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(n,o,i,a,e.correlationId,ln.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(ln.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=e.correlationId,r=new cn(t,this.performanceClient);if(r.addClientId(e.embeddedClientId||e.tokenBodyParameters?.[Jr]||this.config.authOptions.clientId),e.redirectUri&&r.addRedirectUri(e.redirectUri),r.addScopes(e.scopes,!0,this.config.authOptions.authority.options.OIDCOptions?.defaultScopes),r.addGrantType(E),r.addClientInfo(),r.addLibraryInfo(this.config.libraryInfo),r.addApplicationTelemetry(this.config.telemetry.application),r.addThrottling(),this.serverTelemetryManager&&!jr(this.config)&&r.addServerTelemetry(this.serverTelemetryManager),r.addRefreshToken(e.refreshToken),this.config.clientCredentials.clientSecret&&r.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const t=this.config.clientCredentials.clientAssertion;r.addClientAssertion(await Wn(t.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),r.addClientAssertionType(t.assertionType)}if(e.authenticationScheme===z.POP){const t=new zn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await mn(t.generateCnf.bind(t),ln.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}r.addPopToken(n)}else if(e.authenticationScheme===z.SSH){if(!e.sshJwk)throw hr(er);r.addSshJwk(e.sshJwk)}if((!ur.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&r.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case Vr:try{const t=mr(e.ccsCredential.credential);r.addCcsOid(t)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Yr:r.addCcsUpn(e.ccsCredential.credential)}return e.embeddedClientId&&r.addBrokerParameters({brokerClientId:this.config.authOptions.clientId,brokerRedirectUri:this.config.authOptions.redirectUri}),e.tokenBodyParameters&&r.addExtraQueryParameters(e.tokenBodyParameters),r.createQueryString()}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class Yn extends Sn{constructor(e,t){super(e,t)}async acquireCachedToken(e){this.performanceClient?.addQueueMeasurement(ln.SilentFlowClientAcquireCachedToken,e.correlationId);let t=ae;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!ur.isEmptyObj(e.claims))throw this.setCacheOutcome(se,e.correlationId),gt(Je);if(!e.account)throw gt(ze);const r=e.account.tenantId||function(e){const t=new Rr(e).getUrlComponents(),r=t.PathSegments.slice(-1)[0]?.toLowerCase();switch(r){case C:case y:case v:return;default:return r}}(e.authority),n=this.cacheManager.getTokenKeys(),o=this.cacheManager.getAccessToken(e.account,e,n,r,this.performanceClient,e.correlationId);if(!o)throw this.setCacheOutcome(ce,e.correlationId),gt(Je);if(kt(o.cachedAt)||At(o.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(le,e.correlationId),gt(Je);o.refreshOn&&At(o.refreshOn,0)&&(t=de);const i=e.authority||this.authority.getPreferredCache(),a={account:this.cacheManager.readAccountFromCache(e.account),accessToken:o,idToken:this.cacheManager.getIdToken(e.account,n,r,this.performanceClient,e.correlationId),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(i)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await mn(this.generateResultFromCacheRecord.bind(this),ln.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(a,e),t]}setCacheOutcome(e,t){this.serverTelemetryManager?.setCacheOutcome(e),this.performanceClient?.addFields({cacheOutcome:e},t),e!==ae&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){let r;if(this.performanceClient?.addQueueMeasurement(ln.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId),e.idToken&&(r=It(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||0===t.maxAge){const e=r?.auth_time;if(!e)throw gt(Me);Tt(e,t.maxAge)}return $n.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,r)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const Jn={sendGetRequestAsync:()=>Promise.reject(gt(st)),sendPostRequestAsync:()=>Promise.reject(gt(st))};
/*! @azure/msal-common v15.1.1 2025-02-11 */function Xn(e){const{skus:t,libraryName:r,libraryVersion:n,extensionName:o,extensionVersion:i}=e,a=new Map([[0,[r,n]],[2,[o,i]]]);let s=[];if(t?.length){if(s=t.split(","),s.length<4)return t}else s=Array.from({length:4},(()=>"|"));return a.forEach(((e,t)=>{2===e.length&&e[0]?.length&&e[1]?.length&&function(e){const{skuArr:t,index:r,skuName:n,skuVersion:o}=e;if(r>=t.length)return;t[r]=[n,o].join("|")}({skuArr:s,index:t,skuName:e[0],skuVersion:e[1]})})),s.join(",")}class Zn{constructor(e,r){this.cacheOutcome=ae,this.cacheManager=r,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||t.EMPTY_STRING,this.wrapperVer=e.wrapperVer||t.EMPTY_STRING,this.telemetryCacheKey=K.CACHE_KEY+M+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${K.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer],r=this.getNativeBrokerErrorCode();r?.length&&t.push(`broker_error=${r}`);const n=t.join(K.VALUE_SEPARATOR),o=[e,this.getRegionDiscoveryFields()].join(K.VALUE_SEPARATOR);return[K.SCHEMA_VERSION,o,n].join(K.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=Zn.maxErrorsToSend(e),r=e.failedRequests.slice(0,2*t).join(K.VALUE_SEPARATOR),n=e.errors.slice(0,t).join(K.VALUE_SEPARATOR),o=e.errors.length,i=[o,t<o?K.OVERFLOW_TRUE:K.OVERFLOW_FALSE].join(K.VALUE_SEPARATOR);return[K.SCHEMA_VERSION,e.cacheHits,r,n,i].join(K.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=K.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof Ce?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(K.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e),e.cacheHits}getLastRequests(){return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||{failedRequests:[],errors:[],cacheHits:0}}clearTelemetryCache(){const e=this.getLastRequests(),t=Zn.maxErrorsToSend(e);if(t===e.errors.length)this.cacheManager.removeItem(this.telemetryCacheKey);else{const r={failedRequests:e.failedRequests.slice(2*t),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,r)}}static maxErrorsToSend(e){let r,n=0,o=0;const i=e.errors.length;for(r=0;r<i;r++){const i=e.failedRequests[2*r]||t.EMPTY_STRING,a=e.failedRequests[2*r+1]||t.EMPTY_STRING,s=e.errors[r]||t.EMPTY_STRING;if(o+=i.toString().length+a.toString().length+s.length+3,!(o<K.MAX_LAST_HEADER_BYTES))break;n+=1}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||t.EMPTY_STRING),e.push(this.regionSource||t.EMPTY_STRING),e.push(this.regionOutcome||t.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}setNativeBrokerErrorCode(e){const t=this.getLastRequests();t.nativeBrokerErrorCode=e,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}getNativeBrokerErrorCode(){return this.getLastRequests().nativeBrokerErrorCode}clearNativeBrokerErrorCode(){const e=this.getLastRequests();delete e.nativeBrokerErrorCode,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e)}static makeExtraSkuString(e){return Xn(e)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */const eo="missing_kid_error",to="missing_alg_error",ro={[eo]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[to]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};class no extends Ce{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,no.prototype)}}function oo(e){return new no(e,ro[e])}
/*! @azure/msal-common v15.1.1 2025-02-11 */class io{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw oo(eo);if(!e.alg)throw oo(to);const t=new io({typ:e.typ||he.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}
/*! @azure/msal-common v15.1.1 2025-02-11 */class ao{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class so{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:hn,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new ao}}startPerformanceMeasurement(){return new ao}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}
/*! @azure/msal-common v15.1.1 2025-02-11 */function co(e,t,r,n=5){if(e instanceof Error)return e instanceof Ce?(r.errorCode=e.errorCode,r.subErrorCode=e.subError,void((e instanceof Tn||e instanceof xn)&&(r.serverErrorNo=e.errorNo))):void(e instanceof Hr?r.errorCode=e.errorCode:r.errorStack?.length?t.trace("PerformanceClient.addErrorStack: Stack already exist",r.correlationId):e.stack?.length?(e.stack&&(r.errorStack=function(e,t){if(t<0)return[];const r=e.split("\n")||[],n=[],o=r[0];o.startsWith("TypeError: Cannot read property")||o.startsWith("TypeError: Cannot read properties of")||o.startsWith("TypeError: Cannot set property")||o.startsWith("TypeError: Cannot set properties of")||o.endsWith("is not a function")?n.push(lo(o)):(o.startsWith("SyntaxError")||o.startsWith("TypeError"))&&n.push(lo(o.replace(/['].*[']|["].*["]/g,"<redacted>")));for(let e=1;e<r.length&&!(n.length>=t);e++){const t=r[e];n.push(lo(t))}return n}(e.stack,n)),r.errorName=e.name):t.trace("PerformanceClient.addErrorStack: Input stack is empty",r.correlationId));t.trace("PerformanceClient.addErrorStack: Input error is not instance of Error",r.correlationId)}function lo(e){const t=e.lastIndexOf(" ")+1;if(t<1)return e;const r=e.substring(t);let n=r.lastIndexOf("/");return n=n<0?r.lastIndexOf("\\"):n,n>=0?(e.substring(0,t)+"("+r.substring(n+1)+(")"===r.charAt(r.length-1)?"":")")).trimStart():e.trimStart()}class ho{constructor(e,t,r,n,o,i,a,s){this.authority=t,this.libraryName=n,this.libraryVersion=o,this.applicationTelemetry=i,this.clientId=e,this.logger=r,this.callbacks=new Map,this.eventsByCorrelationId=new Map,this.eventStack=new Map,this.queueMeasurements=new Map,this.preQueueTimeByCorrelationId=new Map,this.intFields=a||new Set;for(const e of gn)this.intFields.add(e);this.abbreviations=s||new Map;for(const[e,t]of dn)this.abbreviations.set(e,t)}startPerformanceMeasurement(e,t){return{}}getPreQueueTime(e,t){const r=this.preQueueTimeByCorrelationId.get(t);if(r){if(r.name===e)return r.time;this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue time found for ${e}, unable to add queue measurement`)}else this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue times found for correlationId: ${t}, unable to add queue measurement`)}calculateQueuedTime(e,t){return e<1?(this.logger.trace(`PerformanceClient: preQueueTime should be a positive integer and not ${e}`),0):t<1?(this.logger.trace(`PerformanceClient: currentTime should be a positive integer and not ${t}`),0):t<e?(this.logger.trace("PerformanceClient: currentTime is less than preQueueTime, check how time is being retrieved"),0):t-e}addQueueMeasurement(e,t,r,n){if(!t)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: correlationId not provided for ${e}, cannot add queue measurement`);if(0===r)this.logger.trace(`PerformanceClient.addQueueMeasurement: queue time provided for ${e} is ${r}`);else if(!r)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: no queue time provided for ${e}`);const o={eventName:e,queueTime:n?0:r,manuallyCompleted:n},i=this.queueMeasurements.get(t);if(i)i.push(o),this.queueMeasurements.set(t,i);else{this.logger.trace(`PerformanceClient.addQueueMeasurement: adding correlationId ${t} to queue measurements`);const e=[o];this.queueMeasurements.set(t,e)}this.preQueueTimeByCorrelationId.delete(t)}startMeasurement(e,t){const r=t||this.generateId();t||this.logger.info(`PerformanceClient: No correlation id provided for ${e}, generating`,r),this.logger.trace(`PerformanceClient: Performance measurement started for ${e}`,r);const n={eventId:this.generateId(),status:hn,authority:this.authority,libraryName:this.libraryName,libraryVersion:this.libraryVersion,clientId:this.clientId,name:e,startTimeMs:Date.now(),correlationId:r,appName:this.applicationTelemetry?.appName,appVersion:this.applicationTelemetry?.appVersion};var o,i,a;return this.cacheEventByCorrelationId(n),o=n,i=this.abbreviations,(a=this.eventStack.get(r))&&a.push({name:i.get(o.name)||o.name}),{end:(e,t)=>this.endMeasurement({...n,...e},t),discard:()=>this.discardMeasurements(n.correlationId),add:e=>this.addFields(e,n.correlationId),increment:e=>this.incrementFields(e,n.correlationId),event:n,measurement:new ao}}endMeasurement(e,t){const r=this.eventsByCorrelationId.get(e.correlationId);if(!r)return this.logger.trace(`PerformanceClient: Measurement not found for ${e.eventId}`,e.correlationId),null;const n=e.eventId===r.eventId;let o={totalQueueTime:0,totalQueueCount:0,manuallyCompletedCount:0};e.durationMs=Math.round(e.durationMs||this.getDurationMs(e.startTimeMs));const i=JSON.stringify(function(e,t,r,n){if(!r?.length)return;const o=e=>e.length?e[e.length-1]:void 0,i=t.get(e.name)||e.name,a=o(r);if(a?.name!==i)return;const s=r?.pop();if(!s)return;const c=n instanceof Ce?n.errorCode:n instanceof Error?n.name:void 0,l=n instanceof Ce?n.subError:void 0;c&&s.childErr!==c&&(s.err=c,l&&(s.subErr=l)),delete s.name,delete s.childErr;const d={...s,dur:e.durationMs};e.success||(d.fail=1);const h=o(r);if(!h)return{[i]:d};let u;if(c&&(h.childErr=c),h[i]){const e=Object.keys(h).filter((e=>e.startsWith(i))).length;u=`${i}_${e+1}`}else u=i;return h[u]=d,h}(e,this.abbreviations,this.eventStack.get(r.correlationId),t));if(n?(o=this.getQueueInfo(e.correlationId),this.discardMeasurements(r.correlationId)):r.incompleteSubMeasurements?.delete(e.eventId),this.logger.trace(`PerformanceClient: Performance measurement ended for ${e.name}: ${e.durationMs} ms`,e.correlationId),t&&co(t,this.logger,r),!n)return r[e.name+"DurationMs"]=Math.floor(e.durationMs),{...r};n&&!t&&(r.errorCode||r.subErrorCode)&&(this.logger.trace(`PerformanceClient: Remove error and sub-error codes for root event ${e.name} as intermediate error was successfully handled`,e.correlationId),r.errorCode=void 0,r.subErrorCode=void 0);let a={...r,...e},s=0;return a.incompleteSubMeasurements?.forEach((t=>{this.logger.trace(`PerformanceClient: Incomplete submeasurement ${t.name} found for ${e.name}`,a.correlationId),s++})),a.incompleteSubMeasurements=void 0,a={...a,queuedTimeMs:o.totalQueueTime,queuedCount:o.totalQueueCount,queuedManuallyCompletedCount:o.manuallyCompletedCount,status:un,incompleteSubsCount:s,context:i},this.truncateIntegralFields(a),this.emitEvents([a],e.correlationId),a}addFields(e,t){this.logger.trace("PerformanceClient: Updating static fields");const r=this.eventsByCorrelationId.get(t);r?this.eventsByCorrelationId.set(t,{...r,...e}):this.logger.trace("PerformanceClient: Event not found for",t)}incrementFields(e,t){this.logger.trace("PerformanceClient: Updating counters");const r=this.eventsByCorrelationId.get(t);if(r)for(const t in e){if(r.hasOwnProperty(t)){if(isNaN(Number(r[t])))return}else r[t]=0;r[t]+=e[t]}else this.logger.trace("PerformanceClient: Event not found for",t)}cacheEventByCorrelationId(e){const t=this.eventsByCorrelationId.get(e.correlationId);t?(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} added/updated`,e.correlationId),t.incompleteSubMeasurements=t.incompleteSubMeasurements||new Map,t.incompleteSubMeasurements.set(e.eventId,{name:e.name,startTimeMs:e.startTimeMs})):(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} started`,e.correlationId),this.eventsByCorrelationId.set(e.correlationId,{...e}),this.eventStack.set(e.correlationId,[]))}getQueueInfo(e){const t=this.queueMeasurements.get(e);t||this.logger.trace(`PerformanceClient: no queue measurements found for for correlationId: ${e}`);let r=0,n=0,o=0;return t?.forEach((e=>{r+=e.queueTime,n++,o+=e.manuallyCompleted?1:0})),{totalQueueTime:r,totalQueueCount:n,manuallyCompletedCount:o}}discardMeasurements(e){this.logger.trace("PerformanceClient: Performance measurements discarded",e),this.eventsByCorrelationId.delete(e),this.logger.trace("PerformanceClient: QueueMeasurements discarded",e),this.queueMeasurements.delete(e),this.logger.trace("PerformanceClient: Pre-queue times discarded",e),this.preQueueTimeByCorrelationId.delete(e),this.logger.trace("PerformanceClient: Event stack discarded",e),this.eventStack.delete(e)}addPerformanceCallback(e){for(const[t,r]of this.callbacks)if(r.toString()===e.toString())return this.logger.warning(`PerformanceClient: Performance callback is already registered with id: ${t}`),t;const t=this.generateId();return this.callbacks.set(t,e),this.logger.verbose(`PerformanceClient: Performance callback registered with id: ${t}`),t}removePerformanceCallback(e){const t=this.callbacks.delete(e);return t?this.logger.verbose(`PerformanceClient: Performance callback ${e} removed.`):this.logger.verbose(`PerformanceClient: Performance callback ${e} not removed.`),t}emitEvents(e,t){this.logger.verbose("PerformanceClient: Emitting performance events",t),this.callbacks.forEach(((r,n)=>{this.logger.trace(`PerformanceClient: Emitting event to callback ${n}`,t),r.apply(null,[e])}))}truncateIntegralFields(e){this.intFields.forEach((t=>{t in e&&"number"==typeof e[t]&&(e[t]=Math.floor(e[t]))}))}getDurationMs(e){const t=Date.now()-e;return t<0?t:0}}const uo="pkce_not_created",go="crypto_nonexistent",po="empty_navigate_uri",mo="hash_empty_error",fo="no_state_in_hash",Co="hash_does_not_contain_known_properties",yo="unable_to_parse_state",vo="state_interaction_type_mismatch",Io="interaction_in_progress",To="popup_window_error",wo="empty_window_error",Ao="user_cancelled",ko="monitor_popup_timeout",So="monitor_window_timeout",bo="redirect_in_iframe",Eo="block_iframe_reload",Ro="block_nested_popups",_o="iframe_closed_prematurely",Po="silent_logout_unsupported",Mo="no_account_error",No="silent_prompt_value_error",Oo="no_token_request_cache_error",qo="unable_to_parse_token_request_cache_error",Uo="no_cached_authority_error",Lo="auth_request_not_set_error",Ho="invalid_cache_type",xo="non_browser_environment",Bo="database_not_open",Do="no_network_connectivity",Fo="post_request_failed",Ko="get_request_failed",zo="failed_to_parse_response",Go="unable_to_load_token",$o="crypto_key_not_found",Qo="auth_code_required",Wo="auth_code_or_nativeAccountId_required",jo="spa_code_and_nativeAccountId_present",Vo="database_unavailable",Yo="unable_to_acquire_token_from_native_platform",Jo="native_handshake_timeout",Xo="native_extension_not_installed",Zo="native_connection_not_established",ei="uninitialized_public_client_application",ti="native_prompt_not_supported",ri="invalid_base64_string",ni="invalid_pop_token_request",oi="failed_to_build_headers",ii="failed_to_parse_headers";var ai=Object.freeze({__proto__:null,authCodeOrNativeAccountIdRequired:Wo,authCodeRequired:Qo,authRequestNotSetError:Lo,blockIframeReload:Eo,blockNestedPopups:Ro,cryptoKeyNotFound:$o,cryptoNonExistent:go,databaseNotOpen:Bo,databaseUnavailable:Vo,emptyNavigateUri:po,emptyWindowError:wo,failedToBuildHeaders:oi,failedToParseHeaders:ii,failedToParseResponse:zo,getRequestFailed:Ko,hashDoesNotContainKnownProperties:Co,hashEmptyError:mo,iframeClosedPrematurely:_o,interactionInProgress:Io,invalidBase64String:ri,invalidCacheType:Ho,invalidPopTokenRequest:ni,monitorPopupTimeout:ko,monitorWindowTimeout:So,nativeConnectionNotEstablished:Zo,nativeExtensionNotInstalled:Xo,nativeHandshakeTimeout:Jo,nativePromptNotSupported:ti,noAccountError:Mo,noCachedAuthorityError:Uo,noNetworkConnectivity:Do,noStateInHash:fo,noTokenRequestCacheError:Oo,nonBrowserEnvironment:xo,pkceNotCreated:uo,popupWindowError:To,postRequestFailed:Fo,redirectInIframe:bo,silentLogoutUnsupported:Po,silentPromptValueError:No,spaCodeAndNativeAccountIdPresent:jo,stateInteractionTypeMismatch:vo,unableToAcquireTokenFromNativePlatform:Yo,unableToLoadToken:Go,unableToParseState:yo,unableToParseTokenRequestCacheError:qo,uninitializedPublicClientApplication:ei,userCancelled:Ao});const si="For more visit: aka.ms/msaljs/browser-errors",ci={[uo]:"The PKCE code challenge and verifier could not be generated.",[go]:"The crypto object or function is not available.",[po]:"Navigation URI is empty. Please check stack trace for more info.",[mo]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${si}`,[fo]:"Hash does not contain state. Please verify that the request originated from msal.",[Co]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${si}`,[yo]:"Unable to parse state. Please verify that the request originated from msal.",[vo]:"Hash contains state but the interaction type does not match the caller.",[Io]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${si}`,[To]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[wo]:"window.open returned null or undefined window object.",[Ao]:"User cancelled the flow.",[ko]:`Token acquisition in popup failed due to timeout.  ${si}`,[So]:`Token acquisition in iframe failed due to timeout.  ${si}`,[bo]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[Eo]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${si}`,[Ro]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[_o]:"The iframe being monitored was closed prematurely.",[Po]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[Mo]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[No]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[Oo]:"No token request found in cache.",[qo]:"The cached token request could not be parsed.",[Uo]:"No cached authority found.",[Lo]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[Ho]:"Invalid cache type",[xo]:"Login and token requests are not supported in non-browser environments.",[Bo]:"Database is not open!",[Do]:"No network connectivity. Check your internet connection.",[Fo]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[Ko]:"Network request failed. Please check the network trace to determine root cause.",[zo]:"Failed to parse network response. Check network trace.",[Go]:"Error loading token to cache.",[$o]:"Cryptographic Key or Keypair not found in browser storage.",[Qo]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[Wo]:"An authorization code or nativeAccountId must be provided to this flow.",[jo]:"Request cannot contain both spa code and native account id.",[Vo]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[Yo]:`Unable to acquire token from native platform.  ${si}`,[Jo]:"Timed out while attempting to establish connection to browser extension",[Xo]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[Zo]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${si}`,[ei]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${si}`,[ti]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[ri]:"Invalid base64 encoded string.",[ni]:"Invalid PoP token request. The request should not have both a popKid value and signPopToken set to true.",[oi]:"Failed to build request headers object.",[ii]:"Failed to parse response headers"},li={pkceNotGenerated:{code:uo,desc:ci[uo]},cryptoDoesNotExist:{code:go,desc:ci[go]},emptyNavigateUriError:{code:po,desc:ci[po]},hashEmptyError:{code:mo,desc:ci[mo]},hashDoesNotContainStateError:{code:fo,desc:ci[fo]},hashDoesNotContainKnownPropertiesError:{code:Co,desc:ci[Co]},unableToParseStateError:{code:yo,desc:ci[yo]},stateInteractionTypeMismatchError:{code:vo,desc:ci[vo]},interactionInProgress:{code:Io,desc:ci[Io]},popupWindowError:{code:To,desc:ci[To]},emptyWindowError:{code:wo,desc:ci[wo]},userCancelledError:{code:Ao,desc:ci[Ao]},monitorPopupTimeoutError:{code:ko,desc:ci[ko]},monitorIframeTimeoutError:{code:So,desc:ci[So]},redirectInIframeError:{code:bo,desc:ci[bo]},blockTokenRequestsInHiddenIframeError:{code:Eo,desc:ci[Eo]},blockAcquireTokenInPopupsError:{code:Ro,desc:ci[Ro]},iframeClosedPrematurelyError:{code:_o,desc:ci[_o]},silentLogoutUnsupportedError:{code:Po,desc:ci[Po]},noAccountError:{code:Mo,desc:ci[Mo]},silentPromptValueError:{code:No,desc:ci[No]},noTokenRequestCacheError:{code:Oo,desc:ci[Oo]},unableToParseTokenRequestCacheError:{code:qo,desc:ci[qo]},noCachedAuthorityError:{code:Uo,desc:ci[Uo]},authRequestNotSet:{code:Lo,desc:ci[Lo]},invalidCacheType:{code:Ho,desc:ci[Ho]},notInBrowserEnvironment:{code:xo,desc:ci[xo]},databaseNotOpen:{code:Bo,desc:ci[Bo]},noNetworkConnectivity:{code:Do,desc:ci[Do]},postRequestFailed:{code:Fo,desc:ci[Fo]},getRequestFailed:{code:Ko,desc:ci[Ko]},failedToParseNetworkResponse:{code:zo,desc:ci[zo]},unableToLoadTokenError:{code:Go,desc:ci[Go]},signingKeyNotFoundInStorage:{code:$o,desc:ci[$o]},authCodeRequired:{code:Qo,desc:ci[Qo]},authCodeOrNativeAccountRequired:{code:Wo,desc:ci[Wo]},spaCodeAndNativeAccountPresent:{code:jo,desc:ci[jo]},databaseUnavailable:{code:Vo,desc:ci[Vo]},unableToAcquireTokenFromNativePlatform:{code:Yo,desc:ci[Yo]},nativeHandshakeTimeout:{code:Jo,desc:ci[Jo]},nativeExtensionNotInstalled:{code:Xo,desc:ci[Xo]},nativeConnectionNotEstablished:{code:Zo,desc:ci[Zo]},uninitializedPublicClientApplication:{code:ei,desc:ci[ei]},nativePromptNotSupported:{code:ti,desc:ci[ti]},invalidBase64StringError:{code:ri,desc:ci[ri]},invalidPopTokenRequest:{code:ni,desc:ci[ni]}};class di extends Ce{constructor(e,t){super(e,ci[e],t),Object.setPrototypeOf(this,di.prototype),this.name="BrowserAuthError"}}function hi(e,t){return new di(e,t)}const ui="invalid_grant",gi=483,pi=600,mi="msal",fi=30,Ci="msal.js.browser",yi="53ee284d-920a-4b59-9d30-a60315b26836",vi="ppnbnpeolgkicgegkbkbjmhlideopiji",Ii="MATS",Ti="Handshake",wi="HandshakeResponse",Ai="GetToken",ki="Response",Si={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},bi="GET",Ei="POST",Ri="authority",_i="request.state",Pi="nonce.id_token",Mi="request.origin",Ni="urlHash",Oi="request.params",qi="interaction.status",Ui="ccs.credential",Li="request.correlationId",Hi="request.native",xi="msal.account.keys",Bi="msal.token.keys",Di="wrapper.sku",Fi="wrapper.version",Ki={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var zi;e.InteractionType=void 0,(zi=e.InteractionType||(e.InteractionType={})).Redirect="redirect",zi.Popup="popup",zi.Silent="silent",zi.None="none";const Gi={Startup:"startup",Login:"login",Logout:"logout",AcquireToken:"acquireToken",SsoSilent:"ssoSilent",HandleRedirect:"handleRedirect",None:"none"},$i={scopes:a},Qi="msal.db",Wi=`${Qi}.keys`,ji={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},Vi=[ji.Default,ji.Skip,ji.RefreshTokenAndNetwork];function Yi(e){return encodeURIComponent(Xi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function Ji(e){return Zi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function Xi(e){return Zi((new TextEncoder).encode(e))}function Zi(e){const t=Array.from(e,(e=>String.fromCodePoint(e))).join("");return btoa(t)}function ea(e){return(new TextDecoder).decode(ta(e))}function ta(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");switch(t.length%4){case 0:break;case 2:t+="==";break;case 3:t+="=";break;default:throw hi(ri)}const r=atob(t);return Uint8Array.from(r,(e=>e.codePointAt(0)||0))}const ra="AES-GCM",na="HKDF",oa="SHA-256",ia=new Uint8Array([1,0,1]),aa="0123456789abcdef",sa=new Uint32Array(1),ca="encrypt",la="decrypt",da={name:"RSASSA-PKCS1-v1_5",hash:oa,modulusLength:2048,publicExponent:ia};async function ha(e,t,r){t?.addQueueMeasurement(ln.Sha256Digest,r);const n=(new TextEncoder).encode(e);return window.crypto.subtle.digest(oa,n)}function ua(e){return window.crypto.getRandomValues(e)}function ga(){return window.crypto.getRandomValues(sa),sa[0]}function pa(){const e=Date.now(),t=1024*ga()+(1023&ga()),r=new Uint8Array(16),n=Math.trunc(t/2**30),o=t&2**30-1,i=ga();r[0]=e/2**40,r[1]=e/2**32,r[2]=e/2**24,r[3]=e/65536,r[4]=e/256,r[5]=e,r[6]=112|n>>>8,r[7]=n,r[8]=128|o>>>24,r[9]=o>>>16,r[10]=o>>>8,r[11]=o,r[12]=i>>>24,r[13]=i>>>16,r[14]=i>>>8,r[15]=i;let a="";for(let e=0;e<r.length;e++)a+=aa.charAt(r[e]>>>4),a+=aa.charAt(15&r[e]),3!==e&&5!==e&&7!==e&&9!==e||(a+="-");return a}async function ma(e){return window.crypto.subtle.exportKey("jwk",e)}async function fa(){const e=await window.crypto.subtle.generateKey({name:ra,length:256},!0,[ca,la]);return window.crypto.subtle.exportKey("raw",e)}async function Ca(e){return window.crypto.subtle.importKey("raw",e,na,!1,["deriveKey"])}async function ya(e,t,r){return window.crypto.subtle.deriveKey({name:na,salt:t,hash:oa,info:(new TextEncoder).encode(r)},e,{name:ra,length:256},!1,[ca,la])}async function va(e,t,r){const n=(new TextEncoder).encode(t),o=window.crypto.getRandomValues(new Uint8Array(16)),i=await ya(e,o,r),a=await window.crypto.subtle.encrypt({name:ra,iv:new Uint8Array(12)},i,n);return{data:Ji(new Uint8Array(a)),nonce:Ji(o)}}async function Ia(e,t,r,n){const o=ta(n),i=await ya(e,ta(t),r),a=await window.crypto.subtle.decrypt({name:ra,iv:new Uint8Array(12)},i,o);return(new TextDecoder).decode(a)}async function Ta(e){const t=await ha(e);return Ji(new Uint8Array(t))}const wa="storage_not_supported",Aa="stubbed_public_client_application_called",ka="in_mem_redirect_unavailable";var Sa=Object.freeze({__proto__:null,inMemRedirectUnavailable:ka,storageNotSupported:wa,stubbedPublicClientApplicationCalled:Aa});const ba={[wa]:"Given storage configuration option was not supported.",[Aa]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[ka]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."},Ea={storageNotSupportedError:{code:wa,desc:ba[wa]},stubPcaInstanceCalled:{code:Aa,desc:ba[Aa]},inMemRedirectUnavailable:{code:ka,desc:ba[ka]}};class Ra extends Ce{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,Ra.prototype)}}function _a(e){return new Ra(e,ba[e])}function Pa(e){e.location.hash="","function"==typeof e.history.replaceState&&e.history.replaceState(null,"",`${e.location.origin}${e.location.pathname}${e.location.search}`)}function Ma(e){const t=e.split("#");t.shift(),window.location.hash=t.length>0?t.join("#"):""}function Na(){return window.parent!==window}function Oa(){return"undefined"!=typeof window&&!!window.opener&&window.opener!==window&&"string"==typeof window.name&&0===window.name.indexOf(`${mi}.`)}function qa(){return"undefined"!=typeof window&&window.location?window.location.href.split("?")[0].split("#")[0]:""}function Ua(){const e=new Rr(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function La(){if(Rr.hashContainsKnownProperties(window.location.hash)&&Na())throw hi(Eo)}function Ha(e){if(Na()&&!e)throw hi(bo)}function xa(){if(Oa())throw hi(Ro)}function Ba(){if("undefined"==typeof window)throw hi(xo)}function Da(e){if(!e)throw hi(ei)}function Fa(e){Ba(),La(),xa(),Da(e)}function Ka(e,t){if(Fa(e),Ha(t.system.allowRedirectInIframe),t.cache.cacheLocation===Si.MemoryStorage&&!t.cache.storeAuthStateInCookie)throw _a(ka)}function za(e){const t=document.createElement("link");t.rel="preconnect",t.href=new URL(e).origin,t.crossOrigin="anonymous",document.head.appendChild(t),window.setTimeout((()=>{try{document.head.removeChild(t)}catch{}}),1e4)}function Ga(){return pa()}var $a=Object.freeze({__proto__:null,blockAPICallsBeforeInitialize:Da,blockAcquireTokenInPopups:xa,blockNonBrowserEnvironment:Ba,blockRedirectInIframe:Ha,blockReloadInHiddenIframes:La,clearHash:Pa,createGuid:Ga,getCurrentUri:qa,getHomepage:Ua,invoke:pn,invokeAsync:mn,isInIframe:Na,isInPopup:Oa,preconnect:za,preflightCheck:Fa,redirectPreflightCheck:Ka,replaceHash:Ma});class Qa{navigateInternal(e,t){return Qa.defaultNavigateWindow(e,t)}navigateExternal(e,t){return Qa.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise((e=>{setTimeout((()=>{e(!0)}),t.timeout)}))}}class Wa{async sendGetRequestAsync(e,t){let r,n={},o=0;const i=ja(t);try{r=await fetch(e,{method:bi,headers:i})}catch(e){throw hi(window.navigator.onLine?Ko:Do)}n=Va(r.headers);try{return o=r.status,{headers:n,body:await r.json(),status:o}}catch(e){throw kn(hi(zo),o,n)}}async sendPostRequestAsync(e,t){const r=t&&t.body||"",n=ja(t);let o,i=0,a={};try{o=await fetch(e,{method:Ei,headers:n,body:r})}catch(e){throw hi(window.navigator.onLine?Fo:Do)}a=Va(o.headers);try{return i=o.status,{headers:a,body:await o.json(),status:i}}catch(e){throw kn(hi(zo),i,a)}}}function ja(e){try{const t=new Headers;if(!e||!e.headers)return t;const r=e.headers;return Object.entries(r).forEach((([e,r])=>{t.append(e,r)})),t}catch(e){throw hi(oi)}}function Va(e){try{const t={};return e.forEach(((e,r)=>{t[r]=e})),t}catch(e){throw hi(ii)}}const Ya=1e4;const Ja="@azure/msal-browser",Xa="4.2.1";class Za{static loggerCallback(t,r){switch(t){case e.LogLevel.Error:return void console.error(r);case e.LogLevel.Info:return void console.info(r);case e.LogLevel.Verbose:return void console.debug(r);case e.LogLevel.Warning:return void console.warn(r);default:return void console.log(r)}}constructor(r){let n;this.browserEnvironment="undefined"!=typeof window,this.config=function({auth:r,cache:n,system:o,telemetry:i},a){const s={clientId:t.EMPTY_STRING,authority:`${t.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:t.EMPTY_STRING,authorityMetadata:t.EMPTY_STRING,redirectUri:"undefined"!=typeof window?qa():"",postLogoutRedirectUri:t.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:kr.AAD,OIDCOptions:{serverResponseType:k.FRAGMENT,defaultScopes:[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:vt.None,tenant:t.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1,instanceAware:!1},c={cacheLocation:Si.SessionStorage,temporaryCacheLocation:Si.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!(!n||n.cacheLocation!==Si.LocalStorage),claimsBasedCachingEnabled:!1},l={loggerCallback:()=>{},logLevel:e.LogLevel.Info,piiLoggingEnabled:!1},d={...{...Dr,loggerOptions:l,networkClient:a?new Wa:Jn,navigationClient:new Qa,loadFrameTimeout:0,windowHashTimeout:o?.loadFrameTimeout||6e4,iframeHashTimeout:o?.loadFrameTimeout||Ya,navigateFrameWait:0,redirectNavigationTimeout:3e4,asyncPopups:!1,allowRedirectInIframe:!1,allowPlatformBroker:!1,nativeBrokerHandshakeTimeout:o?.nativeBrokerHandshakeTimeout||2e3,pollIntervalMilliseconds:fi},...o,loggerOptions:o?.loggerOptions||l},h={application:{appName:t.EMPTY_STRING,appVersion:t.EMPTY_STRING},client:new so};r?.protocolMode!==kr.OIDC&&r?.OIDCOptions&&new ft(d.loggerOptions).warning(JSON.stringify(hr(or)));if(r?.protocolMode&&r.protocolMode!==kr.AAD&&d?.allowPlatformBroker)throw hr(ir);return{auth:{...s,...r,OIDCOptions:{...s.OIDCOptions,...r?.OIDCOptions}},cache:{...c,...n},system:d,telemetry:{...h,...i}}}(r,this.browserEnvironment);try{n=window[Si.SessionStorage]}catch(e){}const o=n?.getItem("msal.browser.log.level"),i=n?.getItem("msal.browser.log.pii")?.toLowerCase(),a="true"===i||"false"!==i&&void 0,s={...this.config.system.loggerOptions},c=o&&Object.keys(e.LogLevel).includes(o)?e.LogLevel[o]:void 0;c&&(s.loggerCallback=Za.loggerCallback,s.logLevel=c),void 0!==a&&(s.piiLoggingEnabled=a),this.logger=new ft(s,Ja,Xa),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}const es="USER_INTERACTION_REQUIRED",ts="USER_CANCEL",rs="NO_NETWORK",ns="TRANSIENT_ERROR",os="PERSISTENT_ERROR",is="DISABLED",as="ACCOUNT_UNAVAILABLE",ss="NESTED_APP_AUTH_UNAVAILABLE";class cs{static async initializeNestedAppAuthBridge(){if(void 0===window)throw new Error("window is undefined");if(void 0===window.nestedAppAuthBridge)throw new Error("window.nestedAppAuthBridge is undefined");try{window.nestedAppAuthBridge.addEventListener("message",(e=>{const t="string"==typeof e?e:e.data,r=JSON.parse(t),n=cs.bridgeRequests.find((e=>e.requestId===r.requestId));void 0!==n&&(cs.bridgeRequests.splice(cs.bridgeRequests.indexOf(n),1),r.success?n.resolve(r):n.reject(r.error))}));const e=await new Promise(((e,t)=>{const r=cs.buildRequest("GetInitContext"),n={requestId:r.requestId,method:r.method,resolve:e,reject:t};cs.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}));return cs.validateBridgeResultOrThrow(e.initContext)}catch(e){throw window.console.log(e),e}}getTokenInteractive(e){return this.getToken("GetTokenPopup",e)}getTokenSilent(e){return this.getToken("GetToken",e)}async getToken(e,t){const r=await this.sendRequest(e,{tokenParams:t});return{token:cs.validateBridgeResultOrThrow(r.token),account:cs.validateBridgeResultOrThrow(r.account)}}getHostCapabilities(){return this.capabilities??null}getAccountContext(){return this.accountContext?this.accountContext:null}static buildRequest(e,t){return{messageType:"NestedAppAuthRequest",method:e,requestId:pa(),sendTime:Date.now(),clientLibrary:Ci,clientLibraryVersion:Xa,...t}}sendRequest(e,t){const r=cs.buildRequest(e,t);return new Promise(((e,t)=>{const n={requestId:r.requestId,method:r.method,resolve:e,reject:t};cs.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}))}static validateBridgeResultOrThrow(e){if(void 0===e){throw{status:ss}}return e}constructor(e,t,r,n){this.sdkName=e,this.sdkVersion=t,this.accountContext=r,this.capabilities=n}static async create(){const e=await cs.initializeNestedAppAuthBridge();return new cs(e.sdkName,e.sdkVersion,e.accountContext,e.capabilities)}}cs.bridgeRequests=[];class ls extends Za{constructor(){super(...arguments),this.bridgeProxy=void 0,this.accountContext=null}getModuleName(){return ls.MODULE_NAME}getId(){return ls.ID}getBridgeProxy(){return this.bridgeProxy}async initialize(){try{if("undefined"!=typeof window){"function"==typeof window.__initializeNestedAppAuth&&await window.__initializeNestedAppAuth();const e=await cs.create();this.accountContext=e.getAccountContext(),this.bridgeProxy=e,this.available=void 0!==e}}catch(e){this.logger.infoPii(`Could not initialize Nested App Auth bridge (${e})`)}return this.logger.info(`Nested App Auth Bridge available: ${this.available}`),this.available}}ls.MODULE_NAME="",ls.ID="NestedAppOperatingContext";class ds extends Za{getModuleName(){return ds.MODULE_NAME}getId(){return ds.ID}async initialize(){return this.available="undefined"!=typeof window,this.available}}ds.MODULE_NAME="",ds.ID="StandardOperatingContext";class hs{constructor(){this.dbName=Qi,this.version=1,this.tableName=Wi,this.dbOpen=!1}async open(){return new Promise(((e,t)=>{const r=window.indexedDB.open(this.dbName,this.version);r.addEventListener("upgradeneeded",(e=>{e.target.result.createObjectStore(this.tableName)})),r.addEventListener("success",(t=>{const r=t;this.db=r.target.result,this.dbOpen=!0,e()})),r.addEventListener("error",(()=>t(hi(Vo))))}))}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(hi(Bo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async setItem(e,t){return await this.validateDbIsOpen(),new Promise(((r,n)=>{if(!this.db)return n(hi(Bo));const o=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);o.addEventListener("success",(()=>{this.closeConnection(),r()})),o.addEventListener("error",(e=>{this.closeConnection(),n(e)}))}))}async removeItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(hi(Bo));const n=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);n.addEventListener("success",(()=>{this.closeConnection(),t()})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async getKeys(){return await this.validateDbIsOpen(),new Promise(((e,t)=>{if(!this.db)return t(hi(Bo));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",(t=>{const r=t;this.closeConnection(),e(r.target.result)})),r.addEventListener("error",(e=>{this.closeConnection(),t(e)}))}))}async containsKey(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(hi(Bo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(1===r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise(((e,t)=>{const r=window.indexedDB.deleteDatabase(Qi),n=setTimeout((()=>t(!1)),200);r.addEventListener("success",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("blocked",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("error",(()=>(clearTimeout(n),t(!1))))}))}}class us{constructor(){this.cache=new Map}async initialize(){}getItem(e){return this.cache.get(e)||null}getUserData(e){return this.getItem(e)}setItem(e,t){this.cache.set(e,t)}async setUserData(e,t){this.setItem(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach(((t,r)=>{e.push(r)})),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}class gs{constructor(e){this.inMemoryCache=new us,this.indexedDBCache=new hs,this.logger=e}handleDatabaseAccessError(e){if(!(e instanceof di&&e.errorCode===Vo))throw e;this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.")}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(e){this.handleDatabaseAccessError(e)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(e){this.handleDatabaseAccessError(e)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(e){this.handleDatabaseAccessError(e)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(0===e.length)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(e){this.handleDatabaseAccessError(e)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(e){this.handleDatabaseAccessError(e)}return t}clearInMemory(){this.logger.verbose("Deleting in-memory keystore"),this.inMemoryCache.clear(),this.logger.verbose("In-memory keystore deleted")}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}class ps{constructor(e,t,r){this.logger=e,function(e){if(!window)throw hi(xo);if(!window.crypto)throw hi(go);if(!e&&!window.crypto.subtle)throw hi(go,"crypto_subtle_undefined")}(r??!1),this.cache=new gs(this.logger),this.performanceClient=t}createNewGuid(){return pa()}base64Encode(e){return Xi(e)}base64Decode(e){return ea(e)}base64UrlEncode(e){return Yi(e)}encodeKid(e){return this.base64UrlEncode(JSON.stringify({kid:e}))}async getPublicKeyThumbprint(e){const t=this.performanceClient?.startMeasurement(ln.CryptoOptsGetPublicKeyThumbprint,e.correlationId),r=await async function(e,t){return window.crypto.subtle.generateKey(da,e,t)}(ps.EXTRACTABLE,ps.POP_KEY_USAGES),n=await ma(r.publicKey),o=ms({e:n.e,kty:n.kty,n:n.n}),i=await this.hashString(o),a=await ma(r.privateKey),s=await async function(e,t,r){return window.crypto.subtle.importKey("jwk",e,da,t,r)}(a,!1,["sign"]);return await this.cache.setItem(i,{privateKey:s,publicKey:r.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),i}async removeTokenBindingKey(e){await this.cache.removeItem(e);return!await this.cache.containsKey(e)}async clearKeystore(){this.cache.clearInMemory();try{return await this.cache.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}async signJwt(e,t,r,n){const o=this.performanceClient?.startMeasurement(ln.CryptoOptsSignJwt,n),i=await this.cache.getItem(t);if(!i)throw hi($o);const a=await ma(i.publicKey),s=ms(a),c=Yi(JSON.stringify({kid:t})),l=Yi(io.getShrHeaderString({...r?.header,alg:a.alg,kid:c}));e.cnf={jwk:JSON.parse(s)};const d=`${l}.${Yi(JSON.stringify(e))}`,h=(new TextEncoder).encode(d),u=await async function(e,t){return window.crypto.subtle.sign(da,e,t)}(i.privateKey,h),g=`${d}.${Ji(new Uint8Array(u))}`;return o&&o.end({success:!0}),g}async hashString(e){return Ta(e)}}function ms(e){return JSON.stringify(e,Object.keys(e).sort())}ps.POP_KEY_USAGES=["sign","verify"],ps.EXTRACTABLE=!0;const fs=864e5,Cs="Lax",ys="None";class vs{initialize(){return Promise.resolve()}getItem(e){const t=`${encodeURIComponent(e)}`,r=document.cookie.split(";");for(let e=0;e<r.length;e++){const n=r[e],[o,...i]=decodeURIComponent(n).trim().split("="),a=i.join("=");if(o===t)return a}return""}getUserData(){throw gt(st)}setItem(e,t,r,n=!0,o=Cs){let i=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=${o};`;if(r){const e=function(e){const t=new Date,r=new Date(t.getTime()+e*fs);return r.toUTCString()}(r);i+=`expires=${e};`}(n||o===ys)&&(i+="Secure;"),document.cookie=i}async setUserData(){return Promise.reject(gt(st))}removeItem(e){this.setItem(e,"",-1)}getKeys(){const e=document.cookie.split(";"),t=[];return e.forEach((e=>{const r=decodeURIComponent(e).trim().split("=");t.push(r[0])})),t}containsKey(e){return this.getKeys().includes(e)}}function Is(e){const t=e.getItem(xi);return t?JSON.parse(t):[]}function Ts(e,t){const r=t.getItem(`${Bi}.${e}`);if(r){const e=JSON.parse(r);if(e&&e.hasOwnProperty("idToken")&&e.hasOwnProperty("accessToken")&&e.hasOwnProperty("refreshToken"))return e}return{idToken:[],accessToken:[],refreshToken:[]}}const ws="msal.cache.encryption";class As{constructor(e,t,r){if(!window.localStorage)throw _a(wa);this.memoryStorage=new us,this.initialized=!1,this.clientId=e,this.logger=t,this.performanceClient=r,this.broadcast=new BroadcastChannel("msal.broadcast.cache")}async initialize(e){this.initialized=!0;const t=new vs,r=t.getItem(ws);let n={key:"",id:""};if(r)try{n=JSON.parse(r)}catch(e){}if(n.key&&n.id){const t=pn(ta,ln.Base64Decode,this.logger,this.performanceClient,e)(n.key);this.encryptionCookie={id:n.id,key:await mn(Ca,ln.GenerateHKDF,this.logger,this.performanceClient,e)(t)},await mn(this.importExistingCache.bind(this),ln.ImportExistingCache,this.logger,this.performanceClient,e)(e)}else{this.clear();const r=pa(),n=await mn(fa,ln.GenerateBaseKey,this.logger,this.performanceClient,e)(),o=pn(Ji,ln.UrlEncodeArr,this.logger,this.performanceClient,e)(new Uint8Array(n));this.encryptionCookie={id:r,key:await mn(Ca,ln.GenerateHKDF,this.logger,this.performanceClient,e)(n)};const i={id:r,key:o};t.setItem(ws,JSON.stringify(i),0,!0,ys)}this.broadcast.addEventListener("message",this.updateCache.bind(this))}getItem(e){return window.localStorage.getItem(e)}getUserData(e){if(!this.initialized)throw hi(ei);return this.memoryStorage.getItem(e)}setItem(e,t){window.localStorage.setItem(e,t)}async setUserData(e,t,r){if(!this.initialized||!this.encryptionCookie)throw hi(ei);const{data:n,nonce:o}=await mn(va,ln.Encrypt,this.logger,this.performanceClient,r)(this.encryptionCookie.key,t,this.getContext(e)),i={id:this.encryptionCookie.id,nonce:o,data:n};this.memoryStorage.setItem(e,t),this.setItem(e,JSON.stringify(i)),this.broadcast.postMessage({key:e,value:t,context:this.getContext(e)})}removeItem(e){this.memoryStorage.containsKey(e)&&(this.memoryStorage.removeItem(e),this.broadcast.postMessage({key:e,value:null,context:this.getContext(e)})),window.localStorage.removeItem(e)}getKeys(){return Object.keys(window.localStorage)}containsKey(e){return window.localStorage.hasOwnProperty(e)}clear(){this.memoryStorage.clear();Is(this).forEach((e=>this.removeItem(e)));const e=Ts(this.clientId,this);e.idToken.forEach((e=>this.removeItem(e))),e.accessToken.forEach((e=>this.removeItem(e))),e.refreshToken.forEach((e=>this.removeItem(e))),this.getKeys().forEach((e=>{(e.startsWith(t.CACHE_PREFIX)||-1!==e.indexOf(this.clientId))&&this.removeItem(e)}))}async importExistingCache(e){if(!this.encryptionCookie)return;let t=Is(this);t=await this.importArray(t,e),this.setItem(xi,JSON.stringify(t));const r=Ts(this.clientId,this);r.idToken=await this.importArray(r.idToken,e),r.accessToken=await this.importArray(r.accessToken,e),r.refreshToken=await this.importArray(r.refreshToken,e),this.setItem(`${Bi}.${this.clientId}`,JSON.stringify(r))}async getItemFromEncryptedCache(e,t){if(!this.encryptionCookie)return null;const r=this.getItem(e);if(!r)return null;let n;try{n=JSON.parse(r)}catch(e){return null}return n.id&&n.nonce&&n.data?n.id!==this.encryptionCookie.id?(this.performanceClient.incrementFields({encryptedCacheExpiredCount:1},t),null):mn(Ia,ln.Decrypt,this.logger,this.performanceClient,t)(this.encryptionCookie.key,n.nonce,this.getContext(e),n.data):(this.performanceClient.incrementFields({unencryptedCacheCount:1},t),null)}async importArray(e,t){const r=[],n=[];return e.forEach((e=>{const o=this.getItemFromEncryptedCache(e,t).then((t=>{t?(this.memoryStorage.setItem(e,t),r.push(e)):this.removeItem(e)}));n.push(o)})),await Promise.all(n),r}getContext(e){let t="";return e.includes(this.clientId)&&(t=this.clientId),t}updateCache(e){this.logger.trace("Updating internal cache from broadcast event");const t=this.performanceClient.startMeasurement(ln.LocalStorageUpdated);t.add({isBackground:!0});const{key:r,value:n,context:o}=e.data;return r?o&&o!==this.clientId?(this.logger.trace(`Ignoring broadcast event from clientId: ${o}`),void t.end({success:!1,errorCode:"contextMismatch"})):(n?(this.memoryStorage.setItem(r,n),this.logger.verbose("Updated item in internal cache")):(this.memoryStorage.removeItem(r),this.logger.verbose("Removed item from internal cache")),void t.end({success:!0})):(this.logger.error("Broadcast event missing key"),void t.end({success:!1,errorCode:"noKey"}))}}class ks{constructor(){if(!window.sessionStorage)throw _a(wa)}async initialize(){}getItem(e){return window.sessionStorage.getItem(e)}getUserData(e){return this.getItem(e)}setItem(e,t){window.sessionStorage.setItem(e,t)}async setUserData(e,t){this.setItem(e,t)}removeItem(e){window.sessionStorage.removeItem(e)}getKeys(){return Object.keys(window.sessionStorage)}containsKey(e){return window.sessionStorage.hasOwnProperty(e)}}function Ss(e,t){if(!t)return null;try{return Fn.parseRequestState(e,t).libraryState.meta}catch(e){throw gt(Ee)}}const bs={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache"};class Es extends xr{constructor(e,t,r,n,o,i,a){super(e,r,n,a),this.cacheConfig=t,this.logger=n,this.internalStorage=new us,this.browserStorage=Rs(e,t.cacheLocation,n,o),this.temporaryCacheStorage=Rs(e,t.temporaryCacheLocation,n,o),this.cookieStorage=new vs,this.performanceClient=o,this.eventHandler=i}async initialize(e){await this.browserStorage.initialize(e)}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&"object"==typeof t?t:null}catch(e){return null}}getAccount(e){this.logger.trace("BrowserCacheManager.getAccount called");const t=this.browserStorage.getUserData(e);if(!t)return this.removeAccountKeyFromMap(e),null;const r=this.validateAndParseJson(t);return r&&Sr.isAccountEntity(r)?xr.toObject(new Sr,r):(this.removeAccountKeyFromMap(e),null)}async setAccount(e,t){this.logger.trace("BrowserCacheManager.setAccount called");const r=e.generateAccountKey();await mn(this.browserStorage.setUserData.bind(this.browserStorage),ln.SetUserData,this.logger,this.performanceClient)(r,JSON.stringify(e),t);const n=this.addAccountKeyToMap(r);this.cacheConfig.cacheLocation===Si.LocalStorage&&n&&this.eventHandler.emitEvent(bs.ACCOUNT_ADDED,void 0,e.getAccountInfo())}getAccountKeys(){return Is(this.browserStorage)}addAccountKeyToMap(e){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const t=this.getAccountKeys();return-1===t.indexOf(e)?(t.push(e),this.browserStorage.setItem(xi,JSON.stringify(t)),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added"),!0):(this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map"),!1)}removeAccountKeyFromMap(e){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const t=this.getAccountKeys(),r=t.indexOf(e);r>-1?(t.splice(r,1),this.browserStorage.setItem(xi,JSON.stringify(t)),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")):this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}async removeAccount(e){super.removeAccount(e),this.removeAccountKeyFromMap(e)}async removeAccountContext(e){await super.removeAccountContext(e),this.cacheConfig.cacheLocation===Si.LocalStorage&&this.eventHandler.emitEvent(bs.ACCOUNT_REMOVED,void 0,e.getAccountInfo())}removeIdToken(e){super.removeIdToken(e),this.removeTokenKey(e,O.ID_TOKEN)}async removeAccessToken(e){super.removeAccessToken(e),this.removeTokenKey(e,O.ACCESS_TOKEN)}removeRefreshToken(e){super.removeRefreshToken(e),this.removeTokenKey(e,O.REFRESH_TOKEN)}getTokenKeys(){return Ts(this.clientId,this.browserStorage)}addTokenKey(e,t){this.logger.trace("BrowserCacheManager addTokenKey called");const r=this.getTokenKeys();switch(t){case O.ID_TOKEN:-1===r.idToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),r.idToken.push(e));break;case O.ACCESS_TOKEN:-1===r.accessToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - accessToken added to map"),r.accessToken.push(e));break;case O.REFRESH_TOKEN:-1===r.refreshToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),r.refreshToken.push(e));break;default:throw this.logger.error(`BrowserCacheManager:addTokenKey - CredentialType provided invalid. CredentialType: ${t}`),gt(je)}this.browserStorage.setItem(`${Bi}.${this.clientId}`,JSON.stringify(r))}removeTokenKey(e,t){this.logger.trace("BrowserCacheManager removeTokenKey called");const r=this.getTokenKeys();switch(t){case O.ID_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove idToken with key: ${e} from map`);const n=r.idToken.indexOf(e);n>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - idToken removed from map"),r.idToken.splice(n,1)):this.logger.info("BrowserCacheManager: removeTokenKey - idToken does not exist in map. Either it was previously removed or it was never added.");break;case O.ACCESS_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove accessToken with key: ${e} from map`);const o=r.accessToken.indexOf(e);o>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - accessToken removed from map"),r.accessToken.splice(o,1)):this.logger.info("BrowserCacheManager: removeTokenKey - accessToken does not exist in map. Either it was previously removed or it was never added.");break;case O.REFRESH_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove refreshToken with key: ${e} from map`);const i=r.refreshToken.indexOf(e);i>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken removed from map"),r.refreshToken.splice(i,1)):this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken does not exist in map. Either it was previously removed or it was never added.");break;default:throw this.logger.error(`BrowserCacheManager:removeTokenKey - CredentialType provided invalid. CredentialType: ${t}`),gt(je)}this.browserStorage.setItem(`${Bi}.${this.clientId}`,JSON.stringify(r))}getIdTokenCredential(e){const t=this.browserStorage.getUserData(e);if(!t)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.ID_TOKEN),null;const r=this.validateAndParseJson(t);return r&&((n=r)&&_t(n)&&n.hasOwnProperty("realm")&&n.credentialType===O.ID_TOKEN)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.ID_TOKEN),null);var n}async setIdTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const r=St(e);await mn(this.browserStorage.setUserData.bind(this.browserStorage),ln.SetUserData,this.logger,this.performanceClient)(r,JSON.stringify(e),t),this.addTokenKey(r,O.ID_TOKEN)}getAccessTokenCredential(e){const t=this.browserStorage.getUserData(e);if(!t)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.ACCESS_TOKEN),null;const r=this.validateAndParseJson(t);return r&&(n=r)&&_t(n)&&n.hasOwnProperty("realm")&&n.hasOwnProperty("target")&&(n.credentialType===O.ACCESS_TOKEN||n.credentialType===O.ACCESS_TOKEN_WITH_AUTH_SCHEME)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.ACCESS_TOKEN),null);var n}async setAccessTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const r=St(e);await mn(this.browserStorage.setUserData.bind(this.browserStorage),ln.SetUserData,this.logger,this.performanceClient)(r,JSON.stringify(e),t),this.addTokenKey(r,O.ACCESS_TOKEN)}getRefreshTokenCredential(e){const t=this.browserStorage.getUserData(e);if(!t)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.REFRESH_TOKEN),null;const r=this.validateAndParseJson(t);return r&&(n=r)&&_t(n)&&n.credentialType===O.REFRESH_TOKEN?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,O.REFRESH_TOKEN),null);var n}async setRefreshTokenCredential(e,t){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const r=St(e);await mn(this.browserStorage.setUserData.bind(this.browserStorage),ln.SetUserData,this.logger,this.performanceClient)(r,JSON.stringify(e),t),this.addTokenKey(r,O.REFRESH_TOKEN)}getAppMetadata(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&(n=e,(o=r)&&0===n.indexOf(q)&&o.hasOwnProperty("clientId")&&o.hasOwnProperty("environment"))?(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null);var n,o}setAppMetadata(e){this.logger.trace("BrowserCacheManager.setAppMetadata called");const t=function({environment:e,clientId:t}){return[q,e,t].join(M).toLowerCase()}(e);this.browserStorage.setItem(t,JSON.stringify(e))}getServerTelemetry(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){const r=0===e.indexOf(K.CACHE_KEY);let n=!0;return t&&(n=t.hasOwnProperty("failedRequests")&&t.hasOwnProperty("errors")&&t.hasOwnProperty("cacheHits")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),r):(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null)}setServerTelemetry(e,t){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.browserStorage.setItem(e,JSON.stringify(t))}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){return!!t&&0===e.indexOf(L)&&t.hasOwnProperty("aliases")&&t.hasOwnProperty("preferred_cache")&&t.hasOwnProperty("preferred_network")&&t.hasOwnProperty("canonical_authority")&&t.hasOwnProperty("authorization_endpoint")&&t.hasOwnProperty("token_endpoint")&&t.hasOwnProperty("issuer")&&t.hasOwnProperty("aliasesFromNetwork")&&t.hasOwnProperty("endpointsFromNetwork")&&t.hasOwnProperty("expiresAt")&&t.hasOwnProperty("jwks_uri")}(e,r)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),r):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter((e=>this.isAuthorityMetadata(e)))}setWrapperMetadata(e,t){this.internalStorage.setItem(Di,e),this.internalStorage.setItem(Fi,t)}getWrapperMetadata(){return[this.internalStorage.getItem(Di)||t.EMPTY_STRING,this.internalStorage.getItem(Fi)||t.EMPTY_STRING]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(){const e=this.generateCacheKey(f),t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters found"),null;const r=this.validateAndParseJson(t);return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:r.homeAccountId,localAccountId:r.localAccountId,tenantId:r.tenantId})):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e){const t=this.generateCacheKey(f);if(e){this.logger.verbose("setActiveAccount: Active account set");const r={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId};this.browserStorage.setItem(t,JSON.stringify(r))}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(t);this.eventHandler.emitEvent(bs.ACTIVE_ACCOUNT_CHANGED)}getThrottlingCache(e){const t=this.browserStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){let r=!1;e&&(r=0===e.indexOf(Q));let n=!0;return t&&(n=t.hasOwnProperty("throttleTime")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),r):(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null)}setThrottlingCache(e,t){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.browserStorage.setItem(e,JSON.stringify(t))}getTemporaryCache(e,t){const r=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const e=this.cookieStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),e}const n=this.temporaryCacheStorage.getItem(r);if(!n){if(this.cacheConfig.cacheLocation===Si.LocalStorage){const e=this.browserStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),e}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),n}setTemporaryCache(e,t,r){const n=r?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(n,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.cookieStorage.setItem(n,t,void 0,this.cacheConfig.secureCookies))}removeItem(e){this.browserStorage.removeItem(e)}removeTemporaryItem(e){this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.cookieStorage.removeItem(e))}getKeys(){return this.browserStorage.getKeys()}async clear(){await this.removeAllAccounts(),this.removeAppMetadata(),this.temporaryCacheStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.removeTemporaryItem(e)})),this.browserStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.browserStorage.removeItem(e)})),this.internalStorage.clear()}async clearTokensAndKeysWithClaims(e,t){e.addQueueMeasurement(ln.ClearTokensAndKeysWithClaims,t);const r=this.getTokenKeys(),n=[];r.accessToken.forEach((e=>{const t=this.getAccessTokenCredential(e);t?.requestedClaimsHash&&e.includes(t.requestedClaimsHash.toLowerCase())&&n.push(this.removeAccessToken(e))})),await Promise.all(n),n.length>0&&this.logger.warning(`${n.length} access tokens with claims in the cache keys have been removed from the cache.`)}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):ur.startsWith(e,t.CACHE_PREFIX)?e:`${t.CACHE_PREFIX}.${this.clientId}.${e}`}generateAuthorityKey(e){const{libraryState:{id:t}}=Fn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Ri}.${t}`)}generateNonceKey(e){const{libraryState:{id:t}}=Fn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Pi}.${t}`)}generateStateKey(e){const{libraryState:{id:t}}=Fn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${_i}.${t}`)}getCachedAuthority(e){const t=this.generateStateKey(e),r=this.getTemporaryCache(t);if(!r)return null;const n=this.generateAuthorityKey(r);return this.getTemporaryCache(n)}updateCacheEntries(e,t,r,n,o){this.logger.trace("BrowserCacheManager.updateCacheEntries called");const i=this.generateStateKey(e);this.setTemporaryCache(i,e,!1);const a=this.generateNonceKey(e);this.setTemporaryCache(a,t,!1);const s=this.generateAuthorityKey(e);if(this.setTemporaryCache(s,r,!1),o){const e={credential:o.homeAccountId,type:Vr};this.setTemporaryCache(Ui,JSON.stringify(e),!0)}else if(n){const e={credential:n,type:Yr};this.setTemporaryCache(Ui,JSON.stringify(e),!0)}}resetRequestCache(e){this.logger.trace("BrowserCacheManager.resetRequestCache called"),e&&(this.temporaryCacheStorage.getKeys().forEach((t=>{-1!==t.indexOf(e)&&this.removeTemporaryItem(t)})),this.removeTemporaryItem(this.generateStateKey(e)),this.removeTemporaryItem(this.generateNonceKey(e)),this.removeTemporaryItem(this.generateAuthorityKey(e))),this.removeTemporaryItem(this.generateCacheKey(Oi)),this.removeTemporaryItem(this.generateCacheKey(Mi)),this.removeTemporaryItem(this.generateCacheKey(Ni)),this.removeTemporaryItem(this.generateCacheKey(Li)),this.removeTemporaryItem(this.generateCacheKey(Ui)),this.removeTemporaryItem(this.generateCacheKey(Hi)),this.setInteractionInProgress(!1)}cleanRequestByState(e){if(this.logger.trace("BrowserCacheManager.cleanRequestByState called"),e){const r=this.generateStateKey(e),n=this.temporaryCacheStorage.getItem(r);this.logger.infoPii(`BrowserCacheManager.cleanRequestByState: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n||t.EMPTY_STRING)}}cleanRequestByInteractionType(e){this.logger.trace("BrowserCacheManager.cleanRequestByInteractionType called"),this.temporaryCacheStorage.getKeys().forEach((t=>{if(-1===t.indexOf(_i))return;const r=this.temporaryCacheStorage.getItem(t);if(!r)return;const n=Ss(this.cryptoImpl,r);n&&n.interactionType===e&&(this.logger.infoPii(`BrowserCacheManager.cleanRequestByInteractionType: Removing temporary cache items for state: ${r}`),this.resetRequestCache(r))})),this.setInteractionInProgress(!1)}cacheCodeRequest(e){this.logger.trace("BrowserCacheManager.cacheCodeRequest called");const t=Xi(JSON.stringify(e));this.setTemporaryCache(Oi,t,!0)}getCachedRequest(e){this.logger.trace("BrowserCacheManager.getCachedRequest called");const t=this.getTemporaryCache(Oi,!0);if(!t)throw hi(Oo);let r;try{r=JSON.parse(ea(t))}catch(e){throw this.logger.errorPii(`Attempted to parse: ${t}`),this.logger.error(`Parsing cached token request threw with error: ${e}`),hi(qo)}if(this.removeTemporaryItem(this.generateCacheKey(Oi)),!r.authority){const t=this.generateAuthorityKey(e),n=this.getTemporaryCache(t);if(!n)throw hi(Uo);r.authority=n}return r}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(Hi,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress();return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${t.CACHE_PREFIX}.${qi}`;return this.getTemporaryCache(e,!1)}setInteractionInProgress(e){const r=`${t.CACHE_PREFIX}.${qi}`;if(e){if(this.getInteractionInProgress())throw hi(Io);this.setTemporaryCache(r,this.clientId,!1)}else e||this.getInteractionInProgress()!==this.clientId||this.removeTemporaryItem(r)}async hydrateCache(e,t){const r=bt(e.account?.homeAccountId,e.account?.environment,e.idToken,this.clientId,e.tenantId);let n;t.claims&&(n=await this.cryptoImpl.hashString(t.claims));const o={idToken:r,accessToken:Et(e.account?.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?e.expiresOn.getTime()/1e3:0,e.extExpiresOn?e.extExpiresOn.getTime()/1e3:0,ea,void 0,e.tokenType,void 0,t.sshKid,t.claims,n)};return this.saveCacheRecord(o,e.correlationId)}async saveCacheRecord(e,t,r){try{await super.saveCacheRecord(e,t,r)}catch(e){if(e instanceof Hr&&this.performanceClient&&t)try{const e=this.getTokenKeys();this.performanceClient.addFields({cacheRtCount:e.refreshToken.length,cacheIdCount:e.idToken.length,cacheAtCount:e.accessToken.length},t)}catch(e){}throw e}}}function Rs(e,t,r,n){try{switch(t){case Si.LocalStorage:return new As(e,r,n);case Si.SessionStorage:return new ks}}catch(e){r.error(e)}return new us}const _s=(e,t,r,n)=>new Es(e,{cacheLocation:Si.MemoryStorage,temporaryCacheLocation:Si.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1},pt,t,r,n);function Ps(e,t,r,n){return e.verbose("getAllAccounts called"),r?t.getAllAccounts(n):[]}function Ms(e,t,r){if(t.trace("getAccount called"),0===Object.keys(e).length)return t.warning("getAccount: No accountFilter provided"),null;const n=r.getAccountInfoFilteredBy(e);return n?(t.verbose("getAccount: Account matching provided filter found, returning"),n):(t.verbose("getAccount: No matching account found, returning null"),null)}function Ns(e,t,r){if(t.trace("getAccountByUsername called"),!e)return t.warning("getAccountByUsername: No username provided"),null;const n=r.getAccountInfoFilteredBy({username:e});return n?(t.verbose("getAccountByUsername: Account matching username found, returning"),t.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${e}`),n):(t.verbose("getAccountByUsername: No matching account found, returning null"),null)}function Os(e,t,r){if(t.trace("getAccountByHomeId called"),!e)return t.warning("getAccountByHomeId: No homeAccountId provided"),null;const n=r.getAccountInfoFilteredBy({homeAccountId:e});return n?(t.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),t.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${e}`),n):(t.verbose("getAccountByHomeId: No matching account found, returning null"),null)}function qs(e,t,r){if(t.trace("getAccountByLocalId called"),!e)return t.warning("getAccountByLocalId: No localAccountId provided"),null;const n=r.getAccountInfoFilteredBy({localAccountId:e});return n?(t.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),t.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${e}`),n):(t.verbose("getAccountByLocalId: No matching account found, returning null"),null)}function Us(e,t){t.setActiveAccount(e)}function Ls(e){return e.getActiveAccount()}class Hs{constructor(e){this.eventCallbacks=new Map,this.logger=e||new ft({}),this.broadcastChannel=new BroadcastChannel("msal.broadcast.event"),this.invokeCrossTabCallbacks=this.invokeCrossTabCallbacks.bind(this)}addEventCallback(e,t,r){if("undefined"!=typeof window){const n=r||Ga();return this.eventCallbacks.has(n)?(this.logger.error(`Event callback with id: ${n} is already registered. Please provide a unique id or remove the existing callback and try again.`),null):(this.eventCallbacks.set(n,[e,t||[]]),this.logger.verbose(`Event callback registered with id: ${n}`),n)}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}emitEvent(e,t,r,n){const o={eventType:e,interactionType:t||null,payload:r||null,error:n||null,timestamp:Date.now()};switch(e){case bs.ACCOUNT_ADDED:case bs.ACCOUNT_REMOVED:case bs.ACTIVE_ACCOUNT_CHANGED:this.broadcastChannel.postMessage(o);break;default:this.invokeCallbacks(o)}}invokeCallbacks(e){this.eventCallbacks.forEach((([t,r],n)=>{(0===r.length||r.includes(e.eventType))&&(this.logger.verbose(`Emitting event to callback ${n}: ${e.eventType}`),t.apply(null,[e]))}))}invokeCrossTabCallbacks(e){const t=e.data;this.invokeCallbacks(t)}subscribeCrossTab(){this.broadcastChannel.addEventListener("message",this.invokeCrossTabCallbacks)}unsubscribeCrossTab(){this.broadcastChannel.removeEventListener("message",this.invokeCrossTabCallbacks)}}class xs{constructor(e,t,r,n,o,i,a,s,c){this.config=e,this.browserStorage=t,this.browserCrypto=r,this.networkClient=this.config.system.networkClient,this.eventHandler=o,this.navigationClient=i,this.nativeMessageHandler=s,this.correlationId=c||pa(),this.logger=n.clone(Ci,Xa,this.correlationId),this.performanceClient=a}async clearCacheOnLogout(e){if(e){Sr.accountInfoIsEqual(e,this.browserStorage.getActiveAccount(),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null));try{await this.browserStorage.removeAccount(Sr.generateAccountCacheKey(e)),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch(e){this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),await this.browserStorage.clear(),await this.browserCrypto.clearKeystore()}catch(e){this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri;return Rr.getAbsoluteUrl(t,qa())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const r={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new Zn(r,this.browserStorage)}async getDiscoveredAuthority(e){const{account:t}=e,r=e.requestExtraQueryParameters&&e.requestExtraQueryParameters.hasOwnProperty("instance_aware")?e.requestExtraQueryParameters.instance_aware:void 0;this.performanceClient.addQueueMeasurement(ln.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const n={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},o=e.requestAuthority||this.config.auth.authority,i=r?.length?"true"===r:this.config.auth.instanceAware,a=t&&i?this.config.auth.authority.replace(Rr.getDomainFromUrl(o),t.environment):o,s=Cn.generateAuthority(a,e.requestAzureCloudOptions||this.config.auth.azureCloudOptions),c=await mn(In,ln.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(s,this.config.system.networkClient,this.browserStorage,n,this.logger,this.correlationId,this.performanceClient);if(t&&!c.isAlias(t.environment))throw hr(ar);return c}}async function Bs(e,t,r){e.addQueueMeasurement(ln.GeneratePkceCodes,r);const n=pn(Ds,ln.GenerateCodeVerifier,t,e,r)(e,t,r);return{verifier:n,challenge:await mn(Fs,ln.GenerateCodeChallengeFromVerifier,t,e,r)(n,e,t,r)}}function Ds(e,t,r){try{const n=new Uint8Array(32);pn(ua,ln.GetRandomValues,t,e,r)(n);return Ji(n)}catch(e){throw hi(uo)}}async function Fs(e,t,r,n){t.addQueueMeasurement(ln.GenerateCodeChallengeFromVerifier,n);try{const o=await mn(ha,ln.Sha256Digest,r,t,n)(e,t,n);return Ji(new Uint8Array(o))}catch(e){throw hi(uo)}}async function Ks(e,t,r,n){r.addQueueMeasurement(ln.InitializeBaseRequest,e.correlationId);const o=e.authority||t.auth.authority,i=[...e&&e.scopes||[]],a={...e,correlationId:e.correlationId,authority:o,scopes:i};if(a.authenticationScheme){if(a.authenticationScheme===z.SSH){if(!e.sshJwk)throw hr(er);if(!e.sshKid)throw hr(tr)}n.verbose(`Authentication Scheme set to "${a.authenticationScheme}" as configured in Auth request`)}else a.authenticationScheme=z.BEARER,n.verbose('Authentication Scheme wasn\'t explicitly set in request, defaulting to "Bearer" request');return t.cache.claimsBasedCachingEnabled&&e.claims&&!ur.isEmptyObj(e.claims)&&(a.requestedClaimsHash=await Ta(e.claims)),a}async function zs(e,t,r,n,o){n.addQueueMeasurement(ln.InitializeSilentRequest,e.correlationId);const i=await mn(Ks,ln.InitializeBaseRequest,o,n,e.correlationId)(e,r,n,o);return{...e,...i,account:t,forceRefresh:e.forceRefresh||!1}}class Gs extends xs{async initializeAuthorizationCodeRequest(e){this.performanceClient.addQueueMeasurement(ln.StandardInteractionClientInitializeAuthorizationCodeRequest,this.correlationId);const r=await mn(Bs,ln.GeneratePkceCodes,this.logger,this.performanceClient,this.correlationId)(this.performanceClient,this.logger,this.correlationId),n={...e,redirectUri:e.redirectUri,code:t.EMPTY_STRING,codeVerifier:r.verifier};return e.codeChallenge=r.challenge,e.codeChallengeMethod=t.S256_CODE_CHALLENGE_METHOD,n}initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e?.correlationId);const t={correlationId:this.correlationId||pa(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const r=this.getLogoutHintFromIdTokenClaims(e.account);r&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=r)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return e&&null===e.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId):e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=Rr.getAbsoluteUrl(e.postLogoutRedirectUri,qa())):null===this.config.auth.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=Rr.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,qa())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=Rr.getAbsoluteUrl(qa(),qa())),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e){this.performanceClient.addQueueMeasurement(ln.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const t=await mn(this.getClientConfiguration.bind(this),ln.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e);return new jn(t,this.performanceClient)}async getClientConfiguration(e){const{serverTelemetryManager:r,requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:a}=e;this.performanceClient.addQueueMeasurement(ln.StandardInteractionClientGetClientConfiguration,this.correlationId);const s=await mn(this.getDiscoveredAuthority.bind(this),ln.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)({requestAuthority:n,requestAzureCloudOptions:o,requestExtraQueryParameters:i,account:a}),c=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:s,clientCapabilities:this.config.auth.clientCapabilities,redirectUri:this.config.auth.redirectUri},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:c.loggerCallback,piiLoggingEnabled:c.piiLoggingEnabled,logLevel:c.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:r,libraryInfo:{sku:Ci,version:Xa,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,r){this.performanceClient.addQueueMeasurement(ln.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:r},i=Fn.setRequestState(this.browserCrypto,e&&e.state||t.EMPTY_STRING,o),a={...await mn(Ks,ln.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)({...e,correlationId:this.correlationId},this.config,this.performanceClient,this.logger),redirectUri:n,state:i,nonce:e.nonce||pa(),responseMode:this.config.auth.OIDCOptions.serverResponseType};if(e.loginHint||e.sid)return a;const s=e.account||this.browserStorage.getActiveAccount();return s&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${s.homeAccountId}`,this.correlationId),a.account=s),a}}const $s="user_switch",Qs={[$s]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class Ws extends Ce{constructor(e,t,r){super(e,t),Object.setPrototypeOf(this,Ws.prototype),this.name="NativeAuthError",this.ext=r}}function js(e){return!(!e.ext||!e.ext.status||"PERSISTENT_ERROR"!==e.ext.status&&"DISABLED"!==e.ext.status)||(!(!e.ext||!e.ext.error||-2147186943!==e.ext.error)||"ContentError"===e.errorCode)}function Vs(e,t,r){if(r&&r.status)switch(r.status){case"ACCOUNT_UNAVAILABLE":return Dn(En);case"USER_INTERACTION_REQUIRED":return new xn(e,t);case"USER_CANCEL":return hi(Ao);case"NO_NETWORK":return hi(Do)}return new Ws(e,Qs[e]||t,r)}class Ys extends Gs{async acquireToken(e){this.performanceClient.addQueueMeasurement(ln.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(Ki.acquireTokenSilent_silentFlow),r=await mn(this.getClientConfiguration.bind(this),ln.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:e.authority,requestAzureCloudOptions:e.azureCloudOptions,account:e.account}),n=new Yn(r,this.performanceClient);this.logger.verbose("Silent auth client created");try{const t=(await mn(n.acquireCachedToken.bind(n),ln.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),t}catch(e){throw e instanceof di&&e.errorCode===$o&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),e}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t?.account)}}class Js extends xs{constructor(e,t,r,n,o,i,a,s,c,l,d,h){super(e,t,r,n,o,i,s,c,h),this.apiId=a,this.accountId=l,this.nativeMessageHandler=c,this.nativeStorageManager=d,this.silentCacheClient=new Ys(e,this.nativeStorageManager,r,n,o,i,s,c,h);const u=this.nativeMessageHandler.getExtensionId()===vi?"chrome":this.nativeMessageHandler.getExtensionId()?.length?"unknown":void 0;this.skus=Zn.makeExtraSkuString({libraryName:Ci,libraryVersion:Xa,extensionName:u,extensionVersion:this.nativeMessageHandler.getExtensionVersion()})}addRequestSKUs(e){e.extraParameters={...e.extraParameters,[nn]:this.skus}}async acquireToken(e){this.performanceClient.addQueueMeasurement(ln.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const t=this.performanceClient.startMeasurement(ln.NativeInteractionClientAcquireToken,e.correlationId),r=wt(),n=this.initializeServerTelemetryManager(this.apiId);try{const o=await this.initializeNativeRequest(e);try{const e=await this.acquireTokensFromCache(this.accountId,o);return t.end({success:!0,isNativeBroker:!1,fromCache:!0}),e}catch(e){this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const{...i}=o,a={method:Ai,request:i},s=await this.nativeMessageHandler.sendMessage(a),c=this.validateNativeResponse(s);return await this.handleNativeResponse(c,o,r).then((e=>(t.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),n.clearNativeBrokerErrorCode(),e))).catch((e=>{throw t.end({success:!1,errorCode:e.errorCode,subErrorCode:e.subError,isNativeBroker:!0}),e}))}catch(e){throw e instanceof Ws&&n.setNativeBrokerErrorCode(e.errorCode),e}}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:gr.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),gt(Qe);const r=this.browserStorage.getBaseAccountInfo({nativeAccountId:e});if(!r)throw gt(Qe);try{const e=this.createSilentCacheRequest(t,r),n=await this.silentCacheClient.acquireToken(e),o={...r,idTokenClaims:n?.idTokenClaims,idToken:n?.idToken};return{...n,account:o}}catch(e){throw e}}async acquireTokenRedirect(e,t){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const{...r}=e;delete r.onRedirectNavigate;const n=await this.initializeNativeRequest(r),o={method:Ai,request:n};try{const e=await this.nativeMessageHandler.sendMessage(o);this.validateNativeResponse(e)}catch(e){if(e instanceof Ws){if(this.initializeServerTelemetryManager(this.apiId).setNativeBrokerErrorCode(e.errorCode),js(e))throw e}}this.browserStorage.setTemporaryCache(Hi,JSON.stringify(n),!0);const i={apiId:Ki.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},a=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);t.end({success:!0}),await this.navigationClient.navigateExternal(a,i)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getCachedNativeRequest();if(!r)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&e?.addFields({errorCode:"no_cached_request"},t),null;const{prompt:n,...o}=r;n&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Hi));const i={method:Ai,request:o},a=wt();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const e=await this.nativeMessageHandler.sendMessage(i);this.validateNativeResponse(e);const t=this.handleNativeResponse(e,o,a);this.browserStorage.setInteractionInProgress(!1);const r=await t;return this.initializeServerTelemetryManager(this.apiId).clearNativeBrokerErrorCode(),r}catch(e){throw this.browserStorage.setInteractionInProgress(!1),e}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,r){this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const n=It(e.id_token,ea),o=this.createHomeAccountIdentifier(e,n),i=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId})?.homeAccountId;if(o!==i&&e.account.id!==t.accountId)throw Vs($s);const a=await this.getDiscoveredAuthority({requestAuthority:t.authority}),s=Qn(this.browserStorage,a,o,ea,n,e.client_info,void 0,n.tid,void 0,e.account.id,this.logger),c=await this.generateAuthenticationResult(e,t,n,s,a.canonicalAuthority,r);return await this.cacheAccount(s),await this.cacheNativeTokens(e,t,o,n,e.access_token,c.tenantId,r),c}createHomeAccountIdentifier(e,r){return Sr.generateHomeAccountId(e.client_info||t.EMPTY_STRING,vr,this.logger,this.browserCrypto,r)}generateScopes(e,t){return e.scope?gr.fromString(e.scope):gr.fromString(t.scope)}async generatePopAccessToken(e,t){if(t.tokenType===z.POP&&t.signPopToken){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const r=new zn(this.browserCrypto),n={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw gt(nt);return r.signPopToken(e.access_token,t.keyId,n)}return e.access_token}async generateAuthenticationResult(e,r,n,o,i,a){const s=this.addTelemetryFromNativeResponse(e),c=e.scope?gr.fromString(e.scope):gr.fromString(r.scope),l=e.account.properties||{},d=l.UID||n.oid||n.sub||t.EMPTY_STRING,h=l.TenantId||n.tid||t.EMPTY_STRING,u=yr(o.getAccountInfo(),void 0,n,e.id_token);u.nativeAccountId!==e.account.id&&(u.nativeAccountId=e.account.id);const g=await this.generatePopAccessToken(e,r),p=r.tokenType===z.POP?z.POP:z.BEARER;return{authority:i,uniqueId:d,tenantId:h,scopes:c.asArray(),account:u,idToken:e.id_token,idTokenClaims:n,accessToken:g,fromCache:!!s&&this.isResponseFromCache(s),expiresOn:new Date(1e3*Number(a+e.expires_in)),tokenType:p,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}async cacheAccount(e){await this.browserStorage.setAccount(e,this.correlationId),this.browserStorage.removeAccountContext(e).catch((e=>{this.logger.error(`Error occurred while removing account context from browser storage. ${e}`)}))}cacheNativeTokens(e,r,n,o,i,a,s){const c=bt(n,r.authority,e.id_token||"",r.clientId,o.tid||""),l=s+(r.tokenType===z.POP?t.SHR_NONCE_VALIDITY:("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0),d=this.generateScopes(e,r),h={idToken:c,accessToken:Et(n,r.authority,i,r.clientId,o.tid||a,d.printScopes(),l,0,ea,void 0,r.tokenType,void 0,r.keyId)};return this.nativeStorageManager.saveCacheRecord(h,this.correlationId,r.storeInCache)}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.nativeMessageHandler.getExtensionId(),extensionVersion:this.nativeMessageHandler.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}validateNativeResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw ye(ue,"Response missing expected properties.")}getMATSFromResponse(e){if(e.properties.MATS)try{return JSON.parse(e.properties.MATS)}catch(e){this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return void 0===e.is_cached?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority({requestAuthority:t,requestAzureCloudOptions:e.azureCloudOptions,account:e.account});const r=new Rr(t);r.validateAsUri();const{scopes:n,...o}=e,i=new gr(n||[]);i.appendScopes(a);const s={...o,accountId:this.accountId,clientId:this.config.auth.clientId,authority:r.urlString,scope:i.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:(()=>{switch(this.apiId){case Ki.ssoSilent:case Ki.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),w.NONE}if(e.prompt)switch(e.prompt){case w.NONE:case w.CONSENT:case w.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e.prompt;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e.prompt} is not compatible with native flow`),hi(ti)}else this.logger.trace("initializeNativeRequest: prompt was not provided")})(),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1,keyId:e.popKid};if(s.signPopToken&&e.popKid)throw hi(ni);if(this.handleExtraBrokerParams(s),s.extraParameters=s.extraParameters||{},s.extraParameters.telemetry=Ii,e.authenticationScheme===z.POP){const t={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},r=new zn(this.browserCrypto);let n;if(s.keyId)n=this.browserCrypto.base64UrlEncode(JSON.stringify({kid:s.keyId})),s.signPopToken=!1;else{const o=await mn(r.generateCnf.bind(r),ln.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(t,this.logger);n=o.reqCnfString,s.keyId=o.kid,s.signPopToken=!0}s.reqCnf=n}return this.addRequestSKUs(s),s}handleExtraBrokerParams(e){const t=e.extraParameters&&e.extraParameters.hasOwnProperty(on)&&e.extraParameters.hasOwnProperty(an)&&e.extraParameters.hasOwnProperty(Jr);if(!e.embeddedClientId&&!t)return;let r="";const n=e.redirectUri;e.embeddedClientId?(e.redirectUri=this.config.auth.redirectUri,r=e.embeddedClientId):e.extraParameters&&(e.redirectUri=e.extraParameters[an],r=e.extraParameters[Jr]),e.extraParameters={child_client_id:r,child_redirect_uri:n},this.performanceClient?.addFields({embeddedClientId:r,embeddedRedirectUri:n},e.correlationId)}}class Xs{constructor(e,t,r,n){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=n,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=r,this.handshakeEvent=r.startMeasurement(ln.NativeMessageHandlerHandshake)}async sendMessage(e){this.logger.trace("NativeMessageHandler - sendMessage called.");const t={channel:yi,extensionId:this.extensionId,responseId:pa(),body:e};return this.logger.trace("NativeMessageHandler - Sending request to browser extension"),this.logger.tracePii(`NativeMessageHandler - Sending request to browser extension: ${JSON.stringify(t)}`),this.messageChannel.port1.postMessage(t),new Promise(((e,r)=>{this.resolvers.set(t.responseId,{resolve:e,reject:r})}))}static async createProvider(e,t,r){e.trace("NativeMessageHandler - createProvider called.");try{const n=new Xs(e,t,r,vi);return await n.sendHandshakeRequest(),n}catch(n){const o=new Xs(e,t,r);return await o.sendHandshakeRequest(),o}}async sendHandshakeRequest(){this.logger.trace("NativeMessageHandler - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:yi,extensionId:this.extensionId,responseId:pa(),body:{method:Ti}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=e=>{this.onChannelMessage(e)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise(((t,r)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:r}),this.timeoutId=window.setTimeout((()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),r(hi(Jo)),this.handshakeResolvers.delete(e.responseId)}),this.handshakeTimeoutMs)}))}onWindowMessage(e){if(this.logger.trace("NativeMessageHandler - onWindowMessage called"),e.source!==window)return;const t=e.data;if(t.channel&&t.channel===yi&&(!t.extensionId||t.extensionId===this.extensionId)&&t.body.method===Ti){const e=this.handshakeResolvers.get(t.responseId);if(!e)return void this.logger.trace(`NativeMessageHandler.onWindowMessage - resolver can't be found for request ${t.responseId}`);this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),e.reject(hi(Xo))}}onChannelMessage(e){this.logger.trace("NativeMessageHandler - onChannelMessage called.");const t=e.data,r=this.resolvers.get(t.responseId),n=this.handshakeResolvers.get(t.responseId);try{const e=t.body.method;if(e===ki){if(!r)return;const e=t.body.response;if(this.logger.trace("NativeMessageHandler - Received response from browser extension"),this.logger.tracePii(`NativeMessageHandler - Received response from browser extension: ${JSON.stringify(e)}`),"Success"!==e.status)r.reject(Vs(e.code,e.description,e.ext));else{if(!e.result)throw ye(ue,"Event does not contain result.");e.result.code&&e.result.description?r.reject(Vs(e.result.code,e.result.description,e.result.ext)):r.resolve(e.result)}this.resolvers.delete(t.responseId)}else if(e===wi){if(!n)return void this.logger.trace(`NativeMessageHandler.onChannelMessage - resolver can't be found for request ${t.responseId}`);clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(`NativeMessageHandler - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),n.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(t){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${t}`),this.logger.errorPii(`Unable to parse ${e}`),r?r.reject(t):n&&n.reject(t)}}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}static isPlatformBrokerAvailable(e,t,r,n){if(t.trace("isPlatformBrokerAvailable called"),!e.system.allowPlatformBroker)return t.trace("isPlatformBrokerAvailable: allowPlatformBroker is not enabled, returning false"),!1;if(!r)return t.trace("isPlatformBrokerAvailable: Platform extension provider is not initialized, returning false"),!1;if(n)switch(n){case z.BEARER:case z.POP:return t.trace("isPlatformBrokerAvailable: authenticationScheme is supported, returning true"),!0;default:return t.trace("isPlatformBrokerAvailable: authenticationScheme is not supported, returning false"),!1}return!0}}class Zs{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async handleCodeResponse(e,t){let r;this.performanceClient.addQueueMeasurement(ln.HandleCodeResponse,t.correlationId);try{r=this.authModule.handleFragmentResponse(e,t.state)}catch(e){throw e instanceof Tn&&e.subError===Ao?hi(Ao):e}return mn(this.handleCodeResponseFromServer.bind(this),ln.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(r,t)}async handleCodeResponseFromServer(e,t,r=!0){if(this.performanceClient.addQueueMeasurement(ln.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await mn(this.authModule.updateAuthority.bind(this.authModule),ln.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),r&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const e=this.createCcsCredentials(t);e&&(this.authCodeRequest.ccsCredential=e)}return await mn(this.authModule.acquireToken.bind(this.authModule),ln.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:Vr}:e.loginHint?{credential:e.loginHint,type:Yr}:null}}function ec(e,t,r){const n=Er(e);if(!n)throw br(e)?(r.error(`A ${t} is present in the iframe but it does not contain known properties. It's likely that the ${t} has been replaced by code running on the redirectUri page.`),r.errorPii(`The ${t} detected is: ${e}`),hi(Co)):(r.error(`The request has returned to the redirectUri but a ${t} is not present. It's likely that the ${t} has been removed or the page has been redirected by code running on the redirectUri page.`),hi(mo));return n}class tc extends Gs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=s}acquireToken(e){try{const t={popupName:this.generatePopupName(e.scopes||a,e.authority||this.config.auth.authority),popupWindowAttributes:e.popupWindowAttributes||{},popupWindowParent:e.popupWindowParent??window};return this.performanceClient.addFields({isAsyncPopup:this.config.system.asyncPopups},this.correlationId),this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,t)):(this.logger.verbose("asyncPopup set to false, opening popup before acquiring token"),t.popup=this.openSizedPopup("about:blank",t),this.acquireTokenPopupAsync(e,t))}catch(e){return Promise.reject(e)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),r={popupName:this.generateLogoutPopupName(t),popupWindowAttributes:e?.popupWindowAttributes||{},popupWindowParent:e?.popupWindowParent??window},n=e&&e.authority,o=e&&e.mainWindowRedirectUri;return this.config.system.asyncPopups?(this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,r,n,o)):(this.logger.verbose("asyncPopup set to false, opening popup"),r.popup=this.openSizedPopup("about:blank",r),this.logoutPopupAsync(t,r,n,o))}catch(e){return Promise.reject(e)}}async acquireTokenPopupAsync(t,r){this.logger.verbose("acquireTokenPopupAsync called");const n=this.initializeServerTelemetryManager(Ki.acquireTokenPopup),o=await mn(this.initializeAuthorizationRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Popup);za(o.authority);try{const i=await mn(this.initializeAuthorizationCodeRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(o),a=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:o.authority,requestAzureCloudOptions:o.azureCloudOptions,requestExtraQueryParameters:o.extraQueryParameters,account:o.account}),s=Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme);let c;s&&(c=this.performanceClient.startMeasurement(ln.FetchAccountIdWithNativeBroker,t.correlationId));const l=await a.getAuthCodeUrl({...o,platformBroker:s}),d=new Zs(a,this.browserStorage,i,this.logger,this.performanceClient),h=this.initiateAuthRequest(l,r);this.eventHandler.emitEvent(bs.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:h},null);const u=await this.monitorPopupForHash(h,r.popupWindowParent),g=pn(ec,ln.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(u,this.config.auth.OIDCOptions.serverResponseType,this.logger);if(wn.removeThrottle(this.browserStorage,this.config.auth.clientId,i),g.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),c&&c.end({success:!0,isNativeBroker:!0}),!this.nativeMessageHandler)throw hi(Zo);const e=new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,g.accountId,this.nativeStorage,o.correlationId),{userRequestState:t}=Fn.parseRequestState(this.browserCrypto,o.state);return await e.acquireToken({...o,state:t,prompt:void 0})}return await d.handleCodeResponse(g,o)}catch(e){throw r.popup?.close(),e instanceof Ce&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}async logoutPopupAsync(t,r,n,o){this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(bs.LOGOUT_START,e.InteractionType.Popup,t);const i=this.initializeServerTelemetryManager(Ki.logoutPopup);try{await this.clearCacheOnLogout(t.account);const a=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:i,requestAuthority:n,account:t.account||void 0});try{a.authority.endSessionEndpoint}catch{if(t.account?.homeAccountId&&t.postLogoutRedirectUri&&a.authority.protocolMode===kr.OIDC){if(this.browserStorage.removeAccount(t.account?.homeAccountId),this.eventHandler.emitEvent(bs.LOGOUT_SUCCESS,e.InteractionType.Popup,t),o){const e={apiId:Ki.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=Rr.getAbsoluteUrl(o,qa());await this.navigationClient.navigateInternal(t,e)}return void r.popup?.close()}}const s=a.getLogoutUri(t);this.eventHandler.emitEvent(bs.LOGOUT_SUCCESS,e.InteractionType.Popup,t);const c=this.openPopup(s,r);if(this.eventHandler.emitEvent(bs.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:c},null),await this.monitorPopupForHash(c,r.popupWindowParent).catch((()=>{})),o){const e={apiId:Ki.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=Rr.getAbsoluteUrl(o,qa());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${t}`),await this.navigationClient.navigateInternal(t,e)}else this.logger.verbose("No main window navigation requested")}catch(t){throw r.popup?.close(),t instanceof Ce&&(t.setCorrelationId(this.correlationId),i.cacheFailedRequest(t)),this.browserStorage.setInteractionInProgress(!1),this.eventHandler.emitEvent(bs.LOGOUT_FAILURE,e.InteractionType.Popup,null,t),this.eventHandler.emitEvent(bs.LOGOUT_END,e.InteractionType.Popup),t}this.eventHandler.emitEvent(bs.LOGOUT_END,e.InteractionType.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),hi(po)}monitorPopupForHash(e,t){return new Promise(((t,r)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const n=setInterval((()=>{if(e.closed)return this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(n),void r(hi(Ao));let o="";try{o=e.location.href}catch(e){}if(!o||"about:blank"===o)return;clearInterval(n);let i="";const a=this.config.auth.OIDCOptions.serverResponseType;e&&(i=a===k.QUERY?e.location.search:e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),t(i)}),this.config.system.pollIntervalMilliseconds)})).finally((()=>{this.cleanPopup(e,t)}))}openPopup(e,t){try{let r;if(t.popup?(r=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),r.location.assign(e)):void 0===t.popup&&(this.logger.verbosePii(`Opening popup window to: ${e}`),r=this.openSizedPopup(e,t)),!r)throw hi(wo);return r.focus&&r.focus(),this.currentWindow=r,t.popupWindowParent.addEventListener("beforeunload",this.unloadWindow),r}catch(e){throw this.logger.error("error opening popup "+e.message),this.browserStorage.setInteractionInProgress(!1),hi(To)}}openSizedPopup(e,{popupName:t,popupWindowAttributes:r,popupWindowParent:n}){const o=n.screenLeft?n.screenLeft:n.screenX,i=n.screenTop?n.screenTop:n.screenY,a=n.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,s=n.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let c=r.popupSize?.width,l=r.popupSize?.height,d=r.popupPosition?.top,h=r.popupPosition?.left;return(!c||c<0||c>a)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),c=gi),(!l||l<0||l>s)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),l=pi),(!d||d<0||d>s)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),d=Math.max(0,s/2-pi/2+i)),(!h||h<0||h>a)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),h=Math.max(0,a/2-gi/2+o)),n.open(e,t,`width=${c}, height=${l}, top=${d}, left=${h}, scrollbars=yes`)}unloadWindow(t){this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Popup),this.currentWindow&&this.currentWindow.close(),t.preventDefault()}cleanPopup(e,t){e.close(),t.removeEventListener("beforeunload",this.unloadWindow),this.browserStorage.setInteractionInProgress(!1)}generatePopupName(e,t){return`${mi}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${mi}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}class rc{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){t.redirectStartPage&&(this.logger.verbose("RedirectHandler.initiateAuthRequest: redirectStartPage set, caching start page"),this.browserStorage.setTemporaryCache(Mi,t.redirectStartPage,!0)),this.browserStorage.setTemporaryCache(Li,this.authCodeRequest.correlationId,!0),this.browserStorage.cacheCodeRequest(this.authCodeRequest),this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const r={apiId:Ki.acquireTokenRedirect,timeout:t.redirectTimeout,noHistory:!1};if("function"==typeof t.onRedirectNavigate){this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback");return!1!==t.onRedirectNavigate(e)?(this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),void await t.navigationClient.navigateExternal(e,r)):void this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation")}return this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),void await t.navigationClient.navigateExternal(e,r)}throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),hi(po)}async handleCodeResponse(e,t){this.logger.verbose("RedirectHandler.handleCodeResponse called"),this.browserStorage.setInteractionInProgress(!1);const r=this.browserStorage.generateStateKey(t),n=this.browserStorage.getTemporaryCache(r);if(!n)throw gt(_e,"Cached State");let o;try{o=this.authModule.handleFragmentResponse(e,n)}catch(e){throw e instanceof Tn&&e.subError===Ao?hi(Ao):e}const i=this.browserStorage.generateNonceKey(n),a=this.browserStorage.getTemporaryCache(i);if(this.authCodeRequest.code=o.code,o.cloud_instance_host_name&&await mn(this.authModule.updateAuthority.bind(this.authModule),ln.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,this.authCodeRequest.correlationId)(o.cloud_instance_host_name,this.authCodeRequest.correlationId),o.nonce=a||void 0,o.state=n,o.client_info)this.authCodeRequest.clientInfo=o.client_info;else{const e=this.checkCcsCredentials();e&&(this.authCodeRequest.ccsCredential=e)}const s=await this.authModule.acquireToken(this.authCodeRequest,o);return this.browserStorage.cleanRequestByState(t),s}checkCcsCredentials(){const e=this.browserStorage.getTemporaryCache(Ui,!0);if(e)try{return JSON.parse(e)}catch(t){this.authModule.logger.error("Cache credential could not be parsed"),this.authModule.logger.errorPii(`Cache credential could not be parsed: ${e}`)}return null}}class nc extends Gs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.nativeStorage=s}async acquireToken(t){const r=await mn(this.initializeAuthorizationRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Redirect);this.browserStorage.updateCacheEntries(r.state,r.nonce,r.authority,r.loginHint||"",r.account||null);const n=this.initializeServerTelemetryManager(Ki.acquireTokenRedirect),o=t=>{t.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.cleanRequestByState(r.state),this.eventHandler.emitEvent(bs.RESTORE_FROM_BFCACHE,e.InteractionType.Redirect))};try{const e=await mn(this.initializeAuthorizationCodeRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(r),i=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:r.authority,requestAzureCloudOptions:r.azureCloudOptions,requestExtraQueryParameters:r.extraQueryParameters,account:r.account}),a=new rc(i,this.browserStorage,e,this.logger,this.performanceClient),s=await i.getAuthCodeUrl({...r,platformBroker:Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),c=this.getRedirectStartPage(t.redirectStartPage);return this.logger.verbosePii(`Redirect start page: ${c}`),window.addEventListener("pageshow",o),await a.initiateAuthRequest(s,{navigationClient:this.navigationClient,redirectTimeout:this.config.system.redirectNavigationTimeout,redirectStartPage:c,onRedirectNavigate:t.onRedirectNavigate||this.config.auth.onRedirectNavigate})}catch(e){throw e instanceof Ce&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),window.removeEventListener("pageshow",o),this.browserStorage.cleanRequestByState(r.state),e}}async handleRedirectPromise(r="",n){const o=this.initializeServerTelemetryManager(Ki.handleRedirectPromise);try{if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const[i,a]=this.getRedirectResponse(r||"");if(!i)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),"back_forward"!==function(){if("undefined"==typeof window||void 0===window.performance||"function"!=typeof window.performance.getEntriesByType)return;const e=window.performance.getEntriesByType("navigation"),t=e.length?e[0]:void 0;return t?.type}()?n.event.errorCode="no_server_response":this.logger.verbose("Back navigation event detected. Muting no_server_response error"),null;const s=this.browserStorage.getTemporaryCache(Mi,!0)||t.EMPTY_STRING,c=Rr.removeHashFromUrl(s);if(c===Rr.removeHashFromUrl(window.location.href)&&this.config.auth.navigateToLoginRequestUrl){this.logger.verbose("Current page is loginRequestUrl, handling response"),s.indexOf("#")>-1&&Ma(s);return await this.handleResponse(i,o)}if(!this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(i,o);if(!Na()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(Ni,a,!0);const e={apiId:Ki.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let t=!0;if(s&&"null"!==s)this.logger.verbose(`Navigating to loginRequestUrl: ${s}`),t=await this.navigationClient.navigateInternal(s,e);else{const r=Ua();this.browserStorage.setTemporaryCache(Mi,r,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),t=await this.navigationClient.navigateInternal(r,e)}if(!t)return await this.handleResponse(i,o)}return null}catch(t){throw t instanceof Ce&&(t.setCorrelationId(this.correlationId),o.cacheFailedRequest(t)),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),t}}getRedirectResponse(t){this.logger.verbose("getRedirectResponseHash called");let r=t;r||(r=this.config.auth.OIDCOptions.serverResponseType===k.QUERY?window.location.search:window.location.hash);let n=Er(r);if(n){try{!function(e,t,r){if(!e.state)throw hi(fo);const n=Ss(t,e.state);if(!n)throw hi(yo);if(n.interactionType!==r)throw hi(vo)}(n,this.browserCrypto,e.InteractionType.Redirect)}catch(e){return e instanceof Ce&&this.logger.error(`Interaction type validation failed due to ${e.errorCode}: ${e.errorMessage}`),[null,""]}return Pa(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,r]}const o=this.browserStorage.getTemporaryCache(Ni,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Ni)),o&&(n=Er(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t){const r=e.state;if(!r)throw hi(fo);const n=this.browserStorage.getCachedRequest(r);if(this.logger.verbose("handleResponse called, retrieved cached request"),e.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw hi(Zo);const t=new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,e.accountId,this.nativeStorage,n.correlationId),{userRequestState:o}=Fn.parseRequestState(this.browserCrypto,r);return t.acquireToken({...n,state:o,prompt:void 0}).finally((()=>{this.browserStorage.cleanRequestByState(r)}))}const o=this.browserStorage.getCachedAuthority(r);if(!o)throw hi(Uo);const i=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:t,requestAuthority:o});wn.removeThrottle(this.browserStorage,this.config.auth.clientId,n);return new rc(i,this.browserStorage,n,this.logger,this.performanceClient).handleCodeResponse(e,r)}async logout(t){this.logger.verbose("logoutRedirect called");const r=this.initializeLogoutRequest(t),n=this.initializeServerTelemetryManager(Ki.logout);try{this.eventHandler.emitEvent(bs.LOGOUT_START,e.InteractionType.Redirect,t),await this.clearCacheOnLogout(r.account);const o={apiId:Ki.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:n,requestAuthority:t&&t.authority,requestExtraQueryParameters:t?.extraQueryParameters,account:t&&t.account||void 0});if(i.authority.protocolMode===kr.OIDC)try{i.authority.endSessionEndpoint}catch{if(r.account?.homeAccountId)return this.browserStorage.removeAccount(r.account?.homeAccountId),void this.eventHandler.emitEvent(bs.LOGOUT_SUCCESS,e.InteractionType.Redirect,r)}const a=i.getLogoutUri(r);if(this.eventHandler.emitEvent(bs.LOGOUT_SUCCESS,e.InteractionType.Redirect,r),!t||"function"!=typeof t.onRedirectNavigate)return this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);if(!1!==t.onRedirectNavigate(a))return this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation")}catch(t){throw t instanceof Ce&&(t.setCorrelationId(this.correlationId),n.cacheFailedRequest(t)),this.eventHandler.emitEvent(bs.LOGOUT_FAILURE,e.InteractionType.Redirect,null,t),this.eventHandler.emitEvent(bs.LOGOUT_END,e.InteractionType.Redirect),t}this.eventHandler.emitEvent(bs.LOGOUT_END,e.InteractionType.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return Rr.getAbsoluteUrl(t,qa())}}async function oc(e,t,r,n,o){if(t.addQueueMeasurement(ln.SilentHandlerInitiateAuthRequest,n),!e)throw r.info("Navigate url is empty"),hi(po);return o?mn(ac,ln.SilentHandlerLoadFrame,r,t,n)(e,o,t,n):pn(sc,ln.SilentHandlerLoadFrameSync,r,t,n)(e)}async function ic(e,t,r,n,o,i,a){return n.addQueueMeasurement(ln.SilentHandlerMonitorIframeForHash,i),new Promise(((n,i)=>{t<Ya&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${t}ms) than the default (10000ms). This may result in timeouts.`);const s=window.setTimeout((()=>{window.clearInterval(c),i(hi(So))}),t),c=window.setInterval((()=>{let t="";const r=e.contentWindow;try{t=r?r.location.href:""}catch(e){}if(!t||"about:blank"===t)return;let o="";r&&(o=a===k.QUERY?r.location.search:r.location.hash),window.clearTimeout(s),window.clearInterval(c),n(o)}),r)})).finally((()=>{pn(lc,ln.RemoveHiddenIframe,o,n,i)(e)}))}function ac(e,t,r,n){return r.addQueueMeasurement(ln.SilentHandlerLoadFrame,n),new Promise(((r,n)=>{const o=cc();window.setTimeout((()=>{o?(o.src=e,r(o)):n("Unable to load iframe")}),t)}))}function sc(e){const t=cc();return t.src=e,t}function cc(){const e=document.createElement("iframe");return e.className="msalSilentIframe",e.style.visibility="hidden",e.style.position="absolute",e.style.width=e.style.height="0",e.style.border="0",e.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(e),e}function lc(e){document.body===e.parentNode&&document.body.removeChild(e)}class dc extends Gs{constructor(e,t,r,n,o,i,a,s,c,l,d){super(e,t,r,n,o,i,s,l,d),this.apiId=a,this.nativeStorage=c}async acquireToken(t){this.performanceClient.addQueueMeasurement(ln.SilentIframeClientAcquireToken,t.correlationId),t.loginHint||t.sid||t.account&&t.account.username||this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const r={...t};r.prompt?r.prompt!==w.NONE&&r.prompt!==w.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${r.prompt} with ${w.NONE}`),r.prompt=w.NONE):r.prompt=w.NONE;const n=await mn(this.initializeAuthorizationRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);za(n.authority);const o=this.initializeServerTelemetryManager(this.apiId);let i;try{return i=await mn(this.createAuthCodeClient.bind(this),ln.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,t.correlationId)({serverTelemetryManager:o,requestAuthority:n.authority,requestAzureCloudOptions:n.azureCloudOptions,requestExtraQueryParameters:n.extraQueryParameters,account:n.account}),await mn(this.silentTokenHelper.bind(this),ln.SilentIframeClientTokenHelper,this.logger,this.performanceClient,t.correlationId)(i,n)}catch(n){if(n instanceof Ce&&(n.setCorrelationId(this.correlationId),o.cacheFailedRequest(n)),!(i&&n instanceof Ce&&n.errorCode===ui))throw n;this.performanceClient.addFields({retryError:n.errorCode},this.correlationId);const a=await mn(this.initializeAuthorizationRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);return await mn(this.silentTokenHelper.bind(this),ln.SilentIframeClientTokenHelper,this.logger,this.performanceClient,this.correlationId)(i,a)}}logout(){return Promise.reject(hi(Po))}async silentTokenHelper(e,t){const r=t.correlationId;this.performanceClient.addQueueMeasurement(ln.SilentIframeClientTokenHelper,r);const n=await mn(this.initializeAuthorizationCodeRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,r)(t),o=await mn(e.getAuthCodeUrl.bind(e),ln.GetAuthCodeUrl,this.logger,this.performanceClient,r)({...t,platformBroker:Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),i=new Zs(e,this.browserStorage,n,this.logger,this.performanceClient),a=await mn(oc,ln.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(o,this.performanceClient,this.logger,r,this.config.system.navigateFrameWait),s=this.config.auth.OIDCOptions.serverResponseType,c=await mn(ic,ln.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(a,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,r,s),l=pn(ec,ln.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(c,s,this.logger);if(l.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw hi(Zo);const e=new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.apiId,this.performanceClient,this.nativeMessageHandler,l.accountId,this.browserStorage,r),{userRequestState:n}=Fn.parseRequestState(this.browserCrypto,t.state);return mn(e.acquireToken.bind(e),ln.NativeInteractionClientAcquireToken,this.logger,this.performanceClient,r)({...t,state:n,prompt:t.prompt||w.NONE})}return mn(i.handleCodeResponse.bind(i),ln.HandleCodeResponse,this.logger,this.performanceClient,r)(l,t)}}class hc extends Gs{async acquireToken(e){this.performanceClient.addQueueMeasurement(ln.SilentRefreshClientAcquireToken,e.correlationId);const t=await mn(Ks,ln.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e,this.config,this.performanceClient,this.logger),r={...e,...t};e.redirectUri&&(r.redirectUri=this.getRedirectUri(e.redirectUri));const n=this.initializeServerTelemetryManager(Ki.acquireTokenSilent_silentFlow),o=await this.createRefreshTokenClient({serverTelemetryManager:n,authorityUrl:r.authority,azureCloudOptions:r.azureCloudOptions,account:r.account});return mn(o.acquireTokenByRefreshToken.bind(o),ln.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(r).catch((e=>{throw e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e),e}))}logout(){return Promise.reject(hi(Po))}async createRefreshTokenClient(e){const t=await mn(this.getClientConfiguration.bind(this),ln.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)({serverTelemetryManager:e.serverTelemetryManager,requestAuthority:e.authorityUrl,requestAzureCloudOptions:e.azureCloudOptions,requestExtraQueryParameters:e.extraQueryParameters,account:e.account});return new Vn(t,this.performanceClient)}}class uc{constructor(e,t,r,n){this.isBrowserEnvironment="undefined"!=typeof window,this.config=e,this.storage=t,this.logger=r,this.cryptoObj=n}async loadExternalTokens(e,t,r){if(!this.isBrowserEnvironment)throw hi(xo);const n=e.correlationId||pa(),o=t.id_token?It(t.id_token,ea):void 0,i={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},a=e.authority?new Cn(Cn.generateAuthority(e.authority,e.azureCloudOptions),this.config.system.networkClient,this.storage,i,this.logger,e.correlationId||pa()):void 0,s=await this.loadAccount(e,r.clientInfo||t.client_info||"",n,o,a),c=await this.loadIdToken(t,s.homeAccountId,s.environment,s.realm,n),l=await this.loadAccessToken(e,t,s.homeAccountId,s.environment,s.realm,r,n),d=await this.loadRefreshToken(t,s.homeAccountId,s.environment,n);return this.generateAuthenticationResult(e,{account:s,idToken:c,accessToken:l,refreshToken:d},o,a)}async loadAccount(e,t,r,n,o){if(this.logger.verbose("TokenCache - loading account"),e.account){const t=Sr.createFromAccountInfo(e.account);return await this.storage.setAccount(t,r),t}if(!o||!t&&!n)throw this.logger.error("TokenCache - if an account is not provided on the request, authority and either clientInfo or idToken must be provided instead."),hi(Go);const i=Sr.generateHomeAccountId(t,o.authorityType,this.logger,this.cryptoObj,n),a=n?.tid,s=Qn(this.storage,o,i,ea,n,t,o.hostnameAndPort,a,void 0,void 0,this.logger);return await this.storage.setAccount(s,r),s}async loadIdToken(e,t,r,n,o){if(!e.id_token)return this.logger.verbose("TokenCache - no id token found in response"),null;this.logger.verbose("TokenCache - loading id token");const i=bt(t,r,e.id_token,this.config.auth.clientId,n);return await this.storage.setIdTokenCredential(i,o),i}async loadAccessToken(e,t,r,n,o,i,a){if(!t.access_token)return this.logger.verbose("TokenCache - no access token found in response"),null;if(!t.expires_in)return this.logger.error("TokenCache - no expiration set on the access token. Cannot add it to the cache."),null;if(!(t.scope||e.scopes&&e.scopes.length))return this.logger.error("TokenCache - scopes not specified in the request or response. Cannot add token to the cache."),null;this.logger.verbose("TokenCache - loading access token");const s=t.scope?gr.fromString(t.scope):new gr(e.scopes),c=i.expiresOn||t.expires_in+(new Date).getTime()/1e3,l=i.extendedExpiresOn||(t.ext_expires_in||t.expires_in)+(new Date).getTime()/1e3,d=Et(r,n,t.access_token,this.config.auth.clientId,o,s.printScopes(),c,l,ea);return await this.storage.setAccessTokenCredential(d,a),d}async loadRefreshToken(e,t,r,n){if(!e.refresh_token)return this.logger.verbose("TokenCache - no refresh token found in response"),null;this.logger.verbose("TokenCache - loading refresh token");const o=Rt(t,r,e.refresh_token,this.config.auth.clientId,e.foci,void 0,e.refresh_token_expires_in);return await this.storage.setRefreshTokenCredential(o,n),o}generateAuthenticationResult(e,t,r,n){let o,i="",a=[],s=null;t?.accessToken&&(i=t.accessToken.secret,a=gr.fromString(t.accessToken.target).asArray(),s=new Date(1e3*Number(t.accessToken.expiresOn)),o=new Date(1e3*Number(t.accessToken.extendedExpiresOn)));const c=t.account;return{authority:n?n.canonicalAuthority:"",uniqueId:t.account.localAccountId,tenantId:t.account.realm,scopes:a,account:c.getAccountInfo(),idToken:t.idToken?.secret||"",idTokenClaims:r||{},accessToken:i,fromCache:!0,expiresOn:s,correlationId:e.correlationId||"",requestId:"",extExpiresOn:o,familyId:t.refreshToken?.familyId||"",tokenType:t?.accessToken?.tokenType||"",state:e.state||"",cloudGraphHostName:c.cloudGraphHostName||"",msGraphHost:c.msGraphHost||"",fromNativeBroker:!1}}}class gc extends jn{constructor(e){super(e),this.includeRedirectUri=!1}}class pc extends Gs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,s,c,l),this.apiId=a}async acquireToken(t){if(!t.code)throw hi(Qo);const r=await mn(this.initializeAuthorizationRequest.bind(this),ln.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(t,e.InteractionType.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const e={...r,code:t.code},o=await mn(this.getClientConfiguration.bind(this),ln.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,t.correlationId)({serverTelemetryManager:n,requestAuthority:r.authority,requestAzureCloudOptions:r.azureCloudOptions,requestExtraQueryParameters:r.extraQueryParameters,account:r.account}),i=new gc(o);this.logger.verbose("Auth code client created");const a=new Zs(i,this.browserStorage,e,this.logger,this.performanceClient);return await mn(a.handleCodeResponseFromServer.bind(a),ln.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)({code:t.code,msgraph_host:t.msGraphHost,cloud_graph_host_name:t.cloudGraphHostName,cloud_instance_host_name:t.cloudInstanceHostName},r,!1)}catch(e){throw e instanceof Ce&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}logout(){return Promise.reject(hi(Po))}}function mc(e){const t=e?.idTokenClaims;return t?.tfp||t?.acr?"B2C":t?.tid?"9188040d-6c67-4c5b-b112-36a304b66dad"===t?.tid?"MSA":"AAD":void 0}function fc(e,t){try{Fa(e)}catch(e){throw t.end({success:!1},e),e}}class Cc{constructor(e){this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new ps(this.logger,this.performanceClient):pt,this.eventHandler=new Hs(this.logger),this.browserStorage=this.isBrowserEnvironment?new Es(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,vn(this.config.auth)):_s(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler);const t={cacheLocation:Si.MemoryStorage,temporaryCacheLocation:Si.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new Es(this.config.auth.clientId,t,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler),this.tokenCache=new uc(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this)}static async createController(e,t){const r=new Cc(e);return await r.initialize(t),r}trackPageVisibility(e){e&&(this.logger.info("Perf: Visibility change detected"),this.performanceClient.incrementFields({visibilityChangeCount:1},e))}async initialize(e){if(this.logger.trace("initialize called"),this.initialized)return void this.logger.info("initialize has already been called, exiting early.");if(!this.isBrowserEnvironment)return this.logger.info("in non-browser environment, exiting early."),this.initialized=!0,void this.eventHandler.emitEvent(bs.INITIALIZE_END);const t=e?.correlationId||this.getRequestCorrelationId(),r=this.config.system.allowPlatformBroker,n=this.performanceClient.startMeasurement(ln.InitializeClientApplication,t);if(this.eventHandler.emitEvent(bs.INITIALIZE_START),await mn(this.browserStorage.initialize.bind(this.browserStorage),ln.InitializeCache,this.logger,this.performanceClient,t)(t),r)try{this.nativeExtensionProvider=await Xs.createProvider(this.logger,this.config.system.nativeBrokerHandshakeTimeout,this.performanceClient)}catch(e){this.logger.verbose(e)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),await mn(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),ln.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient,t)(this.performanceClient,t)),this.initialized=!0,this.eventHandler.emitEvent(bs.INITIALIZE_END),n.end({allowPlatformBroker:r,success:!0})}async handleRedirectPromise(e){if(this.logger.verbose("handleRedirectPromise called"),Da(this.initialized),this.isBrowserEnvironment){const t=e||"";let r=this.redirectResponse.get(t);return void 0===r?(r=this.handleRedirectPromiseInternal(e),this.redirectResponse.set(t,r),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise")):this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call"),r}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async handleRedirectPromiseInternal(t){const r=this.getAllAccounts(),n=this.browserStorage.getCachedNativeRequest(),o=n&&Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeExtensionProvider)&&this.nativeExtensionProvider&&!t,i=o?n?.correlationId:this.browserStorage.getTemporaryCache(Li,!0)||"",a=this.performanceClient.startMeasurement(ln.AcquireTokenRedirect,i);let s;if(this.eventHandler.emitEvent(bs.HANDLE_REDIRECT_START,e.InteractionType.Redirect),o&&this.nativeExtensionProvider){this.logger.trace("handleRedirectPromise - acquiring token from native platform");const e=new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.handleRedirectPromise,this.performanceClient,this.nativeExtensionProvider,n.accountId,this.nativeInternalStorage,n.correlationId);s=mn(e.handleRedirectPromise.bind(e),ln.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(this.performanceClient,a.event.correlationId)}else{this.logger.trace("handleRedirectPromise - acquiring token from web flow");const e=this.createRedirectClient(i);s=mn(e.handleRedirectPromise.bind(e),ln.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(t,a)}return s.then((t=>{if(t){r.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(bs.LOGIN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),a.end({success:!0,accountType:mc(t.account)})}else a.event.errorCode?a.end({success:!1}):a.discard();return this.eventHandler.emitEvent(bs.HANDLE_REDIRECT_END,e.InteractionType.Redirect),t})).catch((t=>{const n=t;throw r.length>0?this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,n):this.eventHandler.emitEvent(bs.LOGIN_FAILURE,e.InteractionType.Redirect,null,n),this.eventHandler.emitEvent(bs.HANDLE_REDIRECT_END,e.InteractionType.Redirect),a.end({success:!1},n),t}))}async acquireTokenRedirect(t){const r=this.getRequestCorrelationId(t);this.logger.verbose("acquireTokenRedirect called",r);const n=this.performanceClient.startMeasurement(ln.AcquireTokenPreRedirect,r);n.add({accountType:mc(t.account),scenarioId:t.scenarioId});const o=t.onRedirectNavigate;if(o)t.onRedirectNavigate=e=>{const t="function"==typeof o?o(e):void 0;return!1!==t?n.end({success:!0}):n.discard(),t};else{const e=this.config.auth.onRedirectNavigate;this.config.auth.onRedirectNavigate=t=>{const r="function"==typeof e?e(t):void 0;return!1!==r?n.end({success:!0}):n.discard(),r}}const i=this.getAllAccounts().length>0;try{let o;if(Ka(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0),i?this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_START,e.InteractionType.Redirect,t):this.eventHandler.emitEvent(bs.LOGIN_START,e.InteractionType.Redirect,t),this.nativeExtensionProvider&&this.canUsePlatformBroker(t)){o=new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.acquireTokenRedirect,this.performanceClient,this.nativeExtensionProvider,this.getNativeAccountId(t),this.nativeInternalStorage,r).acquireTokenRedirect(t,n).catch((e=>{if(e instanceof Ws&&js(e)){this.nativeExtensionProvider=void 0;return this.createRedirectClient(r).acquireToken(t)}if(e instanceof xn){this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createRedirectClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}))}else{o=this.createRedirectClient(r).acquireToken(t)}return await o}catch(t){throw n.end({success:!1},t),i?this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,t):this.eventHandler.emitEvent(bs.LOGIN_FAILURE,e.InteractionType.Redirect,null,t),t}}acquireTokenPopup(t){const r=this.getRequestCorrelationId(t),n=this.performanceClient.startMeasurement(ln.AcquireTokenPopup,r);n.add({scenarioId:t.scenarioId,accountType:mc(t.account)});try{this.logger.verbose("acquireTokenPopup called",r),fc(this.initialized,n),this.browserStorage.setInteractionInProgress(!0)}catch(e){return Promise.reject(e)}const o=this.getAllAccounts();let i;if(o.length>0?this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t):this.eventHandler.emitEvent(bs.LOGIN_START,e.InteractionType.Popup,t),this.canUsePlatformBroker(t))i=this.acquireTokenNative({...t,correlationId:r},Ki.acquireTokenPopup).then((e=>(this.browserStorage.setInteractionInProgress(!1),n.end({success:!0,isNativeBroker:!0,accountType:mc(e.account)}),e))).catch((e=>{if(e instanceof Ws&&js(e)){this.nativeExtensionProvider=void 0;return this.createPopupClient(r).acquireToken(t)}if(e instanceof xn){this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createPopupClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}));else{i=this.createPopupClient(r).acquireToken(t)}return i.then((t=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(bs.LOGIN_SUCCESS,e.InteractionType.Popup,t):this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,t),n.end({success:!0,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:mc(t.account)}),t))).catch((t=>(o.length>0?this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t):this.eventHandler.emitEvent(bs.LOGIN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),Promise.reject(t))))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(t){const r=this.getRequestCorrelationId(t),n={...t,prompt:t.prompt,correlationId:r};let o;if(this.ssoSilentMeasurement=this.performanceClient.startMeasurement(ln.SsoSilent,r),this.ssoSilentMeasurement?.add({scenarioId:t.scenarioId,accountType:mc(t.account)}),fc(this.initialized,this.ssoSilentMeasurement),this.ssoSilentMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",r),this.eventHandler.emitEvent(bs.SSO_SILENT_START,e.InteractionType.Silent,n),this.canUsePlatformBroker(n))o=this.acquireTokenNative(n,Ki.ssoSilent).catch((e=>{if(e instanceof Ws&&js(e)){this.nativeExtensionProvider=void 0;return this.createSilentIframeClient(n.correlationId).acquireToken(n)}throw e}));else{o=this.createSilentIframeClient(n.correlationId).acquireToken(n)}return o.then((t=>(this.eventHandler.emitEvent(bs.SSO_SILENT_SUCCESS,e.InteractionType.Silent,t),this.ssoSilentMeasurement?.end({success:!0,isNativeBroker:t.fromNativeBroker,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:mc(t.account)}),t))).catch((t=>{throw this.eventHandler.emitEvent(bs.SSO_SILENT_FAILURE,e.InteractionType.Silent,null,t),this.ssoSilentMeasurement?.end({success:!1},t),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenByCode(t){const r=this.getRequestCorrelationId(t);this.logger.trace("acquireTokenByCode called",r);const n=this.performanceClient.startMeasurement(ln.AcquireTokenByCode,r);fc(this.initialized,n),this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_BY_CODE_START,e.InteractionType.Silent,t),n.add({scenarioId:t.scenarioId});try{if(t.code&&t.nativeAccountId)throw hi(jo);if(t.code){const o=t.code;let i=this.hybridAuthCodeResponses.get(o);return i?(this.logger.verbose("Existing acquireTokenByCode request found",r),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",r),i=this.acquireTokenByCodeAsync({...t,correlationId:r}).then((t=>(this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_BY_CODE_SUCCESS,e.InteractionType.Silent,t),this.hybridAuthCodeResponses.delete(o),n.end({success:!0,isNativeBroker:t.fromNativeBroker,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:mc(t.account)}),t))).catch((t=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t})),this.hybridAuthCodeResponses.set(o,i)),await i}if(t.nativeAccountId){if(this.canUsePlatformBroker(t,t.nativeAccountId)){const e=await this.acquireTokenNative({...t,correlationId:r},Ki.acquireTokenByCode,t.nativeAccountId).catch((e=>{throw e instanceof Ws&&js(e)&&(this.nativeExtensionProvider=void 0),e}));return n.end({accountType:mc(e.account),success:!0}),e}throw hi(Yo)}throw hi(Wo)}catch(t){throw this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t}}async acquireTokenByCodeAsync(e){this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(ln.AcquireTokenByCodeAsync,e.correlationId),this.acquireTokenByCodeAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement);const t=this.createSilentAuthCodeClient(e.correlationId);return await t.acquireToken(e).then((e=>(this.acquireTokenByCodeAsyncMeasurement?.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker}),e))).catch((e=>{throw this.acquireTokenByCodeAsyncMeasurement?.end({success:!1},e),e})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenFromCache(e,t){switch(this.performanceClient.addQueueMeasurement(ln.AcquireTokenFromCache,e.correlationId),t){case ji.Default:case ji.AccessToken:case ji.AccessTokenAndRefreshToken:const t=this.createSilentCacheClient(e.correlationId);return mn(t.acquireToken.bind(t),ln.SilentCacheClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw gt(Je)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(ln.AcquireTokenByRefreshToken,e.correlationId),t){case ji.Default:case ji.AccessTokenAndRefreshToken:case ji.RefreshToken:case ji.RefreshTokenAndNetwork:const t=this.createSilentRefreshClient(e.correlationId);return mn(t.acquireToken.bind(t),ln.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw gt(Je)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(ln.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return mn(t.acquireToken.bind(t),ln.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(e){const t=this.getRequestCorrelationId(e);Ka(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0);return this.createRedirectClient(t).logout(e)}logoutPopup(e){try{const t=this.getRequestCorrelationId(e);Fa(this.initialized),this.browserStorage.setInteractionInProgress(!0);return this.createPopupClient(t).logout(e)}catch(e){return Promise.reject(e)}}async clearCache(e){if(!this.isBrowserEnvironment)return void this.logger.info("in non-browser environment, returning early.");const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){return Ps(this.logger,this.browserStorage,this.isBrowserEnvironment,e)}getAccount(e){return Ms(e,this.logger,this.browserStorage)}getAccountByUsername(e){return Ns(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return Os(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return qs(e,this.logger,this.browserStorage)}setActiveAccount(e){Us(e,this.browserStorage)}getActiveAccount(){return Ls(this.browserStorage)}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=Sr.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return await this.browserStorage.setAccount(r,e.correlationId),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}async acquireTokenNative(e,t,r){if(this.logger.trace("acquireTokenNative called"),!this.nativeExtensionProvider)throw hi(Zo);return new Js(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.nativeExtensionProvider,r||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e)}canUsePlatformBroker(e,t){if(this.logger.trace("canUsePlatformBroker called"),!Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme))return this.logger.trace("canUsePlatformBroker: isPlatformBrokerAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case w.NONE:case w.CONSENT:case w.LOGIN:this.logger.trace("canUsePlatformBroker: prompt is compatible with platform broker flow");break;default:return this.logger.trace(`canUsePlatformBroker: prompt = ${e.prompt} is not compatible with platform broker flow, returning false`),!1}return!(!t&&!this.getNativeAccountId(e))||(this.logger.trace("canUsePlatformBroker: nativeAccountId is not available, returning false"),!1)}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new tc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createRedirectClient(e){return new nc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentIframeClient(e){return new dc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentCacheClient(e){return new Ys(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentRefreshClient(e){return new hc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentAuthCodeClient(e){return new pc(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ki.acquireTokenByCode,this.performanceClient,this.nativeExtensionProvider,e)}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return Ba(),this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){this.config.cache.cacheLocation===Si.LocalStorage?this.eventHandler.subscribeCrossTab():this.logger.info("Account storage events are only available when cacheLocation is set to localStorage")}disableAccountStorageEvents(){this.config.cache.cacheLocation===Si.LocalStorage?this.eventHandler.unsubscribeCrossTab():this.logger.info("Account storage events are only available when cacheLocation is set to localStorage")}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}isBrowserEnv(){return this.isBrowserEnvironment}getRequestCorrelationId(e){return e?.correlationId?e.correlationId:this.isBrowserEnvironment?pa():t.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||$i})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||$i})}async acquireTokenSilent(e){const r=this.getRequestCorrelationId(e),n=this.performanceClient.startMeasurement(ln.AcquireTokenSilent,r);n.add({cacheLookupPolicy:e.cacheLookupPolicy,scenarioId:e.scenarioId}),fc(this.initialized,n),this.logger.verbose("acquireTokenSilent called",r);const o=e.account||this.getActiveAccount();if(!o)throw hi(Mo);n.add({accountType:mc(o)});const i={clientId:this.config.auth.clientId,authority:e.authority||t.EMPTY_STRING,scopes:e.scopes,homeAccountIdentifier:o.homeAccountId,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid,shrOptions:e.shrOptions},a=JSON.stringify(i),s=this.activeSilentTokenRequests.get(a);if(void 0===s){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",r);const t=mn(this.acquireTokenSilentAsync.bind(this),ln.AcquireTokenSilentAsync,this.logger,this.performanceClient,r)({...e,correlationId:r},o).then((t=>(this.activeSilentTokenRequests.delete(a),n.end({success:!0,fromCache:t.fromCache,isNativeBroker:t.fromNativeBroker,cacheLookupPolicy:e.cacheLookupPolicy,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),t))).catch((e=>{throw this.activeSilentTokenRequests.delete(a),n.end({success:!1},e),e}));return this.activeSilentTokenRequests.set(a,t),{...await t,state:e.state}}return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",r),n.discard(),{...await s,state:e.state}}async acquireTokenSilentAsync(t,r){const n=()=>this.trackPageVisibility(t.correlationId);this.performanceClient.addQueueMeasurement(ln.AcquireTokenSilentAsync,t.correlationId),this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t),t.correlationId&&this.performanceClient.incrementFields({visibilityChangeCount:0},t.correlationId),document.addEventListener("visibilitychange",n);const o=await mn(zs,ln.InitializeSilentRequest,this.logger,this.performanceClient,t.correlationId)(t,r,this.config,this.performanceClient,this.logger),i=t.cacheLookupPolicy||ji.Default;return this.acquireTokenSilentNoIframe(o,i).catch((async e=>{const t=function(e,t){const r=!(e instanceof xn&&e.subError!==Nn),n=e.errorCode===ui||e.errorCode===Je,o=r&&n||e.errorCode===bn||e.errorCode===Rn,i=Vi.includes(t);return o&&i}(e,i);if(t){if(this.activeIframeRequest){if(i!==ji.Skip){const[t,r]=this.activeIframeRequest;this.logger.verbose(`Iframe request is already in progress, awaiting resolution for request with correlationId: ${r}`,o.correlationId);const n=this.performanceClient.startMeasurement(ln.AwaitConcurrentIframe,o.correlationId);n.add({awaitIframeCorrelationId:r});const a=await t;if(n.end({success:a}),a)return this.logger.verbose(`Parallel iframe request with correlationId: ${r} succeeded. Retrying cache and/or RT redemption`,o.correlationId),this.acquireTokenSilentNoIframe(o,i);throw this.logger.info(`Iframe request with correlationId: ${r} failed. Interaction is required.`),e}return this.logger.warning("Another iframe request is currently in progress and CacheLookupPolicy is set to Skip. This may result in degraded performance and/or reliability for both calls. Please consider changing the CacheLookupPolicy to take advantage of request queuing and token cache.",o.correlationId),mn(this.acquireTokenBySilentIframe.bind(this),ln.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o)}{let e;return this.activeIframeRequest=[new Promise((t=>{e=t})),o.correlationId],this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",o.correlationId),mn(this.acquireTokenBySilentIframe.bind(this),ln.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o).then((t=>(e(!0),t))).catch((t=>{throw e(!1),t})).finally((()=>{this.activeIframeRequest=void 0}))}}throw e})).then((r=>(this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,r),t.correlationId&&this.performanceClient.addFields({fromCache:r.fromCache,isNativeBroker:r.fromNativeBroker},t.correlationId),r))).catch((t=>{throw this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),t})).finally((()=>{document.removeEventListener("visibilitychange",n)}))}async acquireTokenSilentNoIframe(t,r){return Xs.isPlatformBrokerAvailable(this.config,this.logger,this.nativeExtensionProvider,t.authenticationScheme)&&t.account.nativeAccountId?(this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform"),this.acquireTokenNative(t,Ki.acquireTokenSilent_silentFlow).catch((async e=>{if(e instanceof Ws&&js(e))throw this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.nativeExtensionProvider=void 0,gt(Je);throw e}))):(this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow"),mn(this.acquireTokenFromCache.bind(this),ln.AcquireTokenFromCache,this.logger,this.performanceClient,t.correlationId)(t,r).catch((n=>{if(r===ji.AccessToken)throw n;return this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_NETWORK_START,e.InteractionType.Silent,t),mn(this.acquireTokenByRefreshToken.bind(this),ln.AcquireTokenByRefreshToken,this.logger,this.performanceClient,t.correlationId)(t,r)})))}}class yc{constructor(e,t,r,n){this.clientId=e,this.clientCapabilities=t,this.crypto=r,this.logger=n}toNaaTokenRequest(e){let t;t=void 0===e.extraQueryParameters?new Map:new Map(Object.entries(e.extraQueryParameters));const r=e.correlationId||this.crypto.createNewGuid(),n=new cn(r).addClientCapabilitiesToClaims(e.claims,this.clientCapabilities),o=e.scopes||a;return{platformBrokerId:e.account?.homeAccountId,clientId:this.clientId,authority:e.authority,scope:o.join(" "),correlationId:r,claims:ur.isEmptyObj(n)?void 0:n,state:e.state,authenticationScheme:e.authenticationScheme||z.BEARER,extraParameters:t}}fromNaaTokenResponse(e,t,r){if(!t.token.id_token||!t.token.access_token)throw gt(we);const n=new Date(1e3*(r+(t.token.expires_in||0))),o=It(t.token.id_token,this.crypto.base64Decode),i=this.fromNaaAccountInfo(t.account,t.token.id_token,o),a=t.token.scope||e.scope;return{authority:t.token.authority||i.environment,uniqueId:i.localAccountId,tenantId:i.tenantId,scopes:a.split(" "),account:i,idToken:t.token.id_token,idTokenClaims:o,accessToken:t.token.access_token,fromCache:!1,expiresOn:n,tokenType:e.authenticationScheme||z.BEARER,correlationId:e.correlationId,extExpiresOn:n,state:e.state}}fromNaaAccountInfo(e,t,r){const n=r||e.idTokenClaims,o=e.localAccountId||n?.oid||n?.sub||"",i=e.tenantId||n?.tid||"",a=e.homeAccountId||`${o}.${i}`,s=e.username||n?.preferred_username||"",c=e.name||n?.name,l=new Map,d=Cr(a,o,i,n);l.set(i,d);return{homeAccountId:a,environment:e.environment,tenantId:i,username:s,localAccountId:o,name:c,idToken:t,idTokenClaims:n,tenantProfiles:l}}fromBridgeError(e){if(!function(e){return void 0!==e.status}(e))return new Ce("unknown_error","An unknown error occurred");switch(e.status){case ts:return new ut(it);case rs:return new ut(ot);case as:return new ut(Qe);case is:return new ut(ct);case ss:return new ut(e.code||ct,e.description);case ns:case os:return new Tn(e.code,e.description);case es:return new xn(e.code,e.description);default:return new Ce(e.code,e.description)}}toAuthenticationResultFromCache(e,t,r,n,o){if(!t||!r)throw gt(we);const i=It(t.secret,this.crypto.base64Decode),a=r.target||n.scopes.join(" ");return{authority:r.environment||e.environment,uniqueId:e.localAccountId,tenantId:e.tenantId,scopes:a.split(" "),account:e,idToken:t.secret,idTokenClaims:i||{},accessToken:r.secret,fromCache:!0,expiresOn:new Date(1e3*Number(r.expiresOn)),tokenType:n.authenticationScheme||z.BEARER,correlationId:o,extExpiresOn:new Date(1e3*Number(r.extendedExpiresOn)),state:n.state}}}const vc={code:"unsupported_method",desc:"This method is not supported in nested app environment."};class Ic extends Ce{constructor(e,t){super(e,t),Object.setPrototypeOf(this,Ic.prototype),this.name="NestedAppAuthError"}static createUnsupportedError(){return new Ic(vc.code,vc.desc)}}class Tc{constructor(e){this.operatingContext=e;const t=this.operatingContext.getBridgeProxy();if(void 0===t)throw new Error("unexpected: bridgeProxy is undefined");this.bridgeProxy=t,this.config=e.getConfig(),this.logger=this.operatingContext.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=e.isBrowserEnvironment()?new ps(this.logger,this.performanceClient,!0):pt,this.eventHandler=new Hs(this.logger),this.browserStorage=this.operatingContext.isBrowserEnvironment()?new Es(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,vn(this.config.auth)):_s(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler),this.nestedAppAuthAdapter=new yc(this.config.auth.clientId,this.config.auth.clientCapabilities,this.browserCrypto,this.logger);const r=this.bridgeProxy.getAccountContext();this.currentAccountContext=r||null}static async createController(e){const t=new Tc(e);return Promise.resolve(t)}async initialize(e){const t=e?.correlationId||pa();return await this.browserStorage.initialize(t),Promise.resolve()}ensureValidRequest(e){return e?.correlationId?e:{...e,correlationId:this.browserCrypto.createNewGuid()}}async acquireTokenInteractive(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_START,e.InteractionType.Popup,r);const n=this.performanceClient.startMeasurement(ln.AcquireTokenPopup,r.correlationId);n?.add({nestedAppAuthRequest:!0});try{const o=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=wt(),a=await this.bridgeProxy.getTokenInteractive(o),s={...this.nestedAppAuthAdapter.fromNaaTokenResponse(o,a,i)};return await this.hydrateCache(s,t),this.currentAccountContext={homeAccountId:s.account.homeAccountId,environment:s.account.environment,tenantId:s.account.tenantId},this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,s),n.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),n.end({success:!0,requestId:s.requestId}),s}catch(t){const r=t instanceof Ce?t:this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),r}}async acquireTokenSilentInternal(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_START,e.InteractionType.Silent,r);const n=await this.acquireTokenFromCache(r);if(n)return this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),n;const o=this.performanceClient.startMeasurement(ln.SsoSilent,r.correlationId);o?.increment({visibilityChangeCount:0}),o?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=wt(),a=await this.bridgeProxy.getTokenSilent(n),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,a,i);return await this.hydrateCache(s,t),this.currentAccountContext={homeAccountId:s.account.homeAccountId,environment:s.account.environment,tenantId:s.account.tenantId},this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,s),o?.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),o?.end({success:!0,requestId:s.requestId}),s}catch(t){const r=t instanceof Ce?t:this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),o?.end({success:!1},t),r}}async acquireTokenFromCache(t){const r=this.performanceClient.startMeasurement(ln.AcquireTokenSilent,t.correlationId);if(r?.add({nestedAppAuthRequest:!0}),t.claims)return this.logger.verbose("Claims are present in the request, skipping cache lookup"),null;if(t.forceRefresh)return this.logger.verbose("forceRefresh is set to true, skipping cache lookup"),null;let n=null;switch(t.cacheLookupPolicy||(t.cacheLookupPolicy=ji.Default),t.cacheLookupPolicy){case ji.Default:case ji.AccessToken:case ji.AccessTokenAndRefreshToken:n=await this.acquireTokenFromCacheInternal(t);break;default:return null}return n?(this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),r?.add({accessTokenSize:n?.accessToken.length,idTokenSize:n?.idToken.length}),r?.end({success:!0}),n):(this.logger.error("Cached tokens are not found for the account, proceeding with silent token request."),this.eventHandler.emitEvent(bs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null),r?.end({success:!1}),null)}async acquireTokenFromCacheInternal(e){const t=this.bridgeProxy.getAccountContext()||this.currentAccountContext;let r=null;if(t&&(r=Ms(t,this.logger,this.browserStorage)),!r)return this.logger.verbose("No active account found, falling back to the host"),Promise.resolve(null);this.logger.verbose("active account found, attempting to acquire token silently");const n={...e,correlationId:e.correlationId||this.browserCrypto.createNewGuid(),authority:e.authority||r.environment,scopes:e.scopes?.length?e.scopes:[...a]},o=this.browserStorage.getTokenKeys(),i=this.browserStorage.getAccessToken(r,n,o,r.tenantId,this.performanceClient,n.correlationId);if(!i)return this.logger.verbose("No cached access token found"),Promise.resolve(null);if(kt(i.cachedAt)||At(i.expiresOn,this.config.system.tokenRenewalOffsetSeconds))return this.logger.verbose("Cached access token has expired"),Promise.resolve(null);const s=this.browserStorage.getIdToken(r,o,r.tenantId,this.performanceClient,n.correlationId);return s?this.nestedAppAuthAdapter.toAuthenticationResultFromCache(r,s,i,n,n.correlationId):(this.logger.verbose("No cached id token found"),Promise.resolve(null))}async acquireTokenPopup(e){return this.acquireTokenInteractive(e)}acquireTokenRedirect(e){throw Ic.createUnsupportedError()}async acquireTokenSilent(e){return this.acquireTokenSilentInternal(e)}acquireTokenByCode(e){throw Ic.createUnsupportedError()}acquireTokenNative(e,t,r){throw Ic.createUnsupportedError()}acquireTokenByRefreshToken(e,t){throw Ic.createUnsupportedError()}addEventCallback(e,t){return this.eventHandler.addEventCallback(e,t)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){throw Ic.createUnsupportedError()}removePerformanceCallback(e){throw Ic.createUnsupportedError()}enableAccountStorageEvents(){throw Ic.createUnsupportedError()}disableAccountStorageEvents(){throw Ic.createUnsupportedError()}getAllAccounts(e){return Ps(this.logger,this.browserStorage,this.isBrowserEnv(),e)}getAccount(e){return Ms(e,this.logger,this.browserStorage)}getAccountByUsername(e){return Ns(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return Os(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return qs(e,this.logger,this.browserStorage)}setActiveAccount(e){return Us(e,this.browserStorage)}getActiveAccount(){return Ls(this.browserStorage)}handleRedirectPromise(e){return Promise.resolve(null)}loginPopup(e){return this.acquireTokenInteractive(e||$i)}loginRedirect(e){throw Ic.createUnsupportedError()}logout(e){throw Ic.createUnsupportedError()}logoutRedirect(e){throw Ic.createUnsupportedError()}logoutPopup(e){throw Ic.createUnsupportedError()}ssoSilent(e){return this.acquireTokenSilentInternal(e)}getTokenCache(){throw Ic.createUnsupportedError()}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){}setNavigationClient(e){this.logger.warning("setNavigationClient is not supported in nested app auth")}getConfiguration(){return this.config}isBrowserEnv(){return this.operatingContext.isBrowserEnvironment()}getBrowserCrypto(){return this.browserCrypto}getPerformanceClient(){throw Ic.createUnsupportedError()}getRedirectResponse(){throw Ic.createUnsupportedError()}async clearCache(e){throw Ic.createUnsupportedError()}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=Sr.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return await this.browserStorage.setAccount(r,e.correlationId),this.browserStorage.hydrateCache(e,t)}}async function wc(e){const t=new ds(e),r=new ls(e),n=[t.initialize(),r.initialize()];return await Promise.all(n),r.isAvailable()&&e.auth.supportsNestedAppAuth?Tc.createController(r):t.isAvailable()?Cc.createController(t):null}class Ac{static async createPublicClientApplication(e){const t=await async function(e,t){const r=new ds(e);return await r.initialize(),Cc.createController(r,t)}(e);return new Ac(e,t)}constructor(e,t){this.controller=t||new Cc(new ds(e))}async initialize(e){return this.controller.initialize(e)}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}async function kc(e){const t=new Ac(e);return await t.initialize(),t}class Sc{constructor(e){this.initialized=!1,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.logger=e.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new ps(this.logger,this.performanceClient):pt,this.eventHandler=new Hs(this.logger),this.browserStorage=this.isBrowserEnvironment?new Es(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,this.performanceClient,this.eventHandler,void 0):_s(this.config.auth.clientId,this.logger,this.performanceClient,this.eventHandler)}getBrowserStorage(){return this.browserStorage}getAccount(e){return null}getAccountByHomeId(e){return null}getAccountByLocalId(e){return null}getAccountByUsername(e){return null}getAllAccounts(){return[]}initialize(){return this.initialized=!0,Promise.resolve()}acquireTokenPopup(e){return Da(this.initialized),Ba(),{}}acquireTokenRedirect(e){return Da(this.initialized),Ba(),Promise.resolve()}acquireTokenSilent(e){return Da(this.initialized),Ba(),{}}acquireTokenByCode(e){return Da(this.initialized),Ba(),{}}acquireTokenNative(e,t,r){return Da(this.initialized),Ba(),{}}acquireTokenByRefreshToken(e,t){return Da(this.initialized),Ba(),{}}addEventCallback(e,t){return null}removeEventCallback(e){}addPerformanceCallback(e){return Da(this.initialized),Ba(),""}removePerformanceCallback(e){return Da(this.initialized),Ba(),!0}enableAccountStorageEvents(){Da(this.initialized),Ba()}disableAccountStorageEvents(){Da(this.initialized),Ba()}handleRedirectPromise(e){return Da(this.initialized),Promise.resolve(null)}loginPopup(e){return Da(this.initialized),Ba(),{}}loginRedirect(e){return Da(this.initialized),Ba(),{}}logout(e){return Da(this.initialized),Ba(),{}}logoutRedirect(e){return Da(this.initialized),Ba(),{}}logoutPopup(e){return Da(this.initialized),Ba(),{}}ssoSilent(e){return Da(this.initialized),Ba(),{}}getTokenCache(){return Da(this.initialized),Ba(),{}}getLogger(){return this.logger}setLogger(e){Da(this.initialized),Ba()}setActiveAccount(e){Da(this.initialized),Ba()}getActiveAccount(){return Da(this.initialized),Ba(),null}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){Da(this.initialized),Ba()}getConfiguration(){return this.config}isBrowserEnv(){return Da(this.initialized),Ba(),!0}getBrowserCrypto(){return Da(this.initialized),Ba(),{}}getPerformanceClient(){return Da(this.initialized),Ba(),{}}getRedirectResponse(){return Da(this.initialized),Ba(),{}}async clearCache(e){Da(this.initialized),Ba()}async hydrateCache(e,t){Da(this.initialized),Ba()}}class bc extends Za{getId(){return bc.ID}getModuleName(){return bc.MODULE_NAME}async initialize(){return!0}}bc.MODULE_NAME="",bc.ID="UnknownOperatingContext";class Ec{static async createPublicClientApplication(e){const t=await wc(e);let r;return r=null!==t?new Ec(e,t):new Ec(e),r}constructor(e,t){if(this.configuration=e,t)this.controller=t;else{const t=new bc(e);this.controller=new Sc(t)}}async initialize(){if(this.controller instanceof Sc){const e=await wc(this.configuration);return null!==e&&(this.controller=e),this.controller.initialize()}return Promise.resolve()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e,t){return this.controller.addEventCallback(e,t)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const Rc={initialize:()=>Promise.reject(_a(Aa)),acquireTokenPopup:()=>Promise.reject(_a(Aa)),acquireTokenRedirect:()=>Promise.reject(_a(Aa)),acquireTokenSilent:()=>Promise.reject(_a(Aa)),acquireTokenByCode:()=>Promise.reject(_a(Aa)),getAllAccounts:()=>[],getAccount:()=>null,getAccountByHomeId:()=>null,getAccountByUsername:()=>null,getAccountByLocalId:()=>null,handleRedirectPromise:()=>Promise.reject(_a(Aa)),loginPopup:()=>Promise.reject(_a(Aa)),loginRedirect:()=>Promise.reject(_a(Aa)),logout:()=>Promise.reject(_a(Aa)),logoutRedirect:()=>Promise.reject(_a(Aa)),logoutPopup:()=>Promise.reject(_a(Aa)),ssoSilent:()=>Promise.reject(_a(Aa)),addEventCallback:()=>null,removeEventCallback:()=>{},addPerformanceCallback:()=>"",removePerformanceCallback:()=>!1,enableAccountStorageEvents:()=>{},disableAccountStorageEvents:()=>{},getTokenCache:()=>{throw _a(Aa)},getLogger:()=>{throw _a(Aa)},setLogger:()=>{},setActiveAccount:()=>{},getActiveAccount:()=>null,initializeWrapperLibrary:()=>{},setNavigationClient:()=>{},getConfiguration:()=>{throw _a(Aa)},hydrateCache:()=>Promise.reject(_a(Aa)),clearCache:()=>Promise.reject(_a(Aa))};function _c(){let e;try{e=window[Si.SessionStorage];const t=e?.getItem("msal.browser.performance.enabled");if(1===Number(t))return Promise.resolve().then((function(){return Oc}))}catch(e){}}function Pc(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.now}function Mc(e){if(e&&Pc())return Math.round(window.performance.now()-e)}class Nc{constructor(e,t){this.correlationId=t,this.measureName=Nc.makeMeasureName(e,t),this.startMark=Nc.makeStartMark(e,t),this.endMark=Nc.makeEndMark(e,t)}static makeMeasureName(e,t){return`msal.measure.${e}.${t}`}static makeStartMark(e,t){return`msal.start.${e}.${t}`}static makeEndMark(e,t){return`msal.end.${e}.${t}`}static supportsBrowserPerformance(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.mark&&"function"==typeof window.performance.measure&&"function"==typeof window.performance.clearMarks&&"function"==typeof window.performance.clearMeasures&&"function"==typeof window.performance.getEntriesByName}static flushMeasurements(e,t){if(Nc.supportsBrowserPerformance())try{t.forEach((t=>{const r=Nc.makeMeasureName(t.name,e);window.performance.getEntriesByName(r,"measure").length>0&&(window.performance.clearMeasures(r),window.performance.clearMarks(Nc.makeStartMark(r,e)),window.performance.clearMarks(Nc.makeEndMark(r,e)))}))}catch(e){}}startMeasurement(){if(Nc.supportsBrowserPerformance())try{window.performance.mark(this.startMark)}catch(e){}}endMeasurement(){if(Nc.supportsBrowserPerformance())try{window.performance.mark(this.endMark),window.performance.measure(this.measureName,this.startMark,this.endMark)}catch(e){}}flushMeasurement(){if(Nc.supportsBrowserPerformance())try{const e=window.performance.getEntriesByName(this.measureName,"measure");if(e.length>0){const t=e[0].duration;return window.performance.clearMeasures(this.measureName),window.performance.clearMarks(this.startMark),window.performance.clearMarks(this.endMark),t}}catch(e){}return null}}var Oc=Object.freeze({__proto__:null,BrowserPerformanceMeasurement:Nc});e.AccountEntity=Sr,e.ApiId=Ki,e.AuthError=Ce,e.AuthErrorCodes=pe,e.AuthErrorMessage=fe,e.AuthenticationHeaderParser=class{constructor(e){this.headers=e}getShrNonce(){const e=this.headers[g];if(e){const t=this.parseChallenges(e);if(t.nextnonce)return t.nextnonce;throw hr(nr)}const t=this.headers[u];if(t){const e=this.parseChallenges(t);if(e.nonce)return e.nonce;throw hr(nr)}throw hr(rr)}parseChallenges(e){const r=e.indexOf(" "),n=e.substr(r+1).split(","),o={};return n.forEach((e=>{const[r,n]=e.split("=");o[r]=unescape(n.replace(/['"]+/g,t.EMPTY_STRING))})),o}}
/*! @azure/msal-common v15.1.1 2025-02-11 */,e.AuthenticationScheme=z,e.AzureCloudInstance=vt,e.BrowserAuthError=di,e.BrowserAuthErrorCodes=ai,e.BrowserAuthErrorMessage=li,e.BrowserCacheLocation=Si,e.BrowserConfigurationAuthError=Ra,e.BrowserConfigurationAuthErrorCodes=Sa,e.BrowserConfigurationAuthErrorMessage=Ea,e.BrowserPerformanceClient=class extends ho{constructor(e,r,n){super(e.auth.clientId,e.auth.authority||`${t.DEFAULT_AUTHORITY}`,new ft(e.system?.loggerOptions||{},Ja,Xa),Ja,Xa,e.telemetry?.application||{appName:"",appVersion:""},r,n)}generateId(){return pa()}getPageVisibility(){return document.visibilityState?.toString()||null}deleteIncompleteSubMeasurements(e){_c()?.then((t=>{const r=this.eventsByCorrelationId.get(e.event.correlationId),n=r&&r.eventId===e.event.eventId,o=[];n&&r?.incompleteSubMeasurements&&r.incompleteSubMeasurements.forEach((e=>{o.push({...e})})),t.BrowserPerformanceMeasurement.flushMeasurements(e.event.correlationId,o)}))}startMeasurement(e,t){const r=this.getPageVisibility(),n=super.startMeasurement(e,t),o=Pc()?window.performance.now():void 0,i=_c()?.then((t=>new t.BrowserPerformanceMeasurement(e,n.event.correlationId)));return i?.then((e=>e.startMeasurement())),{...n,end:(e,t)=>{const a=n.end({...e,startPageVisibility:r,endPageVisibility:this.getPageVisibility(),durationMs:Mc(o)},t);return i?.then((e=>e.endMeasurement())),this.deleteIncompleteSubMeasurements(n),a},discard:()=>{n.discard(),i?.then((e=>e.flushMeasurement())),this.deleteIncompleteSubMeasurements(n)}}}setPreQueueTime(e,t){if(!Pc())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to set telemetry queue time for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to set telemetry queue time`);const r=this.preQueueTimeByCorrelationId.get(t);r&&(this.logger.trace(`BrowserPerformanceClient: Incomplete pre-queue ${r.name} found`,t),this.addQueueMeasurement(r.name,t,void 0,!0)),this.preQueueTimeByCorrelationId.set(t,{name:e,time:window.performance.now()})}addQueueMeasurement(e,t,r,n){if(!Pc())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to add queue measurement for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to add queue measurement`);const o=super.getPreQueueTime(e,t);if(!o)return;const i=window.performance.now(),a=r||super.calculateQueuedTime(o,i);return super.addQueueMeasurement(e,t,a,n)}},e.BrowserPerformanceMeasurement=Nc,e.BrowserUtils=$a,e.CacheLookupPolicy=ji,e.ClientAuthError=ut,e.ClientAuthErrorCodes=lt,e.ClientAuthErrorMessage=ht,e.ClientConfigurationError=dr,e.ClientConfigurationErrorCodes=sr,e.ClientConfigurationErrorMessage=lr,e.DEFAULT_IFRAME_TIMEOUT_MS=Ya,e.EventHandler=Hs,e.EventMessageUtils=class{static getInteractionStatusFromEvent(t,r){switch(t.eventType){case bs.LOGIN_START:return Gi.Login;case bs.SSO_SILENT_START:return Gi.SsoSilent;case bs.ACQUIRE_TOKEN_START:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup)return Gi.AcquireToken;break;case bs.HANDLE_REDIRECT_START:return Gi.HandleRedirect;case bs.LOGOUT_START:return Gi.Logout;case bs.SSO_SILENT_SUCCESS:case bs.SSO_SILENT_FAILURE:if(r&&r!==Gi.SsoSilent)break;return Gi.None;case bs.LOGOUT_END:if(r&&r!==Gi.Logout)break;return Gi.None;case bs.HANDLE_REDIRECT_END:if(r&&r!==Gi.HandleRedirect)break;return Gi.None;case bs.LOGIN_SUCCESS:case bs.LOGIN_FAILURE:case bs.ACQUIRE_TOKEN_SUCCESS:case bs.ACQUIRE_TOKEN_FAILURE:case bs.RESTORE_FROM_BFCACHE:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup){if(r&&r!==Gi.Login&&r!==Gi.AcquireToken)break;return Gi.None}}return null}},e.EventType=bs,e.InteractionRequiredAuthError=xn,e.InteractionRequiredAuthErrorCodes=On,e.InteractionRequiredAuthErrorMessage=Hn,e.InteractionStatus=Gi,e.JsonWebTokenTypes=he,e.LocalStorage=As,e.Logger=ft,e.MemoryStorage=us,e.NavigationClient=Qa,e.OIDC_DEFAULT_SCOPES=a,e.PerformanceEvents=ln,e.PromptValue=w,e.ProtocolMode=kr,e.PublicClientApplication=Ac,e.PublicClientNext=Ec,e.ServerError=Tn,e.ServerResponseType=k,e.SessionStorage=ks,e.SignedHttpRequest=class{constructor(e,t){const r=t&&t.loggerOptions||{};this.logger=new ft(r,Ja,Xa),this.cryptoOps=new ps(this.logger),this.popTokenGenerator=new zn(this.cryptoOps),this.shrParameters=e}async generatePublicKeyThumbprint(){const{kid:e}=await this.popTokenGenerator.generateKid(this.shrParameters);return e}async signRequest(e,t,r){return this.popTokenGenerator.signPayload(e,t,this.shrParameters,r)}async removeKeys(e){return this.cryptoOps.removeTokenBindingKey(e)}},e.StringUtils=ur,e.StubPerformanceClient=so,e.UrlString=Rr,e.WrapperSKU={React:"@azure/msal-react",Angular:"@azure/msal-angular"},e.createNestablePublicClientApplication=async function(e){const t=new ls(e);if(await t.initialize(),t.isAvailable()){const r=new Tc(t),n=new Ac(e,r);return await n.initialize(),n}return kc(e)},e.createStandardPublicClientApplication=kc,e.stubbedPublicClientApplication=Rc,e.version=Xa}));
