import type * as Model from './types.ts';
import type * as CST from '../cst/types.ts';
/**
 * Shared symbol used as a key on message data model nodes
 * to reference their CST source.
 *
 * Only set on message data model nodes when parsed by {@link messageFromCST}.
 */
export declare const cstKey: unique symbol;
/**
 * Convert a CST message structure into its data model representation.
 *
 * In the returned {@link Model.Message},
 * all nodes include a reference to their source {@link CST} node
 * as a {@link cstKey} symbol-keyed property.
 */
export declare function messageFromCST(msg: CST.Message): Model.Message;
