/* eslint-disable @typescript-eslint/no-explicit-any */
/** @category Message Data Model */
export const isCatchallKey = (key) => !!key && typeof key === 'object' && key.type === '*';
/** @category Message Data Model */
export const isExpression = (part) => !!part && typeof part === 'object' && part.type === 'expression';
/** @category Message Data Model */
export const isFunctionRef = (part) => !!part && typeof part === 'object' && part.type === 'function';
/** @category Message Data Model */
export const isLiteral = (part) => !!part && typeof part === 'object' && part.type === 'literal';
/** @category Message Data Model */
export const isMarkup = (part) => !!part && typeof part === 'object' && part.type === 'markup';
/** @category Message Data Model */
export const isMessage = (msg) => !!msg &&
    typeof msg === 'object' &&
    (msg.type === 'message' || msg.type === 'select');
/** @category Message Data Model */
export const isPatternMessage = (msg) => msg.type === 'message';
/** @category Message Data Model */
export const isSelectMessage = (msg) => msg.type === 'select';
/** @category Message Data Model */
export const isVariableRef = (part) => !!part && typeof part === 'object' && part.type === 'variable';
