import { MessageDataModelError } from '../errors.ts';
import type { Message, Node } from './types.ts';
/**
 * Ensure that the `msg` data model is _valid_, calling `onError` on errors.
 * If `onError` is not defined, a {@link MessageDataModelError} will be thrown on error.
 *
 * Detects the following errors:
 *
 * - `'key-mismatch'`: **Variant Key Mismatch**<br>
 *   The number of keys on a _variant_ does not equal the number of _selectors_.
 *
 * - `'missing-fallback'`: **Missing Fallback Variant**<br>
 *   The message does not include a _variant_ with only catch-all keys.
 *
 * - `'missing-selector-annotation'`: **Missing Selector Annotation**<br>
 *   A _selector_ does not contains a _variable_ that directly or indirectly
 *   reference a _declaration_ with a _function_.
 *
 * - `'duplicate-declaration'`: **Duplicate Declaration**<br>
 *   A _variable_ appears in two _declarations_.
 *
 * - `'duplicate-variant'`: **Duplicate Variant**<br>
 *   The same list of _keys_ is used for more than one _variant_.
 *
 * @category Message Data Model
 * @returns The sets of runtime `functions` and `variables` used by the message.
 */
export declare function validate(msg: Message, onError?: (type: MessageDataModelError['type'], node: Node) => void): {
    functions: Set<string>;
    variables: Set<string>;
};
