import type { Attributes, CatchallKey, Declaration, Expression, FunctionRef, Literal, Markup, Message, Node, Options, Pattern, VariableRef, Variant } from './types.ts';
/**
 * Apply visitor functions to message nodes.
 *
 * The visitors are applied in source order, starting from the root.
 * Visitors for nodes that contain other nodes may return a callback function
 * that will be called with no arguments when exiting the node.
 *
 * If set, the `node` visitor is called for all {@link Node} values
 * for which an explicit visitor is not defined.
 *
 * Many visitors will be called with additional arguments
 * identifying some of the context for the visited node.
 *
 * @category Message Data Model
 */
export declare function visit(msg: Message, visitors: {
    attributes?: (attributes: Attributes, context: 'declaration' | 'placeholder') => (() => void) | void;
    declaration?: (declaration: Declaration) => (() => void) | void;
    expression?: (expression: Expression, context: 'declaration' | 'placeholder') => (() => void) | void;
    functionRef?: (functionRef: FunctionRef, context: 'declaration' | 'placeholder', argument: Literal | VariableRef | undefined) => (() => void) | void;
    key?: (key: Literal | CatchallKey, index: number, keys: (Literal | CatchallKey)[]) => void;
    markup?: (markup: Markup, context: 'declaration' | 'placeholder') => (() => void) | void;
    node?: (node: Node, ...rest: unknown[]) => void;
    options?: (options: Options, context: 'declaration' | 'placeholder') => (() => void) | void;
    pattern?: (pattern: Pattern) => (() => void) | void;
    value?: (value: Literal | VariableRef, context: 'declaration' | 'selector' | 'placeholder', position: 'arg' | 'option' | 'attribute') => void;
    variant?: (variant: Variant) => (() => void) | void;
}): void;
