import type { Node } from './data-model/types.ts';
/**
 * Base error class used by MessageFormat
 *
 * @category Errors
 */
export declare class MessageError extends Error {
    type: 'not-formattable' | 'unknown-function' | typeof MessageResolutionError.prototype.type | typeof MessageSelectionError.prototype.type | typeof MessageSyntaxError.prototype.type;
    constructor(type: typeof MessageError.prototype.type, message: string);
}
/**
 * Errors in the message syntax.
 *
 * @category Errors
 */
export declare class MessageSyntaxError extends MessageError {
    type: 'empty-token' | 'bad-escape' | 'bad-input-expression' | 'duplicate-attribute' | 'duplicate-declaration' | 'duplicate-option-name' | 'duplicate-variant' | 'extra-content' | 'key-mismatch' | 'parse-error' | 'missing-fallback' | 'missing-selector-annotation' | 'missing-syntax';
    start: number;
    end: number;
    /** @private */
    constructor(type: typeof MessageSyntaxError.prototype.type, start: number, end?: number, expected?: string);
}
/**
 * Errors in the message data model.
 *
 * @category Errors
 */
export declare class MessageDataModelError extends MessageSyntaxError {
    type: 'duplicate-declaration' | 'duplicate-variant' | 'key-mismatch' | 'missing-fallback' | 'missing-selector-annotation';
    /** @private */
    constructor(type: typeof MessageDataModelError.prototype.type, node: Node);
}
/**
 * Message runtime resolution errors
 *
 * @category Errors
 */
export declare class MessageResolutionError extends MessageError {
    type: 'bad-function-result' | 'bad-operand' | 'bad-option' | 'unresolved-variable' | 'unsupported-operation';
    source: string;
    constructor(type: typeof MessageResolutionError.prototype.type, message: string, source: string);
}
/**
 * Errors in message selection.
 *
 * @category Errors
 */
export declare class MessageSelectionError extends MessageError {
    type: 'bad-selector' | 'no-match';
    cause?: unknown;
    constructor(type: typeof MessageSelectionError.prototype.type, cause?: unknown);
}
