import { cstKey } from "./data-model/from-cst.js";
/**
 * Base error class used by MessageFormat
 *
 * @category Errors
 */
export class MessageError extends Error {
    type;
    constructor(type, message) {
        super(message);
        this.type = type;
    }
}
/**
 * Errors in the message syntax.
 *
 * @category Errors
 */
export class MessageSyntaxError extends MessageError {
    start;
    end;
    /** @private */
    constructor(type, start, end, expected) {
        let message = expected ? `Missing ${expected}` : type;
        if (start >= 0)
            message += ` at ${start}`;
        super(type, message);
        this.start = start;
        this.end = end ?? start + 1;
    }
}
/**
 * Errors in the message data model.
 *
 * @category Errors
 */
export class MessageDataModelError extends MessageSyntaxError {
    /** @private */
    constructor(type, node) {
        const { start, end } = node[cstKey] ?? { start: -1, end: -1 };
        super(type, start, end);
    }
}
/**
 * Message runtime resolution errors
 *
 * @category Errors
 */
export class MessageResolutionError extends MessageError {
    source;
    constructor(type, message, source) {
        super(type, message);
        this.source = source;
    }
}
/**
 * Errors in message selection.
 *
 * @category Errors
 */
export class MessageSelectionError extends MessageError {
    cause;
    constructor(type, cause) {
        super(type, `Selection error: ${type}`);
        if (cause !== undefined)
            this.cause = cause;
    }
}
