import type { MessageExpressionPart } from '../formatted-parts.ts';
import type { MessageValue } from '../message-value.ts';
import type { MessageFunctionContext } from '../resolve/function-context.ts';
/**
 * The resolved value of a {@link DraftFunctions.date | :date},
 * {@link DraftFunctions.datetime | :datetime}, or {@link DraftFunctions.time | :time} expression.
 *
 * @beta
 */
export interface MessageDateTime extends MessageValue<'datetime'> {
    readonly type: 'datetime';
    readonly source: string;
    readonly dir: 'ltr' | 'rtl' | 'auto';
    readonly options: Readonly<Intl.DateTimeFormatOptions>;
    toParts(): [MessageDateTimePart];
    toString(): string;
    valueOf(): Date;
}
/**
 * The formatted part for a {@link MessageDateTime} value.
 *
 * @beta
 * @category Formatted Parts
 */
export interface MessageDateTimePart extends MessageExpressionPart<'datetime'> {
    type: 'datetime';
    locale: string;
    parts: Intl.DateTimeFormatPart[];
}
/**
 * `datetime` accepts a Date, number or string as its input
 * and formats it with the same options as
 * {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/DateTimeFormat | Intl.DateTimeFormat}.
 *
 * @beta
 */
export declare const datetime: (ctx: MessageFunctionContext, options: Record<string, unknown>, operand?: unknown) => MessageDateTime;
/**
 * `date` accepts a Date, number or string as its input
 * and formats it according to a single "style" option.
 *
 * @beta
 */
export declare const date: (ctx: MessageFunctionContext, options: Record<string, unknown>, operand?: unknown) => MessageDateTime;
/**
 * `time` accepts a Date, number or string as its input
 * and formats it according to a single "style" option.
 *
 * @beta
 */
export declare const time: (ctx: MessageFunctionContext, options: Record<string, unknown>, operand?: unknown) => MessageDateTime;
