import { MessageResolutionError } from "../errors.js";
import { number, readNumericOperand } from "./number.js";
import { asPositiveInteger } from "./utils.js";
/**
 * `math` accepts a numeric value as input and adds or subtracts an integer value from it
 *
 * @beta
 */
export function math(ctx, exprOpt, operand) {
    const { source } = ctx;
    let { value, options } = readNumericOperand(operand, source);
    let add;
    let sub;
    try {
        add = 'add' in exprOpt ? asPositiveInteger(exprOpt.add) : -1;
        sub = 'subtract' in exprOpt ? asPositiveInteger(exprOpt.subtract) : -1;
    }
    catch (error) {
        throw new MessageResolutionError('bad-option', String(error), source);
    }
    if (add < 0 === sub < 0) {
        const msg = 'Exactly one of "add" or "subtract" is required as a :math option';
        throw new MessageResolutionError('bad-option', msg, source);
    }
    const delta = add < 0 ? -sub : add;
    if (typeof value === 'number')
        value += delta;
    else
        value += BigInt(delta);
    return number(ctx, {}, { valueOf: () => value, options });
}
