import type { MessageExpressionPart } from '../formatted-parts.ts';
import type { MessageValue } from '../message-value.ts';
import type { MessageFunctionContext } from '../resolve/function-context.ts';
/**
 * The resolved value of a {@link DraftFunctions.currency | :currency},
 * {@link DefaultFunctions.integer | :integer}, {@link DraftFunctions.math | :math},
 * {@link DefaultFunctions.number | :number}, or {@link DraftFunctions.unit | :unit} expression.
 */
export interface MessageNumber extends MessageValue<'number'> {
    readonly type: 'number';
    readonly source: string;
    readonly dir: 'ltr' | 'rtl' | 'auto';
    readonly options: Readonly<Intl.NumberFormatOptions & Intl.PluralRulesOptions>;
    /**
     * In addition to matching exact values,
     * numerical values may also match keys with the same plural rule category,
     * i.e. one of `zero`, `one`, `two`, `few`, `many`, and `other`.
     *
     * Different languages use different subset of plural rule categories.
     * For example, cardinal English plurals only use `one` and `other`,
     * so a key `zero` will never be matched for that locale.
     */
    selectKey?: (keys: Set<string>) => string | null;
    toParts?: () => [MessageNumberPart];
    toString?: () => string;
    valueOf(): number | bigint;
}
/**
 * The formatted part for a {@link MessageNumber} value.
 *
 * @category Formatted Parts
 */
export interface MessageNumberPart extends MessageExpressionPart<'number'> {
    type: 'number';
    locale: string;
    parts: Intl.NumberFormatPart[];
}
export type MessageNumberOptions = Intl.NumberFormatOptions & Intl.PluralRulesOptions & {
    select?: 'exact' | 'cardinal' | 'ordinal';
};
export declare function readNumericOperand(value: unknown, source: string): {
    value: number | bigint;
    options: unknown;
};
export declare function getMessageNumber(ctx: MessageFunctionContext, value: number | bigint, options: MessageNumberOptions, canSelect: boolean): MessageNumber;
export declare function number(ctx: MessageFunctionContext, exprOpt: Record<string, unknown>, operand?: unknown): MessageNumber;
export declare function integer(ctx: MessageFunctionContext, exprOpt: Record<string, unknown>, operand?: unknown): MessageNumber;
