export function string(ctx, _options, operand) {
    const str = operand === undefined ? '' : String(operand);
    const selStr = str.normalize();
    return {
        type: 'string',
        source: ctx.source,
        dir: ctx.dir ?? 'auto',
        selectKey: keys => (keys.has(selStr) ? selStr : null),
        toParts() {
            const { dir } = ctx;
            const locale = ctx.locales[0];
            return dir === 'ltr' || dir === 'rtl'
                ? [{ type: 'string', dir, locale, value: str }]
                : [{ type: 'string', locale, value: str }];
        },
        toString: () => str,
        valueOf: () => str
    };
}
