/**
 * Utility function for custom functions.
 * Cast a value as a Boolean,
 * unwrapping objects using their `valueOf()` methods.
 * Also accepts `'true'` and `'false'`.
 * Throws a `RangeError` for invalid inputs.
 */
export declare function asBoolean(value: unknown): boolean;
/**
 * Utility function for custom functions.
 * Cast a value as a non-negative integer,
 * unwrapping objects using their `valueOf()` methods.
 * Also accepts JSON string reprentations of integers.
 * Throws a `RangeError` for invalid inputs.
 *
 * The default functions use this to validate _digit size options_.
 */
export declare function asPositiveInteger(value: unknown): number;
/**
 * Utility function for custom functions.
 * Cast a value as a string,
 * unwrapping objects using their `valueOf()` methods.
 * Throws a `RangeError` for invalid inputs.
 */
export declare function asString(value: unknown): string;
