import { MessageResolutionError } from "../errors.js";
import { getValueSource, resolveValue } from "./resolve-value.js";
export function formatMarkup(ctx, { kind, name, options }) {
    const part = { type: 'markup', kind, name };
    if (options?.size) {
        part.options = {};
        for (const [name, value] of options) {
            if (name === 'u:dir') {
                const msg = `The option ${name} is not valid for markup`;
                const optSource = getValueSource(value);
                ctx.onError(new MessageResolutionError('bad-option', msg, optSource));
            }
            else {
                let rv = resolveValue(ctx, value);
                if (typeof rv === 'object' && typeof rv?.valueOf === 'function') {
                    rv = rv.valueOf();
                }
                if (name === 'u:id')
                    part.id = String(rv);
                else
                    part.options[name] = rv;
            }
        }
    }
    return part;
}
