import { lookupVariableRef } from "./resolve-variable.js";
export function resolveValue(ctx, value) {
    switch (value.type) {
        case 'literal':
            return value.value;
        case 'variable':
            return lookupVariableRef(ctx, value);
        default:
            // @ts-expect-error - should never happen
            throw new Error(`Unsupported value: ${value.type}`);
    }
}
export function getValueSource(value) {
    switch (value?.type) {
        case 'literal':
            return ('|' + value.value.replaceAll('\\', '\\\\').replaceAll('|', '\\|') + '|');
        case 'variable':
            return '$' + value.name;
        default:
            return undefined;
    }
}
