import type { Expression, VariableRef } from '../data-model/types.ts';
import type { Context } from '../format-context.ts';
import { MessageValue } from '../message-value.ts';
/**
 * Declarations aren't resolved until they're requierd,
 * and their resolution order matters for variable resolution.
 * This internal class is used to store any required data,
 * and to allow for `instanceof` detection.
 *
 * @internal
 */
export declare class UnresolvedExpression {
    expression: Expression;
    scope: Record<string, unknown> | undefined;
    constructor(expression: Expression, scope?: Record<string, unknown>);
}
/**
 * Get the raw value of a variable.
 * Resolves declarations as necessary
 *
 * @internal
 * @returns `unknown` or `any` for input values;
 *   `MessageValue` for `.input` and `.local` declaration values.
 */
export declare function lookupVariableRef(ctx: Context, { name }: VariableRef): unknown;
export declare function resolveVariableRef<T extends string, P extends string>(ctx: Context<T, P>, ref: VariableRef): import("../functions/fallback.ts").MessageFallback | import("../functions/unknown.ts").MessageUnknownValue | MessageValue<T, P>;
