# $Id: pager.pl,v 1.1.1.1 2002/02/13 06:24:49 root Exp $

use Irssi 20020121.2020 ();
$VERSION = "0.20";
%IRSSI = (
	  authors     => 'Jean-Yves "decadix" Lefort',
	  contact     => 'jylefort\@brutele.be, decadix on IRCNet',
	  name        => 'pager',
	  description => 'Notifies people if they send you a private message or a DCC chat offer while you are away; runs a shell command configurable via /set if they page you',
	  license     => 'BSD',
	  changed     => '$Date: 2002/02/13 06:24:49 $ ',
);

# note:
#
#	Irssi special variables (see IRSSI_DOC_DIR/special_vars.txt) will be
#	expanded in *_notice /set's, and will NOT be expanded in page_command
#	for obvious security reasons.
#
# /set's:
#
#	page_command	a shell command to run if someone sends you the
#			private message 'page' while you are away
#
#	away_notice	a notice to send to someone sending you a private
#			message while you are away
#
#	paged_notice	a notice to send to someone who has just paged you
#
#	dcc_notice	a notice to send to someone who has just sent you
#			a DCC chat offer (this automatically pages you)
#
# changes:
#
#	2002-02-06	release 0.20
#			* builtin expand deprecated;
#			  now uses Irssi's special variables
#
#	2002-01-27	release 0.11
#			* uses builtin expand
#
#	2002-01-23	initial release

use strict;
use Irssi::Irc;			# for DCC object

sub message {
  my ($server, $msg, $nick, $address) = @_;
  
  if ($server->{usermode_away}) {
    if (lc($msg) eq "page") {
      system(Irssi::settings_get_str("page_command"));
      $server->command("EVAL NOTICE $nick " .
		       Irssi::settings_get_str("paged_notice"))
    } else {
      $server->command("EVAL NOTICE $nick " .
		       Irssi::settings_get_str("away_notice"));
    }
  }
}

sub dcc_request {
  my ($dcc, $sendaddr) = @_;
  
  if ($dcc->{server}->{usermode_away} && $dcc->{type} eq "CHAT") {
    system(Irssi::settings_get_str("page_command"));
    $dcc->{server}->command("EVAL NOTICE $dcc->{nick} " .
			    Irssi::settings_get_str("dcc_notice"));
  }
}

Irssi::settings_add_str("misc",	"page_command",
			"esdplay ~/sound/events/page.wav &");
Irssi::settings_add_str("misc", "away_notice",
			'$N is away ($A). Type /MSG $N PAGE to page him.');
Irssi::settings_add_str("misc", "paged_notice",
			'$N has been paged.');
Irssi::settings_add_str("misc",	"dcc_notice",
			'$N is away ($A) and has been paged. Type /MSG $N PAGE to page him again.');

Irssi::signal_add_last("message private", "message");
Irssi::signal_add_last("dcc request", "dcc_request");
