/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.ant;

import com.alternatecomputing.jsvn.ant.AbstractSvnTask;
import com.alternatecomputing.jsvn.command.Checkout;
import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.Commandable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;

public class SvnCheckout
extends AbstractSvnTask {
    private String revision = "HEAD";
    private String username = "";
    private String password = "";
    private String date;
    private boolean verbose = false;
    private boolean recursive = true;
    private File destination;

    Commandable buildCommand() throws CommandException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("REPOS_URL", this.getRepositoryUrl());
        args.put("DESTINATION", this.getDestinationPath());
        args.put("USERNAME", this.getUsername());
        args.put("PASSWORD", this.getPassword());
        args.put("REVISION", this.revision);
        args.put("NONRECURSIVE", new Boolean(!this.recursive));
        Checkout command = new Checkout();
        ((Command)command).init(args);
        return command;
    }

    public void execute() throws BuildException {
        super.execute();
    }

    private String getDestinationPath() throws CommandException {
        if (this.destination == null) {
            this.destination = ((ProjectComponent)this).project.getBaseDir();
        }
        String destinationPath = null;
        try {
            if (!this.destination.exists()) {
                this.destination.mkdirs();
            }
            destinationPath = this.destination.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CommandException(e.toString());
        }
        return destinationPath;
    }

    public String getDate() {
        return this.date;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDate(String string) {
        this.date = string;
        throw new UnsupportedOperationException("sorry. checkout by date not supported yet");
    }

    public void setDestination(File file) {
        this.destination = file;
    }

    public void setRecursive(boolean b) {
        this.recursive = b;
    }

    public void setRevision(String i) {
        this.revision = i;
    }

    public void setUsername(String s) {
        this.username = s;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }
}

