/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.ant;

import com.alternatecomputing.jsvn.ant.AbstractSvnTask;
import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.Commandable;
import com.alternatecomputing.jsvn.command.Switch;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;

public class SvnSwitch
extends AbstractSvnTask {
    private String url;
    private String destination;
    private String revision = "HEAD";
    private boolean recursive = true;

    public Commandable buildCommand() throws CommandException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("URL", this.url);
        args.put("REVISION", this.revision);
        args.put("PATH", this.destination);
        args.put("NONRECURSIVE", new Boolean(!this.recursive));
        Switch command = new Switch();
        ((Command)command).init(args);
        return command;
    }

    public void execute() throws BuildException {
        this.log("switching to : " + this.url, 2);
        super.execute();
    }

    public void setDestination(File file) throws CommandException {
        try {
            if (!(file.exists() && file.isDirectory() && file.canWrite())) {
                throw new CommandException("Destination " + file + " doesn't exist or is not writable");
            }
            this.destination = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CommandException(e.toString());
        }
    }

    public void setRevision(String s) {
        this.revision = s;
    }

    public void setUrl(String s) {
        this.url = s;
    }

    public void setRecursive(boolean b) {
        this.recursive = b;
    }
}

