/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.util.Map;

public class Checkout
extends Command
implements WorkingCopyModifiable {
    public static final String DESTINATION = "DESTINATION";
    public static final String REVISION = "REVISION";
    public static final String REPOS_URL = "REPOS_URL";
    public static final String NONRECURSIVE = "NONRECURSIVE";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";

    public void init(Map args) throws CommandException {
        Boolean nonRecursive;
        String revision;
        String password;
        super.init(args);
        String url = (String)args.get(REPOS_URL);
        if (url == null || "".equals(url.trim())) {
            throw new CommandException("Missing url");
        }
        String destination = (String)args.get(DESTINATION);
        if (destination == null || "".equals(destination.trim())) {
            throw new CommandException("Missing destination");
        }
        this.addCommand("svn");
        this.addCommand("checkout");
        String username = (String)args.get(USERNAME);
        if (username != null && !"".equals(username.trim())) {
            this.addCommand("--username");
            this.addCommand(username);
        }
        if ((password = (String)args.get(PASSWORD)) != null && !"".equals(password.trim())) {
            this.addCommand("--password");
            this.addCommand(password);
        }
        if ((revision = (String)args.get(REVISION)) != null && !"".equals(revision.trim())) {
            this.addCommand("-r");
            this.addCommand(revision);
        }
        if ((nonRecursive = (Boolean)args.get(NONRECURSIVE)).booleanValue()) {
            this.addCommand("-N");
        }
        this.addCommand("--non-interactive");
        this.addCommand(url);
        this.addCommand(destination);
    }
}

