/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class Commit
extends Command
implements WorkingCopyModifiable {
    public static final String COMMIT_MESSAGE = "COMMIT_MESSAGE";
    public static final String TARGETS = "TARGETS";

    public void init(Map args) throws CommandException {
        super.init(args);
        String targets = (String)args.get(TARGETS);
        if (targets == null || "".equals(targets.trim())) {
            throw new CommandException("Missing target(s)");
        }
        String commitMessage = (String)args.get(COMMIT_MESSAGE);
        if (commitMessage == null) {
            throw new CommandException("Missing commit message");
        }
        try {
            File tempFile = File.createTempFile("jsvn", ".tmp", null);
            tempFile.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
            out.write(commitMessage);
            out.close();
            this.addCommand("svn");
            this.addCommand("commit");
            this.addCommand(targets);
            this.addCommand("--file");
            this.addCommand(tempFile.getCanonicalPath());
            this.addCommand("--non-interactive");
        }
        catch (IOException e) {
            throw new CommandException("Error while building commit command.  Original exception: " + e.getMessage());
        }
    }
}

