/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class Import
extends Command
implements WorkingCopyModifiable {
    public static final String COMMIT_MESSAGE = "COMMIT_MESSAGE";
    public static final String PATH = "PATH";
    public static final String REPOS_URL = "REPOS_URL";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";

    public void init(Map args) throws CommandException {
        super.init(args);
        String url = (String)args.get(REPOS_URL);
        if (url == null || "".equals(url.trim())) {
            throw new CommandException("Missing url");
        }
        String path = (String)args.get(PATH);
        if (path == null || "".equals(path.trim())) {
            throw new CommandException("Missing path");
        }
        String commitMessage = (String)args.get(COMMIT_MESSAGE);
        if (commitMessage == null || "".equals(commitMessage.trim())) {
            throw new CommandException("Missing commit message");
        }
        String username = (String)args.get(USERNAME);
        String password = (String)args.get(PASSWORD);
        try {
            File tempFile = File.createTempFile("jsvn", ".tmp", null);
            tempFile.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
            out.write(commitMessage);
            out.close();
            this.addCommand("svn");
            this.addCommand("import");
            this.addCommand("--file");
            this.addCommand(tempFile.getCanonicalPath());
            if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                this.addCommand("--username");
                this.addCommand(username);
                this.addCommand("--password");
                this.addCommand(password);
            }
            this.addCommand(path);
            this.addCommand(url);
            System.out.println(Arrays.asList(this.getCommand()));
        }
        catch (IOException e) {
            throw new CommandException("Error while building commit command.  Original exception: " + e.getMessage());
        }
    }
}

