/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class Mkdir
extends Command
implements WorkingCopyModifiable {
    public static final String URL = "URL";
    public static final String PATH = "PATH";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String MESSAGE = "MESSAGE";

    public void init(Map args) throws CommandException {
        super.init(args);
        this.addCommand("svn");
        this.addCommand("mkdir");
        this.addCommand("--non-interactive");
        String message = (String)args.get(MESSAGE);
        if (message == null) {
            message = "*** Empty message ***";
        }
        try {
            File tempFile = File.createTempFile("jsvn", ".tmp", null);
            tempFile.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
            out.write(message);
            out.close();
            this.addCommand("--file");
            this.addCommand(tempFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new CommandException("Error while building commit command.  Original exception: " + e.getMessage());
        }
        String username = (String)args.get(USERNAME);
        String password = (String)args.get(PASSWORD);
        if (username != null && !"".equals(username.trim())) {
            this.addCommand("--username");
            this.addCommand(username);
        }
        if (password != null && !"".equals(password.trim())) {
            this.addCommand("--password");
            this.addCommand(password);
        }
        String url = (String)args.get(URL);
        String path = (String)args.get(PATH);
        if ((url == null || "".equals(url.trim())) && (path == null || "".equals(path.trim())) || url != null && url.trim().length() > 0 && path != null && path.trim().length() > 0) {
            throw new CommandException("url or path should be specified but not both at a time");
        }
        String dir = url != null ? url : path;
        this.addCommand(dir);
    }
}

