/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.command;

import com.alternatecomputing.jsvn.command.Command;
import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import java.util.Map;

public class PropSet
extends Command
implements WorkingCopyModifiable {
    public static final String NONRECURSIVE = "NONRECURSIVE";
    public static final String NAME = "PROPERTY_NAME";
    public static final String VALUE = "PROPERTY_VALUE";
    public static final String PROPVALUE_IS_FILE = "PROPVALUE_IS_FILE";
    public static final String TARGETS = "TARGETS";
    public static final String QUIET = "QUIET";

    public void init(Map args) throws CommandException {
        Boolean nonRecursive;
        super.init(args);
        String targets = (String)args.get(TARGETS);
        if (targets == null || "".equals(targets.trim())) {
            throw new CommandException("Missing target(s)");
        }
        String propertyNameOption = (String)args.get(NAME);
        if (propertyNameOption == null || "".equals(propertyNameOption.trim())) {
            throw new CommandException("Missing property name");
        }
        String propertyValueOption = (String)args.get(VALUE);
        if (propertyValueOption == null || "".equals(propertyValueOption.trim())) {
            throw new CommandException("Missing property value");
        }
        propertyValueOption = "\"" + propertyValueOption + "\"";
        this.addCommand("svn");
        this.addCommand("propset");
        this.addCommand(targets);
        Boolean quiet = (Boolean)args.get(QUIET);
        if (Boolean.TRUE == quiet) {
            this.addCommand("-q");
        }
        if (Boolean.TRUE == (nonRecursive = (Boolean)args.get(NONRECURSIVE))) {
            this.addCommand("-N");
        }
        this.addCommand(propertyNameOption);
        this.addCommand(targets);
        Boolean propValIsFile = (Boolean)args.get(PROPVALUE_IS_FILE);
        if (Boolean.TRUE == propValIsFile) {
            this.addCommand("-F");
        }
        this.addCommand(propertyValueOption);
        this.addCommand(targets);
    }
}

