/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.Commandable;
import com.alternatecomputing.jsvn.gui.Application;
import com.alternatecomputing.jsvn.gui.CenterableDialog;
import com.alternatecomputing.jsvn.gui.Frame;
import com.alternatecomputing.jsvn.gui.JSVNCommandEvent;
import com.alternatecomputing.jsvn.gui.JSVNCommandExecutor;
import com.alternatecomputing.jsvn.gui.JSVNEventListener;
import com.alternatecomputing.jsvn.gui.JSVNStatusEvent;
import com.alternatecomputing.jsvn.gui.JSVNUIEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class CommandDialog
extends CenterableDialog
implements JSVNEventListener,
ActionListener {
    private static final String OK_TEXT = "OK";
    private static final char OK_MNEMONIC = 'O';
    private static final String CANCEL_TEXT = "Cancel";
    private static final char CANCEL_MNEMONIC = 'C';
    private String _targets;
    private JPanel _optionsPanel;
    private JPanel _buttonPanel = new JPanel();
    private JButton _okButton = new JButton();
    private JButton _cancelButton = new JButton();
    private FlowLayout _buttonPaneLayout = new FlowLayout(2);
    CenterableDialog _thisDialog;

    public CommandDialog(Frame parent, boolean modal) {
        super((java.awt.Frame)parent, modal);
        this.initGUI();
        this.pack();
    }

    protected abstract boolean isValidOptions();

    protected abstract String getDialogTitle();

    protected abstract String getDialogCaption();

    protected abstract Commandable buildCommand(Map var1);

    protected abstract JPanel getOptionsPanel();

    protected void runCommand() throws CommandException {
        HashMap args = new HashMap();
        Commandable command = this.buildCommand(args);
        JSVNCommandExecutor executor = new JSVNCommandExecutor(command, args);
        executor.addJSVNEventListener(this);
        executor.addJSVNEventListener(Application.getApplicationFrame());
        Thread t = new Thread(executor);
        t.start();
    }

    public void postExecute(boolean success) {
        if (success) {
            this.setVisible(false);
            this.dispose();
        }
    }

    protected String getTargets() {
        return this._targets;
    }

    public void setTargets(String targets) {
        this._targets = targets;
    }

    private void initGUI() {
        this._thisDialog = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CommandDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this._optionsPanel = this.getOptionsPanel();
        this._optionsPanel.setBorder(new TitledBorder(this.getDialogCaption()));
        this.getContentPane().add((Component)this._optionsPanel, "Center");
        this._buttonPanel.setLayout(this._buttonPaneLayout);
        this._okButton.setText(OK_TEXT);
        this._okButton.setMnemonic('O');
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandDialog.this.isValidOptions()) {
                    try {
                        CommandDialog.this.runCommand();
                    }
                    catch (CommandException ce) {
                        JOptionPane.showMessageDialog(CommandDialog.this._thisDialog.getContentPane(), ce.getMessage());
                    }
                }
            }
        });
        this._buttonPanel.add(this._okButton);
        this._cancelButton.setText(CANCEL_TEXT);
        this._cancelButton.setMnemonic('C');
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommandDialog.this.setVisible(false);
                CommandDialog.this.dispose();
            }
        });
        this._buttonPanel.add(this._cancelButton);
        this.getContentPane().add((Component)this._buttonPanel, "South");
        this.setTitle(this.getDialogTitle());
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this._okButton);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void processJSVNEvent(JSVNUIEvent event) {
        if (event instanceof JSVNStatusEvent) {
            if (((JSVNStatusEvent)event).getStatus() == 1) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else if (((JSVNStatusEvent)event).getStatus() == 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            return;
        }
        if (event instanceof JSVNCommandEvent) {
            String error = ((JSVNCommandEvent)event).getError();
            if (error != null) {
                this.postExecute(false);
            } else {
                this.postExecute(true);
            }
        }
    }

    public abstract void actionPerformed(ActionEvent var1);
}

