/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.command.Commandable;
import com.alternatecomputing.jsvn.command.Diff;
import com.alternatecomputing.jsvn.command.WorkingCopyModifiable;
import com.alternatecomputing.jsvn.configuration.Configuration;
import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.gui.AboutDialog;
import com.alternatecomputing.jsvn.gui.Application;
import com.alternatecomputing.jsvn.gui.CenterableFrame;
import com.alternatecomputing.jsvn.gui.CheckoutDialog;
import com.alternatecomputing.jsvn.gui.DirectoryBrowserCellRenderer;
import com.alternatecomputing.jsvn.gui.DirectoryBrowserTableModel;
import com.alternatecomputing.jsvn.gui.JSVNCommandEvent;
import com.alternatecomputing.jsvn.gui.JSVNEventListener;
import com.alternatecomputing.jsvn.gui.JSVNStatusEvent;
import com.alternatecomputing.jsvn.gui.JSVNTree;
import com.alternatecomputing.jsvn.gui.JSVNUIEvent;
import com.alternatecomputing.jsvn.model.SVNTreeModel;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Frame
extends CenterableFrame
implements JSVNEventListener,
ActionListener {
    private static final char MNEMONIC_CHECKOUT = 'C';
    private static final char MNEMONIC_SET_WORKING_COPY = 'S';
    private static final char MNEMONIC_WORKING_COPY = 'W';
    private static final char MNEMONIC_REFRESH_WORKING_COPY = 'R';
    private static final char MNEMONIC_HELP = 'H';
    private static final char MNEMONIC_ABOUT = 'A';
    private static final char MNEMONIC_EXIT = 'E';
    private static final char MNEMONIC_FILE = 'F';
    private static final String CONFIRMATION = "Confirmation";
    private static final String OVERWRITE_EXISTING_FILE = "Overwrite existing file?";
    private static final String ACTION_CLOSE_TAB = "CloseTab";
    private static final String ACTION_CLOSE_ALL_TAB = "CloseAllTab";
    private static final String ACTION_CLOSE_ALL_BUT_THIS_TAB = "CloseAllButThisTab";
    private static final String ACTION_SAVE_TAB = "SaveTab";
    private static final String MENU_ITEM_FILE = "File";
    private static final String MENU_ITEM_EXIT = "Exit";
    private static final String MENU_ITEM_WORKING_COPY = "Working Copy";
    private static final String MENU_ITEM_WORKING_COPY_SET = "Set";
    private static final String MENU_ITEM_WORKING_COPY_CHECKOUT = "Checkout";
    private static final String MENU_ITEM_WORKING_COPY_REFRESH = "Refresh";
    private static final String MENU_ITEM_HELP = "Help";
    private static final String MENU_ITEM_ABOUT = "About";
    private static final String MENU_ITEM_CLOSE = "Close";
    private static final String MENU_ITEM_CLOSE_ALL = "Close All";
    private static final String MENU_ITEM_CLOSE_ALL_BUT_THIS = "Close All But This";
    private static final String MENU_ITEM_SAVE = "Save To File";
    private static final String STATUS_READY = "Ready";
    private static final String STATUS_EXECUTING = "Executing...";
    private static final String STATUS_REFRESHING = "Refreshing...";
    private static final String TAB_COMMAND_HISTORY = "Command History";
    private static final String TAB_DIRECTORY_BROWSER = "Directory Browser";
    private static final int DIRECTORY_BROWSER_TABLE_INDEX = 0;
    private JPanel content;
    private JLabel _statusBar = new JLabel("Ready");
    private JTabbedPane _outputTabbedPane = new JTabbedPane();
    private JTextPane _historyTextPane = new JTextPane();
    private JSVNTree _svnTree;
    private JPopupMenu _popupMenu;
    private JMenuItem _miCloseTab;
    private JMenuItem _miCloseAllTab;
    private JMenuItem _miCloseAllButThisTab;
    private JMenuItem _miSaveTab;
    private JTable _directoryBrowserTable;
    private DirectoryBrowserTableModel _directoryBrowserTableModel;

    public Frame() {
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.content = new JPanel();
        this.content.setPreferredSize(new Dimension(1000, 600));
        this.content.setLayout(new BorderLayout());
        JSplitPane mainSplitPane = new JSplitPane();
        this.content.add((Component)mainSplitPane, "Center");
        this.getContentPane().add((Component)this.content, "Center");
        this.setTitle("JSVN 0.9");
        this.content.add((Component)this._statusBar, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu(MENU_ITEM_FILE);
        menuFile.setMnemonic('F');
        JMenuItem fileExit = new JMenuItem(MENU_ITEM_EXIT);
        fileExit.setMnemonic('E');
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenu menuWorkingCopy = new JMenu(MENU_ITEM_WORKING_COPY);
        menuWorkingCopy.setMnemonic('W');
        JMenuItem workingCopySet = new JMenuItem(MENU_ITEM_WORKING_COPY_SET);
        workingCopySet.setMnemonic('S');
        workingCopySet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File currentWorkingDirectory;
                Configuration c = ConfigurationManager.getInstance().getConfig();
                String workingDirectory = ConfigurationManager.getInstance().getWorkingDirectory();
                JFileChooser chooser = workingDirectory != null ? ((currentWorkingDirectory = new File(workingDirectory)).exists() ? new JFileChooser(currentWorkingDirectory) : new JFileChooser()) : new JFileChooser();
                chooser.setFileSelectionMode(1);
                int action = chooser.showOpenDialog(new JFrame());
                if (action == 0) {
                    try {
                        File file = new File(chooser.getSelectedFile().getCanonicalPath());
                        c.setWorkingCopy(file.toString());
                        ConfigurationManager.getInstance().setConfig(c);
                        ConfigurationManager.getInstance().saveConfig();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                Frame.this.setWorkingCopy(ConfigurationManager.getInstance().getWorkingCopy());
            }
        });
        menuWorkingCopy.add(workingCopySet);
        JMenuItem workingCopyCheckout = new JMenuItem(MENU_ITEM_WORKING_COPY_CHECKOUT);
        workingCopyCheckout.setMnemonic('C');
        workingCopyCheckout.setEnabled(true);
        workingCopyCheckout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckoutDialog dialog = new CheckoutDialog(Application.getApplicationFrame(), true);
                dialog.setVisible(true);
            }
        });
        menuWorkingCopy.add(workingCopyCheckout);
        JMenuItem workingCopyRefresh = new JMenuItem(MENU_ITEM_WORKING_COPY_REFRESH);
        workingCopyRefresh.setMnemonic('R');
        workingCopyRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame.this._svnTree.refresh(false);
            }
        });
        menuWorkingCopy.add(workingCopyRefresh);
        JMenu menuHelp = new JMenu(MENU_ITEM_HELP);
        menuHelp.setMnemonic('H');
        JMenuItem helpAbout = new JMenuItem(MENU_ITEM_ABOUT);
        helpAbout.setMnemonic('A');
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutDialog = new AboutDialog((java.awt.Frame)Frame.this, true);
                aboutDialog.setVisible(true);
            }
        });
        menuHelp.add(helpAbout);
        menuFile.add(fileExit);
        menuBar.add(menuFile);
        menuBar.add(menuWorkingCopy);
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        ((Component)this).setBounds(new Rectangle(0, 0, 713, 384));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Frame.this.exitForm(evt);
            }
        });
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setDividerLocation(375);
        JSplitPane rightSplitPane = new JSplitPane();
        mainSplitPane.add((Component)rightSplitPane, "right");
        SVNTreeModel model = new SVNTreeModel(ConfigurationManager.getInstance().getWorkingCopy(), false);
        this._svnTree = new JSVNTree(model);
        this._svnTree.addTreeSelectionListener(new WorkingCopySelectionListener());
        JScrollPane svnPane = new JScrollPane();
        svnPane.setViewportView(this._svnTree);
        mainSplitPane.add((Component)svnPane, "left");
        this._directoryBrowserTableModel = new DirectoryBrowserTableModel();
        this._directoryBrowserTable = new JTable(this._directoryBrowserTableModel);
        DirectoryBrowserCellRenderer renderer = new DirectoryBrowserCellRenderer();
        int i = 0;
        while (i < this._directoryBrowserTable.getColumnModel().getColumnCount()) {
            TableColumn column = this._directoryBrowserTable.getColumnModel().getColumn(i);
            column.setCellRenderer(renderer);
            ++i;
        }
        this._outputTabbedPane.add((Component)new JScrollPane(this._directoryBrowserTable), TAB_DIRECTORY_BROWSER);
        rightSplitPane.setOrientation(0);
        rightSplitPane.setOneTouchExpandable(true);
        rightSplitPane.setDividerLocation(450);
        rightSplitPane.setResizeWeight(1.0);
        JTabbedPane historyTabbedPane = new JTabbedPane();
        rightSplitPane.add((Component)historyTabbedPane, "bottom");
        rightSplitPane.add((Component)this._outputTabbedPane, "top");
        this._historyTextPane.setText("");
        this._historyTextPane.setEditable(false);
        JScrollPane historyPane = new JScrollPane();
        historyPane.setViewportView(this._historyTextPane);
        historyTabbedPane.setSize(new Dimension(633, 174));
        historyTabbedPane.setSize(new Dimension(633, 174));
        historyTabbedPane.add((Component)historyPane, TAB_COMMAND_HISTORY);
        this._popupMenu = new JPopupMenu();
        this._miCloseTab = new JMenuItem(MENU_ITEM_CLOSE);
        this._miCloseTab.addActionListener(this);
        this._miCloseTab.setActionCommand(ACTION_CLOSE_TAB);
        this._popupMenu.add(this._miCloseTab);
        this._miCloseAllButThisTab = new JMenuItem(MENU_ITEM_CLOSE_ALL_BUT_THIS);
        this._miCloseAllButThisTab.addActionListener(this);
        this._miCloseAllButThisTab.setActionCommand(ACTION_CLOSE_ALL_BUT_THIS_TAB);
        this._popupMenu.add(this._miCloseAllButThisTab);
        this._miCloseAllTab = new JMenuItem(MENU_ITEM_CLOSE_ALL);
        this._miCloseAllTab.addActionListener(this);
        this._miCloseAllTab.setActionCommand(ACTION_CLOSE_ALL_TAB);
        this._popupMenu.add(this._miCloseAllTab);
        this._miSaveTab = new JMenuItem(MENU_ITEM_SAVE);
        this._miSaveTab.addActionListener(this);
        this._miSaveTab.setActionCommand(ACTION_SAVE_TAB);
        this._popupMenu.add(this._miSaveTab);
        this._outputTabbedPane.addMouseListener(new MouseAdapter(){

            private void popup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int tabCount = Frame.this._outputTabbedPane.getTabCount();
                    if (tabCount > 0) {
                        if (tabCount > 1) {
                            Frame.this._miCloseAllTab.setEnabled(true);
                            Frame.this._miCloseAllButThisTab.setEnabled(true);
                        } else {
                            Frame.this._miCloseAllTab.setEnabled(false);
                            Frame.this._miCloseAllButThisTab.setEnabled(false);
                        }
                        Frame.this._popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                    if (Frame.this._outputTabbedPane.getSelectedIndex() == 0) {
                        Frame.this._miSaveTab.setEnabled(false);
                        Frame.this._miCloseTab.setEnabled(false);
                    } else {
                        Frame.this._miSaveTab.setEnabled(true);
                        Frame.this._miCloseTab.setEnabled(true);
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.popup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }
        });
    }

    public void setWorkingCopy(String workingCopy) {
        SVNTreeModel svnTreeModel = new SVNTreeModel(workingCopy, false);
        this._svnTree.setModel(new DefaultTreeModel(JSVNTree.buildTreeNode(svnTreeModel)));
    }

    private void addHighlightersToTextPane(JEditorPane newPane, char addition, char removal) {
        DefaultHighlighter.DefaultHighlightPainter addPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(196, 255, 196));
        DefaultHighlighter.DefaultHighlightPainter removePainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(196, 196, 255));
        Document doc = newPane.getDocument();
        try {
            String body = doc.getText(0, doc.getLength());
            int startPos = body.indexOf(addition);
            int endPos = 0;
            while (startPos != -1) {
                endPos = body.indexOf(10, startPos);
                if (body.charAt(startPos - 1) == '\n') {
                    newPane.getHighlighter().addHighlight(startPos, endPos, addPainter);
                }
                startPos = body.indexOf(addition, endPos);
            }
            startPos = body.indexOf(removal);
            while (startPos != -1) {
                int pos;
                endPos = body.indexOf(10, startPos);
                int n = pos = startPos > 0 ? startPos - 1 : 0;
                if (body.charAt(pos) == '\n' || pos == 0) {
                    newPane.getHighlighter().addHighlight(startPos, endPos, removePainter);
                }
                startPos = body.indexOf(removal, endPos);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_CLOSE_TAB)) {
            this._outputTabbedPane.remove(this._outputTabbedPane.getSelectedIndex());
            return;
        } else if (e.getActionCommand().equals(ACTION_CLOSE_ALL_TAB)) {
            int i = this._outputTabbedPane.getTabCount();
            while (i > 1) {
                this._outputTabbedPane.remove(i - 1);
                --i;
            }
            return;
        } else if (e.getActionCommand().equals(ACTION_CLOSE_ALL_BUT_THIS_TAB)) {
            int index = this._outputTabbedPane.getSelectedIndex();
            int i = this._outputTabbedPane.getTabCount() - 1;
            while (i > index) {
                this._outputTabbedPane.remove(i);
                --i;
            }
            int i2 = 1;
            while (i2 < index) {
                this._outputTabbedPane.remove(1);
                ++i2;
            }
            return;
        } else {
            File currentWorkingDirectory;
            if (!e.getActionCommand().equals(ACTION_SAVE_TAB)) return;
            String workingDirectory = ConfigurationManager.getInstance().getWorkingDirectory();
            JFileChooser chooser = workingDirectory != null ? ((currentWorkingDirectory = new File(workingDirectory)).exists() ? new JFileChooser(currentWorkingDirectory) : new JFileChooser()) : new JFileChooser();
            chooser.setFileSelectionMode(2);
            int action = chooser.showOpenDialog(new JFrame());
            if (action != 0) return;
            try {
                File file = new File(chooser.getSelectedFile().getCanonicalPath());
                if (file.exists()) {
                    int confirmation = JOptionPane.showConfirmDialog(this, OVERWRITE_EXISTING_FILE, CONFIRMATION, 2);
                    if (confirmation != 0) return;
                    this.writeSelectedTabToFile(file);
                    return;
                }
                this.writeSelectedTabToFile(file);
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void writeSelectedTabToFile(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        JScrollPane scrollpane = (JScrollPane)this._outputTabbedPane.getSelectedComponent();
        JTextPane textPane = (JTextPane)scrollpane.getViewport().getComponent(0);
        writer.write(textPane.getText());
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public JPanel getContent() {
        return this.content;
    }

    public void processJSVNEvent(JSVNUIEvent event) {
        if (event instanceof JSVNStatusEvent) {
            if (((JSVNStatusEvent)event).getStatus() == 1) {
                this._statusBar.setText(STATUS_EXECUTING);
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else if (((JSVNStatusEvent)event).getStatus() == 0) {
                this._statusBar.setText(STATUS_READY);
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (((JSVNStatusEvent)event).getStatus() == 2) {
                this._statusBar.setText(STATUS_REFRESHING);
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            return;
        }
        if (event instanceof JSVNCommandEvent) {
            String error = ((JSVNCommandEvent)event).getError();
            if (error != null) {
                JOptionPane.showMessageDialog(Application.getApplicationFrame().getContentPane(), error);
            } else {
                Commandable command = ((JSVNCommandEvent)event).getCommand();
                String result = ((JSVNCommandEvent)event).getResult();
                String[] commandStrings = command.getCommand();
                StringBuffer commandString = new StringBuffer(this._historyTextPane.getText());
                int i = 0;
                while (i < commandStrings.length) {
                    commandString.append(commandStrings[i]);
                    commandString.append(" ");
                    ++i;
                }
                commandString.append("\n");
                this._historyTextPane.setText(commandString.toString());
                JTextPane newPane = new JTextPane();
                Font fixedFont = new Font("Monospaced", 0, 10);
                newPane.setFont(fixedFont);
                newPane.setText(result);
                newPane.setEditable(false);
                if (command instanceof Diff) {
                    if (command.getArgs().get("EXTENSIONS") != null) {
                        this.addHighlightersToTextPane(newPane, '>', '<');
                    } else {
                        this.addHighlightersToTextPane(newPane, '+', '-');
                    }
                }
                JScrollPane scrollPane = new JScrollPane(newPane);
                String commandName = command.getClass().getName();
                this._outputTabbedPane.add(commandName.substring(commandName.lastIndexOf(".") + 1), scrollPane);
                this._outputTabbedPane.setSelectedIndex(this._outputTabbedPane.getTabCount() - 1);
                if (command instanceof WorkingCopyModifiable) {
                    this._svnTree.refresh(false);
                }
            }
        }
    }

    private String buildFileName(DefaultMutableTreeNode node) {
        StringTokenizer token = new StringTokenizer(node.toString(), " ");
        String name = token.nextToken();
        switch (node.getLevel()) {
            case 0: {
                return ConfigurationManager.getInstance().getWorkingCopy();
            }
            case 1: {
                return ConfigurationManager.getInstance().getWorkingCopy() + "/" + name;
            }
        }
        return this.buildFileName((DefaultMutableTreeNode)node.getParent()) + "/" + name;
    }

    public String getWorkingCopy() {
        return ConfigurationManager.getInstance().getWorkingCopy();
    }

    private class WorkingCopySelectionListener
    implements TreeSelectionListener {
        private WorkingCopySelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)Frame.this._svnTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            SVNTreeNodeData svnNode = (SVNTreeNodeData)node.getUserObject();
            String fileName = Frame.this.buildFileName(node);
            File file = new File(fileName);
            if (Frame.this._directoryBrowserTableModel != null) {
                if (file.isDirectory()) {
                    Frame.this._directoryBrowserTableModel.setPathToBrowse(svnNode, file);
                } else {
                    Frame.this._directoryBrowserTableModel.clearPathToBrowse();
                }
            }
        }
    }
}

