/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.gui.JTextFieldLimit;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JLimitedTextField
extends JTextField
implements Serializable,
Cloneable {
    private int maxLength;
    private boolean upperCase = false;
    private JTextFieldLimit doc;
    private static final int DEFAULT_MAX_LENGTH = 255;
    private boolean pbLastKeyEventWasAlt = false;

    public JLimitedTextField() {
        try {
            this.doc = new JTextFieldLimit(255);
            ((JTextComponent)this).setDocument(this.doc);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JLimitedTextField(int maxlength) {
        try {
            this.doc = new JTextFieldLimit(maxlength);
            ((JTextComponent)this).setDocument(this.doc);
            this.setMaxLength(maxlength);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JLimitedTextField(int maxlength, boolean makeUpperCase) {
        try {
            ((JTextComponent)this).setDocument(new JTextFieldLimit(maxlength, makeUpperCase));
            this.setMaxLength(maxlength);
            this.setUpperCase(makeUpperCase);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JLimitedTextField.this.this_mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                JLimitedTextField.this.this_mouseExited(e);
            }
        });
    }

    void this_mouseEntered(MouseEvent e) {
        if (this.isEditable()) {
            this.setCursor(new Cursor(2));
        }
    }

    void this_mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public void setMaxLength(int newMaxLength) {
        this.maxLength = newMaxLength;
        this.doc.setMaxLength(this.getMaxLength());
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setUpperCase(boolean newIsUpperCase) {
        this.upperCase = newIsUpperCase;
        this.doc.setIsUpperCase(this.isUpperCase());
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setEnabled(boolean parm1) {
        if (!parm1) {
            this.setBackground(Color.lightGray);
        }
        super.setEnabled(parm1);
    }

    public void setEditable(boolean parm1) {
        if (!parm1) {
            this.setBackground(Color.lightGray);
        }
        super.setEditable(parm1);
    }

    public boolean isDirty() {
        return this.doc.isDirty();
    }

    public void resetDirtyFlag() {
        this.doc.setIsDirty(false);
    }

    protected void processComponentKeyEvent(KeyEvent evt) {
        super.processComponentKeyEvent(evt);
        this.pbLastKeyEventWasAlt = evt.isAltDown();
    }

    protected void processInputMethodEvent(InputMethodEvent evt) {
        if (this.pbLastKeyEventWasAlt) {
            evt.consume();
        }
        this.doc.setIsDirty(true);
        super.processInputMethodEvent(evt);
    }
}

