/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.gui;

import com.alternatecomputing.jsvn.command.Add;
import com.alternatecomputing.jsvn.command.Cleanup;
import com.alternatecomputing.jsvn.command.Commandable;
import com.alternatecomputing.jsvn.command.Delete;
import com.alternatecomputing.jsvn.command.Info;
import com.alternatecomputing.jsvn.command.Resolve;
import com.alternatecomputing.jsvn.command.Revert;
import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.gui.Application;
import com.alternatecomputing.jsvn.gui.CatDialog;
import com.alternatecomputing.jsvn.gui.CheckoutDialog;
import com.alternatecomputing.jsvn.gui.CommandDialog;
import com.alternatecomputing.jsvn.gui.CommitDialog;
import com.alternatecomputing.jsvn.gui.CopyDialog;
import com.alternatecomputing.jsvn.gui.DiffDialog;
import com.alternatecomputing.jsvn.gui.JSVNCommandExecutor;
import com.alternatecomputing.jsvn.gui.JSVNStatusEvent;
import com.alternatecomputing.jsvn.gui.JSVNTreeCellRenderer;
import com.alternatecomputing.jsvn.gui.LogDialog;
import com.alternatecomputing.jsvn.gui.MergeDialog;
import com.alternatecomputing.jsvn.gui.MkdirDialog;
import com.alternatecomputing.jsvn.gui.MoveDialog;
import com.alternatecomputing.jsvn.gui.StatusDialog;
import com.alternatecomputing.jsvn.gui.SwitchDialog;
import com.alternatecomputing.jsvn.gui.UpdateDialog;
import com.alternatecomputing.jsvn.model.SVNTreeModel;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JSVNTree
extends JTree
implements ActionListener {
    private static final String CONFIRMATION = "Confirmation";
    private static final String CLEANUP_ERROR = "The following item is not a directory:\n\n";
    private static final String RESOLVE_WARNING = "You are about to resolve the following items:\n\n";
    private static final String REVERT_WARNING = "You are about to revert the following items:\n\n";
    private static final String ACTION_ADD = "Add";
    private static final String ACTION_CAT = "Cat";
    private static final String ACTION_CHECKOUT = "Checkout";
    private static final String ACTION_CLEANUP = "Cleanup";
    private static final String ACTION_COMMIT = "Commit";
    private static final String ACTION_COPY = "Copy";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_DIFF = "Diff";
    private static final String ACTION_INFO = "Info";
    private static final String ACTION_IMPORT = "Import";
    private static final String ACTION_LOG = "Log";
    private static final String ACTION_MERGE = "Merge";
    private static final String ACTION_MKDIR = "Mkdir";
    private static final String ACTION_MOVE = "Move";
    private static final String ACTION_PROPERTY = "Property";
    private static final String ACTION_PROPDEL = "PropDel";
    private static final String ACTION_PROPEDIT = "PropEdit";
    private static final String ACTION_PROPGET = "PropGet";
    private static final String ACTION_PROPLIST = "PropList";
    private static final String ACTION_PROPSET = "PropSet";
    private static final String ACTION_REFRESH_RECURSIVELY = "Refresh Recursively";
    private static final String ACTION_REFRESH_ONLINE = "Online";
    private static final String ACTION_REFRESH_OFFLINE = "Local";
    private static final String ACTION_RESOLVE = "Resolve";
    private static final String ACTION_REVERT = "Revert";
    private static final String ACTION_STATUS = "Status";
    private static final String ACTION_SWITCH = "Switch";
    private static final String ACTION_UPDATE = "Update";
    private JPopupMenu mainPopup;
    private JMenuItem miAdd;
    private JMenuItem miCat;
    private JMenuItem miCheckout;
    private JMenuItem miCleanup;
    private JMenuItem miCommit;
    private JMenuItem miDelete;
    private JMenuItem miDiff;
    private JMenuItem miImport;
    private JMenuItem miCopy;
    private JMenuItem miResolve;
    private JMenuItem miMerge;
    private JMenuItem miMkDir;
    private JMenuItem miMove;
    private JMenuItem miRevert;
    private JMenuItem miSwitch;
    private JMenuItem miUpdate;
    private JMenuItem miInfo;
    private JMenuItem miLog;
    private JMenuItem miStatus;
    private JMenuItem miPropList;
    private JMenuItem miPropGet;
    private JMenuItem miPropSet;
    private JMenuItem miPropEdit;
    private JMenuItem miPropDel;
    private JMenuItem miRefreshOnline;
    private JMenuItem miRefreshOffline;

    public JSVNTree(SVNTreeModel root) {
        this.setModel(new DefaultTreeModel(JSVNTree.buildTreeNode(root).getRoot()));
        this.mainPopup = new JPopupMenu();
        this.miAdd = new JMenuItem(ACTION_ADD);
        this.miAdd.addActionListener(this);
        this.miAdd.setActionCommand(ACTION_ADD);
        this.mainPopup.add(this.miAdd);
        this.miCat = new JMenuItem(ACTION_CAT);
        this.miCat.addActionListener(this);
        this.miCat.setActionCommand(ACTION_CAT);
        this.miCat.setEnabled(true);
        this.mainPopup.add(this.miCat);
        this.miCheckout = new JMenuItem(ACTION_CHECKOUT);
        this.miCheckout.addActionListener(this);
        this.miCheckout.setActionCommand(ACTION_CHECKOUT);
        this.miCheckout.setEnabled(true);
        this.mainPopup.add(this.miCheckout);
        this.miCleanup = new JMenuItem(ACTION_CLEANUP);
        this.miCleanup.addActionListener(this);
        this.miCleanup.setActionCommand(ACTION_CLEANUP);
        this.miCleanup.setEnabled(true);
        this.mainPopup.add(this.miCleanup);
        this.miCommit = new JMenuItem(ACTION_COMMIT);
        this.miCommit.addActionListener(this);
        this.miCommit.setActionCommand(ACTION_COMMIT);
        this.mainPopup.add(this.miCommit);
        this.miCopy = new JMenuItem(ACTION_COPY);
        this.miCopy.addActionListener(this);
        this.miCopy.setActionCommand(ACTION_COPY);
        this.miCopy.setEnabled(true);
        this.mainPopup.add(this.miCopy);
        this.miDelete = new JMenuItem(ACTION_DELETE);
        this.miDelete.addActionListener(this);
        this.miDelete.setActionCommand(ACTION_DELETE);
        this.miDelete.setEnabled(true);
        this.mainPopup.add(this.miDelete);
        this.miDiff = new JMenuItem(ACTION_DIFF);
        this.miDiff.addActionListener(this);
        this.miDiff.setActionCommand(ACTION_DIFF);
        this.mainPopup.add(this.miDiff);
        this.miImport = new JMenuItem(ACTION_IMPORT);
        this.miImport.addActionListener(this);
        this.miImport.setActionCommand(ACTION_IMPORT);
        this.miImport.setEnabled(false);
        this.mainPopup.add(this.miImport);
        this.miMerge = new JMenuItem(ACTION_MERGE);
        this.miMerge.addActionListener(this);
        this.miMerge.setActionCommand(ACTION_MERGE);
        this.miMerge.setEnabled(true);
        this.mainPopup.add(this.miMerge);
        this.miMkDir = new JMenuItem(ACTION_MKDIR);
        this.miMkDir.addActionListener(this);
        this.miMkDir.setActionCommand(ACTION_MKDIR);
        this.miMkDir.setEnabled(true);
        this.mainPopup.add(this.miMkDir);
        this.miMove = new JMenuItem(ACTION_MOVE);
        this.miMove.addActionListener(this);
        this.miMove.setActionCommand(ACTION_MOVE);
        this.miMove.setEnabled(true);
        this.mainPopup.add(this.miMove);
        this.miResolve = new JMenuItem(ACTION_RESOLVE);
        this.miResolve.addActionListener(this);
        this.miResolve.setActionCommand(ACTION_RESOLVE);
        this.miResolve.setEnabled(true);
        this.mainPopup.add(this.miResolve);
        this.miRevert = new JMenuItem(ACTION_REVERT);
        this.miRevert.addActionListener(this);
        this.miRevert.setActionCommand(ACTION_REVERT);
        this.miRevert.setEnabled(true);
        this.mainPopup.add(this.miRevert);
        this.miSwitch = new JMenuItem(ACTION_SWITCH);
        this.miSwitch.addActionListener(this);
        this.miSwitch.setActionCommand(ACTION_SWITCH);
        this.miSwitch.setEnabled(true);
        this.mainPopup.add(this.miSwitch);
        this.miUpdate = new JMenuItem(ACTION_UPDATE);
        this.miUpdate.addActionListener(this);
        this.miUpdate.setActionCommand(ACTION_UPDATE);
        this.miUpdate.setEnabled(true);
        this.mainPopup.add(this.miUpdate);
        this.mainPopup.add(new JPopupMenu.Separator());
        this.miInfo = new JMenuItem(ACTION_INFO);
        this.miInfo.addActionListener(this);
        this.miInfo.setActionCommand(ACTION_INFO);
        this.mainPopup.add(this.miInfo);
        this.miLog = new JMenuItem(ACTION_LOG);
        this.miLog.addActionListener(this);
        this.miLog.setActionCommand(ACTION_LOG);
        this.mainPopup.add(this.miLog);
        this.miStatus = new JMenuItem(ACTION_STATUS);
        this.miStatus.addActionListener(this);
        this.miStatus.setActionCommand(ACTION_STATUS);
        this.mainPopup.add(this.miStatus);
        this.mainPopup.add(new JPopupMenu.Separator());
        JMenu propertyMenu = new JMenu(ACTION_PROPERTY);
        this.miPropList = new JMenuItem(ACTION_PROPLIST);
        this.miPropList.addActionListener(this);
        this.miPropList.setActionCommand(ACTION_PROPLIST);
        this.miPropList.setEnabled(false);
        propertyMenu.add(this.miPropList);
        this.miPropGet = new JMenuItem(ACTION_PROPGET);
        this.miPropGet.addActionListener(this);
        this.miPropGet.setActionCommand(ACTION_PROPGET);
        this.miPropGet.setEnabled(false);
        propertyMenu.add(this.miPropGet);
        this.miPropSet = new JMenuItem(ACTION_PROPSET);
        this.miPropSet.addActionListener(this);
        this.miPropSet.setActionCommand(ACTION_PROPSET);
        this.miPropSet.setEnabled(false);
        propertyMenu.add(this.miPropSet);
        this.miPropEdit = new JMenuItem(ACTION_PROPEDIT);
        this.miPropEdit.addActionListener(this);
        this.miPropEdit.setActionCommand(ACTION_PROPEDIT);
        this.miPropEdit.setEnabled(false);
        propertyMenu.add(this.miPropEdit);
        this.miPropDel = new JMenuItem(ACTION_PROPDEL);
        this.miPropDel.addActionListener(this);
        this.miPropDel.setActionCommand(ACTION_PROPDEL);
        this.miPropDel.setEnabled(false);
        propertyMenu.add(this.miPropDel);
        this.mainPopup.add(propertyMenu);
        this.mainPopup.add(new JPopupMenu.Separator());
        JMenu refreshMenu = new JMenu(ACTION_REFRESH_RECURSIVELY);
        this.miRefreshOffline = new JMenuItem(ACTION_REFRESH_OFFLINE);
        this.miRefreshOffline.addActionListener(this);
        this.miRefreshOffline.setActionCommand(ACTION_REFRESH_OFFLINE);
        refreshMenu.add(this.miRefreshOffline);
        this.miRefreshOnline = new JMenuItem(ACTION_REFRESH_ONLINE);
        this.miRefreshOnline.addActionListener(this);
        this.miRefreshOnline.setActionCommand(ACTION_REFRESH_ONLINE);
        refreshMenu.add(this.miRefreshOnline);
        this.mainPopup.add(refreshMenu);
        this.mainPopup.setOpaque(true);
        this.mainPopup.setLightWeightPopupEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            private void popup(MouseEvent e) {
                if (e.isPopupTrigger() && JSVNTree.this.getSelectedTargetsAsString() != null) {
                    if (JSVNTree.this.getSelectedTargetsAsArray().length > 1) {
                        JSVNTree.this.miCat.setEnabled(false);
                        JSVNTree.this.miCopy.setEnabled(false);
                        JSVNTree.this.miMerge.setEnabled(false);
                        JSVNTree.this.miMove.setEnabled(false);
                    } else {
                        JSVNTree.this.miCat.setEnabled(true);
                        JSVNTree.this.miCopy.setEnabled(true);
                        JSVNTree.this.miMerge.setEnabled(true);
                        JSVNTree.this.miMove.setEnabled(true);
                    }
                    JSVNTree.this.mainPopup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                this.popup(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.popup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.popup(e);
            }
        });
        this.setCellRenderer(new JSVNTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public static DefaultMutableTreeNode buildTreeNode(SVNTreeModel svnTreeModel) {
        if (svnTreeModel.getRoot() == null) {
            return new DefaultMutableTreeNode();
        }
        return JSVNTree.buildTreeNode(svnTreeModel.getRoot());
    }

    public static DefaultMutableTreeNode buildTreeNode(SVNTreeNodeData svnTreeNode) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(svnTreeNode);
        Iterator iterator = svnTreeNode.getChildren().iterator();
        while (iterator.hasNext()) {
            SVNTreeNodeData svnTreeNodeData = (SVNTreeNodeData)iterator.next();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
            newNode.setUserObject(svnTreeNodeData);
            DefaultMutableTreeNode newChild = JSVNTree.buildTreeNode(svnTreeNodeData);
            if (newChild == null) continue;
            rootNode.add(newChild);
        }
        return rootNode;
    }

    public void actionPerformed(ActionEvent ae) {
        String targets = this.getSelectedTargetsAsString();
        if (targets != null) {
            if (ae.getActionCommand().equals(ACTION_ADD)) {
                Add command = new Add();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("TARGETS", targets);
                this.executeCommand(command, args);
            } else if (ae.getActionCommand().equals(ACTION_CAT)) {
                CatDialog dialog = new CatDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_CHECKOUT)) {
                CheckoutDialog dialog = new CheckoutDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_CLEANUP)) {
                TreePath[] paths = this.getSelectionPaths();
                int i = 0;
                while (i < paths.length) {
                    TreePath path = paths[i];
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
                    SVNTreeNodeData svnNode = (SVNTreeNodeData)dmtn.getUserObject();
                    if (svnNode.getNodeKind() != 1) {
                        this.showMessageDialog(CLEANUP_ERROR + svnNode.getPath());
                        return;
                    }
                    ++i;
                }
                Cleanup command = new Cleanup();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("TARGETS", targets);
                this.executeCommand(command, args);
            } else if (ae.getActionCommand().equals(ACTION_COMMIT)) {
                CommitDialog dialog = new CommitDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_COPY)) {
                CopyDialog dialog = new CopyDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_DELETE)) {
                Delete command = new Delete();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("TARGETS", targets);
                this.executeCommand(command, args);
            } else if (ae.getActionCommand().equals(ACTION_DIFF)) {
                DiffDialog dialog = new DiffDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_INFO)) {
                Info command = new Info();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("TARGETS", targets);
                this.executeCommand(command, args);
            } else if (ae.getActionCommand().equals(ACTION_LOG)) {
                LogDialog dialog = new LogDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_MERGE)) {
                MergeDialog dialog = new MergeDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_MKDIR)) {
                MkdirDialog dialog = new MkdirDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_MOVE)) {
                MoveDialog dialog = new MoveDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_REFRESH_ONLINE)) {
                this.refreshSelectedTargets(true);
            } else if (ae.getActionCommand().equals(ACTION_REFRESH_OFFLINE)) {
                this.refreshSelectedTargets(false);
            } else if (ae.getActionCommand().equals(ACTION_RESOLVE)) {
                String message = RESOLVE_WARNING;
                String[] targetArray = this.getSelectedTargetsAsArray();
                int i = 0;
                while (i < targetArray.length) {
                    String s = targetArray[i];
                    message = message + s + "\n";
                    ++i;
                }
                int confirmation = JOptionPane.showConfirmDialog(this, message, CONFIRMATION, 2);
                if (confirmation == 0) {
                    Resolve command = new Resolve();
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("TARGETS", targets);
                    this.executeCommand(command, args);
                }
            } else if (ae.getActionCommand().equals(ACTION_REVERT)) {
                String message = REVERT_WARNING;
                String[] targetArray = this.getSelectedTargetsAsArray();
                int i = 0;
                while (i < targetArray.length) {
                    String s = targetArray[i];
                    message = message + s + "\n";
                    ++i;
                }
                int confirmation = JOptionPane.showConfirmDialog(this, message, CONFIRMATION, 2);
                if (confirmation == 0) {
                    Revert command = new Revert();
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("TARGETS", targets);
                    this.executeCommand(command, args);
                }
            } else if (ae.getActionCommand().equals(ACTION_STATUS)) {
                StatusDialog dialog = new StatusDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_SWITCH)) {
                SwitchDialog dialog = new SwitchDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            } else if (ae.getActionCommand().equals(ACTION_UPDATE)) {
                UpdateDialog dialog = new UpdateDialog(Application.getApplicationFrame(), true);
                this.initializeAndShowDialog(dialog, targets);
            }
        }
    }

    private void initializeAndShowDialog(CommandDialog dialog, String targets) {
        dialog.setTargets(targets);
        dialog.setVisible(true);
    }

    private void executeCommand(Commandable command, Map args) {
        JSVNCommandExecutor executor = new JSVNCommandExecutor(command, args);
        executor.addJSVNEventListener(Application.getApplicationFrame());
        Thread t = new Thread(executor);
        t.start();
    }

    private void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(Application.getApplicationFrame().getContentPane(), message);
    }

    private String getSelectedTargetsAsString() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        StringBuffer targets = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            SVNTreeNodeData svnNode = (SVNTreeNodeData)dmtn.getUserObject();
            targets.append(ConfigurationManager.getInstance().getWorkingDirectory());
            targets.append(svnNode.getPath()).append(" ");
            String target = ConfigurationManager.getInstance().getWorkingDirectory() + svnNode.getPath();
            ++i;
        }
        return targets.toString().trim();
    }

    private String[] getSelectedTargetsAsArray() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        String[] targets = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            SVNTreeNodeData svnNode = (SVNTreeNodeData)dmtn.getUserObject();
            targets[i] = ConfigurationManager.getInstance().getWorkingDirectory() + svnNode.getPath();
            ++i;
        }
        return targets;
    }

    public void refresh(boolean online) {
        this.refresh((DefaultMutableTreeNode)this.getModel().getRoot(), online);
    }

    private void refreshSelectedTargets(boolean online) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.refresh(dmtn, online);
                ++i;
            }
        }
    }

    private void refresh(final DefaultMutableTreeNode node, final boolean online) {
        SVNTreeNodeData nodeData = (SVNTreeNodeData)node.getUserObject();
        if (nodeData == null) {
            return;
        }
        final String workingCopy = ConfigurationManager.getInstance().getWorkingDirectory() + nodeData.getPath();
        Thread t = new Thread(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Application.getApplicationFrame().processJSVNEvent(new JSVNStatusEvent(2));
                    }
                });
                SVNTreeModel partialModel = new SVNTreeModel(workingCopy, online);
                DefaultMutableTreeNode foo = JSVNTree.buildTreeNode(partialModel);
                JSVNTree.this.reconcileNodes(node, foo);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Application.getApplicationFrame().processJSVNEvent(new JSVNStatusEvent(0));
                    }
                });
            }
        });
        t.start();
    }

    private void reconcileNodes(DefaultMutableTreeNode original, DefaultMutableTreeNode updated) {
        int insertionPoint;
        SVNTreeNodeData updatedData;
        SVNTreeNodeData originalData = (SVNTreeNodeData)original.getUserObject();
        if (!originalData.equals(updatedData = (SVNTreeNodeData)updated.getUserObject())) {
            originalData.copyNodeValues(updatedData);
        }
        int originalChildCount = original.getChildCount();
        int i = insertionPoint = 0;
        while (i < originalChildCount) {
            boolean found = false;
            DefaultMutableTreeNode originalChildNode = (DefaultMutableTreeNode)original.getChildAt(insertionPoint);
            SVNTreeNodeData originalChildData = (SVNTreeNodeData)originalChildNode.getUserObject();
            while (updated.children().hasMoreElements()) {
                DefaultMutableTreeNode updatedChildNode = (DefaultMutableTreeNode)updated.children().nextElement();
                SVNTreeNodeData updatedChildData = (SVNTreeNodeData)updatedChildNode.getUserObject();
                if (originalChildData.getPath().equals(updatedChildData.getPath())) {
                    ++insertionPoint;
                    found = true;
                    updated.remove(updatedChildNode);
                    if (!originalChildData.equals(updatedChildData)) {
                        originalChildData.copyNodeValues(updatedChildData);
                        this.reconcileNodes(originalChildNode, updatedChildNode);
                        ((DefaultTreeModel)this.getModel()).nodeChanged(originalChildNode);
                        break;
                    }
                    this.reconcileNodes(originalChildNode, updatedChildNode);
                    break;
                }
                if (updatedChildData.getPath().compareTo(originalChildData.getPath()) >= 0) break;
                original.insert(updatedChildNode, insertionPoint);
                ((DefaultTreeModel)this.getModel()).nodesWereInserted(original, new int[]{insertionPoint++});
            }
            if (!found) {
                original.remove(insertionPoint);
                ((DefaultTreeModel)this.getModel()).nodesWereRemoved(original, new int[]{insertionPoint}, new Object[]{originalChildNode});
            }
            ++i;
        }
        while (updated.children().hasMoreElements()) {
            DefaultMutableTreeNode updatedChildNode = (DefaultMutableTreeNode)updated.children().nextElement();
            original.add(updatedChildNode);
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(original, new int[]{insertionPoint++});
        }
    }
}

