/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.model;

import com.alternatecomputing.jsvn.configuration.ConfigurationManager;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Parser {
    private static final int FILE_STATUS_POS = 0;
    private static final int PROPERTY_STATUS_POS = 1;
    private static final int LOCKED_STATUS_POS = 2;
    private static final int WITH_HISTORY_POS = 3;
    private static final int SWITCHED_POS = 4;
    private static final int OUTDATED_POS = 7;
    private static final String HEAD_REVISION_PREFIX = "Head revision";
    private static final String STATUS_AGAINST_REVISION_PREFIX = "Status against revision";

    public static SVNTreeNodeData parse(String result) throws IOException {
        HashMap<File, SVNTreeNodeData> nodeCache = new HashMap<File, SVNTreeNodeData>();
        SVNTreeNodeData root = null;
        String wkdirpath = new File(ConfigurationManager.getInstance().getWorkingDirectory()).getCanonicalPath();
        String[] sortedEntries = Parser.sortByFileName(result);
        int i = 0;
        while (i < sortedEntries.length) {
            String item = sortedEntries[i];
            if (!item.startsWith(HEAD_REVISION_PREFIX) && !item.startsWith(STATUS_AGAINST_REVISION_PREFIX)) {
                File localItem;
                String fileStatus = item.substring(0, 1);
                String propertyStatus = item.substring(1, 2);
                String lockedIndicator = item.substring(2, 3);
                String historyIndicator = item.substring(3, 4);
                String switchedIndicator = item.substring(4, 5);
                String outdatedIndicator = item.substring(7, 8);
                item = item.substring(8);
                SVNTreeNodeData nodeData = new SVNTreeNodeData();
                Parser.handleFileStatus(fileStatus, nodeData);
                if (fileStatus.equals("?")) {
                    localItem = new File(item.trim());
                    nodeData.setPath(Parser.getPathRelativeToWorkingCopy(localItem, wkdirpath));
                    nodeData.setName(localItem.getName());
                    nodeData.setRevision(-1);
                    nodeData.setLastChangedRevision(-1);
                    nodeData.setLastChangedAuthor(null);
                } else {
                    Parser.handlePropertyStatus(propertyStatus, nodeData);
                    Parser.handleLockedIndicator(lockedIndicator, nodeData);
                    Parser.handleHistoryIndicator(historyIndicator, nodeData);
                    Parser.handleSwitchedIndicator(switchedIndicator, nodeData);
                    Parser.handleOutDatedIndicator(outdatedIndicator, nodeData);
                    StringTokenizer st = new StringTokenizer(item, " ");
                    String token = st.nextToken();
                    if (token.equals("-")) {
                        nodeData.setRevision(-1);
                    } else {
                        try {
                            nodeData.setRevision(Integer.parseInt(token));
                        }
                        catch (NumberFormatException e) {
                            nodeData.setRevision(-2);
                        }
                    }
                    token = st.nextToken();
                    if (token.equals("?")) {
                        nodeData.setLastChangedRevision(-1);
                    } else {
                        nodeData.setLastChangedRevision(Integer.parseInt(token));
                    }
                    token = st.nextToken();
                    if (st.hasMoreTokens()) {
                        nodeData.setLastChangedAuthor(token);
                        String fileName = st.nextToken("");
                        localItem = new File(fileName.trim());
                        nodeData.setPath(Parser.getPathRelativeToWorkingCopy(localItem, wkdirpath));
                        nodeData.setName(localItem.getName());
                    } else {
                        localItem = new File(token.trim());
                        nodeData.setPath(Parser.getPathRelativeToWorkingCopy(localItem, wkdirpath));
                        nodeData.setName(localItem.getName());
                    }
                }
                if (localItem.isDirectory()) {
                    nodeData.setNodeKind(1);
                } else {
                    nodeData.setNodeKind(0);
                }
                SVNTreeNodeData parent = (SVNTreeNodeData)nodeCache.get(localItem.getParentFile());
                if (parent == null) {
                    parent = nodeData;
                    root = nodeData;
                } else {
                    parent.getChildren().add(nodeData);
                }
                nodeCache.put(localItem, nodeData);
            }
            ++i;
        }
        return root;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] sortByFileName(String statusOutput) throws IOException {
        String item;
        FileNameComparator comparator = new FileNameComparator();
        TreeSet<void> sortedSet = new TreeSet<void>(comparator);
        BufferedReader reader = new BufferedReader(new StringReader(statusOutput));
        while ((item = reader.readLine()) != null) {
            void var4_4;
            sortedSet.add(var4_4);
        }
        return sortedSet.toArray(new String[0]);
    }

    private static String getPathRelativeToWorkingCopy(File localItem, String wkdirpath) throws IOException {
        return localItem.getCanonicalPath().substring(wkdirpath.length() + 1);
    }

    private static void handleFileStatus(String fileStatus, SVNTreeNodeData nodeData) {
        if ((fileStatus = fileStatus.intern()) == " ") {
            nodeData.setFileStatus(0);
        } else if (fileStatus == "A") {
            nodeData.setFileStatus(1);
        } else if (fileStatus == "D") {
            nodeData.setFileStatus(2);
        } else if (fileStatus == "M") {
            nodeData.setFileStatus(3);
        } else if (fileStatus == "C") {
            nodeData.setFileStatus(4);
        } else if (fileStatus == "?") {
            nodeData.setFileStatus(5);
        } else if (fileStatus == "!") {
            nodeData.setFileStatus(6);
        } else if (fileStatus == "~") {
            nodeData.setFileStatus(7);
        }
    }

    private static void handlePropertyStatus(String propertyStatus, SVNTreeNodeData nodeData) {
        if ((propertyStatus = propertyStatus.intern()) == " ") {
            nodeData.setPropertyStatus(0);
        } else if (propertyStatus == "M") {
            nodeData.setPropertyStatus(1);
        } else if (propertyStatus == "C") {
            nodeData.setPropertyStatus(2);
        }
    }

    private static void handleLockedIndicator(String lockedIndicator, SVNTreeNodeData nodeData) {
        if ((lockedIndicator = lockedIndicator.intern()) == " ") {
            nodeData.setLockedIndicator(false);
        } else if (lockedIndicator == "L") {
            nodeData.setLockedIndicator(true);
        }
    }

    private static void handleHistoryIndicator(String historyIndicator, SVNTreeNodeData nodeData) {
        if ((historyIndicator = historyIndicator.intern()) == " ") {
            nodeData.setHistoryIndicator(false);
        } else if (historyIndicator == "+") {
            nodeData.setHistoryIndicator(true);
        }
    }

    private static void handleSwitchedIndicator(String switchedIndicator, SVNTreeNodeData nodeData) {
        if ((switchedIndicator = switchedIndicator.intern()) == " ") {
            nodeData.setSwitchedIndicator(false);
        } else if (switchedIndicator == "S") {
            nodeData.setSwitchedIndicator(true);
        }
    }

    private static void handleOutDatedIndicator(String outdatedIndicator, SVNTreeNodeData nodeData) {
        if ((outdatedIndicator = outdatedIndicator.intern()) == " ") {
            nodeData.setOutDatedIndicator(false);
        } else if (outdatedIndicator == "*") {
            nodeData.setOutDatedIndicator(true);
        }
    }

    private static class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((String)o1).substring(((String)o1).lastIndexOf(" ") + 1);
            String s2 = ((String)o2).substring(((String)o2).lastIndexOf(" ") + 1);
            return s1.compareTo(s2);
        }
    }
}

