/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.model;

import com.alternatecomputing.jsvn.command.CommandException;
import com.alternatecomputing.jsvn.command.Status;
import com.alternatecomputing.jsvn.model.Parser;
import com.alternatecomputing.jsvn.model.SVNTreeNodeData;
import java.io.IOException;
import java.util.HashMap;

public class SVNTreeModel {
    private SVNTreeNodeData _root;

    public SVNTreeModel(String workingCopy, boolean online) {
        if (workingCopy == null) {
            this._root = null;
        } else {
            Status status = new Status();
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("VERBOSE", Boolean.TRUE);
            args.put("TARGETS", workingCopy);
            if (online) {
                args.put("SHOW_UPDATES", Boolean.TRUE);
            }
            try {
                status.init(args);
                status.execute();
                String result = status.getResult();
                this._root = Parser.parse(result);
            }
            catch (CommandException e) {
                e.printStackTrace();
                this._root = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                this._root = null;
            }
        }
    }

    public SVNTreeNodeData getRoot() {
        return this._root;
    }
}

