/*
 * Decompiled with CFR 0.152.
 */
package com.alternatecomputing.jsvn.model;

import java.util.AbstractList;
import java.util.ArrayList;

public class SVNTreeNodeData {
    public static final int UNKNOWN_VERSION = -2;
    public static final int NOT_VERSIONED = -1;
    public static final int NODE_KIND_FILE = 0;
    public static final int NODE_KIND_DIRECTORY = 1;
    public static final int FILE_STATUS_NO_CHANGES = 0;
    public static final int FILE_STATUS_ADDITION_SCHEDULED = 1;
    public static final int FILE_STATUS_DELETION_SCHEDULED = 2;
    public static final int FILE_STATUS_MODIFIED = 3;
    public static final int FILE_STATUS_CONFLICT = 4;
    public static final int FILE_STATUS_NOT_VERSIONED = 5;
    public static final int FILE_STATUS_MISSING = 6;
    public static final int FILE_STATUS_WRONG_TYPE = 7;
    public static final int PROPERTY_STATUS_NO_CHANGE = 0;
    public static final int PROPERTY_STATUS_MODIFIED = 1;
    public static final int PROPERTY_STATUS_CONFLICT = 2;
    public static final String UNKNOWN_LAST_CHANGED_AUTHOR = "";
    private String _path;
    private String _name;
    private int _revision = -1;
    private int _nodeKind;
    private int _fileStatus;
    private int _propertyStatus;
    private boolean _hasHistory = false;
    private boolean _isLocked = false;
    private boolean _isSwitched = false;
    private boolean _isOutDated = false;
    private String _lastChangedAuthor = "";
    private int _lastChangedRevision = -1;
    private SVNTreeNodeData _parent;
    private AbstractList _children = new ArrayList();

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public int getRevision() {
        return this._revision;
    }

    public void setRevision(int revision) {
        this._revision = revision;
    }

    public int getNodeKind() {
        return this._nodeKind;
    }

    public void setNodeKind(int nodeKind) {
        this._nodeKind = nodeKind;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String n) {
        this._name = n;
    }

    public String getLastChangedAuthor() {
        return this._lastChangedAuthor;
    }

    public void setLastChangedAuthor(String lastChangedAuthor) {
        this._lastChangedAuthor = lastChangedAuthor;
    }

    public int getLastChangedRevision() {
        return this._lastChangedRevision;
    }

    public void setLastChangedRevision(int lastChangedRevision) {
        this._lastChangedRevision = lastChangedRevision;
    }

    public int getFileStatus() {
        return this._fileStatus;
    }

    public void setFileStatus(int fileStatus) {
        this._fileStatus = fileStatus;
    }

    public int getPropertyStatus() {
        return this._propertyStatus;
    }

    public void setPropertyStatus(int propertyStatus) {
        this._propertyStatus = propertyStatus;
    }

    public boolean getHistoryIndicator() {
        return this._hasHistory;
    }

    public void setHistoryIndicator(boolean historyIndicator) {
        this._hasHistory = historyIndicator;
    }

    public boolean getLockedIndicator() {
        return this._isLocked;
    }

    public void setLockedIndicator(boolean lockedIndicator) {
        this._isLocked = lockedIndicator;
    }

    public boolean getSwitchedIndicator() {
        return this._isSwitched;
    }

    public void setSwitchedIndicator(boolean lockedSwitched) {
        this._isSwitched = lockedSwitched;
    }

    public boolean getOutDatedIndicator() {
        return this._isOutDated;
    }

    public void setOutDatedIndicator(boolean outDatedSwitched) {
        this._isOutDated = outDatedSwitched;
    }

    public SVNTreeNodeData getParent() {
        return this._parent;
    }

    public void setParent(SVNTreeNodeData parent) {
        this._parent = parent;
    }

    public AbstractList getChildren() {
        return this._children;
    }

    public void setChildren(AbstractList children) {
        this._children = children;
    }

    public String toString() {
        String statusText = this.getStatusText();
        if (statusText.length() > 0) {
            return this.getName() + "  [" + statusText + "]";
        }
        return this.getName();
    }

    public String getStatusText() {
        StringBuffer result = new StringBuffer();
        switch (this._fileStatus) {
            case 5: {
                result.append("not versioned");
                return result.toString();
            }
            case 0: {
                if (!this._isOutDated) {
                    result.append("up-to-date");
                    break;
                }
            }
            case 1: {
                result.append("addition scheduled");
                break;
            }
            case 2: {
                result.append("deletion scheduled");
                break;
            }
            case 3: {
                result.append("locally modified");
                break;
            }
            case 4: {
                result.append("locally conflicted");
                break;
            }
            case 6: {
                result.append("locally deleted");
                break;
            }
            case 7: {
                result.append("wrong type");
                break;
            }
            default: {
                System.err.println("Unexpected local status: " + this._fileStatus);
                return UNKNOWN_LAST_CHANGED_AUTHOR;
            }
        }
        if (this._isOutDated) {
            if (this._revision == -2) {
                result.append("new repository file");
            } else if (this._fileStatus == 0) {
                result.append("out-of-date");
            } else {
                result.append(", out-of-date");
            }
        }
        switch (this._propertyStatus) {
            case 0: {
                break;
            }
            case 1: {
                result.append(", locally modified properties");
                break;
            }
            case 2: {
                result.append(", conflicting local properties");
                break;
            }
            default: {
                System.err.println("Unexpected local property status: " + this._propertyStatus);
                return UNKNOWN_LAST_CHANGED_AUTHOR;
            }
        }
        if (this._isLocked) {
            result.append(", locked");
        }
        if (this._hasHistory) {
            result.append(", with history");
        }
        if (this._isSwitched) {
            result.append(", switched");
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SVNTreeNodeData o = (SVNTreeNodeData)obj;
        return this.getPath().equals(o.getPath()) && this.getRevision() == o.getRevision() && this.getNodeKind() == o.getNodeKind() && this.getFileStatus() == o.getFileStatus() && this.getOutDatedIndicator() == o.getOutDatedIndicator() && this.getLockedIndicator() == o.getLockedIndicator() && this.getSwitchedIndicator() == o.getSwitchedIndicator();
    }

    public void copyNodeValues(SVNTreeNodeData node) {
        if (node == null) {
            return;
        }
        this.setPath(node.getPath());
        this.setRevision(node.getRevision());
        this.setNodeKind(node.getNodeKind());
        this.setLastChangedAuthor(node.getLastChangedAuthor());
        this.setLastChangedRevision(node.getLastChangedRevision());
        this.setFileStatus(node.getFileStatus());
        this.setOutDatedIndicator(node.getOutDatedIndicator());
        this.setLockedIndicator(node.getLockedIndicator());
        this.setSwitchedIndicator(node.getSwitchedIndicator());
    }
}

