/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashSet;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.Area;

public abstract class FObj
extends FONode {
    public PropertyList properties;
    protected PropertyManager propMgr;
    protected String systemId;
    protected int line;
    protected int column;
    private HashSet markerClassNames;

    protected FObj(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent);
        this.properties = propertyList;
        propertyList.setFObj(this);
        this.propMgr = this.makePropertyManager(propertyList);
        this.systemId = systemId;
        this.line = line;
        this.column = column;
        this.setWritingMode();
    }

    protected PropertyManager makePropertyManager(PropertyList propertyList) {
        return new PropertyManager(propertyList);
    }

    protected void addCharacters(char[] data, int start, int length) {
    }

    public int layout(Area area) throws FOPException {
        return 1;
    }

    public abstract String getName();

    protected void end() {
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public int getContentWidth() {
        return 0;
    }

    public void removeID(IDReferences idReferences) {
        if (this.properties.get("id") == null || this.properties.get("id").getString() == null) {
            return;
        }
        idReferences.removeID(this.properties.get("id").getString());
        int numChildren = this.children.size();
        for (int i = 0; i < numChildren; ++i) {
            FONode child = (FONode)this.children.get(i);
            if (!(child instanceof FObj)) continue;
            ((FObj)child).removeID(idReferences);
        }
    }

    public boolean generatesReferenceAreas() {
        return false;
    }

    protected void setWritingMode() {
        FObj parent;
        FObj p = this;
        while (!p.generatesReferenceAreas() && (parent = p.getParent()) != null) {
            p = parent;
        }
        this.properties.setWritingMode(p.getProperty("writing-mode").getEnum());
    }

    public void addMarker(String markerClassName) throws FOPException {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                FONode child = (FONode)this.children.get(i);
                if (child.mayPrecedeMarker()) continue;
                throw new FOPException("A fo:marker must be an initial child of '" + this.getName() + "'", this.systemId, this.line, this.column);
            }
        }
        if (this.markerClassNames == null) {
            this.markerClassNames = new HashSet();
            this.markerClassNames.add(markerClassName);
        } else if (!this.markerClassNames.contains(markerClassName)) {
            this.markerClassNames.add(markerClassName);
        } else {
            throw new FOPException("marker-class-name '" + markerClassName + "' already exists for this parent", this.systemId, this.line, this.column);
        }
    }

    public static abstract class Maker {
        public abstract FObj make(FObj var1, PropertyList var2, String var3, int var4, int var5) throws FOPException;
    }
}

